/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.obr.command;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resource;
import org.apache.karaf.obr.command.ObrCommandSupport;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="obr", name="info", description="Prints information about OBR bundles.")
@Service
public class InfoCommand
extends ObrCommandSupport {
    @Argument(index=0, name="bundles", description="Specify bundles to query for information (separated by whitespaces). The bundles are identified using the following syntax: symbolic_name,version where version is optional.", required=true, multiValued=true)
    List<String> bundles;

    @Override
    protected void doExecute(RepositoryAdmin admin) throws Exception {
        for (String bundle : this.bundles) {
            String[] target = this.getTarget(bundle);
            Resource[] resources = this.searchRepository(admin, target[0], target[1]);
            if (resources == null) {
                System.err.println("Unknown bundle and/or version: " + target[0]);
                continue;
            }
            for (int resIdx = 0; resIdx < resources.length; ++resIdx) {
                if (resIdx > 0) {
                    System.out.println();
                }
                this.printResource(System.out, resources[resIdx]);
            }
        }
    }

    private void printResource(PrintStream out, Resource resource) {
        if (out != null && resource != null) {
            Capability[] capabilityArray;
            String resourceId = this.getResourceId(resource);
            this.printUnderline(out, resourceId.length());
            out.println(resourceId);
            this.printUnderline(out, resourceId.length());
            Map map = resource.getProperties();
            for (Map.Entry entry : map.entrySet()) {
                Map.Entry entry2 = entry;
                if (entry2.getValue().getClass().isArray()) {
                    out.println(entry2.getKey() + ":");
                    for (int j = 0; j < Array.getLength(entry2.getValue()); ++j) {
                        out.println("   " + Array.get(entry2.getValue(), j));
                    }
                    continue;
                }
                out.println(entry2.getKey() + ": " + entry2.getValue());
            }
            Requirement[] reqs = resource.getRequirements();
            if (reqs != null && reqs.length > 0) {
                out.println("Requires:");
                for (Requirement req : reqs) {
                    out.println("   " + req.getName() + ":" + req.getFilter());
                }
            }
            if ((capabilityArray = resource.getCapabilities()) != null && capabilityArray.length > 0) {
                out.println("Capabilities:");
                for (Capability cap : capabilityArray) {
                    out.println("   " + cap.getName() + ":" + cap.getPropertiesAsMap());
                }
            }
        }
    }
}

