/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.network;

import java.net.InetAddress;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.opennms.core.network.IPAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InetAddressXmlAdapter
extends XmlAdapter<String, InetAddress> {
    private static final Logger LOG = LoggerFactory.getLogger(InetAddressXmlAdapter.class);

    public String marshal(InetAddress inetAddr) throws Exception {
        return inetAddr == null ? null : new IPAddress(inetAddr).toDbString();
    }

    public InetAddress unmarshal(String ipAddr) throws Exception {
        try {
            return ipAddr == null || ipAddr.isEmpty() ? null : new IPAddress(ipAddr).toInetAddress();
        }
        catch (Throwable t) {
            LOG.warn("Invalid IP Address {}", (Object)ipAddr);
            return null;
        }
    }
}

