/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.alarms.history.elastic;

import com.google.common.collect.ImmutableMap;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import org.opennms.features.alarms.history.elastic.TimeRange;

public class QueryProvider {
    public static final long MAX_STATES_FOR_ALARM = 100L;
    public static final long MAX_BUCKETS = 1000L;
    private final Configuration cfg = new Configuration(Configuration.VERSION_2_3_23);

    public QueryProvider() {
        this.cfg.setClassForTemplateLoading(this.getClass(), "");
        this.cfg.setDefaultEncoding(StandardCharsets.UTF_8.name());
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
    }

    public String getAlarmStatesByDbId(long id) {
        return this.render("get_alarm.ftl", (Map<Object, Object>)ImmutableMap.builder().put((Object)"alarmId", (Object)id).put((Object)"maxResults", (Object)100L).build());
    }

    public String getAlarmStatesByReductionKey(String reductionKey) {
        return this.render("get_alarm.ftl", (Map<Object, Object>)ImmutableMap.builder().put((Object)"reductionKey", (Object)reductionKey).put((Object)"maxResults", (Object)100L).build());
    }

    public String getAlarmByDbIdAt(long id, TimeRange timeRange) {
        return this.render("get_alarm_at.ftl", (Map<Object, Object>)ImmutableMap.builder().put((Object)"alarmId", (Object)id).put((Object)"fromMillis", (Object)timeRange.getStart()).put((Object)"toMillis", (Object)timeRange.getEnd()).build());
    }

    public String getAlarmByReductionKeyAt(String reductionKey, TimeRange timeRange) {
        return this.render("get_alarm_at.ftl", (Map<Object, Object>)ImmutableMap.builder().put((Object)"reductionKey", (Object)reductionKey).put((Object)"fromMillis", (Object)timeRange.getStart()).put((Object)"toMillis", (Object)timeRange.getEnd()).build());
    }

    public String getActiveAlarmsAt(TimeRange timeRange, Integer afterAlarmWithId) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"fromMillis", (Object)timeRange.getStart()).put((Object)"toMillis", (Object)timeRange.getEnd()).put((Object)"maxBuckets", (Object)1000L).put((Object)"idOnly", (Object)false);
        if (afterAlarmWithId != null) {
            builder.put((Object)"afterAlarmWithId", (Object)afterAlarmWithId);
        }
        return this.render("get_alarms_at.ftl", (Map<Object, Object>)builder.build());
    }

    public String getActiveAlarmIdsAt(TimeRange timeRange, Integer afterAlarmWithId) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"fromMillis", (Object)timeRange.getStart()).put((Object)"toMillis", (Object)timeRange.getEnd()).put((Object)"maxBuckets", (Object)1000L).put((Object)"idOnly", (Object)true);
        if (afterAlarmWithId != null) {
            builder.put((Object)"afterAlarmWithId", (Object)afterAlarmWithId);
        }
        return this.render("get_alarms_at.ftl", (Map<Object, Object>)builder.build());
    }

    public String getActiveAlarmIdsAtTimeAndExclude(TimeRange timeRange, Set<Integer> alarmIdsToKeep, Integer afterAlarmWithId) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"fromMillis", (Object)timeRange.getStart()).put((Object)"toMillis", (Object)timeRange.getEnd()).put((Object)"maxBuckets", (Object)1000L).put((Object)"alarmIdsToExclude", alarmIdsToKeep).put((Object)"idOnly", (Object)true);
        if (afterAlarmWithId != null) {
            builder.put((Object)"afterAlarmWithId", (Object)afterAlarmWithId);
        }
        return this.render("get_alarms_at.ftl", (Map<Object, Object>)builder.build());
    }

    public String getAllAlarms(TimeRange timeRange, Integer afterAlarmWithId) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"fromMillis", (Object)timeRange.getStart()).put((Object)"toMillis", (Object)timeRange.getEnd()).put((Object)"maxBuckets", (Object)1000L);
        if (afterAlarmWithId != null) {
            builder.put((Object)"afterAlarmWithId", (Object)afterAlarmWithId);
        }
        return this.render("get_all_alarms.ftl", (Map<Object, Object>)builder.build());
    }

    private String render(String templateName, Map<Object, Object> context) {
        try {
            StringWriter writer = new StringWriter();
            Template template = this.cfg.getTemplate(templateName);
            template.process(context, (Writer)writer);
            return writer.toString();
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException(e);
        }
    }
}

