/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.persistence.rrd;

import java.util.LinkedHashMap;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.persistence.rrd.BasePersister;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.rrd.RrdStrategy;

public class GroupPersister
extends BasePersister {
    protected GroupPersister(ServiceParameters params, RrdRepository repository, RrdStrategy<?, ?> rrdStrategy, ResourceStorageDao resourceStorageDao) {
        super(params, repository, rrdStrategy, resourceStorageDao);
    }

    public void visitGroup(AttributeGroup group) {
        this.pushShouldPersist(group);
        if (this.shouldPersist()) {
            LinkedHashMap<String, String> dsNamesToRrdNames = new LinkedHashMap<String, String>();
            for (CollectionAttribute a : group.getAttributes()) {
                if (!a.getType().isNumeric()) continue;
                dsNamesToRrdNames.put(a.getName(), group.getName());
            }
            this.setBuilder(this.createBuilder(group.getResource(), group.getName(), group.getGroupType().getAttributeTypes()));
            ResourcePath path = ResourceTypeUtils.getResourcePathWithRepository((RrdRepository)this.getRepository(), (ResourcePath)group.getResource().getPath());
            this.m_resourceStorageDao.updateMetricToResourceMappings(path, dsNamesToRrdNames);
        }
    }

    public void completeGroup(AttributeGroup group) {
        if (this.shouldPersist()) {
            this.commitBuilder();
        }
        this.popShouldPersist();
    }
}

