/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.File;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsResource;

@XmlRootElement(name="rrd-graph-attribute")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RrdGraphAttribute
implements OnmsAttribute {
    @XmlAttribute(name="name")
    private String m_name;
    @XmlAttribute(name="relativePath")
    private String m_relativePath;
    @XmlAttribute(name="rrdFile")
    private String m_rrdFile;
    private OnmsResource m_resource;

    public RrdGraphAttribute() {
    }

    public RrdGraphAttribute(String name, String relativePath, String rrdFile) {
        this.m_name = name;
        this.m_relativePath = relativePath;
        this.m_rrdFile = rrdFile;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public OnmsResource getResource() {
        return this.m_resource;
    }

    @Override
    public void setResource(OnmsResource resource) {
        this.m_resource = resource;
    }

    public String getRrdRelativePath() {
        return this.m_relativePath + File.separator + this.m_rrdFile;
    }

    public void setRrdRelativePath(String relativePath) {
        this.m_relativePath = relativePath;
    }

    public String getRrdFile() {
        return this.m_rrdFile;
    }

    public void setRrdFile(String rrdFile) {
        this.m_rrdFile = rrdFile;
    }

    public String toString() {
        return String.valueOf(this.m_resource) + "." + this.m_name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RrdGraphAttribute that = (RrdGraphAttribute)o;
        return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_relativePath, that.m_relativePath) && Objects.equals(this.m_rrdFile, that.m_rrdFile) && Objects.equals(this.m_resource, that.m_resource);
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_relativePath, this.m_rrdFile, this.m_resource);
    }
}

