/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.minion.status;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import org.opennms.minion.status.MinionStatus;

public class MinionServiceStatus
implements MinionStatus,
Comparable<MinionServiceStatus>,
Serializable {
    private static final Comparator<MinionServiceStatus> COMPARATOR = Comparator.comparing(MinionServiceStatus::getState);
    private static final long serialVersionUID = 1L;
    private MinionStatus.State m_state;

    MinionServiceStatus(MinionStatus.State state) {
        this.m_state = state;
    }

    public static MinionServiceStatus up() {
        return new MinionServiceStatus(MinionStatus.State.UP);
    }

    public static MinionServiceStatus down() {
        return new MinionServiceStatus(MinionStatus.State.DOWN);
    }

    @Override
    public MinionStatus.State getState() {
        return this.m_state;
    }

    @Override
    public boolean isUp() {
        return this.m_state == MinionStatus.UP;
    }

    public String toString() {
        return this.m_state.toString();
    }

    @Override
    public int compareTo(MinionServiceStatus o) {
        return COMPARATOR.compare(this, o);
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof MinionServiceStatus) {
            MinionServiceStatus status = (MinionServiceStatus)o;
            return Objects.equals((Object)this.m_state, (Object)status.m_state);
        }
        return false;
    }
}

