/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.features.vaadin.jmxconfiggenerator.data.SelectableBeanItemContainer;

public class AttributesContainerCache<ATTRIBUTETYPE, PARENTTYPE> {
    private final Map<PARENTTYPE, SelectableBeanItemContainer<ATTRIBUTETYPE>> containerMap = new HashMap<PARENTTYPE, SelectableBeanItemContainer<ATTRIBUTETYPE>>();
    private final Class<? super ATTRIBUTETYPE> type;
    private final AttributeCollector<ATTRIBUTETYPE, PARENTTYPE> attribCollector;

    AttributesContainerCache(Class<? super ATTRIBUTETYPE> type, AttributeCollector<ATTRIBUTETYPE, PARENTTYPE> attribCollector) {
        this.type = type;
        this.attribCollector = attribCollector;
    }

    public SelectableBeanItemContainer<ATTRIBUTETYPE> getContainer(PARENTTYPE bean) {
        if (bean == null) {
            return null;
        }
        if (this.containerMap.get(bean) != null) {
            return this.containerMap.get(bean);
        }
        this.containerMap.put(bean, new SelectableBeanItemContainer<ATTRIBUTETYPE>(this.type));
        this.initContainer(this.containerMap.get(bean), bean);
        return this.containerMap.get(bean);
    }

    public PARENTTYPE getParentFor(ATTRIBUTETYPE child) {
        for (Map.Entry<PARENTTYPE, SelectableBeanItemContainer<ATTRIBUTETYPE>> eachEntry : this.containerMap.entrySet()) {
            if (!eachEntry.getValue().containsId(child)) continue;
            return eachEntry.getKey();
        }
        return null;
    }

    private void initContainer(SelectableBeanItemContainer<ATTRIBUTETYPE> container, PARENTTYPE bean) {
        for (ATTRIBUTETYPE att : this.attribCollector.getAttributes(bean)) {
            container.addItem(att);
        }
    }

    public void clear() {
        this.containerMap.clear();
    }

    public static interface AttributeCollector<ATTRIBUTETYPE, PARENTTYPE> {
        public List<ATTRIBUTETYPE> getAttributes(PARENTTYPE var1);
    }
}

