/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.jobs;

import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.opennms.features.vaadin.jmxconfiggenerator.JmxConfigGeneratorUI;
import org.opennms.features.vaadin.jmxconfiggenerator.jobs.Task;
import org.opennms.features.vaadin.jmxconfiggenerator.jobs.TaskRunException;
import org.opennms.netmgt.vaadin.core.UIHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManager {
    private static final Logger LOG = LoggerFactory.getLogger(JobManager.class);
    private ExecutorService executorService = Executors.newFixedThreadPool(1);
    private Future<?> runningJob;

    public void enqueue(Task task) {
        if (this.runningJob != null && !this.runningJob.isDone()) {
            LOG.warn("A job is already running. Try cancelling...");
            boolean success = this.runningJob.cancel(true);
            LOG.warn("Job was cancelled: {}", (Object)success);
        }
        this.runningJob = this.executorService.submit(new TaskRunnable(task));
    }

    public void cancelAllJobs() {
        if (this.runningJob != null) {
            this.runningJob.cancel(true);
            if (!this.runningJob.isDone()) {
                LOG.error("The currently running Job could not be stopped.", this.runningJob);
            }
        }
    }

    private static class TaskRunnable
    implements Runnable {
        private final Task taskToRun;

        private TaskRunnable(Task taskToRun) {
            this.taskToRun = Objects.requireNonNull(taskToRun);
        }

        @Override
        public void run() {
            JmxConfigGeneratorUI ui = this.taskToRun.getUI();
            try {
                Object result = this.taskToRun.execute();
                ui.access(() -> {
                    ui.hideProgressWindow();
                    this.taskToRun.onSuccess(result);
                });
            }
            catch (TaskRunException trex) {
                this.handleError((UI)ui, trex);
            }
            catch (Exception ex) {
                this.handleError((UI)ui, ex);
            }
            finally {
                ui.access(ui::hideProgressWindow);
            }
        }

        private void handleError(UI ui, TaskRunException trex) {
            ui.access(() -> {
                LOG.error(trex.getMessage(), trex.getCause());
                StringBuilder errorMessage = new StringBuilder(100);
                errorMessage.append(trex.getMessage());
                if (trex.getCause() != null) {
                    errorMessage.append("<br/><br/>").append(trex.getCause().getMessage());
                }
                UIHelper.showNotification((String)(trex.getShortDescription() != null ? trex.getShortDescription() : "Error"), (String)errorMessage.toString().trim(), (Notification.Type)Notification.Type.ERROR_MESSAGE, (int)5000);
                this.taskToRun.onError();
            });
        }

        private void handleError(UI ui, Exception ex) {
            ui.access(() -> {
                LOG.error("Unknown Error occurred", (Throwable)ex);
                UIHelper.showNotification((String)"Unknown Error", (String)ex.getMessage(), (Notification.Type)Notification.Type.ERROR_MESSAGE);
                this.taskToRun.onError();
            });
        }
    }
}

