/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ackd;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.ackd.AckReader;
import org.opennms.netmgt.ackd.readers.ReaderSchedule;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.dao.api.AckdConfigurationDao;
import org.opennms.netmgt.dao.api.AcknowledgmentDao;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.events.api.model.IParm;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@EventListener(name="Ackd", logPrefix="ackd")
public class Ackd
implements SpringServiceDaemon,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(Ackd.class);
    public static final String NAME = "Ackd";
    private volatile AckdConfigurationDao m_configDao;
    private volatile AcknowledgmentDao m_ackDao;
    private volatile EventForwarder m_eventForwarder;
    private volatile ScheduledThreadPoolExecutor m_executor;
    private List<AckReader> m_ackReaders;
    private Object m_lock = new Object();

    public void start() {
        LOG.info("start: Starting {} readers...", (Object)this.m_ackReaders.size());
        this.startReaders();
        LOG.info("start: readers started.");
    }

    public void destroy() {
        LOG.info("destroy: shutting down readers...");
        try {
            this.stopReaders();
            this.m_executor.purge();
            this.m_executor.shutdown();
            this.m_executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            LOG.error("destroy: error destroying readers.", e);
            this.m_executor.shutdownNow();
        }
        LOG.info("destroy: readers shutdown.");
    }

    protected void startReaders() {
        this.startReaders(false);
    }

    protected void startReaders(boolean reloadConfig) {
        int enabledReaderCount = this.getConfigDao().getEnabledReaderCount();
        if (enabledReaderCount < 1) {
            LOG.info("startReaders: there are not readers enabled in the configuration.");
            return;
        }
        this.m_executor.setCorePoolSize(enabledReaderCount);
        LOG.info("startReaders: starting {} enabled readers of {} readers registered.", (Object)enabledReaderCount, (Object)this.m_ackReaders.size());
        for (AckReader reader : this.m_ackReaders) {
            LOG.debug("startReaders: starting reader: {}", (Object)reader.getName());
            ArrayList<AckReader.AckReaderState> allowedStates = new ArrayList<AckReader.AckReaderState>();
            allowedStates.add(AckReader.AckReaderState.STOPPED);
            try {
                this.adjustReaderState(reader, AckReader.AckReaderState.STARTED, allowedStates, reloadConfig);
            }
            catch (Throwable e) {
                LOG.error("startReaders: Could not start reader: {}", (Object)reader.getName(), (Object)e);
                continue;
            }
            LOG.debug("startReaders: reader: {} started.", (Object)reader.getName());
        }
        LOG.info("startReaders: {} readers started.", (Object)this.m_ackReaders.size());
    }

    protected void stopReaders() {
        LOG.info("stopReaders: stopping {} readers...", (Object)this.m_ackReaders.size());
        for (AckReader reader : this.m_ackReaders) {
            LOG.debug("stopReaders: stopping reader: {}", (Object)reader.getName());
            ArrayList<AckReader.AckReaderState> allowedStates = new ArrayList<AckReader.AckReaderState>();
            allowedStates.add(AckReader.AckReaderState.PAUSE_PENDING);
            allowedStates.add(AckReader.AckReaderState.PAUSED);
            allowedStates.add(AckReader.AckReaderState.RESUME_PENDING);
            allowedStates.add(AckReader.AckReaderState.RESUMED);
            allowedStates.add(AckReader.AckReaderState.STARTED);
            allowedStates.add(AckReader.AckReaderState.START_PENDING);
            allowedStates.add(AckReader.AckReaderState.STOP_PENDING);
            try {
                this.adjustReaderState(reader, AckReader.AckReaderState.STOPPED, allowedStates, false);
            }
            catch (Throwable e) {
                LOG.error("startReaders: Could not stop reader: {}", (Object)reader.getName(), (Object)e);
            }
            LOG.debug("stopReaders: reader: {} stopped.", (Object)reader.getName());
        }
        LOG.info("stopReaders: {} readers stopped.", (Object)this.m_ackReaders.size());
    }

    protected void pauseReaders() {
        for (AckReader reader : this.m_ackReaders) {
            ArrayList<AckReader.AckReaderState> allowedStates = new ArrayList<AckReader.AckReaderState>();
            allowedStates.add(AckReader.AckReaderState.STARTED);
            allowedStates.add(AckReader.AckReaderState.RESUMED);
            try {
                this.adjustReaderState(reader, AckReader.AckReaderState.PAUSED, allowedStates, false);
            }
            catch (Throwable e) {
                LOG.error("startReaders: Could not pause reader: {}", (Object)reader.getName(), (Object)e);
            }
        }
    }

    protected void resumeReaders() {
        for (AckReader reader : this.m_ackReaders) {
            ArrayList<AckReader.AckReaderState> allowedStates = new ArrayList<AckReader.AckReaderState>();
            allowedStates.add(AckReader.AckReaderState.PAUSED);
            try {
                this.adjustReaderState(reader, AckReader.AckReaderState.RESUMED, allowedStates, false);
            }
            catch (Throwable e) {
                LOG.error("startReaders: Could not resume reader: {}", (Object)reader.getName(), (Object)e);
            }
        }
    }

    protected void restartReaders(boolean reloadConfigs) {
        LOG.info("restartReaders: restarting readers...");
        this.stopReaders();
        this.startReaders(reloadConfigs);
        LOG.info("restartReaders: readers restarted.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void adjustReaderState(AckReader reader, AckReader.AckReaderState requestedState, List<AckReader.AckReaderState> allowedCurrentStates, boolean reloadConfig) {
        if (requestedState != null && requestedState.equals((Object)reader.getState())) {
            LOG.warn("adjustReaderState: attempting to adjust reader state to {} but it is already {}.", (Object)requestedState, (Object)requestedState);
        }
        Object object = this.m_lock;
        synchronized (object) {
            if (!this.getConfigDao().isReaderEnabled(reader.getName())) {
                if (!AckReader.AckReaderState.STOPPED.equals((Object)reader.getState())) {
                    LOG.warn("adjustReaderState: ignoring requested state and stopping the disabled reader: {}...", (Object)reader.getName());
                    reader.stop();
                    LOG.warn("adjustReaderState: disabled reader: {} stopped", (Object)reader.getName());
                    return;
                }
                LOG.warn("adjustReaderState: Not adjustingReaderState, disabled reader: {}", (Object)reader.getName());
                return;
            }
            if (!allowedCurrentStates.contains((Object)reader.getState())) {
                IllegalStateException e = new IllegalStateException("error adjusting reader state; reader cannot be change from: " + String.valueOf((Object)reader.getState()) + " to: " + String.valueOf((Object)requestedState));
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
                throw e;
            }
            LOG.debug("adjustReaderState: adjusting reader state from: {} to: {}...", (Object)reader.getState(), (Object)requestedState);
            org.opennms.netmgt.config.ackd.ReaderSchedule configSchedule = this.getConfigDao().getReaderSchedule(reader.getName());
            long interval = configSchedule.getInterval();
            String unit = configSchedule.getUnit();
            if (AckReader.AckReaderState.STARTED.equals((Object)requestedState)) {
                reader.start(this.m_executor, ReaderSchedule.createSchedule(interval, unit), reloadConfig);
            } else if (AckReader.AckReaderState.STOPPED.equals((Object)requestedState)) {
                reader.stop();
            } else if (AckReader.AckReaderState.PAUSED.equals((Object)requestedState)) {
                reader.pause();
            } else {
                if (!AckReader.AckReaderState.RESUMED.equals((Object)requestedState)) {
                    IllegalStateException e = new IllegalStateException("adjustReaderState: cannot request state: " + String.valueOf((Object)requestedState));
                    LOG.error(e.getLocalizedMessage(), (Throwable)e);
                    throw e;
                }
                reader.resume(this.m_executor);
            }
            return;
        }
    }

    @EventHandler(uei="uei.opennms.org/ackd/acknowledge")
    public void handleAckEvent(IEvent event) {
        LOG.info("handleAckEvent: Received acknowledgment event: {}", (Object)event);
        try {
            OnmsAcknowledgment ack = new OnmsAcknowledgment(Event.copyFrom((IEvent)event));
            this.m_ackDao.processAck(ack);
        }
        catch (ParseException e) {
            LOG.error("handleAckEvent: unable to process acknowledgment event: {}", (Object)event, (Object)e);
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadConfigEvent(IEvent event) {
        String specifiedDaemon = null;
        LOG.info("handleReloadConfigEvent: processing reload event: {}", (Object)event);
        List parms = event.getParmCollection();
        for (IParm parm : parms) {
            specifiedDaemon = parm.getValue().getContent();
            if (!"daemonName".equals(parm.getParmName()) || !this.getName().equalsIgnoreCase(specifiedDaemon)) continue;
            LOG.debug("handleReloadConfigEvent: reload event is for this daemon: {}; reloading configuration...", (Object)this.getName());
            try {
                this.m_configDao.reloadConfiguration();
                EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", this.getName(), Calendar.getInstance().getTime());
                bldr.addParam("daemonName", this.getName());
                this.m_eventForwarder.sendNow(bldr.getEvent());
                LOG.debug("handleReloadConfigEvent: restarting readers due to reload configuration event...");
                this.restartReaders(true);
            }
            catch (Throwable e) {
                LOG.error("handleReloadConfigEvent: ", e);
                EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName(), Calendar.getInstance().getTime());
                bldr.addParam("daemonName", this.getName());
                bldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
                this.m_eventForwarder.sendNow(bldr.getEvent());
            }
            LOG.debug("handleReloadConfigEvent: configuration reloaded.");
            return;
        }
        LOG.debug("handleReloadConfigEvent: reload event not for this daemon: {}; daemon specified is: {}", (Object)this.getName(), specifiedDaemon);
    }

    public void setExecutor(ScheduledThreadPoolExecutor executor) {
        this.m_executor = executor;
    }

    public ScheduledThreadPoolExecutor getExecutor() {
        return this.m_executor;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    protected List<AckReader> getAckReaders() {
        return this.m_ackReaders;
    }

    public void setAckReaders(List<AckReader> ackReaders) {
        this.m_ackReaders = ackReaders;
    }

    public AcknowledgmentDao getAcknowledgmentDao() {
        return this.m_ackDao;
    }

    public void setAcknowledgmentDao(AcknowledgmentDao ackDao) {
        this.m_ackDao = ackDao;
    }

    public AckdConfigurationDao getConfigDao() {
        return this.m_configDao;
    }

    public void setConfigDao(AckdConfigurationDao config) {
        this.m_configDao = config;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public String getName() {
        return NAME;
    }
}

