/*
 * Decompiled with CFR 0.152.
 */
package rpc.pdu;

import ndr.NetworkDataRepresentation;
import rpc.ConnectionOrientedPdu;
import rpc.core.PresentationContext;

public class BindPdu
extends ConnectionOrientedPdu {
    public static final int BIND_TYPE = 11;
    private PresentationContext[] contextList;
    private int maxTransmitFragment = 7160;
    private int maxReceiveFragment = 7160;
    private int associationGroupId = 0;

    public void resetCallIdCounter() {
        ConnectionOrientedPdu.callIdCounter = 0;
    }

    @Override
    public int getType() {
        return 11;
    }

    public int getMaxTransmitFragment() {
        return this.maxTransmitFragment;
    }

    public void setMaxTransmitFragment(int maxTransmitFragment) {
        this.maxTransmitFragment = maxTransmitFragment;
    }

    public int getMaxReceiveFragment() {
        return this.maxReceiveFragment;
    }

    public void setMaxReceiveFragment(int maxReceiveFragment) {
        this.maxReceiveFragment = maxReceiveFragment;
    }

    public int getAssociationGroupId() {
        return this.associationGroupId;
    }

    public void setAssociationGroupId(int associationGroupId) {
        this.associationGroupId = associationGroupId;
    }

    public PresentationContext[] getContextList() {
        return this.contextList;
    }

    public void setContextList(PresentationContext[] contextList) {
        this.contextList = contextList;
    }

    @Override
    protected void readBody(NetworkDataRepresentation ndr) {
        this.setMaxTransmitFragment(ndr.readUnsignedShort());
        this.setMaxReceiveFragment(ndr.readUnsignedShort());
        this.setAssociationGroupId(ndr.readUnsignedLong());
        int count = ndr.readUnsignedSmall();
        PresentationContext[] contextList = new PresentationContext[count];
        for (int i = 0; i < count; ++i) {
            contextList[i] = new PresentationContext();
            contextList[i].read(ndr);
        }
        this.setContextList(contextList);
    }

    @Override
    protected void writeBody(NetworkDataRepresentation ndr) {
        ndr.writeUnsignedShort(this.getMaxTransmitFragment());
        ndr.writeUnsignedShort(this.getMaxReceiveFragment());
        ndr.writeUnsignedLong(this.getAssociationGroupId());
        PresentationContext[] contextList = this.getContextList();
        int count = contextList.length;
        ndr.writeUnsignedSmall((short)count);
        for (int i = 0; i < count; ++i) {
            contextList[i].write(ndr);
        }
    }
}

