/*
 * Decompiled with CFR 0.152.
 */
package rpc.pdu;

import ndr.NetworkDataRepresentation;
import rpc.ConnectionOrientedPdu;
import rpc.core.ProtocolVersion;

public class BindNoAcknowledgePdu
extends ConnectionOrientedPdu {
    public static final int BIND_NO_ACKNOWLEDGE_TYPE = 13;
    public static final int REASON_NOT_SPECIFIED = 0;
    public static final int TEMPORARY_CONGESTION = 1;
    public static final int LOCAL_LIMIT_EXCEEDED = 2;
    public static final int CALLED_PADDR_UNKNOWN = 3;
    public static final int PROTOCOL_VERSION_NOT_SUPPORTED = 4;
    public static final int DEFAULT_CONTEXT_NOT_SUPPORTED = 5;
    public static final int USER_DATA_NOT_READABLE = 6;
    public static final int NO_PSAP_AVAILABLE = 7;
    private ProtocolVersion[] versionList;
    private int rejectReason = 0;

    @Override
    public int getType() {
        return 13;
    }

    public int getRejectReason() {
        return this.rejectReason;
    }

    public void setRejectReason(int rejectReason) {
        this.rejectReason = rejectReason;
    }

    public ProtocolVersion[] getVersionList() {
        return this.versionList;
    }

    public void setVersionList(ProtocolVersion[] versionList) {
        this.versionList = versionList;
    }

    @Override
    protected void readBody(NetworkDataRepresentation ndr) {
        int reason = ndr.readUnsignedSmall();
        this.setRejectReason(reason);
        ProtocolVersion[] versionList = null;
        if (reason == 4) {
            int count = ndr.readUnsignedSmall();
            versionList = new ProtocolVersion[count];
            for (int i = 0; i < count; ++i) {
                versionList[i] = new ProtocolVersion();
                versionList[i].read(ndr);
            }
        }
        this.setVersionList(versionList);
    }

    @Override
    protected void writeBody(NetworkDataRepresentation ndr) {
        int reason = this.getRejectReason();
        ndr.writeUnsignedSmall((short)reason);
        if (reason != 4) {
            return;
        }
        ProtocolVersion[] versionList = this.getVersionList();
        int count = versionList != null ? versionList.length : 0;
        for (int i = 0; i < count; ++i) {
            versionList[i].write(ndr);
        }
    }
}

