/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.servlets;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.jolokia.config.ConfigKey;
import org.jolokia.http.AgentServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JolokiaConfiguredAgentServlet
extends AgentServlet {
    private static final transient Logger LOG = LoggerFactory.getLogger(JolokiaConfiguredAgentServlet.class);

    public void init(ServletConfig pServletConfig) throws ServletException {
        ServletConfigWrapper pServletConfigWrapper = null;
        Properties properties = System.getProperties();
        for (String key : properties.stringPropertyNames()) {
            String value;
            String effectiveKey;
            if (!key.startsWith("jolokia.") || !JolokiaConfiguredAgentServlet.containsEnum(effectiveKey = key.substring(key.indexOf(".") + 1)) || (value = properties.getProperty(key)) == null) continue;
            if (pServletConfigWrapper == null) {
                pServletConfigWrapper = new ServletConfigWrapper(pServletConfig);
            }
            LOG.info("Jolokia overridden property: [key={}, value={}]", (Object)effectiveKey, (Object)value);
            pServletConfigWrapper.addProperty(effectiveKey, value);
        }
        if (pServletConfigWrapper != null) {
            super.init(pServletConfigWrapper);
        } else {
            LOG.info("Jolokia has not found any overriden configuration property passed at launch time; Default configuration values will be used.");
            super.init(pServletConfig);
        }
    }

    public static boolean containsEnum(String test) {
        for (ConfigKey c : ConfigKey.values()) {
            if (!c.getKeyValue().equals(test)) continue;
            return true;
        }
        return false;
    }

    class TwoEnumerationsWrapper
    implements Enumeration<String> {
        Enumeration<String> a;
        Enumeration<String> b;

        public TwoEnumerationsWrapper(Enumeration a, Enumeration b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean hasMoreElements() {
            return this.a.hasMoreElements() || this.b.hasMoreElements();
        }

        @Override
        public String nextElement() {
            if (this.a.hasMoreElements()) {
                return this.a.nextElement();
            }
            return this.b.nextElement();
        }
    }

    class ServletConfigWrapper
    implements ServletConfig {
        ServletConfig wrapped;
        Hashtable<String, String> ownProps;

        public ServletConfigWrapper(ServletConfig pServletConfig) {
            this.wrapped = pServletConfig;
            this.ownProps = new Hashtable();
        }

        public String getServletName() {
            return this.wrapped.getServletName();
        }

        public ServletContext getServletContext() {
            return this.wrapped.getServletContext();
        }

        public String getInitParameter(String s) {
            if (this.ownProps.containsKey(s)) {
                return this.ownProps.get(s);
            }
            return this.wrapped.getInitParameter(s);
        }

        public Enumeration getInitParameterNames() {
            return new TwoEnumerationsWrapper(this.ownProps.keys(), this.wrapped.getInitParameterNames());
        }

        public void addProperty(String key, String value) {
            this.ownProps.put(key, value);
        }
    }
}

