/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramVisitor;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.DatagramVersion;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.SampleDatagramV5;

public class SampleDatagramType {
    public final DatagramVersion version;
    public final SampleDatagramV5 datagram;

    public SampleDatagramType(ByteBuf buffer) throws InvalidPacketException {
        this.version = DatagramVersion.from(buffer);
        switch (this.version) {
            case VERSION5: {
                this.datagram = new SampleDatagramV5(buffer);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", (Object)this.version).add("datagram", (Object)this.datagram).toString();
    }

    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeName("version");
        this.version.writeBson(bsonWriter, enr);
        bsonWriter.writeName("datagram");
        this.datagram.writeBson(bsonWriter, enr);
        bsonWriter.writeEndDocument();
    }

    public void visit(SampleDatagramVisitor visitor) {
        visitor.accept(this);
        this.datagram.visit(visitor);
    }
}

