/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rss;

import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.SyndFeedOutput;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import org.opennms.web.rss.Feed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFeed
implements Feed {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFeed.class);
    protected int m_maxEntries = 20;
    protected String m_feedType = "rss_2.0";
    protected String m_urlBase = "";
    protected ServletRequest m_servletRequest;
    private ServletContext m_servletContext;

    public AbstractFeed() {
    }

    public AbstractFeed(String feedType) {
        this.setFeedType(feedType);
    }

    @Override
    public final String getUrlBase() {
        return this.m_urlBase;
    }

    @Override
    public final void setUrlBase(String urlBase) {
        this.m_urlBase = urlBase;
    }

    @Override
    public final String getFeedType() {
        return this.m_feedType;
    }

    @Override
    public final void setFeedType(String feedType) {
        this.m_feedType = feedType;
    }

    @Override
    public final int getMaxEntries() {
        return this.m_maxEntries;
    }

    @Override
    public final void setMaxEntries(int maxEntries) {
        this.m_maxEntries = maxEntries;
    }

    @Override
    public final ServletRequest getRequest() {
        return this.m_servletRequest;
    }

    @Override
    public final void setRequest(ServletRequest request) {
        this.m_servletRequest = request;
    }

    @Override
    public final ServletContext getServletContext() {
        return this.m_servletContext;
    }

    @Override
    public final void setServletContext(ServletContext context) {
        this.m_servletContext = context;
    }

    public abstract SyndFeed getFeed();

    @Override
    public final String render() {
        SyndFeed feed = this.getFeed();
        feed.setFeedType(this.getFeedType());
        feed.setAuthor("OpenNMS");
        SyndFeedOutput output = new SyndFeedOutput();
        try {
            StringWriter writer = new StringWriter();
            output.output(feed, (Writer)writer);
            return writer.toString();
        }
        catch (Throwable e) {
            LOG.warn("unable to render feed", e);
            return "";
        }
    }

    protected String sanitizeTitle(String title) {
        return title.replaceAll("<.*?>", "");
    }
}

