/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage.filter;

import javax.servlet.ServletContext;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.filter.NotEqualOrNullFilter;
import org.opennms.web.filter.SQLType;

public class NegativeNodeFilter
extends NotEqualOrNullFilter<Integer> {
    public static final String TYPE = "nodenot";
    private ServletContext m_servletContext;

    public NegativeNodeFilter(int nodeId, ServletContext servletContext) {
        super(TYPE, SQLType.INT, "OUTAGES.NODEID", "node.id", nodeId);
        this.m_servletContext = servletContext;
    }

    @Override
    public String getTextDescription() {
        String nodeName = NetworkElementFactory.getInstance(this.m_servletContext).getNodeLabel(this.getNode());
        if (nodeName == null) {
            nodeName = Integer.toString(this.getNode());
        }
        return "node is not " + nodeName;
    }

    @Override
    public String toString() {
        return "<NegativeNodeFilter: " + this.getDescription() + ">";
    }

    public int getNode() {
        return (Integer)this.getValue();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NegativeNodeFilter)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

