/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.jexl2.ExpressionImpl;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.core.utils.jexl.OnmsJexlEngine;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.netmgt.model.ResourceId;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.util.RrdConvertUtils;
import org.opennms.web.servlet.MissingParameterException;
import org.opennms.web.svclayer.api.GraphResultsService;
import org.opennms.web.svclayer.model.GraphResults;
import org.opennms.web.svclayer.model.RelativeTimePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class GraphResultsController
extends AbstractController
implements InitializingBean {
    private static Logger LOG = LoggerFactory.getLogger(GraphResultsController.class);
    private GraphResultsService m_graphResultsService;
    private static RelativeTimePeriod[] s_periods = RelativeTimePeriod.getDefaultPeriods();

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] requestedParameters = new String[]{"resourceId", "generatedId", "reports", "nodeCriteria"};
        ResourceId[] resourceIds = new ResourceId[]{};
        if (request.getParameterValues("resourceId") != null) {
            resourceIds = (ResourceId[])Arrays.stream(request.getParameterValues("resourceId")).map(ResourceId::fromString).toArray(ResourceId[]::new);
        }
        String[] reports = request.getParameterValues("reports");
        String nodeCriteria = request.getParameter("nodeCriteria");
        String generatedId = request.getParameter("generatedId");
        Object start = request.getParameter("start");
        Object end = request.getParameter("end");
        String relativeTime = request.getParameter("relativetime");
        String startMonth = request.getParameter("startMonth");
        String startDate = request.getParameter("startDate");
        String startYear = request.getParameter("startYear");
        String startHour = request.getParameter("startHour");
        String endMonth = request.getParameter("endMonth");
        String endDate = request.getParameter("endDate");
        String endYear = request.getParameter("endYear");
        String endHour = request.getParameter("endHour");
        long startLong = 0L;
        long endLong = 0L;
        if (start != null || end != null) {
            ourRequiredParameters = new String[]{"start", "end"};
            if (start == null) {
                throw new MissingParameterException("start", ourRequiredParameters);
            }
            if (end == null) {
                throw new MissingParameterException("end", ourRequiredParameters);
            }
            boolean startIsInteger = false;
            boolean endIsInteger = false;
            try {
                startLong = Long.valueOf((String)start);
                startIsInteger = true;
                start = "" + startLong / 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                endLong = Long.valueOf((String)end);
                endIsInteger = true;
                end = "" + endLong / 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (!endIsInteger || !startIsInteger) {
                try {
                    long[] results = RrdConvertUtils.getTimestamps((String)start, (String)end);
                    startLong = results[0] * 1000L;
                    endLong = results[1] * 1000L;
                }
                catch (RrdException e1) {
                    throw new IllegalArgumentException("Could not parse start '" + (String)start + "' and end '" + (String)end + "' as valid time specifications", e1);
                }
            }
        } else if (startMonth != null || startDate != null || startYear != null || startHour != null || endMonth != null || endDate != null || endYear != null || endHour != null) {
            for (String requiredParameter : ourRequiredParameters = new String[]{"startMonth", "startDate", "startYear", "startHour", "endMonth", "endDate", "endYear", "endHour"}) {
                if (request.getParameter(requiredParameter) != null) continue;
                throw new MissingParameterException(requiredParameter, ourRequiredParameters);
            }
            Calendar startCal = Calendar.getInstance();
            startCal.set(2, WebSecurityUtils.safeParseInt((String)startMonth));
            startCal.set(5, WebSecurityUtils.safeParseInt((String)startDate));
            startCal.set(1, WebSecurityUtils.safeParseInt((String)startYear));
            startCal.set(11, WebSecurityUtils.safeParseInt((String)startHour));
            startCal.set(12, 0);
            startCal.set(13, 0);
            startCal.set(14, 0);
            Calendar endCal = Calendar.getInstance();
            endCal.set(2, WebSecurityUtils.safeParseInt((String)endMonth));
            endCal.set(5, WebSecurityUtils.safeParseInt((String)endDate));
            endCal.set(1, WebSecurityUtils.safeParseInt((String)endYear));
            endCal.set(11, WebSecurityUtils.safeParseInt((String)endHour));
            endCal.set(12, 0);
            endCal.set(13, 0);
            endCal.set(14, 0);
            startLong = startCal.getTime().getTime();
            endLong = endCal.getTime().getTime();
        } else {
            if (relativeTime == null) {
                relativeTime = RelativeTimePeriod.DEFAULT_RELATIVE_TIME_PERIOD.getId();
            }
            RelativeTimePeriod period = RelativeTimePeriod.getPeriodByIdOrDefault((RelativeTimePeriod[])s_periods, (String)relativeTime, (RelativeTimePeriod)RelativeTimePeriod.DEFAULT_RELATIVE_TIME_PERIOD);
            long[] times = period.getStartAndEndTimes();
            startLong = times[0];
            endLong = times[1];
        }
        String matching = request.getParameter("matching");
        if (matching != null && resourceIds.length != 0) {
            reports = this.getSuggestedReports(resourceIds[0], matching);
        }
        ModelAndView modelAndView = null;
        try {
            GraphResults model = this.m_graphResultsService.findResults(resourceIds, reports, generatedId, nodeCriteria, startLong, endLong, relativeTime);
            modelAndView = new ModelAndView("/graph/results", "results", (Object)model);
        }
        catch (Exception e) {
            LOG.warn("Can't get graph results", (Throwable)e);
            modelAndView = new ModelAndView("/graph/results-error");
        }
        modelAndView.addObject("loggedIn", (Object)(request.getRemoteUser() != null ? 1 : 0));
        return modelAndView;
    }

    public String[] getSuggestedReports(ResourceId resourceId, String matching) {
        ArrayList<String> metricList = new ArrayList<String>();
        OnmsJexlEngine expressionParser = new OnmsJexlEngine();
        try {
            ExpressionImpl e = (ExpressionImpl)expressionParser.createExpression(matching);
            for (List list : e.getVariables()) {
                if (((String)list.get(0)).equalsIgnoreCase("math")) continue;
                if (((String)list.get(0)).equalsIgnoreCase("datasources")) {
                    metricList.add(((String)list.get(1)).intern());
                    continue;
                }
                metricList.add(((String)list.get(0)).intern());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!metricList.isEmpty()) {
            ArrayList<String> templates = new ArrayList<String>();
            for (PrefabGraph graph : this.m_graphResultsService.getAllPrefabGraphs(resourceId)) {
                boolean found = false;
                for (String c : graph.getColumns()) {
                    if (!metricList.contains(c)) continue;
                    found = true;
                }
                if (!found) continue;
                templates.add(graph.getName());
            }
            if (!templates.isEmpty()) {
                return templates.toArray(new String[templates.size()]);
            }
        }
        return new String[]{"all"};
    }

    public GraphResultsService getGraphResultsService() {
        return this.m_graphResultsService;
    }

    public void setGraphResultsService(GraphResultsService graphResultsService) {
        this.m_graphResultsService = graphResultsService;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_graphResultsService != null ? 1 : 0) != 0, (String)"graphResultsService property must be set to a non-null value");
    }
}

