/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.alarm.filter;

import java.util.Arrays;
import java.util.Map;
import javax.servlet.ServletContext;
import org.opennms.web.alarm.filter.ServiceFilter;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.filter.Filter;
import org.opennms.web.filter.OrFilter;
import org.springframework.util.CollectionUtils;

public class ServiceOrFilter
extends OrFilter {
    private final Integer[] serviceIds;
    private final Map<String, Integer> serviceNameToIdMap;

    public ServiceOrFilter(Integer[] serviceIds, ServletContext servletContext) {
        super((Filter[])Arrays.stream(serviceIds).map(serviceId -> new ServiceFilter((int)serviceId, servletContext)).toArray(Filter[]::new));
        this.serviceIds = serviceIds;
        this.serviceNameToIdMap = NetworkElementFactory.getInstance(servletContext).getServiceNameToIdMap();
    }

    @Override
    public String getTextDescription() {
        Object[] serviceNames = new String[this.serviceIds.length];
        for (int index = 0; index < this.serviceIds.length; ++index) {
            Integer serviceId = this.serviceIds[index];
            serviceNames[index] = this.findServiceName(serviceId);
        }
        return "Service OR Filter: \"" + Arrays.toString(serviceNames) + "\"";
    }

    private String findServiceName(Integer serviceId) {
        if (!CollectionUtils.isEmpty(this.serviceNameToIdMap)) {
            for (Map.Entry<String, Integer> stringIntegerEntry : this.serviceNameToIdMap.entrySet()) {
                if (!stringIntegerEntry.getValue().equals(serviceId)) continue;
                return stringIntegerEntry.getKey();
            }
        }
        return String.format("Service ID: %d", serviceId);
    }

    @Override
    public String toString() {
        return "<ServiceOrFilter: " + this.getDescription() + ">";
    }

    @Override
    public String getDescription() {
        return "conditionalFilter=" + Arrays.toString((Object[])this.serviceIds);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceOrFilter)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

