/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.alarm;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.servlet.ServletContext;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.alarm.AcknowledgeType;
import org.opennms.web.alarm.SortStyle;
import org.opennms.web.alarm.filter.AcknowledgedByFilter;
import org.opennms.web.alarm.filter.AfterFirstEventTimeFilter;
import org.opennms.web.alarm.filter.AfterLastEventTimeFilter;
import org.opennms.web.alarm.filter.AlarmCriteria;
import org.opennms.web.alarm.filter.AlarmTextFilter;
import org.opennms.web.alarm.filter.BeforeFirstEventTimeFilter;
import org.opennms.web.alarm.filter.BeforeLastEventTimeFilter;
import org.opennms.web.alarm.filter.CategoryFilter;
import org.opennms.web.alarm.filter.EventParmLikeFilter;
import org.opennms.web.alarm.filter.ExactUEIFilter;
import org.opennms.web.alarm.filter.IPAddrLikeFilter;
import org.opennms.web.alarm.filter.InterfaceFilter;
import org.opennms.web.alarm.filter.LocationFilter;
import org.opennms.web.alarm.filter.LogMessageMatchesAnyFilter;
import org.opennms.web.alarm.filter.NegativeAcknowledgedByFilter;
import org.opennms.web.alarm.filter.NegativeAlarmTextFilter;
import org.opennms.web.alarm.filter.NegativeCategoryFilter;
import org.opennms.web.alarm.filter.NegativeEventParmLikeFilter;
import org.opennms.web.alarm.filter.NegativeExactUEIFilter;
import org.opennms.web.alarm.filter.NegativeIPAddrLikeFilter;
import org.opennms.web.alarm.filter.NegativeInterfaceFilter;
import org.opennms.web.alarm.filter.NegativeLocationFilter;
import org.opennms.web.alarm.filter.NegativeNodeFilter;
import org.opennms.web.alarm.filter.NegativeNodeLocationFilter;
import org.opennms.web.alarm.filter.NegativeNodeNameLikeFilter;
import org.opennms.web.alarm.filter.NegativePartialUEIFilter;
import org.opennms.web.alarm.filter.NegativeServiceFilter;
import org.opennms.web.alarm.filter.NegativeSeverityFilter;
import org.opennms.web.alarm.filter.NodeFilter;
import org.opennms.web.alarm.filter.NodeLocationFilter;
import org.opennms.web.alarm.filter.NodeNameLikeFilter;
import org.opennms.web.alarm.filter.PartialUEIFilter;
import org.opennms.web.alarm.filter.ServiceOrFilter;
import org.opennms.web.alarm.filter.SeverityOrFilter;
import org.opennms.web.alarm.filter.SituationFilter;
import org.opennms.web.filter.Filter;
import org.opennms.web.utils.filter.CheckboxFilterUtils;
import org.opennms.web.utils.filter.FilterTokenizeUtils;

public abstract class AlarmUtil {
    public static final String ANY_SERVICES_OPTION = "Any";
    public static final String ANY_SEVERITIES_OPTION = "Any";
    public static final String ANY_RELATIVE_TIMES_OPTION = "Any";
    public static final String NEGATION_PREFIX_SYMBOL = "!";
    public static final int LAST_HOUR_RELATIVE_TIME = 1;
    public static final int LAST_FOUR_HOURS_RELATIVE_TIME = 2;
    public static final int LAST_EIGHT_HOURS_RELATIVE_TIME = 3;
    public static final int LAST_TWELVE_HOURS_RELATIVE_TIME = 4;
    public static final int LAST_DAY_RELATIVE_TIME = 5;
    public static final int LAST_WEEK_RELATIVE_TIME = 6;
    public static final int LAST_MONTH_RELATIVE_TIME = 7;

    public static OnmsCriteria getOnmsCriteria(AlarmCriteria alarmCriteria) {
        final OnmsCriteria criteria = new OnmsCriteria(OnmsAlarm.class);
        criteria.createAlias("node", "node", 1);
        criteria.createAlias("distPoller", "distPoller", 1);
        criteria.createAlias("lastEvent", "lastEvent", 1);
        criteria.createAlias("serviceType", "serviceType", 1);
        alarmCriteria.visit(new AlarmCriteria.AlarmCriteriaVisitor<RuntimeException>(){

            @Override
            public void visitAckType(AcknowledgeType ackType) throws RuntimeException {
                if (ackType == AcknowledgeType.ACKNOWLEDGED) {
                    criteria.add(Restrictions.isNotNull((String)"alarmAckUser"));
                } else if (ackType == AcknowledgeType.UNACKNOWLEDGED) {
                    criteria.add(Restrictions.isNull((String)"alarmAckUser"));
                }
            }

            @Override
            public void visitFilter(Filter filter) throws RuntimeException {
                criteria.add(filter.getCriterion());
            }

            @Override
            public void visitLimit(int limit, int offset) throws RuntimeException {
                criteria.setMaxResults(Integer.valueOf(limit));
                criteria.setFirstResult(Integer.valueOf(offset));
            }

            @Override
            public void visitSortStyle(SortStyle sortStyle) throws RuntimeException {
                switch (sortStyle) {
                    case COUNT: {
                        criteria.addOrder(Order.desc((String)"counter"));
                        break;
                    }
                    case FIRSTEVENTTIME: {
                        criteria.addOrder(Order.desc((String)"firstEventTime"));
                        break;
                    }
                    case ID: {
                        criteria.addOrder(Order.desc((String)"id"));
                        break;
                    }
                    case INTERFACE: {
                        criteria.addOrder(Order.desc((String)"ipAddr"));
                        break;
                    }
                    case LASTEVENTTIME: {
                        criteria.addOrder(Order.desc((String)"lastEventTime"));
                        break;
                    }
                    case NODE: {
                        criteria.addOrder(Order.desc((String)"node.label"));
                        break;
                    }
                    case POLLER: {
                        criteria.addOrder(Order.desc((String)"distPoller"));
                        break;
                    }
                    case SERVICE: {
                        criteria.addOrder(Order.desc((String)"serviceType.name"));
                        break;
                    }
                    case SEVERITY: {
                        criteria.addOrder(Order.desc((String)"severity"));
                        break;
                    }
                    case ACKUSER: {
                        criteria.addOrder(Order.asc((String)"alarmAckUser"));
                        break;
                    }
                    case SITUATION: {
                        criteria.addOrder(Order.desc((String)"situation"));
                        break;
                    }
                    case REVERSE_COUNT: {
                        criteria.addOrder(Order.asc((String)"counter"));
                        break;
                    }
                    case REVERSE_FIRSTEVENTTIME: {
                        criteria.addOrder(Order.asc((String)"firstEventTime"));
                        break;
                    }
                    case REVERSE_ID: {
                        criteria.addOrder(Order.asc((String)"id"));
                        break;
                    }
                    case REVERSE_INTERFACE: {
                        criteria.addOrder(Order.asc((String)"ipAddr"));
                        break;
                    }
                    case REVERSE_LASTEVENTTIME: {
                        criteria.addOrder(Order.asc((String)"lastEventTime"));
                        break;
                    }
                    case REVERSE_NODE: {
                        criteria.addOrder(Order.asc((String)"node.label"));
                        break;
                    }
                    case REVERSE_POLLER: {
                        criteria.addOrder(Order.asc((String)"distPoller"));
                        break;
                    }
                    case REVERSE_SERVICE: {
                        criteria.addOrder(Order.asc((String)"serviceType.name"));
                        break;
                    }
                    case REVERSE_SEVERITY: {
                        criteria.addOrder(Order.asc((String)"severity"));
                        break;
                    }
                    case REVERSE_ACKUSER: {
                        criteria.addOrder(Order.desc((String)"alarmAckUser"));
                        break;
                    }
                    case REVERSE_SITUATION: {
                        criteria.addOrder(Order.asc((String)"situation"));
                        break;
                    }
                }
            }
        });
        return criteria;
    }

    public static boolean isInteger(String str) {
        return str != null && !str.isEmpty() && str.chars().allMatch(Character::isDigit);
    }

    public static Filter getFilter(String[] allFilters, String filterString, ServletContext servletContext) {
        if (filterString == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter filter = null;
        String[] tokenizedFilterString = FilterTokenizeUtils.tokenizeFilterString(filterString);
        String type = tokenizedFilterString[0];
        String value = tokenizedFilterString[1];
        if (type.equals("severity")) {
            String[] ids = value.split(",");
            OnmsSeverity[] severities = new OnmsSeverity[ids.length];
            for (int index = 0; index < ids.length; ++index) {
                severities[index] = OnmsSeverity.get((int)WebSecurityUtils.safeParseInt((String)ids[index]));
            }
            filter = new SeverityOrFilter(severities);
        } else if (type.equals("node")) {
            filter = new NodeFilter(WebSecurityUtils.safeParseInt((String)value), servletContext);
        } else if (type.equals("nodenamelike")) {
            filter = value.startsWith(NEGATION_PREFIX_SYMBOL) ? new NegativeNodeNameLikeFilter(value.substring(1)) : new NodeNameLikeFilter(value);
        } else if (type.equals("interface")) {
            filter = new InterfaceFilter(InetAddressUtils.addr((String)value));
        } else if (type.equals("conditionalFilter")) {
            String cleanedValue = value.substring(1, value.length() - 1);
            String[] ids = cleanedValue.split(",");
            boolean hasInteger = false;
            ArrayList<Integer> serviceIdsList = new ArrayList<Integer>();
            ArrayList<OnmsSeverity> severitiesList = new ArrayList<OnmsSeverity>();
            for (String id : ids) {
                String trimmedId = id.trim();
                if (AlarmUtil.isInteger(trimmedId)) {
                    hasInteger = true;
                    serviceIdsList.add(WebSecurityUtils.safeParseInt((String)trimmedId));
                    continue;
                }
                severitiesList.add(OnmsSeverity.get((String)trimmedId));
            }
            if (hasInteger) {
                Integer[] serviceIds = serviceIdsList.toArray(new Integer[0]);
                filter = new ServiceOrFilter(serviceIds, servletContext);
            } else {
                OnmsSeverity[] severities = severitiesList.toArray(new OnmsSeverity[0]);
                filter = new SeverityOrFilter(severities);
            }
        } else if (type.equals("service")) {
            String[] ids = value.split(",");
            Integer[] serviceIds = new Integer[ids.length];
            for (int index = 0; index < ids.length; ++index) {
                serviceIds[index] = WebSecurityUtils.safeParseInt((String)ids[index]);
            }
            filter = new ServiceOrFilter(serviceIds, servletContext);
        } else if (type.equals("partialUei")) {
            filter = new PartialUEIFilter(value);
        } else if (type.equals("exactUei")) {
            filter = new ExactUEIFilter(value);
        } else if (type.equals("acknowledgedBy")) {
            filter = new AcknowledgedByFilter(value);
        } else if (type.equals("severitynot")) {
            filter = new NegativeSeverityFilter(OnmsSeverity.get((int)WebSecurityUtils.safeParseInt((String)value)));
        } else if (type.equals("nodenot")) {
            filter = new NegativeNodeFilter(WebSecurityUtils.safeParseInt((String)value), servletContext);
        } else if (type.equals("interfacenot")) {
            filter = new NegativeInterfaceFilter(InetAddressUtils.addr((String)value));
        } else if (type.equals("servicenot")) {
            filter = new NegativeServiceFilter(WebSecurityUtils.safeParseInt((String)value), servletContext);
        } else if (type.equals("partialUeiNot")) {
            filter = new NegativePartialUEIFilter(value);
        } else if (type.equals("exactUeiNot")) {
            filter = new NegativeExactUEIFilter(value);
        } else if (type.equals("acknowledgedByNot")) {
            filter = new NegativeAcknowledgedByFilter(value);
        } else if (type.equals("iplike")) {
            filter = value.startsWith(NEGATION_PREFIX_SYMBOL) ? new NegativeIPAddrLikeFilter(value.substring(1)) : new IPAddrLikeFilter(value);
        } else if (type.equals("alarmtext")) {
            filter = value.startsWith(NEGATION_PREFIX_SYMBOL) ? new NegativeAlarmTextFilter(value.substring(1)) : new AlarmTextFilter(value);
        } else if (type.equals("msgmatchany")) {
            filter = new LogMessageMatchesAnyFilter(value);
        } else if (type.equals("beforelasteventtime")) {
            filter = new BeforeLastEventTimeFilter(WebSecurityUtils.safeParseLong((String)value));
        } else if (type.equals("beforefirsteventtime")) {
            filter = new BeforeFirstEventTimeFilter(WebSecurityUtils.safeParseLong((String)value));
        } else if (type.equals("afterlasteventtime")) {
            filter = new AfterLastEventTimeFilter(WebSecurityUtils.safeParseLong((String)value));
        } else if (type.equals("afterfirsteventtime")) {
            filter = new AfterFirstEventTimeFilter(WebSecurityUtils.safeParseLong((String)value));
        } else if (type.equals("parmmatchany")) {
            filter = new EventParmLikeFilter(value);
        } else if (type.equals("noparmmatchany")) {
            filter = new NegativeEventParmLikeFilter(value);
        } else if (type.equals("location")) {
            filter = new LocationFilter(value);
        } else if (type.equals("locationnot")) {
            filter = new NegativeLocationFilter(value);
        } else if (type.equals("nodelocation")) {
            filter = new NodeLocationFilter(value);
        } else if (type.equals("nodelocationnot")) {
            filter = new NegativeNodeLocationFilter(value);
        } else if (type.equals("situation")) {
            filter = new SituationFilter(Boolean.valueOf(value));
        } else if (type.equals("category")) {
            String[] nestedFilterString = AlarmUtil.findFilterString(allFilters, "nestedCategoryNot");
            filter = CheckboxFilterUtils.isCheckboxToggled(nestedFilterString) ? new NegativeCategoryFilter(value) : new CategoryFilter(value);
        }
        return filter;
    }

    private static String[] findFilterString(String[] allFilters, String filterString) {
        if (allFilters == null) {
            return null;
        }
        for (String thisFilter : allFilters) {
            if (!thisFilter.startsWith(filterString)) continue;
            return FilterTokenizeUtils.tokenizeFilterString(thisFilter);
        }
        return null;
    }

    public static String getFilterString(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return filter.getDescription();
    }

    public static Filter getRelativeTimeFilter(int relativeTime) {
        AfterLastEventTimeFilter filter = null;
        Calendar now = Calendar.getInstance();
        switch (relativeTime) {
            case 1: {
                now.add(10, -1);
                break;
            }
            case 2: {
                now.add(10, -4);
                break;
            }
            case 3: {
                now.add(10, -8);
                break;
            }
            case 4: {
                now.add(10, -12);
                break;
            }
            case 5: {
                now.add(10, -24);
                break;
            }
            case 6: {
                now.add(10, -168);
                break;
            }
            case 7: {
                now.add(2, -1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown relative time constant: " + relativeTime);
            }
        }
        filter = new AfterLastEventTimeFilter(now.getTime());
        return filter;
    }

    public static List<Filter> getFilterList(String[] filterStrings, ServletContext servletContext) {
        filterStrings = CheckboxFilterUtils.handleCheckboxDuplication(filterStrings);
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        if (filterStrings != null) {
            for (String filterString : filterStrings) {
                Filter filter = AlarmUtil.getFilter(filterStrings, filterString, servletContext);
                if (filter == null) continue;
                filterList.add(filter);
            }
        }
        return filterList;
    }
}

