/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.nodeManagement;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.WebSecurityUtils;

public class SetCriticalPathServlet
extends HttpServlet {
    private static final long serialVersionUID = -5363097208855224954L;
    private static final String SQL_SET_CRITICAL_PATH = "INSERT INTO pathoutage (nodeid, criticalpathip, criticalpathservicename) VALUES (?, ?, ?)";
    private static final String SQL_DELETE_CRITICAL_PATH = "DELETE FROM pathoutage WHERE nodeid=?";

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String nodeString = request.getParameter("node");
        String criticalIp = InetAddressUtils.normalize((String)request.getParameter("criticalIp"));
        String criticalSvc = request.getParameter("criticalSvc");
        String task = request.getParameter("task");
        int node = -1;
        try {
            node = WebSecurityUtils.safeParseInt((String)nodeString);
        }
        catch (NumberFormatException numE) {
            throw new ServletException((Throwable)numE);
        }
        if (task.equals("Delete")) {
            try {
                SetCriticalPathServlet.deleteCriticalPath(node);
            }
            catch (SQLException e) {
                throw new ServletException("SetCriticalPathServlet: Error writing to database." + String.valueOf(e));
            }
        } else if (task.equals("Submit")) {
            try {
                SetCriticalPathServlet.setCriticalPath(node, criticalIp, criticalSvc);
            }
            catch (SQLException e) {
                throw new ServletException("SetCriticalPathServlet: Error writing to database." + String.valueOf(e));
            }
        } else {
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/nodemanagement/setPathOutage.jsp?node=" + node + "&task=Requested operation " + task + " not understood.");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/nodemanagement/index.jsp?node=" + node);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteCriticalPath(int node) throws SQLException {
        DBUtils d = new DBUtils(SetCriticalPathServlet.class);
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement(SQL_DELETE_CRITICAL_PATH);
            d.watch((Object)stmt);
            stmt.setInt(1, node);
            stmt.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCriticalPath(int node, String criticalIp, String criticalSvc) throws SQLException {
        SetCriticalPathServlet.deleteCriticalPath(node);
        DBUtils d = new DBUtils(SetCriticalPathServlet.class);
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement(SQL_SET_CRITICAL_PATH);
            d.watch((Object)stmt);
            stmt.setInt(1, node);
            stmt.setString(2, criticalIp);
            stmt.setString(3, criticalSvc);
            stmt.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
    }
}

