/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.account;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.opennms.netmgt.config.UserFactory;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.config.users.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSettingsFilter
implements Filter {
    private Logger LOG = LoggerFactory.getLogger(UserSettingsFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession userSession = httpRequest.getSession(false);
        String userId = httpRequest.getRemoteUser();
        if (userSession != null && userId != null && userSession.getAttribute("org.opennms.ui.timezoneid") == null) {
            this.setUserTimeZoneIdIfPossible(httpRequest, userId);
        }
        filterChain.doFilter(request, response);
    }

    private void setUserTimeZoneIdIfPossible(HttpServletRequest httpRequest, String userId) {
        Optional<User> user = this.getUser(userId);
        ZoneId timeZoneId = user.isPresent() ? user.get().getTimeZoneId().orElse(ZoneId.systemDefault()) : ZoneId.systemDefault();
        httpRequest.getSession().setAttribute("org.opennms.ui.timezoneid", (Object)timeZoneId);
    }

    private Optional<User> getUser(String userId) {
        if (userId == null || userId.length() == 0) {
            return Optional.empty();
        }
        try {
            UserFactory.init();
            UserManager userFactory = UserFactory.getInstance();
            return Optional.ofNullable(userFactory.getUser(userId));
        }
        catch (IOException e) {
            this.LOG.warn("Can not retrieve user - will use system default time zone settings", (Throwable)e);
            return Optional.empty();
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) {
    }
}

