/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.stats;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.Striped;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import net.agkn.hll.HLL;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.Sample;
import org.opennms.integration.api.v1.timeseries.Tag;
import org.opennms.netmgt.timeseries.stats.StatisticsCollector;

public class StatisticsCollectorImpl
implements StatisticsCollector {
    private static final int MAX_TOP_N_METRIC = 10;
    private static final int MAX_TOP_N_TAG_KEYS = 10000;
    private static final int STRIPE_MULTIPLIER = 4;
    private final AtomicInteger lowestTagCount = new AtomicInteger();
    private final ConcurrentSkipListSet<Metric> topNMetrics = new ConcurrentSkipListSet<Object>(Comparator.comparingInt(m -> ((Metric)m).getMetaTags().size() + ((Metric)m).getExternalTags().size()).reversed().thenComparing(m -> ((Metric)m).getKey()));
    private final ConcurrentHashMap<String, HLL> topNTags = new ConcurrentHashMap();
    private final HashFunction hllHashFunction = Hashing.murmur3_128();
    private final Striped<Lock> stripedLock;

    @Inject
    public StatisticsCollectorImpl(@Named(value="timeseries.writer_threads") Integer numWriterThreads) {
        this.stripedLock = Striped.lazyWeakLock((int)(numWriterThreads * 4));
    }

    @Override
    public void record(Collection<Sample> samples) {
        for (Sample sample : samples) {
            Metric metric = sample.getMetric();
            int count = this.countNoOfTags(metric);
            if (this.topNMetrics.size() < 10 && count >= this.lowestTagCount.get() || count > this.lowestTagCount.get()) {
                this.putInTopNMetrics(metric);
            }
            if (this.topNTags.size() >= 10000) continue;
            metric.getIntrinsicTags().forEach(this::putInTopTags);
            metric.getMetaTags().forEach(this::putInTopTags);
            metric.getExternalTags().forEach(this::putInTopTags);
        }
    }

    void putInTopNMetrics(Metric metric) {
        this.topNMetrics.add(metric);
        while (this.topNMetrics.size() > 10) {
            this.topNMetrics.pollLast();
        }
        this.lowestTagCount.set(this.countNoOfTags(this.topNMetrics.last()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putInTopTags(Tag tag) {
        long hash = this.hllHashFunction.hashString((CharSequence)tag.getValue(), StandardCharsets.UTF_8).asLong();
        Lock lock = null;
        try {
            lock = (Lock)this.stripedLock.get((Object)tag.getKey());
            lock.lock();
            this.topNTags.computeIfAbsent(tag.getKey(), k -> new HLL(14, 5)).addRaw(hash);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    private int countNoOfTags(Metric metric) {
        return 2 + metric.getMetaTags().size() + metric.getExternalTags().size();
    }

    @Override
    public List<Metric> getTopNMetricsWithMostTags() {
        return this.topNMetrics.stream().collect(Collectors.toUnmodifiableList());
    }

    @Override
    public List<String> getTopNTags() {
        Comparator<Map.Entry> comp = Comparator.comparingLong(e -> ((HLL)e.getValue()).cardinality()).reversed().thenComparing(Map.Entry::getKey);
        return this.topNTags.entrySet().stream().sorted(comp).limit(100L).map(e -> (String)e.getKey() + ": " + ((HLL)e.getValue()).cardinality()).collect(Collectors.toUnmodifiableList());
    }
}

