/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.twin.kafka.publisher;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import io.opentracing.Scope;
import io.opentracing.Tracer;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.opennms.core.ipc.common.kafka.KafkaConfigProvider;
import org.opennms.core.ipc.common.kafka.OnmsKafkaConfigProvider;
import org.opennms.core.ipc.common.kafka.Utils;
import org.opennms.core.ipc.twin.api.LocalTwinSubscriber;
import org.opennms.core.ipc.twin.api.TwinRequest;
import org.opennms.core.ipc.twin.api.TwinUpdate;
import org.opennms.core.ipc.twin.common.AbstractTwinPublisher;
import org.opennms.core.ipc.twin.kafka.common.KafkaConsumerRunner;
import org.opennms.core.ipc.twin.kafka.common.Topic;
import org.opennms.core.ipc.twin.model.TwinResponseProto;
import org.opennms.core.logging.Logging;
import org.opennms.core.tracing.api.TracerRegistry;
import org.opennms.core.tracing.util.TracingInfoCarrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTwinPublisher
extends AbstractTwinPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaTwinPublisher.class);
    private static final RateLimitedLog RATE_LIMITED_LOG = RateLimitedLog.withRateLimit((Logger)LOG).maxRate(5).every(Duration.ofSeconds(30L)).build();
    private final KafkaConfigProvider kafkaConfigProvider;
    private KafkaProducer<String, byte[]> producer;
    private KafkaConsumerRunner consumerRunner;

    public KafkaTwinPublisher(LocalTwinSubscriber localTwinSubscriber, TracerRegistry tracerRegistry, MetricRegistry metricRegistry) {
        this(localTwinSubscriber, (KafkaConfigProvider)new OnmsKafkaConfigProvider("org.opennms.core.ipc.twin.kafka.", "org.opennms.core.ipc.kafka."), tracerRegistry, metricRegistry);
    }

    public KafkaTwinPublisher(LocalTwinSubscriber localTwinSubscriber, KafkaConfigProvider kafkaConfigProvider, TracerRegistry tracerRegistry, MetricRegistry metricRegistry) {
        super(localTwinSubscriber, tracerRegistry, metricRegistry);
        this.kafkaConfigProvider = Objects.requireNonNull(kafkaConfigProvider);
    }

    public void init() throws Exception {
        Properties kafkaConfig = new Properties();
        kafkaConfig.put("enable.auto.commit", (Object)true);
        kafkaConfig.put("auto.commit.interval.ms", "1000");
        kafkaConfig.put("auto.offset.reset", "earliest");
        kafkaConfig.put("key.deserializer", StringDeserializer.class.getCanonicalName());
        kafkaConfig.put("value.deserializer", ByteArrayDeserializer.class.getCanonicalName());
        kafkaConfig.put("key.serializer", StringSerializer.class.getCanonicalName());
        kafkaConfig.put("value.serializer", ByteArraySerializer.class.getCanonicalName());
        kafkaConfig.putAll((Map<?, ?>)this.kafkaConfigProvider.getProperties());
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"ipc");){
            LOG.debug("Initialized kafka twin publisher with {}", (Object)kafkaConfig);
            this.producer = (KafkaProducer)Utils.runWithGivenClassLoader(() -> new KafkaProducer(kafkaConfig), (ClassLoader)KafkaProducer.class.getClassLoader());
            KafkaConsumer consumer = (KafkaConsumer)Utils.runWithGivenClassLoader(() -> new KafkaConsumer(kafkaConfig), (ClassLoader)KafkaProducer.class.getClassLoader());
            consumer.subscribe((Collection)ImmutableList.builder().add((Object)Topic.request()).build());
            this.consumerRunner = new KafkaConsumerRunner(consumer, this::handleMessage, "twin-publisher");
        }
    }

    public void close() throws IOException {
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"ipc");){
            if (this.consumerRunner != null) {
                this.consumerRunner.close();
            }
            if (this.producer != null) {
                this.producer.close();
            }
        }
    }

    protected void handleSinkUpdate(TwinUpdate sinkUpdate) {
        try {
            String topic = Strings.isNullOrEmpty((String)sinkUpdate.getLocation()) ? Topic.responseGlobal() : Topic.responseForLocation((String)sinkUpdate.getLocation());
            TwinResponseProto proto = this.mapTwinResponse(sinkUpdate);
            ProducerRecord record = new ProducerRecord(topic, (Object)sinkUpdate.getKey(), (Object)proto.toByteArray());
            this.producer.send(record, (meta, ex) -> {
                if (ex != null) {
                    if (ex instanceof UnknownTopicOrPartitionException) {
                        RATE_LIMITED_LOG.error("Failed to send Twin update to topic '{}'. Topic does not exist. If auto.create.topics.enable=false on the broker, ensure this topic is created manually. Key: {}", new Object[]{topic, sinkUpdate.getKey(), ex});
                    } else {
                        RATE_LIMITED_LOG.error("Error publishing Twin update to topic '{}': {}", new Object[]{topic, ex.getMessage(), ex});
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.error("Exception while sending update for key {} at location {} ", (Object)sinkUpdate.getKey(), (Object)sinkUpdate.getLocation());
        }
    }

    private void handleMessage(ConsumerRecord<String, byte[]> record) {
        try {
            TwinRequest request = this.mapTwinRequestProto((byte[])record.value());
            String tracingOperationKey = KafkaTwinPublisher.generateTracingOperationKey((String)request.getLocation(), (String)request.getKey());
            Tracer.SpanBuilder spanBuilder = TracingInfoCarrier.buildSpanFromTracingMetadata((Tracer)this.getTracer(), (String)tracingOperationKey, (Map)request.getTracingInfo(), (String)"follows_from");
            try (Scope scope = spanBuilder.startActive(true);){
                TwinUpdate response = this.getTwin(request);
                this.addTracingInfo(scope.span(), response);
                this.handleSinkUpdate(response);
            }
        }
        catch (Exception e) {
            LOG.error("Exception while processing request", (Throwable)e);
        }
    }
}

