/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo.util;

import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

public class MorUtil {
    public static final String moPackageName = "com.vmware.vim25.mo";
    private static Logger log = Logger.getLogger(MorUtil.class);

    public static ManagedObjectReference[] createMORs(ManagedObject[] mos) {
        if (mos == null) {
            throw new IllegalArgumentException();
        }
        ManagedObjectReference[] mors = new ManagedObjectReference[mos.length];
        for (int i = 0; i < mos.length; ++i) {
            mors[i] = mos[i].getMOR();
        }
        return mors;
    }

    public static ManagedObject createExactManagedObject(ServerConnection sc, ManagedObjectReference mor) {
        if (mor == null) {
            return null;
        }
        String moType = mor.getType();
        Class<?> moClass = null;
        try {
            moClass = Class.forName("com.vmware.vim25.mo." + moType);
            Constructor<?> constructor = moClass.getConstructor(ServerConnection.class, ManagedObjectReference.class);
            return (ManagedObject)constructor.newInstance(sc, mor);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("vijava does not have an associated class for this mor: " + mor.getVal(), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No constructor found in vijava for class: " + moClass.getName(), e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("vijava is unable to create a managed object from this mor: " + mor.getVal(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("vijava is unable to create a managed object from this mor: " + mor.getVal(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("vijava is unable to create a managed object from this mor: " + mor.getVal(), e);
        }
    }

    public static ManagedEntity createExactManagedEntity(ServerConnection sc, ManagedObjectReference mor) {
        return (ManagedEntity)MorUtil.createExactManagedObject(sc, mor);
    }

    public static ManagedEntity[] createManagedEntities(ServerConnection sc, ManagedObjectReference[] mors) {
        if (mors == null) {
            return new ManagedEntity[0];
        }
        ManagedEntity[] mes = new ManagedEntity[mors.length];
        for (int i = 0; i < mors.length; ++i) {
            mes[i] = MorUtil.createExactManagedEntity(sc, mors[i]);
        }
        return mes;
    }

    public static ManagedObjectReference createMOR(String type, String value) {
        ManagedObjectReference mor = new ManagedObjectReference();
        mor.val = value;
        mor.type = type;
        return mor;
    }
}

