/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo.util;

import com.vmware.vim25.mo.util.OptionSpec;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class CommandLineParser {
    private HashMap<String, String> optsEntered = new HashMap();
    private HashMap userOpts = new HashMap();
    private HashMap builtInOpts = new HashMap();

    public CommandLineParser(OptionSpec[] userOptions, String[] args) {
        this.builtinOptions();
        if (userOptions != null) {
            this.addOptions(userOptions);
            this.parseInput(args);
            this.validate();
        } else {
            this.parseInput(args);
            this.validate();
        }
    }

    public void addOptions(OptionSpec[] userOptions) {
        for (int i = 0; i < userOptions.length; ++i) {
            if (userOptions[i].getOptionName() == null || userOptions[i].getOptionName().length() <= 0 || userOptions[i].getOptionDesc() == null || userOptions[i].getOptionDesc().length() <= 0 || userOptions[i].getOptionType() == null || userOptions[i].getOptionType().length() <= 0 || userOptions[i].getOptionRequired() != 0 && userOptions[i].getOptionName().length() <= 1) {
                System.out.println("Option " + userOptions[i].getOptionName() + " definition is not valid");
                throw new IllegalArgumentException("Option " + userOptions[i].getOptionName() + " definition is not valid");
            }
            this.userOpts.put(userOptions[i].getOptionName(), userOptions[i]);
        }
    }

    private void builtinOptions() {
        OptionSpec url = new OptionSpec("url", "String", 1, "VI SDK URL to connect to", null);
        OptionSpec userName = new OptionSpec("userName", "String", 1, "Username to connect to the host", null);
        OptionSpec password = new OptionSpec("password", "String", 1, "password of the corresponding user", null);
        OptionSpec config = new OptionSpec("config", "String", 0, "Location of the VI perl configuration file", null);
        OptionSpec protocol = new OptionSpec("protocol", "String", 0, "Protocol used to connect to server", null);
        OptionSpec server = new OptionSpec("server", "String", 0, "VI server to connect to", null);
        OptionSpec portNumber = new OptionSpec("portNumber", "String", 0, "Port used to connect to server", "443");
        OptionSpec servicePath = new OptionSpec("servicePath", "String", 0, "Service path used to connect to server", null);
        OptionSpec sessionFile = new OptionSpec("sessionFile", "String", 0, "File containing session ID/cookie to utilize", null);
        OptionSpec help = new OptionSpec("help", "String", 0, "Display user information for the script", null);
        OptionSpec ignorecert = new OptionSpec("ignorecert", "String", 0, "Ignore the server certificate validation", null);
        this.builtInOpts.put("url", url);
        this.builtInOpts.put("username", userName);
        this.builtInOpts.put("password", password);
        this.builtInOpts.put("password", password);
        this.builtInOpts.put("config", config);
        this.builtInOpts.put("protocol", protocol);
        this.builtInOpts.put("server", server);
        this.builtInOpts.put("portnumber", portNumber);
        this.builtInOpts.put("servicepath", servicePath);
        this.builtInOpts.put("sessionfile", sessionFile);
        this.builtInOpts.put("help", help);
        this.builtInOpts.put("ignorecert", ignorecert);
    }

    public void parseInput(String[] args) {
        try {
            this.getCmdArguments(args);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Exception running : " + e);
        }
        Iterator<String> It = this.optsEntered.keySet().iterator();
        while (It.hasNext()) {
            String keyValue = It.next().toString();
            String keyOptions = this.optsEntered.get(keyValue);
            boolean result = this.checkInputOptions(this.builtInOpts, keyValue);
            boolean valid = this.checkInputOptions(this.userOpts, keyValue);
            if (!result && !valid) {
                System.out.println("Invalid Input Option '" + keyValue + "'");
                this.displayUsage();
                throw new IllegalArgumentException("Invalid Input Option '" + keyValue + "'");
            }
            result = this.checkDatatypes(this.builtInOpts, keyValue, keyOptions);
            valid = this.checkDatatypes(this.userOpts, keyValue, keyOptions);
            if (result || valid) continue;
            System.out.println("Invalid datatype for Input Option '" + keyValue + "'");
            this.displayUsage();
            throw new IllegalArgumentException("Invalid Input Option '" + keyValue + "'");
        }
    }

    private void getCmdArguments(String[] args) {
        int len = args.length;
        if (len == 0) {
            this.displayUsage();
            throw new IllegalArgumentException("usage");
        }
        for (int i = 0; i < args.length; ++i) {
            String val = "";
            String opt = args[i];
            if (opt.startsWith("--") && this.optsEntered.containsKey(opt.substring(2))) {
                System.out.println("key '" + opt.substring(2) + "' already exists ");
                this.displayUsage();
                throw new IllegalArgumentException("key '" + opt.substring(2) + "' already exists ");
            }
            if (!args[i].startsWith("--")) continue;
            if (args.length > i + 1) {
                if (!args[i + 1].startsWith("--")) {
                    val = args[i + 1];
                    this.optsEntered.put(opt.substring(2), val);
                    continue;
                }
                this.optsEntered.put(opt.substring(2), null);
                continue;
            }
            this.optsEntered.put(opt.substring(2), null);
        }
    }

    private boolean checkDatatypes(HashMap Opts, String keyValue, String keyOptions) {
        boolean valid = false;
        valid = Opts.containsKey(keyValue);
        if (valid) {
            OptionSpec oSpec = (OptionSpec)Opts.get(keyValue);
            String dataType = oSpec.getOptionType();
            boolean result = this.validateDataType(dataType, keyOptions);
            return result;
        }
        return false;
    }

    private boolean validateDataType(String dataType, String keyValue) {
        try {
            if (dataType.equalsIgnoreCase("Boolean")) {
                return keyValue.equalsIgnoreCase("true") || keyValue.equalsIgnoreCase("false");
            }
            if (dataType.equalsIgnoreCase("Integer")) {
                Integer.parseInt(keyValue);
                return true;
            }
            if (dataType.equalsIgnoreCase("Float")) {
                Float.parseFloat(keyValue);
                return true;
            }
            if (dataType.equalsIgnoreCase("Long")) {
                Long.parseLong(keyValue);
                return true;
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean checkInputOptions(HashMap checkOptions, String value) {
        boolean valid = false;
        valid = checkOptions.containsKey(value);
        return valid;
    }

    public void validate() {
        this.validate(null, null);
    }

    public void validate(Object className, String functionName) {
        int i;
        if (this.optsEntered.isEmpty()) {
            this.displayUsage();
            throw new IllegalArgumentException("---help");
        }
        if (this.optsEntered.get("help") != null) {
            this.displayUsage();
            System.exit(1);
        }
        if (this.option_is_set("help")) {
            this.displayUsage();
            System.exit(1);
        }
        Vector vec = this.getValue(this.builtInOpts);
        for (i = 0; i < vec.size(); ++i) {
            if (this.optsEntered.get(vec.get(i)) != null) continue;
            String missingArg = (String)vec.get(i);
            if (missingArg.equalsIgnoreCase("password")) {
                String password = this.readPassword("Enter password: ");
                this.optsEntered.put("password", password);
                continue;
            }
            System.out.print("----ERROR: " + (String)vec.get(i) + " not specified \n");
            this.displayUsage();
            throw new IllegalArgumentException("----ERROR: " + (String)vec.get(i) + " not specified \n");
        }
        vec = this.getValue(this.userOpts);
        for (i = 0; i < vec.size(); ++i) {
            if (this.optsEntered.get(vec.get(i)) != null) continue;
            System.out.print("----ERROR: " + (String)vec.get(i) + " not specified \n");
            this.displayUsage();
            throw new IllegalArgumentException("----ERROR: " + (String)vec.get(i) + " not specified \n");
        }
        if (this.optsEntered.get("sessionfile") == null && this.optsEntered.get("username") == null && this.optsEntered.get("password") == null) {
            System.out.println("Must have one of command options 'sessionfile' or a 'username' and 'password' pair\n");
            this.displayUsage();
            throw new IllegalArgumentException("Must have one of command options 'sessionfile' or a 'username' and 'password' pair\n");
        }
    }

    private Vector getValue(HashMap checkOptions) {
        Iterator It = checkOptions.keySet().iterator();
        Vector<String> vec = new Vector<String>();
        while (It.hasNext()) {
            String str = It.next().toString();
            OptionSpec oSpec = (OptionSpec)checkOptions.get(str);
            if (oSpec.getOptionRequired() != 1) continue;
            vec.add(str);
        }
        return vec;
    }

    public void displayUsage() {
        System.out.println("Common Java Options :");
        this.print_options(this.builtInOpts);
        System.out.println("\nCommand specific options: ");
        this.print_options(this.userOpts);
    }

    private void print_options(HashMap Opts) {
        String type = "";
        String defaultVal = "";
        String help = "";
        Set generalKeys = Opts.keySet();
        Iterator It = generalKeys.iterator();
        while (It.hasNext()) {
            String keyValue = It.next().toString();
            OptionSpec oSpec = (OptionSpec)Opts.get(keyValue);
            if (oSpec.getOptionType() != null && oSpec.getOptionDefault() != null) {
                type = oSpec.getOptionType();
                defaultVal = oSpec.getOptionDefault();
                System.out.println("   --" + keyValue + " < type " + type + ", default " + defaultVal + ">");
            }
            if (oSpec.getOptionDefault() != null && oSpec.getOptionType() == null) {
                defaultVal = oSpec.getOptionDefault();
                System.out.println("   --" + keyValue + " < default " + defaultVal + " >");
            } else if (oSpec.getOptionType() != null && oSpec.getOptionDefault() == null) {
                type = oSpec.getOptionType();
                System.out.println("   --" + keyValue + " < type " + type + " >");
            } else if (oSpec.getOptionType() == null && oSpec.getOptionDefault() == null) {
                System.out.println("   --" + keyValue + " ");
            }
            help = oSpec.getOptionDesc();
            System.out.println("      " + help);
        }
    }

    public boolean option_is_set(String option) {
        boolean valid = false;
        Iterator<String> It = this.optsEntered.keySet().iterator();
        while (It.hasNext()) {
            String keyVal = It.next().toString();
            if (!option.equals(keyVal)) continue;
            valid = true;
        }
        return valid;
    }

    public String get_option(String key) {
        if (this.optsEntered.get(key) != null) {
            return this.optsEntered.get(key).toString();
        }
        if (this.checkInputOptions(this.builtInOpts, key)) {
            if (((OptionSpec)this.builtInOpts.get(key)).getOptionDefault() != null) {
                String str = ((OptionSpec)this.builtInOpts.get(key)).getOptionDefault();
                return str;
            }
            return null;
        }
        if (this.checkInputOptions(this.userOpts, key)) {
            if (((OptionSpec)this.userOpts.get(key)).getOptionDefault() != null) {
                String str = ((OptionSpec)this.userOpts.get(key)).getOptionDefault();
                return str;
            }
            return null;
        }
        System.out.println("undefined variable");
        return null;
    }

    public String getOnelineInput(String prompt) {
        System.out.print(prompt);
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        String pass = null;
        try {
            pass = stdin.readLine();
        }
        catch (IOException ioe) {
            System.out.println("Error in reading console input.");
        }
        return pass;
    }

    public String getUsername() {
        return this.get_option("username");
    }

    public String getPassword() {
        return this.get_option("password");
    }

    private String readPassword(String prompt) {
        try {
            PasswordMask consoleEraser = new PasswordMask();
            System.out.print(prompt);
            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
            consoleEraser.start();
            String pass = stdin.readLine();
            consoleEraser.halt();
            System.out.print("\b");
            return pass;
        }
        catch (Exception e) {
            return null;
        }
    }

    class PasswordMask
    extends Thread {
        private boolean running = true;

        PasswordMask() {
        }

        @Override
        public void run() {
            while (this.running) {
                System.out.print("\b ");
            }
        }

        public synchronized void halt() {
            this.running = false;
        }
    }
}

