/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime.tree;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.CommonTree;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.Tree;

public abstract class BaseTree
implements Tree {
    protected List children;

    public BaseTree() {
    }

    public BaseTree(Tree node) {
    }

    public Tree getChild(int i) {
        if (this.children == null || i >= this.children.size()) {
            return null;
        }
        return (Tree)this.children.get(i);
    }

    public List getChildren() {
        return this.children;
    }

    public Tree getFirstChildWithType(int type) {
        int i = 0;
        while (this.children != null && i < this.children.size()) {
            Tree t = (Tree)this.children.get(i);
            if (t.getType() == type) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public void addChild(Tree t) {
        if (t == null) {
            return;
        }
        BaseTree childTree = (BaseTree)t;
        if (childTree.isNil()) {
            if (this.children != null && this.children == childTree.children) {
                throw new RuntimeException("attempt to add child list to itself");
            }
            if (childTree.children != null) {
                if (this.children != null) {
                    int n = childTree.children.size();
                    int i = 0;
                    while (i < n) {
                        Tree c = (Tree)childTree.children.get(i);
                        this.children.add(c);
                        c.setParent(this);
                        c.setChildIndex(this.children.size() - 1);
                        ++i;
                    }
                } else {
                    this.children = childTree.children;
                    this.freshenParentAndChildIndexes();
                }
            }
        } else {
            if (this.children == null) {
                this.children = this.createChildrenList();
            }
            this.children.add(t);
            childTree.setParent(this);
            childTree.setChildIndex(this.children.size() - 1);
        }
    }

    public void addChildren(List kids) {
        int i = 0;
        while (i < kids.size()) {
            Tree t = (Tree)kids.get(i);
            this.addChild(t);
            ++i;
        }
    }

    public void setChild(int i, Tree t) {
        if (t == null) {
            return;
        }
        if (t.isNil()) {
            throw new IllegalArgumentException("Can't set single child to a list");
        }
        if (this.children == null) {
            this.children = this.createChildrenList();
        }
        this.children.set(i, t);
        t.setParent(this);
        t.setChildIndex(i);
    }

    public Object deleteChild(int i) {
        if (this.children == null) {
            return null;
        }
        Tree killed = (Tree)this.children.remove(i);
        this.freshenParentAndChildIndexes(i);
        return killed;
    }

    public void replaceChildren(int startChildIndex, int stopChildIndex, Object t) {
        if (this.children == null) {
            throw new IllegalArgumentException("indexes invalid; no children in list");
        }
        int replacingHowMany = stopChildIndex - startChildIndex + 1;
        BaseTree newTree = (BaseTree)t;
        ArrayList<BaseTree> newChildren = null;
        if (newTree.isNil()) {
            newChildren = newTree.children;
        } else {
            newChildren = new ArrayList<BaseTree>(1);
            newChildren.add(newTree);
        }
        int replacingWithHowMany = newChildren.size();
        int numNewChildren = newChildren.size();
        int delta = replacingHowMany - replacingWithHowMany;
        if (delta == 0) {
            int j = 0;
            int i = startChildIndex;
            while (i <= stopChildIndex) {
                BaseTree child = (BaseTree)newChildren.get(j);
                this.children.set(i, child);
                child.setParent(this);
                child.setChildIndex(i);
                ++j;
                ++i;
            }
        } else if (delta > 0) {
            int indexToDelete;
            int j = 0;
            while (j < numNewChildren) {
                this.children.set(startChildIndex + j, newChildren.get(j));
                ++j;
            }
            int c = indexToDelete = startChildIndex + numNewChildren;
            while (c <= stopChildIndex) {
                this.children.remove(indexToDelete);
                ++c;
            }
            this.freshenParentAndChildIndexes(startChildIndex);
        } else {
            int j = 0;
            while (j < replacingHowMany) {
                this.children.set(startChildIndex + j, newChildren.get(j));
                ++j;
            }
            int numToInsert = replacingWithHowMany - replacingHowMany;
            int j2 = replacingHowMany;
            while (j2 < replacingWithHowMany) {
                this.children.add(startChildIndex + j2, newChildren.get(j2));
                ++j2;
            }
            this.freshenParentAndChildIndexes(startChildIndex);
        }
    }

    protected List createChildrenList() {
        return new ArrayList();
    }

    public boolean isNil() {
        return false;
    }

    public void freshenParentAndChildIndexes() {
        this.freshenParentAndChildIndexes(0);
    }

    public void freshenParentAndChildIndexes(int offset) {
        int n = this.getChildCount();
        int c = offset;
        while (c < n) {
            Tree child = this.getChild(c);
            child.setChildIndex(c);
            child.setParent(this);
            ++c;
        }
    }

    public void sanityCheckParentAndChildIndexes() {
        this.sanityCheckParentAndChildIndexes(null, -1);
    }

    public void sanityCheckParentAndChildIndexes(Tree parent, int i) {
        if (parent != this.getParent()) {
            throw new IllegalStateException("parents don't match; expected " + parent + " found " + this.getParent());
        }
        if (i != this.getChildIndex()) {
            throw new IllegalStateException("child indexes don't match; expected " + i + " found " + this.getChildIndex());
        }
        int n = this.getChildCount();
        int c = 0;
        while (c < n) {
            CommonTree child = (CommonTree)this.getChild(c);
            child.sanityCheckParentAndChildIndexes(this, c);
            ++c;
        }
    }

    public int getChildIndex() {
        return 0;
    }

    public void setChildIndex(int index) {
    }

    public Tree getParent() {
        return null;
    }

    public void setParent(Tree t) {
    }

    public boolean hasAncestor(int ttype) {
        return this.getAncestor(ttype) != null;
    }

    public Tree getAncestor(int ttype) {
        Tree t = this;
        t = t.getParent();
        while (t != null) {
            if (t.getType() == ttype) {
                return t;
            }
            t = t.getParent();
        }
        return null;
    }

    public List getAncestors() {
        if (this.getParent() == null) {
            return null;
        }
        ArrayList<Tree> ancestors = new ArrayList<Tree>();
        Tree t = this;
        t = t.getParent();
        while (t != null) {
            ancestors.add(0, t);
            t = t.getParent();
        }
        return ancestors;
    }

    public String toStringTree() {
        if (this.children == null || this.children.size() == 0) {
            return this.toString();
        }
        StringBuffer buf = new StringBuffer();
        if (!this.isNil()) {
            buf.append("(");
            buf.append(this.toString());
            buf.append(' ');
        }
        int i = 0;
        while (this.children != null && i < this.children.size()) {
            Tree t = (Tree)this.children.get(i);
            if (i > 0) {
                buf.append(' ');
            }
            buf.append(t.toStringTree());
            ++i;
        }
        if (!this.isNil()) {
            buf.append(")");
        }
        return buf.toString();
    }

    public int getLine() {
        return 0;
    }

    public int getCharPositionInLine() {
        return 0;
    }

    public abstract String toString();
}

