/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.joesnmp;

import java.math.BigInteger;
import java.net.InetAddress;
import org.opennms.netmgt.snmp.AbstractSnmpValue;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.protocols.snmp.SnmpCounter32;
import org.opennms.protocols.snmp.SnmpCounter64;
import org.opennms.protocols.snmp.SnmpEndOfMibView;
import org.opennms.protocols.snmp.SnmpIPAddress;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpNoSuchInstance;
import org.opennms.protocols.snmp.SnmpNoSuchObject;
import org.opennms.protocols.snmp.SnmpNull;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpOpaque;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpTimeTicks;
import org.opennms.protocols.snmp.SnmpUInt32;

class JoeSnmpValue
extends AbstractSnmpValue {
    SnmpSyntax m_value;

    JoeSnmpValue(SnmpSyntax value) {
        this.m_value = value;
    }

    JoeSnmpValue(int typeId, byte[] initialBytes) {
        byte[] bytes = initialBytes == null ? null : (byte[])initialBytes.clone();
        switch (typeId) {
            case 70: {
                this.m_value = new SnmpCounter64(new BigInteger(bytes));
                break;
            }
            case 2: {
                this.m_value = new SnmpInt32(new BigInteger(bytes).intValue());
                break;
            }
            case 65: {
                this.m_value = new SnmpCounter32(new BigInteger(bytes).longValue());
                break;
            }
            case 67: {
                this.m_value = new SnmpTimeTicks(new BigInteger(bytes).longValue());
                break;
            }
            case 66: {
                this.m_value = new SnmpUInt32(new BigInteger(bytes).longValue());
                break;
            }
            case 64: {
                this.m_value = new SnmpIPAddress(bytes);
                break;
            }
            case 6: {
                this.m_value = new SnmpObjectId(new String(bytes));
                break;
            }
            case 68: {
                this.m_value = new SnmpOpaque(bytes);
                break;
            }
            case 4: {
                this.m_value = new SnmpOctetString(bytes);
                break;
            }
            case -126: {
                this.m_value = new SnmpEndOfMibView();
                break;
            }
            case -127: {
                this.m_value = new SnmpNoSuchInstance();
                break;
            }
            case -128: {
                this.m_value = new SnmpNoSuchObject();
                break;
            }
            case 5: {
                this.m_value = new SnmpNull();
                break;
            }
            default: {
                throw new IllegalArgumentException("invaldi type id " + typeId);
            }
        }
    }

    public byte[] getBytes() {
        switch (this.m_value.typeId()) {
            case 2: 
            case 65: 
            case 66: 
            case 67: 
            case 70: {
                return this.toBigInteger().toByteArray();
            }
            case 64: {
                return this.toInetAddress().getAddress();
            }
            case 6: {
                return ((SnmpObjectId)this.m_value).toString().getBytes();
            }
            case 4: 
            case 68: {
                return ((SnmpOctetString)this.m_value).getString();
            }
            case -128: 
            case -127: 
            case -126: 
            case 5: {
                return new byte[0];
            }
        }
        throw new IllegalArgumentException("cannot convert " + String.valueOf(this.m_value) + " to a byte array");
    }

    public boolean isEndOfMib() {
        return this.m_value instanceof SnmpEndOfMibView;
    }

    public boolean isError() {
        switch (this.getType()) {
            case 128: 
            case 129: {
                return true;
            }
        }
        return false;
    }

    public boolean isNumeric() {
        switch (this.m_value.typeId()) {
            case 2: 
            case 65: 
            case 66: 
            case 67: 
            case 70: {
                return true;
            }
        }
        return false;
    }

    public int toInt() {
        switch (this.m_value.typeId()) {
            case 70: {
                return ((SnmpCounter64)this.m_value).getValue().intValue();
            }
            case 2: {
                return ((SnmpInt32)this.m_value).getValue();
            }
            case 65: 
            case 66: 
            case 67: {
                return (int)((SnmpUInt32)this.m_value).getValue();
            }
        }
        return Integer.parseInt(this.m_value.toString());
    }

    public long toLong() {
        switch (this.m_value.typeId()) {
            case 70: {
                return ((SnmpCounter64)this.m_value).getValue().longValue();
            }
            case 2: {
                return ((SnmpInt32)this.m_value).getValue();
            }
            case 65: 
            case 66: 
            case 67: {
                return ((SnmpUInt32)this.m_value).getValue();
            }
            case 4: {
                return this.convertStringToLong();
            }
        }
        return Long.parseLong(this.m_value.toString());
    }

    private long convertStringToLong() {
        return Double.valueOf(this.m_value.toString()).longValue();
    }

    public int getType() {
        return this.m_value.typeId();
    }

    public String toDisplayString() {
        switch (this.m_value.typeId()) {
            case 67: {
                return Long.toString(this.toLong());
            }
            case 4: {
                return SnmpOctetString.toDisplayString((SnmpOctetString)((SnmpOctetString)this.m_value));
            }
        }
        return this.m_value.toString();
    }

    public InetAddress toInetAddress() {
        switch (this.m_value.typeId()) {
            case 64: {
                return SnmpIPAddress.toInetAddress((SnmpIPAddress)((SnmpIPAddress)this.m_value));
            }
        }
        throw new IllegalArgumentException("cannot convert " + String.valueOf(this.m_value) + " to an InetAddress");
    }

    public String toHexString() {
        switch (this.m_value.typeId()) {
            case 4: {
                return SnmpOctetString.toHexString((SnmpOctetString)((SnmpOctetString)this.m_value));
            }
        }
        throw new IllegalArgumentException("cannt convert " + String.valueOf(this.m_value) + " to a HexString");
    }

    public String toString() {
        return this.toDisplayString();
    }

    public BigInteger toBigInteger() {
        switch (this.m_value.typeId()) {
            case 70: {
                return ((SnmpCounter64)this.m_value).getValue();
            }
            case 2: {
                return BigInteger.valueOf(((SnmpInt32)this.m_value).getValue());
            }
            case 65: 
            case 66: 
            case 67: {
                return BigInteger.valueOf(((SnmpUInt32)this.m_value).getValue());
            }
        }
        return new BigInteger(this.m_value.toString());
    }

    public SnmpObjId toSnmpObjId() {
        switch (this.m_value.typeId()) {
            case 6: {
                return SnmpObjId.get((int[])((SnmpObjectId)this.m_value).getIdentifiers());
            }
        }
        throw new IllegalArgumentException("cannt convert " + String.valueOf(this.m_value) + " to a SnmpObjId");
    }

    public boolean isDisplayable() {
        if (this.isNumeric()) {
            return true;
        }
        if (this.getType() == 6 || this.getType() == 64) {
            return true;
        }
        if (this.getType() == 4) {
            return JoeSnmpValue.allBytesDisplayable((byte[])this.getBytes());
        }
        return false;
    }

    public boolean isNull() {
        return this.getType() == 5;
    }

    public SnmpSyntax getSnmpSyntax() {
        return this.m_value;
    }

    public int hashCode() {
        if (this.m_value == null) {
            return 2677;
        }
        return this.m_value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        JoeSnmpValue that = (JoeSnmpValue)((Object)obj);
        return this.m_value == null ? that.m_value == null : this.m_value.equals(that.m_value);
    }
}

