/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml.schema.syslog;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.integration.api.xml.ConfigUtils;

@XmlRootElement(name="configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Configuration
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String DEFAULT_PARSER = "org.opennms.netmgt.syslogd.CustomSyslogParser";
    private static final String DEFAULT_DISCARD_UEI = "DISCARD-MATCHING-MESSAGES";
    @XmlAttribute(name="listen-address")
    private String m_listenAddress;
    @XmlAttribute(name="syslog-port", required=true)
    private Integer m_syslogPort;
    @XmlAttribute(name="new-suspect-on-message")
    private Boolean m_newSuspectOnMessage;
    @XmlAttribute(name="forwarding-regexp")
    private String m_forwardingRegexp;
    @XmlAttribute(name="matching-group-host")
    private Integer m_matchingGroupHost;
    @XmlAttribute(name="matching-group-message")
    private Integer m_matchingGroupMessage;
    @XmlAttribute(name="parser")
    private String m_parser;
    @XmlAttribute(name="discard-uei")
    private String m_discardUei;
    @XmlAttribute(name="threads")
    private Integer m_threads;
    @XmlAttribute(name="queue-size")
    private Integer m_queueSize;
    @XmlAttribute(name="batch-size")
    private Integer m_batchSize;
    @XmlAttribute(name="batch-interval")
    private Integer m_batchInterval;
    @XmlAttribute(name="timezone")
    private String timeZone;

    public Optional<String> getListenAddress() {
        return Optional.ofNullable(this.m_listenAddress);
    }

    public void setListenAddress(String listenAddress) {
        this.m_listenAddress = ConfigUtils.normalizeString(listenAddress);
    }

    public Integer getSyslogPort() {
        return this.m_syslogPort;
    }

    public void setSyslogPort(Integer syslogPort) {
        this.m_syslogPort = ConfigUtils.assertMinimumInclusive(ConfigUtils.assertNotNull(syslogPort, "syslog-port"), 1L, "syslog-port");
    }

    public Boolean getNewSuspectOnMessage() {
        return this.m_newSuspectOnMessage != null ? this.m_newSuspectOnMessage : Boolean.FALSE;
    }

    public void setNewSuspectOnMessage(Boolean newSuspectOnMessage) {
        this.m_newSuspectOnMessage = newSuspectOnMessage;
    }

    public Optional<String> getForwardingRegexp() {
        return Optional.ofNullable(this.m_forwardingRegexp);
    }

    public void setForwardingRegexp(String forwardingRegexp) {
        this.m_forwardingRegexp = ConfigUtils.normalizeString(forwardingRegexp);
    }

    public Optional<Integer> getMatchingGroupHost() {
        return Optional.ofNullable(this.m_matchingGroupHost);
    }

    public void setMatchingGroupHost(Integer matchingGroupHost) {
        this.m_matchingGroupHost = ConfigUtils.assertMinimumInclusive(matchingGroupHost, 1L, "matching-group-host");
    }

    public Optional<Integer> getMatchingGroupMessage() {
        return Optional.ofNullable(this.m_matchingGroupMessage);
    }

    public void setMatchingGroupMessage(Integer matchingGroupMessage) {
        this.m_matchingGroupMessage = ConfigUtils.assertMinimumInclusive(matchingGroupMessage, 1L, "matching-group-message");
    }

    public String getParser() {
        return this.m_parser != null ? this.m_parser : DEFAULT_PARSER;
    }

    public void setParser(String parser) {
        this.m_parser = ConfigUtils.normalizeString(parser);
    }

    public String getDiscardUei() {
        return this.m_discardUei != null ? this.m_discardUei : DEFAULT_DISCARD_UEI;
    }

    public void setDiscardUei(String discardUei) {
        this.m_discardUei = ConfigUtils.normalizeString(discardUei);
    }

    public Optional<Integer> getThreads() {
        return Optional.ofNullable(this.m_threads);
    }

    public void setThreads(Integer threads) {
        this.m_threads = ConfigUtils.assertMinimumInclusive(threads, 1L, "threads");
    }

    public Integer getQueueSize() {
        return this.m_queueSize != null ? this.m_queueSize : 10000;
    }

    public void setQueueSize(Integer queueSize) {
        this.m_queueSize = ConfigUtils.assertMinimumInclusive(queueSize, 1L, "queue-size");
    }

    public Integer getBatchSize() {
        return this.m_batchSize != null ? this.m_batchSize : 1000;
    }

    public void setBatchSize(Integer batchSize) {
        this.m_batchSize = ConfigUtils.assertMinimumInclusive(batchSize, 1L, "batch-size");
    }

    public Integer getBatchInterval() {
        return this.m_batchInterval != null ? this.m_batchInterval : 500;
    }

    public void setBatchInterval(Integer batchInterval) {
        this.m_batchInterval = ConfigUtils.assertMinimumInclusive(batchInterval, 1L, "batch-interval");
    }

    public Optional<TimeZone> getTimeZone() {
        if (this.timeZone == null || this.timeZone.trim().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(TimeZone.getTimeZone(ZoneId.of(this.timeZone)));
    }

    public void setTimeZone(String timeZone) {
        if (timeZone == null || timeZone.trim().isEmpty()) {
            this.timeZone = null;
        }
        ZoneId.of(timeZone);
        this.timeZone = timeZone;
    }

    public int hashCode() {
        return Objects.hash(this.m_listenAddress, this.m_syslogPort, this.m_newSuspectOnMessage, this.m_forwardingRegexp, this.m_matchingGroupHost, this.m_matchingGroupMessage, this.m_parser, this.m_discardUei, this.m_threads, this.m_queueSize, this.m_batchSize, this.m_batchInterval, this.timeZone);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Configuration) {
            Configuration that = (Configuration)obj;
            return Objects.equals(this.m_listenAddress, that.m_listenAddress) && Objects.equals(this.m_syslogPort, that.m_syslogPort) && Objects.equals(this.m_newSuspectOnMessage, that.m_newSuspectOnMessage) && Objects.equals(this.m_forwardingRegexp, that.m_forwardingRegexp) && Objects.equals(this.m_matchingGroupHost, that.m_matchingGroupHost) && Objects.equals(this.m_matchingGroupMessage, that.m_matchingGroupMessage) && Objects.equals(this.m_parser, that.m_parser) && Objects.equals(this.m_discardUei, that.m_discardUei) && Objects.equals(this.m_threads, that.m_threads) && Objects.equals(this.m_queueSize, that.m_queueSize) && Objects.equals(this.m_batchSize, that.m_batchSize) && Objects.equals(this.m_batchInterval, that.m_batchInterval) && Objects.equals(this.timeZone, that.timeZone);
        }
        return false;
    }
}

