/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.enlinkd;

import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="enlinkd-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="enlinkd-configuration.xsd")
public class EnlinkdConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="executor-threads", required=true)
    private Integer m_executorThreads;
    @XmlAttribute(name="executor-queue-size", required=true)
    private Integer m_executorQueueSize;
    @XmlAttribute(name="threads", required=true)
    private Integer m_schedulerThreads;
    @XmlAttribute(name="discovery-bridge-threads")
    private Integer m_discoveryBridgeThreads;
    @XmlAttribute(name="initial_sleep_time")
    private Long m_initialSleepTime;
    @XmlAttribute(name="bridge_topology_interval")
    private Long m_bridgeTopologyInterval;
    @XmlAttribute(name="topology_interval")
    private Long m_topologyUpdaterInterval;
    @XmlAttribute(name="cdp-priority")
    private Integer m_cdpPriority;
    @XmlAttribute(name="cdp_rescan_interval")
    private Long m_cdpRescanInterval;
    @XmlAttribute(name="use-cdp-discovery")
    private Boolean m_useCdpDiscovery;
    @XmlAttribute(name="bridge-priority")
    private Integer m_bridgePriority;
    @XmlAttribute(name="bridge_rescan_interval")
    private Long m_bridgeRescanInterval;
    @XmlAttribute(name="use-bridge-discovery")
    private Boolean m_useBridgeDiscovery;
    @XmlAttribute(name="lldp-priority")
    private Integer m_lldpPriority;
    @XmlAttribute(name="lldp_rescan_interval")
    private Long m_lldpRescanInterval;
    @XmlAttribute(name="use-lldp-discovery")
    private Boolean m_useLldpDiscovery;
    @XmlAttribute(name="ospf-priority")
    private Integer m_ospfPriority;
    @XmlAttribute(name="ospf_rescan_interval")
    private Long m_ospfRescanInterval;
    @XmlAttribute(name="use-ospf-discovery")
    private Boolean m_useOspfDiscovery;
    @XmlAttribute(name="isis-priority")
    private Integer m_isisPriority;
    @XmlAttribute(name="isis_rescan_interval")
    private Long m_isisRescanInterval;
    @XmlAttribute(name="use-isis-discovery")
    private Boolean m_useIsisDiscovery;
    @XmlAttribute(name="disable-bridge-vlan-discovery")
    private Boolean m_disableBridgeVlanDiscovery;
    @XmlAttribute(name="max_bft")
    private Integer m_maxBft;

    public Integer getExecutorThreads() {
        return this.m_executorThreads;
    }

    public void setExecutorThreads(Integer executorThreads) {
        this.m_executorThreads = (Integer)ConfigUtils.assertNotNull((Object)executorThreads, (String)"executorThreads");
    }

    public Integer getExecutorQueueSize() {
        return this.m_executorQueueSize;
    }

    public void setExecutorQueueSize(Integer executorQueueSize) {
        this.m_executorQueueSize = (Integer)ConfigUtils.assertNotNull((Object)executorQueueSize, (String)"executorQueueSize");
    }

    public Integer getThreads() {
        return this.m_schedulerThreads;
    }

    public void setThreads(Integer schedulerThreads) {
        this.m_schedulerThreads = (Integer)ConfigUtils.assertNotNull((Object)schedulerThreads, (String)"schedulerThreads");
    }

    public Long getInitialSleepTime() {
        return this.m_initialSleepTime == null ? 60000L : this.m_initialSleepTime;
    }

    public void setInitialSleepTime(Long initialSleepTime) {
        this.m_initialSleepTime = initialSleepTime;
    }

    public Long getCdpRescanInterval() {
        return this.m_cdpRescanInterval == null ? 86400000L : this.m_cdpRescanInterval;
    }

    public void setCdpRescanInterval(Long rescanInterval) {
        this.m_cdpRescanInterval = rescanInterval;
    }

    public Long getLldpRescanInterval() {
        return this.m_lldpRescanInterval == null ? 86400000L : this.m_lldpRescanInterval;
    }

    public void setLldpRescanInterval(Long rescanInterval) {
        this.m_lldpRescanInterval = rescanInterval;
    }

    public Long getBridgeRescanInterval() {
        return this.m_bridgeRescanInterval == null ? 86400000L : this.m_bridgeRescanInterval;
    }

    public void setBridgeRescanInterval(Long rescanInterval) {
        this.m_bridgeRescanInterval = rescanInterval;
    }

    public Long getOspfRescanInterval() {
        return this.m_ospfRescanInterval == null ? 86400000L : this.m_ospfRescanInterval;
    }

    public void setOspfRescanInterval(Long rescanInterval) {
        this.m_ospfRescanInterval = rescanInterval;
    }

    public Long getIsisRescanInterval() {
        return this.m_isisRescanInterval == null ? 86400000L : this.m_isisRescanInterval;
    }

    public void setIsisRescanInterval(Long rescanInterval) {
        this.m_isisRescanInterval = rescanInterval;
    }

    public Long getBridgeTopologyInterval() {
        return this.m_bridgeTopologyInterval == null ? 300000L : this.m_bridgeTopologyInterval;
    }

    public void setBridgeTopologyInterval(Long bridgeTopologyInterval) {
        this.m_bridgeTopologyInterval = bridgeTopologyInterval;
    }

    public Long getTopologyInterval() {
        return this.m_topologyUpdaterInterval == null ? 30000L : this.m_topologyUpdaterInterval;
    }

    public void setTopologyInterval(Long topologyInterval) {
        this.m_topologyUpdaterInterval = topologyInterval;
    }

    public Integer getMaxBft() {
        return this.m_maxBft != null ? this.m_maxBft : 100;
    }

    public void setMaxBft(Integer maxBft) {
        this.m_maxBft = maxBft;
    }

    public Integer getDiscoveryBridgeThreads() {
        return this.m_discoveryBridgeThreads != null ? this.m_discoveryBridgeThreads : 1;
    }

    public void setDiscoveryBridgeThreads(Integer discoveryBridgeThreads) {
        this.m_discoveryBridgeThreads = discoveryBridgeThreads;
    }

    public Boolean getUseCdpDiscovery() {
        return this.m_useCdpDiscovery != null ? this.m_useCdpDiscovery : true;
    }

    public void setUseCdpDiscovery(Boolean useCdpDiscovery) {
        this.m_useCdpDiscovery = useCdpDiscovery;
    }

    public Boolean getUseBridgeDiscovery() {
        return this.m_useBridgeDiscovery != null ? this.m_useBridgeDiscovery : true;
    }

    public void setUseBridgeDiscovery(Boolean useBridgeDiscovery) {
        this.m_useBridgeDiscovery = useBridgeDiscovery;
    }

    public Boolean getUseLldpDiscovery() {
        return this.m_useLldpDiscovery != null ? this.m_useLldpDiscovery : true;
    }

    public void setUseLldpDiscovery(Boolean useLldpDiscovery) {
        this.m_useLldpDiscovery = useLldpDiscovery;
    }

    public Boolean getUseOspfDiscovery() {
        return this.m_useOspfDiscovery != null ? this.m_useOspfDiscovery : true;
    }

    public void setUseOspfDiscovery(Boolean useOspfDiscovery) {
        this.m_useOspfDiscovery = useOspfDiscovery;
    }

    public Boolean getUseIsisDiscovery() {
        return this.m_useIsisDiscovery != null ? this.m_useIsisDiscovery : true;
    }

    public void setUseIsisDiscovery(Boolean useIsisDiscovery) {
        this.m_useIsisDiscovery = useIsisDiscovery;
    }

    public Boolean getDisableBridgeVlanDiscovery() {
        return this.m_disableBridgeVlanDiscovery;
    }

    public void setDisableBridgeVlanDiscovery(Boolean disableBridgeVlanDiscovery) {
        this.m_disableBridgeVlanDiscovery = disableBridgeVlanDiscovery;
    }

    public Integer getCdpPriority() {
        return this.m_cdpPriority != null ? this.m_cdpPriority : 1000;
    }

    public void setCdpPriority(Integer cdpPriority) {
        this.m_cdpPriority = cdpPriority;
    }

    public Integer getBridgePriority() {
        return this.m_bridgePriority != null ? this.m_bridgePriority : 10000;
    }

    public void setBridgePriority(Integer bridgePriority) {
        this.m_bridgePriority = bridgePriority;
    }

    public Integer getLldpPriority() {
        return this.m_lldpPriority != null ? this.m_lldpPriority : 2000;
    }

    public void setLldpPriority(Integer lldpPriority) {
        this.m_lldpPriority = lldpPriority;
    }

    public Integer getOspfPriority() {
        return this.m_ospfPriority != null ? this.m_ospfPriority : 3000;
    }

    public void setOspfPriority(Integer ospfPriority) {
        this.m_ospfPriority = ospfPriority;
    }

    public Integer getIsisPriority() {
        return this.m_isisPriority != null ? this.m_isisPriority : 4000;
    }

    public void setIsisPriority(Integer isisPriority) {
        this.m_isisPriority = isisPriority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnlinkdConfiguration that = (EnlinkdConfiguration)o;
        if (!this.m_executorThreads.equals(that.m_executorThreads)) {
            return false;
        }
        if (!this.m_executorQueueSize.equals(that.m_executorQueueSize)) {
            return false;
        }
        if (!this.m_schedulerThreads.equals(that.m_schedulerThreads)) {
            return false;
        }
        if (!Objects.equals(this.m_discoveryBridgeThreads, that.m_discoveryBridgeThreads)) {
            return false;
        }
        if (!Objects.equals(this.m_initialSleepTime, that.m_initialSleepTime)) {
            return false;
        }
        if (!Objects.equals(this.m_bridgeTopologyInterval, that.m_bridgeTopologyInterval)) {
            return false;
        }
        if (!Objects.equals(this.m_topologyUpdaterInterval, that.m_topologyUpdaterInterval)) {
            return false;
        }
        if (!Objects.equals(this.m_cdpPriority, that.m_cdpPriority)) {
            return false;
        }
        if (!Objects.equals(this.m_cdpRescanInterval, that.m_cdpRescanInterval)) {
            return false;
        }
        if (!Objects.equals(this.m_useCdpDiscovery, that.m_useCdpDiscovery)) {
            return false;
        }
        if (!Objects.equals(this.m_bridgePriority, that.m_bridgePriority)) {
            return false;
        }
        if (!Objects.equals(this.m_bridgeRescanInterval, that.m_bridgeRescanInterval)) {
            return false;
        }
        if (!Objects.equals(this.m_useBridgeDiscovery, that.m_useBridgeDiscovery)) {
            return false;
        }
        if (!Objects.equals(this.m_lldpPriority, that.m_lldpPriority)) {
            return false;
        }
        if (!Objects.equals(this.m_lldpRescanInterval, that.m_lldpRescanInterval)) {
            return false;
        }
        if (!Objects.equals(this.m_useLldpDiscovery, that.m_useLldpDiscovery)) {
            return false;
        }
        if (!Objects.equals(this.m_ospfPriority, that.m_ospfPriority)) {
            return false;
        }
        if (!Objects.equals(this.m_ospfRescanInterval, that.m_ospfRescanInterval)) {
            return false;
        }
        if (!Objects.equals(this.m_useOspfDiscovery, that.m_useOspfDiscovery)) {
            return false;
        }
        if (!Objects.equals(this.m_isisPriority, that.m_isisPriority)) {
            return false;
        }
        if (!Objects.equals(this.m_isisRescanInterval, that.m_isisRescanInterval)) {
            return false;
        }
        if (!Objects.equals(this.m_useIsisDiscovery, that.m_useIsisDiscovery)) {
            return false;
        }
        if (!Objects.equals(this.m_disableBridgeVlanDiscovery, that.m_disableBridgeVlanDiscovery)) {
            return false;
        }
        return Objects.equals(this.m_maxBft, that.m_maxBft);
    }

    public int hashCode() {
        int result = this.m_executorThreads.hashCode();
        result = 31 * result + this.m_executorQueueSize.hashCode();
        result = 31 * result + this.m_schedulerThreads.hashCode();
        result = 31 * result + (this.m_discoveryBridgeThreads != null ? this.m_discoveryBridgeThreads.hashCode() : 0);
        result = 31 * result + (this.m_initialSleepTime != null ? this.m_initialSleepTime.hashCode() : 0);
        result = 31 * result + (this.m_bridgeTopologyInterval != null ? this.m_bridgeTopologyInterval.hashCode() : 0);
        result = 31 * result + (this.m_topologyUpdaterInterval != null ? this.m_topologyUpdaterInterval.hashCode() : 0);
        result = 31 * result + (this.m_cdpPriority != null ? this.m_cdpPriority.hashCode() : 0);
        result = 31 * result + (this.m_cdpRescanInterval != null ? this.m_cdpRescanInterval.hashCode() : 0);
        result = 31 * result + (this.m_useCdpDiscovery != null ? this.m_useCdpDiscovery.hashCode() : 0);
        result = 31 * result + (this.m_bridgePriority != null ? this.m_bridgePriority.hashCode() : 0);
        result = 31 * result + (this.m_bridgeRescanInterval != null ? this.m_bridgeRescanInterval.hashCode() : 0);
        result = 31 * result + (this.m_useBridgeDiscovery != null ? this.m_useBridgeDiscovery.hashCode() : 0);
        result = 31 * result + (this.m_lldpPriority != null ? this.m_lldpPriority.hashCode() : 0);
        result = 31 * result + (this.m_lldpRescanInterval != null ? this.m_lldpRescanInterval.hashCode() : 0);
        result = 31 * result + (this.m_useLldpDiscovery != null ? this.m_useLldpDiscovery.hashCode() : 0);
        result = 31 * result + (this.m_ospfPriority != null ? this.m_ospfPriority.hashCode() : 0);
        result = 31 * result + (this.m_ospfRescanInterval != null ? this.m_ospfRescanInterval.hashCode() : 0);
        result = 31 * result + (this.m_useOspfDiscovery != null ? this.m_useOspfDiscovery.hashCode() : 0);
        result = 31 * result + (this.m_isisPriority != null ? this.m_isisPriority.hashCode() : 0);
        result = 31 * result + (this.m_isisRescanInterval != null ? this.m_isisRescanInterval.hashCode() : 0);
        result = 31 * result + (this.m_useIsisDiscovery != null ? this.m_useIsisDiscovery.hashCode() : 0);
        result = 31 * result + (this.m_disableBridgeVlanDiscovery != null ? this.m_disableBridgeVlanDiscovery.hashCode() : 0);
        result = 31 * result + (this.m_maxBft != null ? this.m_maxBft.hashCode() : 0);
        return result;
    }
}

