/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.api.reporting.parameter;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import org.opennms.api.reporting.ReportMode;
import org.opennms.api.reporting.parameter.ReportParm;
import org.opennms.api.reporting.parameter.ReportParmVisitor;

public class ReportDateParm
extends ReportParm
implements Serializable {
    private static final long serialVersionUID = -8528562178984136887L;
    private Date m_date;
    private Boolean m_useAbsoluteDate;
    private String m_interval;
    private Integer m_count;
    private Integer m_hours;
    private Integer m_minutes;
    private boolean m_isAdjustedDate;

    public Boolean getUseAbsoluteDate() {
        return this.m_useAbsoluteDate;
    }

    public void setUseAbsoluteDate(Boolean useAbsoluteDate) {
        this.m_useAbsoluteDate = useAbsoluteDate;
    }

    public String getInterval() {
        return this.m_interval;
    }

    public void setInterval(String interval) {
        this.m_interval = interval;
    }

    public Integer getCount() {
        return this.m_count;
    }

    public void setCount(Integer count) {
        this.m_count = count;
    }

    public Date getDate() {
        return this.m_date;
    }

    public void setDate(Date date) {
        this.m_date = date;
    }

    public Date getValue(ReportMode mode) {
        if (mode == ReportMode.SCHEDULED && !this.m_useAbsoluteDate.booleanValue()) {
            Calendar cal = Calendar.getInstance();
            int amount = 0 - this.m_count;
            if (this.m_interval.equals("year")) {
                cal.add(1, amount);
            } else if (this.m_interval.equals("month")) {
                cal.add(2, amount);
            } else {
                cal.add(5, amount);
            }
            if (this.m_hours != null) {
                cal.set(11, this.m_hours);
            } else {
                cal.set(11, 0);
            }
            if (this.m_minutes != null) {
                cal.set(12, this.m_minutes);
            } else {
                cal.set(12, 0);
            }
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
        return this.getAdjustedDate();
    }

    public Integer getHours() {
        return this.m_hours;
    }

    public void setHours(Integer hour) {
        this.m_hours = hour;
    }

    public Integer getMinutes() {
        return this.m_minutes;
    }

    public void setMinutes(Integer minute) {
        this.m_minutes = minute;
    }

    @Override
    void accept(ReportParmVisitor visitor) {
        Objects.requireNonNull(visitor).visit(this);
    }

    public boolean isAdjustedDate() {
        return this.m_isAdjustedDate;
    }

    public void setIsAdjustedDate(boolean adjusted) {
        this.m_isAdjustedDate = adjusted;
    }

    private Date getAdjustedDate() {
        if (this.m_isAdjustedDate) {
            return this.m_date;
        }
        long millis = this.m_date.getTime();
        if (!this.m_isAdjustedDate) {
            if (this.m_hours != null) {
                millis += (long)(this.m_hours * 60 * 60 * 1000);
            }
            if (this.m_minutes != null) {
                millis += (long)(this.m_minutes * 60 * 1000);
            }
        }
        return new Date(millis);
    }
}

