/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.api.reporting;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.opennms.api.reporting.parameter.ReportDateParm;
import org.opennms.api.reporting.parameter.ReportDoubleParm;
import org.opennms.api.reporting.parameter.ReportFloatParm;
import org.opennms.api.reporting.parameter.ReportIntParm;
import org.opennms.api.reporting.parameter.ReportParameters;
import org.opennms.api.reporting.parameter.ReportStringParm;
import org.opennms.api.reporting.parameter.ReportTimezoneParm;

public class ReportParameterBuilder {
    private final List<ReportStringParm> stringParams = Lists.newArrayList();
    private final List<ReportIntParm> intParams = Lists.newArrayList();
    private final List<ReportFloatParm> floatParams = Lists.newArrayList();
    private final List<ReportDateParm> dateParams = Lists.newArrayList();
    private final List<ReportDoubleParm> doubleParms = Lists.newArrayList();
    private final List<ReportTimezoneParm> timezoneParms = Lists.newArrayList();

    public ReportParameterBuilder withString(String name, String value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        ReportStringParm stringParm = new ReportStringParm();
        stringParm.setName(name);
        stringParm.setValue(value);
        this.stringParams.add(stringParm);
        return this;
    }

    public ReportParameterBuilder withInteger(String name, Integer value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        ReportIntParm intParm = new ReportIntParm();
        intParm.setName(name);
        intParm.setValue(value);
        this.intParams.add(intParm);
        return this;
    }

    public ReportParameterBuilder withFloat(String name, Float value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        ReportFloatParm parm = new ReportFloatParm();
        parm.setName(name);
        parm.setValue(value);
        this.floatParams.add(parm);
        return this;
    }

    public ReportParameterBuilder withDouble(String name, Double value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        ReportDoubleParm parm = new ReportDoubleParm();
        parm.setName(name);
        parm.setValue(value);
        this.doubleParms.add(parm);
        return this;
    }

    public ReportParameterBuilder withDate(String name, String interval, int count) {
        return this.withDate(name, interval, count, 0, 0);
    }

    public ReportParameterBuilder withDate(String name, String interval, int count, int hours, int minutes) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(interval);
        Preconditions.checkArgument((hours >= 0 && hours <= 23 ? 1 : 0) != 0, (Object)"Hours must be >= 0 and <= 23");
        Preconditions.checkArgument((minutes >= 0 && minutes <= 59 ? 1 : 0) != 0, (Object)"Minutes must be >= 0 and <= 59");
        ReportDateParm parm = new ReportDateParm();
        parm.setName(name);
        parm.setInterval(interval);
        parm.setCount(count);
        parm.setUseAbsoluteDate(false);
        parm.setHours(hours);
        parm.setMinutes(minutes);
        this.dateParams.add(parm);
        return this;
    }

    public ReportParameterBuilder withDate(String name, Date value) {
        return this.withDate(name, value, 0, 0);
    }

    public ReportParameterBuilder withDate(String name, Date value, int hours, int minutes) {
        return this.withDate(name, value, hours, minutes, false);
    }

    public ReportParameterBuilder withDate(String name, Date value, int hours, int minutes, boolean adjusted) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        ReportDateParm parm = new ReportDateParm();
        parm.setName(name);
        parm.setDate(value);
        parm.setUseAbsoluteDate(true);
        parm.setHours(hours);
        parm.setMinutes(minutes);
        parm.setIsAdjustedDate(adjusted);
        this.dateParams.add(parm);
        return this;
    }

    public ReportParameterBuilder withTimezone(String name, ZoneId zoneId) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(zoneId);
        ReportTimezoneParm parm = new ReportTimezoneParm();
        parm.setName(name);
        parm.setValue(zoneId);
        this.timezoneParms.add(parm);
        return this;
    }

    public ReportParameters build() {
        ReportParameters parameters = new ReportParameters();
        parameters.setStringParms(this.stringParams);
        parameters.setIntParms(this.intParams);
        parameters.setFloatParms(this.floatParams);
        parameters.setDateParms(this.dateParams);
        parameters.setDoubleParms(this.doubleParms);
        parameters.setTimezoneParms(this.timezoneParms);
        return parameters;
    }

    public static interface Intervals {
        public static final String Years = "year";
        public static final String Months = "month";
        public static final String Days = "day";
        public static final List<String> ALL = Lists.newArrayList((Object[])new String[]{"year", "month", "day"});
    }
}

