/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.internal;

import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.karaf.jaas.config.KeystoreInstance;
import org.apache.karaf.jaas.config.KeystoreManager;
import org.apache.karaf.management.ConnectorServerFactory;
import org.apache.karaf.management.JaasAuthenticator;
import org.apache.karaf.management.KarafMBeanServerGuard;
import org.apache.karaf.management.MBeanServerFactory;
import org.apache.karaf.management.internal.EventAdminLogger;
import org.apache.karaf.management.internal.EventAdminLoggerImpl;
import org.apache.karaf.management.internal.EventAdminMBeanServerWrapper;
import org.apache.karaf.management.internal.JMXSecurityMBeanImpl;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.Managed;
import org.apache.karaf.util.tracker.annotation.ProvideService;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Services(requires={@RequireService(value=ConfigurationAdmin.class), @RequireService(value=KeystoreManager.class)}, provides={@ProvideService(value=MBeanServer.class)})
@Managed(value="org.apache.karaf.management")
public class Activator
extends BaseActivator
implements ManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private ConnectorServerFactory connectorServerFactory;
    private MBeanServerFactory mbeanServerFactory;
    private ServiceTracker<KeystoreInstance, KeystoreInstance> keystoreInstanceServiceTracker;
    private EventAdminLogger eventAdminLogger;

    @Override
    protected void doStart() throws Exception {
        ConfigurationAdmin configurationAdmin = this.getTrackedService(ConfigurationAdmin.class);
        KeystoreManager keystoreManager = this.getTrackedService(KeystoreManager.class);
        if (configurationAdmin == null || keystoreManager == null) {
            return;
        }
        if (!this.ensureStartupConfiguration("org.apache.karaf.management")) {
            return;
        }
        EventAdminLogger logger = null;
        if (this.getBoolean("audit.eventadmin.enabled", true)) {
            try {
                logger = new EventAdminLoggerImpl(this.bundleContext);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (logger == null) {
            logger = new EventAdminLogger(){

                @Override
                public void close() {
                }

                @Override
                public void log(String methodName, String[] signature, Object result, Throwable error, Object ... params) {
                }
            };
        }
        this.eventAdminLogger = logger;
        String rmiRegistryHost = this.getString("rmiRegistryHost", "");
        int rmiRegistryPort = this.getInt("rmiRegistryPort", 1099);
        String rmiServerHost = this.getString("rmiServerHost", "0.0.0.0");
        int rmiServerPort = this.getInt("rmiServerPort", 44444);
        if (System.getProperty("java.rmi.server.hostname") != null) {
            LOG.warn("java.rmi.server.hostname system property is already set to {}. Apache Karaf doesn't override it", (Object)System.getProperty("java.rmi.server.hostname"));
        } else {
            LOG.info("Setting java.rmi.server.hostname system property to {}", (Object)rmiServerHost);
            System.setProperty("java.rmi.server.hostname", rmiServerHost);
        }
        String credentialsFilterPattern = this.getString("jmx.remote.rmi.server.credentials.filter.pattern", String.class.getName() + ";!*");
        String jmxRealm = this.getString("jmxRealm", "karaf");
        String serviceUrl = this.getString("serviceUrl", "service:jmx:rmi://" + rmiServerHost + ":" + rmiServerPort + "/jndi/rmi://" + rmiRegistryHost + ":" + rmiRegistryPort + "/karaf-" + System.getProperty("karaf.name"));
        boolean jmxmpEnabled = this.getBoolean("jmxmpEnabled", false);
        String jmxmpHost = this.getString("jmxmpHost", "0.0.0.0");
        int jmxmpPort = this.getInt("jmxmpPort", 9999);
        String jmxmpServiceUrl = this.getString("jmxmpServiceUrl", "service:jmx:jmxmp://" + jmxmpHost + ":" + jmxmpPort);
        boolean daemon = this.getBoolean("daemon", true);
        boolean threaded = this.getBoolean("threaded", true);
        ObjectName objectName = new ObjectName(this.getString("objectName", "connector:name=rmi"));
        ObjectName jmxmpObjectName = new ObjectName(this.getString("jmxmpObjectName", "connector:name=jmxmp"));
        long keyStoreAvailabilityTimeout = this.getLong("keyStoreAvailabilityTimeout", 5000L);
        String authenticatorType = this.getString("authenticatorType", "password");
        boolean secured = this.getBoolean("secured", false);
        String secureAlgorithm = this.getString("secureAlgorithm", "default");
        String secureProtocol = this.getString("secureProtocol", "TLS");
        String[] enabledProtocols = this.getStringArray("enabledProtocols", null);
        String[] enabledCipherSuites = this.getStringArray("enabledCipherSuites", null);
        String keyStore = this.getString("keyStore", "karaf.ks");
        String keyAlias = this.getString("keyAlias", "karaf");
        String trustStore = this.getString("trustStore", "karaf.ts");
        boolean createRmiRegistry = this.getBoolean("createRmiRegistry", true);
        boolean locateRmiRegistry = this.getBoolean("locateRmiRegistry", true);
        boolean locateExistingMBeanServerIfPossible = this.getBoolean("locateExistingMBeanServerIfPossible", true);
        KarafMBeanServerGuard guard = new KarafMBeanServerGuard();
        guard.setLogger(this.eventAdminLogger);
        guard.setConfigAdmin(configurationAdmin);
        this.mbeanServerFactory = new MBeanServerFactory();
        this.mbeanServerFactory.setLocateExistingServerIfPossible(locateExistingMBeanServerIfPossible);
        this.mbeanServerFactory.init();
        MBeanServer mbeanServer = this.mbeanServerFactory.getServer();
        mbeanServer = new EventAdminMBeanServerWrapper(mbeanServer, this.eventAdminLogger);
        JaasAuthenticator jaasAuthenticator = new JaasAuthenticator();
        jaasAuthenticator.setRealm(jmxRealm);
        this.connectorServerFactory = new ConnectorServerFactory();
        this.connectorServerFactory.setCreate(createRmiRegistry);
        this.connectorServerFactory.setLocate(locateRmiRegistry);
        this.connectorServerFactory.setHost(rmiRegistryHost);
        this.connectorServerFactory.setPort(rmiRegistryPort);
        this.connectorServerFactory.setBundleContext(this.bundleContext);
        this.connectorServerFactory.setServer(mbeanServer);
        this.connectorServerFactory.setServiceUrl(serviceUrl);
        this.connectorServerFactory.setGuard(guard);
        this.connectorServerFactory.setRmiServerHost(rmiServerHost);
        this.connectorServerFactory.setDaemon(daemon);
        this.connectorServerFactory.setThreaded(threaded);
        this.connectorServerFactory.setObjectName(objectName);
        this.connectorServerFactory.setJmxmpEnabled(jmxmpEnabled);
        this.connectorServerFactory.setJmxmpServiceUrl(jmxmpServiceUrl);
        this.connectorServerFactory.setJmxmpObjectName(jmxmpObjectName);
        HashMap<String, Object> jmxmpEnvironment = new HashMap<String, Object>();
        jmxmpEnvironment.put("jmx.remote.profiles", "SASL/PLAIN");
        jmxmpEnvironment.put("jmx.remote.sasl.callback.handler", jaasAuthenticator);
        HashMap<String, Object> environment = new HashMap<String, Object>();
        environment.put("jmx.remote.authenticator", jaasAuthenticator);
        environment.put("jmx.remote.rmi.server.credentials.filter.pattern", credentialsFilterPattern);
        try {
            this.connectorServerFactory.setEnvironment(environment);
            this.connectorServerFactory.setJmxmpEnvironment(jmxmpEnvironment);
            this.connectorServerFactory.setKeyStoreAvailabilityTimeout(keyStoreAvailabilityTimeout);
            this.connectorServerFactory.setAuthenticatorType(authenticatorType);
            this.connectorServerFactory.setSecured(secured);
            this.connectorServerFactory.setAlgorithm(secureAlgorithm);
            this.connectorServerFactory.setSecureProtocol(secureProtocol);
            this.connectorServerFactory.setEnabledProtocols(enabledProtocols);
            this.connectorServerFactory.setEnabledCipherSuites(enabledCipherSuites);
            this.connectorServerFactory.setKeyStore(keyStore);
            this.connectorServerFactory.setKeyAlias(keyAlias);
            this.connectorServerFactory.setTrustStore(trustStore);
            this.connectorServerFactory.setKeystoreManager(keystoreManager);
            this.connectorServerFactory.init();
        }
        catch (Throwable e) {
            LOG.error("Can't init JMXConnectorServer: " + e.getMessage());
        }
        JMXSecurityMBeanImpl securityMBean = new JMXSecurityMBeanImpl();
        securityMBean.setMBeanServer(mbeanServer);
        securityMBean.setGuard(guard);
        this.registerMBean(securityMBean, "type=security,area=jmx");
        this.register(MBeanServer.class, mbeanServer);
        if (secured) {
            this.keystoreInstanceServiceTracker = new ServiceTracker(this.bundleContext, KeystoreInstance.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<KeystoreInstance, KeystoreInstance>(){

                public KeystoreInstance addingService(ServiceReference<KeystoreInstance> reference) {
                    try {
                        Activator.this.connectorServerFactory.init();
                    }
                    catch (Exception e) {
                        LOG.error("Can't re-init JMXConnectorServer with SSL enabled when register a keystore:" + e.getMessage());
                    }
                    return null;
                }

                public void modifiedService(ServiceReference<KeystoreInstance> reference, KeystoreInstance service) {
                }

                public void removedService(ServiceReference<KeystoreInstance> reference, KeystoreInstance service) {
                    try {
                        Activator.this.connectorServerFactory.init();
                    }
                    catch (Exception e) {
                        LOG.error("Can't re-init JMXConnectorServer with SSL enabled when unregister a keystore: " + e.getMessage());
                    }
                }
            });
            this.keystoreInstanceServiceTracker.open();
        }
    }

    @Override
    protected void doStop() {
        super.doStop();
        if (this.connectorServerFactory != null) {
            try {
                this.connectorServerFactory.destroy();
            }
            catch (Exception e) {
                this.logger.warn("Error destroying ConnectorServerFactory", (Throwable)e);
            }
            this.connectorServerFactory = null;
        }
        if (this.mbeanServerFactory != null) {
            try {
                this.mbeanServerFactory.destroy();
            }
            catch (Exception e) {
                this.logger.warn("Error destroying MBeanServerFactory", (Throwable)e);
            }
            this.mbeanServerFactory = null;
        }
        if (this.keystoreInstanceServiceTracker != null) {
            try {
                this.keystoreInstanceServiceTracker.close();
            }
            finally {
                this.keystoreInstanceServiceTracker = null;
            }
        }
        if (this.eventAdminLogger != null) {
            try {
                this.eventAdminLogger.close();
            }
            finally {
                this.eventAdminLogger = null;
            }
        }
    }
}

