/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.sample;

import java.util.concurrent.CompletableFuture;
import org.opennms.integration.api.sample.SampleDetectorFactory;
import org.opennms.integration.api.v1.detectors.DetectRequest;
import org.opennms.integration.api.v1.detectors.DetectResults;
import org.opennms.integration.api.v1.detectors.ServiceDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleDetector
implements ServiceDetector {
    private static final Logger LOG = LoggerFactory.getLogger(SampleDetector.class);
    public static final String SERVICE_NAME = "Sample";
    public static final String DEFAULT_HOST_NAME = "localhost";
    public static final String DEFAULT_USERNAME_PROPERTY = "username";
    public static final String DEFAULT_USERNAME_VALUE = "admin";
    public static final String DEFAULT_PASSWORD_PROPERTY = "password";
    public static final String DEFAULT_PASSWORD_VALUE = "admin";
    private String username;
    private String password;

    public void init() {
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void dispose() {
    }

    public CompletableFuture<DetectResults> detect(final DetectRequest request) {
        if (request.getAddress().getHostName().equals(DEFAULT_HOST_NAME)) {
            return CompletableFuture.completedFuture(new DetectResults(){

                public boolean isServiceDetected() {
                    LOG.info(" {} service detected on {} ", (Object)SampleDetector.this.getServiceName(), (Object)request.getAddress());
                    return SampleDetector.this.getUsername().equals("admin") && SampleDetector.this.getPassword().equals("admin") && ((String)request.getRuntimeAttributes().get(SampleDetectorFactory.PROTOCOL_ATTRIBUTE)).equals(SampleDetectorFactory.PROTOCOL_VALUE);
                }
            });
        }
        return CompletableFuture.completedFuture(new DetectResults(){

            public boolean isServiceDetected() {
                LOG.info(" {} service not detected on {} ", (Object)SampleDetector.this.getServiceName(), (Object)request.getAddress());
                return false;
            }
        });
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

