/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.api;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.events.api.EventSubscriptionService;
import org.opennms.netmgt.events.api.StoppableEventListener;
import org.opennms.netmgt.events.api.ThreadAwareEventListener;
import org.opennms.netmgt.events.api.annotations.EventExceptionHandler;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.events.api.annotations.EventPostProcessor;
import org.opennms.netmgt.events.api.annotations.EventPreProcessor;
import org.opennms.netmgt.events.api.model.IEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class AnnotationBasedEventListenerAdapter
implements StoppableEventListener,
ThreadAwareEventListener,
InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationBasedEventListenerAdapter.class);
    private volatile String m_name = null;
    private volatile Object m_annotatedListener;
    private volatile String m_logPrefix = null;
    private volatile int m_threads = 1;
    private volatile EventSubscriptionService m_subscriptionService;
    private final Map<String, Method> m_ueiToHandlerMap = new HashMap<String, Method>();
    private final List<Method> m_eventPreProcessors = new LinkedList<Method>();
    private final List<Method> m_eventPostProcessors = new LinkedList<Method>();
    private final SortedSet<Method> m_exceptionHandlers = new TreeSet<Method>(this.createExceptionHandlerComparator());

    public AnnotationBasedEventListenerAdapter(String name, Object annotatedListener, EventSubscriptionService subscriptionService) {
        this.m_name = name;
        this.m_annotatedListener = annotatedListener;
        this.m_subscriptionService = subscriptionService;
        this.afterPropertiesSet();
    }

    public AnnotationBasedEventListenerAdapter(Object annotatedListener, EventSubscriptionService subscriptionService) {
        this(null, annotatedListener, subscriptionService);
    }

    public AnnotationBasedEventListenerAdapter() {
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getLogPrefix() {
        return this.m_logPrefix;
    }

    public void setLogPrefix(String logPrefix) {
        this.m_logPrefix = logPrefix;
    }

    @Override
    public void onEvent(final IEvent event) {
        if (event.getUei() == null) {
            return;
        }
        Method m = this.m_ueiToHandlerMap.get(event.getUei());
        if (m == null && (m = this.m_ueiToHandlerMap.get("*")) == null) {
            throw new IllegalArgumentException("Received an event for which we have no handler!");
        }
        final Method method = m;
        Logging.withPrefix((String)this.m_logPrefix, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    AnnotationBasedEventListenerAdapter.this.preprocessEvent(event);
                    AnnotationBasedEventListenerAdapter.this.processEvent(event, method);
                    AnnotationBasedEventListenerAdapter.this.postprocessEvent(event);
                }
                catch (IllegalArgumentException e) {
                    throw e;
                }
                catch (IllegalAccessException e) {
                    throw new UndeclaredThrowableException(e);
                }
                catch (InvocationTargetException e) {
                    AnnotationBasedEventListenerAdapter.this.handleException(event, e.getCause());
                }
            }
        });
    }

    protected void postprocessEvent(IEvent event) throws IllegalAccessException, InvocationTargetException {
        for (Method m : this.m_eventPostProcessors) {
            this.processEvent(event, m);
        }
    }

    protected void processEvent(IEvent event, Method method) throws IllegalAccessException, InvocationTargetException {
        method.invoke(this.m_annotatedListener, event);
    }

    protected void preprocessEvent(IEvent event) throws IllegalAccessException, InvocationTargetException {
        for (Method m : this.m_eventPreProcessors) {
            this.processEvent(event, m);
        }
    }

    protected void handleException(IEvent event, Throwable cause) {
        for (Method method : this.m_exceptionHandlers) {
            if (!ClassUtils.isAssignableValue(method.getParameterTypes()[1], (Object)cause)) continue;
            try {
                method.invoke(this.m_annotatedListener, event, cause);
                return;
            }
            catch (Throwable e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        LOG.debug("Caught an unhandled exception while processing event {}, for listener {}. Add EventExceptionHandler annotation to the listener", new Object[]{event.getUei(), this.m_annotatedListener, cause});
    }

    public void setAnnotatedListener(Object annotatedListener) {
        this.m_annotatedListener = annotatedListener;
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_subscriptionService != null ? 1 : 0) != 0, (String)"subscriptionService must be set");
        Assert.state((this.m_annotatedListener != null ? 1 : 0) != 0, (String)"must set the annotatedListener property");
        EventListener listenerInfo = AnnotationBasedEventListenerAdapter.findEventListenerAnnotation(this.m_annotatedListener);
        Assert.state((listenerInfo != null ? 1 : 0) != 0, (String)("value of annotatedListener property of class " + String.valueOf(this.m_annotatedListener.getClass()) + " must be annotated as " + EventListener.class.getName()));
        if (this.m_name == null) {
            this.m_name = listenerInfo.name();
        }
        if (this.m_logPrefix == null) {
            this.m_logPrefix = listenerInfo.logPrefix() != null && !"".equals(listenerInfo.logPrefix()) ? listenerInfo.logPrefix() : this.m_name;
        }
        this.m_threads = listenerInfo.threads();
        this.populatePreProcessorList();
        this.populateUeiToHandlerMap();
        this.populatePostProcessorList();
        this.populateExceptionHandlersSet();
        if (this.m_ueiToHandlerMap.size() == 1 && "*".equals(this.m_ueiToHandlerMap.keySet().toArray()[0])) {
            this.m_subscriptionService.addEventListener(this);
        } else {
            this.m_subscriptionService.addEventListener((org.opennms.netmgt.events.api.EventListener)this, new HashSet<String>(this.m_ueiToHandlerMap.keySet()));
        }
    }

    private static EventListener findEventListenerAnnotation(Object annotatedListener) {
        return annotatedListener.getClass().getAnnotation(EventListener.class);
    }

    private void populateExceptionHandlersSet() {
        Method[] methods;
        for (Method method : methods = this.m_annotatedListener.getClass().getMethods()) {
            if (!method.isAnnotationPresent(EventExceptionHandler.class)) continue;
            AnnotationBasedEventListenerAdapter.validateMethodAsEventExceptionHandler(method);
            this.m_exceptionHandlers.add(method);
        }
    }

    private static void validateMethodAsEventExceptionHandler(Method method) {
        Assert.state((method.getParameterTypes().length == 2 ? 1 : 0) != 0, (String)"Invalid number of parameters. EventExceptionHandler methods must take 2 arguments with types (Event, ? extends Throwable)");
        Assert.state((boolean)ClassUtils.isAssignable(IEvent.class, method.getParameterTypes()[0]), (String)"First parameter of incorrect type. EventExceptionHandler first paramenter must be of type Event");
        Assert.state((boolean)ClassUtils.isAssignable(Throwable.class, method.getParameterTypes()[1]), (String)"Second parameter of incorrect type. EventExceptionHandler second paramenter must be of type ? extends Throwable");
    }

    @Override
    public int getNumThreads() {
        if (this.m_annotatedListener instanceof ThreadAwareEventListener) {
            return ((ThreadAwareEventListener)this.m_annotatedListener).getNumThreads();
        }
        return this.m_threads;
    }

    private Comparator<Method> createExceptionHandlerComparator() {
        final ClassComparator classComparator = new ClassComparator();
        Comparator<Method> comparator = new Comparator<Method>(){

            @Override
            public int compare(Method left, Method right) {
                Class<Throwable> lhsType = left.getParameterTypes()[1].asSubclass(Throwable.class);
                Class<Throwable> rhsType = right.getParameterTypes()[1].asSubclass(Throwable.class);
                EventExceptionHandler leftHandlerInfo = (EventExceptionHandler)AnnotationUtils.findAnnotation((Method)left, EventExceptionHandler.class);
                EventExceptionHandler rightHandlerInfo = (EventExceptionHandler)AnnotationUtils.findAnnotation((Method)right, EventExceptionHandler.class);
                if (leftHandlerInfo.order() == rightHandlerInfo.order()) {
                    return classComparator.compare(lhsType, rhsType);
                }
                return leftHandlerInfo.order() - rightHandlerInfo.order();
            }
        };
        return comparator;
    }

    private void populatePostProcessorList() {
        Method[] methods;
        for (Method method : methods = this.m_annotatedListener.getClass().getMethods()) {
            if (!method.isAnnotationPresent(EventPostProcessor.class)) continue;
            AnnotationBasedEventListenerAdapter.validateMethodAsEventHandler(method);
            this.m_eventPostProcessors.add(method);
        }
    }

    private void populatePreProcessorList() {
        Method[] methods;
        for (Method method : methods = this.m_annotatedListener.getClass().getMethods()) {
            EventPreProcessor ann = (EventPreProcessor)AnnotationUtils.findAnnotation((Method)method, EventPreProcessor.class);
            if (ann == null) continue;
            AnnotationBasedEventListenerAdapter.validateMethodAsEventHandler(method);
            this.m_eventPreProcessors.add(method);
        }
    }

    private void populateUeiToHandlerMap() {
        Method[] methods;
        for (Method method : methods = this.m_annotatedListener.getClass().getMethods()) {
            String[] ueis;
            EventHandler handlerInfo = (EventHandler)AnnotationUtils.findAnnotation((Method)method, EventHandler.class);
            if (handlerInfo == null) continue;
            String singleUei = handlerInfo.uei();
            if (singleUei != null && !"".equals(singleUei)) {
                AnnotationBasedEventListenerAdapter.validateMethodAsEventHandler(method);
                Assert.state((!this.m_ueiToHandlerMap.containsKey(singleUei) ? 1 : 0) != 0, (String)("Cannot define method " + String.valueOf(method) + " as a handler for event " + singleUei + " since " + String.valueOf(this.m_ueiToHandlerMap.get(singleUei)) + " is already defined as a handler"));
                this.m_ueiToHandlerMap.put(singleUei, method);
            }
            if ((ueis = handlerInfo.ueis()) == null || ueis.length <= 0) continue;
            AnnotationBasedEventListenerAdapter.validateMethodAsEventHandler(method);
            for (String uei : ueis) {
                Assert.state((!this.m_ueiToHandlerMap.containsKey(uei) ? 1 : 0) != 0, (String)("Cannot define method " + String.valueOf(method) + " as a handler for event " + uei + " since " + String.valueOf(this.m_ueiToHandlerMap.get(uei)) + " is already defined as a handler"));
                this.m_ueiToHandlerMap.put(uei, method);
            }
        }
        Assert.state((!this.m_ueiToHandlerMap.isEmpty() ? 1 : 0) != 0, (String)"annotatedListener must have public EventHandler annotated methods");
    }

    private static void validateMethodAsEventHandler(Method method) {
        Assert.state((method.getParameterTypes().length == 1 ? 1 : 0) != 0, (String)("Invalid number of paremeters for method " + String.valueOf(method) + ". EventHandler methods must take a single event argument"));
        Assert.state((boolean)method.getParameterTypes()[0].isAssignableFrom(IEvent.class), (String)("Parameter of incorrent type for method " + String.valueOf(method) + ". EventHandler methods must take a single event argument"));
    }

    @Override
    public void close() {
        this.m_subscriptionService.removeEventListener(this);
    }

    public void destroy() throws Exception {
        this.close();
    }

    public void setEventSubscriptionService(EventSubscriptionService subscriptionService) {
        this.m_subscriptionService = subscriptionService;
    }

    private static class ClassComparator<T>
    implements Comparator<Class<? extends T>> {
        private ClassComparator() {
        }

        @Override
        public int compare(Class<? extends T> lhsType, Class<? extends T> rhsType) {
            return ClassUtils.isAssignable(lhsType, rhsType) ? 1 : -1;
        }
    }
}

