/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.nio.ByteBuffer;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.syslogd.SyslogFacility;
import org.opennms.netmgt.syslogd.SyslogMessage;
import org.opennms.netmgt.syslogd.SyslogParser;
import org.opennms.netmgt.syslogd.SyslogParserException;
import org.opennms.netmgt.syslogd.SyslogSeverity;
import org.opennms.netmgt.syslogd.SyslogTimeStamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomSyslogParser
extends SyslogParser {
    private static final Logger LOG = LoggerFactory.getLogger(CustomSyslogParser.class);
    private static final Pattern m_messageIdPattern = Pattern.compile("^((\\S+):\\s*)");
    private static final Pattern m_datePattern = Pattern.compile("^\\s*((\\d\\d\\d\\d-\\d\\d-\\d\\d)\\s*)");
    private static final Pattern m_oldDatePattern = Pattern.compile("^\\s*(\\S\\S\\S\\s+\\d{1,2}\\s+\\d\\d:\\d\\d:\\d\\d)\\s+");
    private final Pattern m_forwardingPattern;
    private final int m_matchingGroupHost;
    private final int m_matchingGroupMessage;

    public CustomSyslogParser(SyslogdConfig config, ByteBuffer text) throws SyslogParserException {
        super(config, text);
        if (config.getForwardingRegexp() == null) {
            throw new SyslogParserException("no forwarding regular expression defined");
        }
        String forwardingRegexp = config.getForwardingRegexp();
        this.m_forwardingPattern = Pattern.compile(forwardingRegexp, 8);
        this.m_matchingGroupHost = config.getMatchingGroupHost();
        this.m_matchingGroupMessage = config.getMatchingGroupMessage();
    }

    @Override
    protected SyslogMessage parse() throws SyslogParserException {
        String matchedMessage;
        String timestamp;
        LOG.debug("Message parse start");
        SyslogMessage syslogMessage = new SyslogMessage();
        syslogMessage.setParserClass(this.getClass());
        String message = SyslogParser.fromByteBuffer(this.getText());
        int lbIdx = message.indexOf(60);
        int rbIdx = message.indexOf(62);
        if (lbIdx < 0 || rbIdx < 0 || lbIdx >= rbIdx - 1) {
            LOG.warn("Syslogd received an unparsable message!");
            return null;
        }
        int priCode = 0;
        String priStr = message.substring(lbIdx + 1, rbIdx);
        priCode = CustomSyslogParser.parseInt(priStr, "ERROR Bad priority code '{}'");
        LOG.trace("priority code = {}", (Object)priCode);
        syslogMessage.setFacility(SyslogFacility.getFacilityForCode(priCode));
        syslogMessage.setSeverity(SyslogSeverity.getSeverityForCode(priCode));
        message = message.substring(rbIdx + 1, message.length());
        Matcher idMatcher = m_messageIdPattern.matcher(message);
        if (idMatcher.find()) {
            String messageId = idMatcher.group(2);
            LOG.trace("found message ID '{}'", (Object)messageId);
            syslogMessage.setMessageID(messageId);
            message = message.substring(idMatcher.group(1).length() - 1);
        }
        LOG.trace("message = {}", (Object)message);
        Matcher oldDateMatcher = m_oldDatePattern.matcher(message);
        if (oldDateMatcher.find()) {
            LOG.trace("stdMsg = {}", (Object)"true");
            timestamp = oldDateMatcher.group(1);
            message = oldDateMatcher.replaceFirst("");
        } else {
            Matcher stampMatcher = m_datePattern.matcher(message);
            if (stampMatcher.find()) {
                LOG.trace("stdMsg = {}", (Object)"false");
                timestamp = stampMatcher.group(2);
                LOG.trace("found timestamp '{}'", (Object)timestamp);
            } else {
                try {
                    timestamp = SyslogTimeStamp.getInstance().format(new Date());
                }
                catch (IllegalArgumentException ex) {
                    LOG.debug("ERROR INTERNAL DATE ERROR!");
                    timestamp = "";
                }
            }
        }
        LOG.trace("timestamp = {}", (Object)timestamp);
        syslogMessage.setDate(this.parseDate(timestamp));
        LOG.trace("message = {}", (Object)message);
        LOG.trace("pattern = {}", (Object)this.m_forwardingPattern);
        LOG.trace("host group = {}", (Object)this.m_matchingGroupHost);
        LOG.trace("message group = {}", (Object)this.m_matchingGroupMessage);
        Pattern pattern = this.m_forwardingPattern;
        Matcher m = pattern.matcher(message);
        if (m.matches()) {
            matchedMessage = m.group(this.m_matchingGroupMessage);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Syslog message '{}' matched regexp '{}'", (Object)message, (Object)this.m_forwardingPattern);
                LOG.trace("Found host '{}'", (Object)m.group(this.m_matchingGroupHost));
                LOG.trace("Found message '{}'", (Object)matchedMessage);
            }
        } else {
            LOG.debug("Regexp not matched: {}", (Object)message);
            return null;
        }
        syslogMessage.setHostName(m.group(this.m_matchingGroupHost));
        message = matchedMessage;
        lbIdx = message.indexOf(91);
        rbIdx = message.indexOf(93);
        int colonIdx = message.indexOf(58);
        int spaceIdx = message.indexOf(32);
        String processId = null;
        String processName = null;
        if (lbIdx < rbIdx - 1 && colonIdx == rbIdx + 1 && spaceIdx == colonIdx + 1) {
            processName = message.substring(0, lbIdx);
            processId = message.substring(lbIdx + 1, rbIdx);
            message = message.substring(colonIdx + 2);
        } else if (colonIdx > 0 && spaceIdx == colonIdx + 1) {
            processName = message.substring(0, colonIdx);
            message = message.substring(colonIdx + 2);
        }
        if (processId != null) {
            syslogMessage.setProcessId(processId);
        }
        if (processName != null) {
            syslogMessage.setProcessName(processName);
        }
        syslogMessage.setMessage(message.trim());
        LOG.debug("Message parse end");
        return syslogMessage;
    }

    private static int parseInt(String stringToInt, String logMessage) {
        int integerValue = 0;
        try {
            integerValue = Integer.parseInt(stringToInt);
        }
        catch (NumberFormatException e) {
            LOG.debug(logMessage, (Object)stringToInt);
        }
        return integerValue;
    }
}

