/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.log.osgi;

import io.hawt.log.LogEvent;
import io.hawt.log.LogFilter;
import io.hawt.log.osgi.MavenCoordinates;
import io.hawt.log.support.Objects;
import io.hawt.log.support.Predicate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ops4j.pax.logging.spi.PaxLevel;
import org.ops4j.pax.logging.spi.PaxLocationInfo;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

public class Logs {
    public static LogEvent newInstance(PaxLoggingEvent event) {
        LogEvent answer = new LogEvent();
        try {
            answer.setLevel(Logs.toString(event.getLevel()));
        }
        catch (NoClassDefFoundError error) {
            answer.setLevel("LOG");
        }
        answer.setMessage(event.getMessage());
        answer.setLogger(event.getLoggerName());
        answer.setTimestamp(new Date(event.getTimeStamp()));
        answer.setThread(event.getThreadName());
        answer.setException(MavenCoordinates.addMavenCoord(event.getThrowableStrRep()));
        Map eventProperties = event.getProperties();
        if (eventProperties != null && eventProperties.size() > 0) {
            HashMap<String, String> properties = new HashMap<String, String>();
            Set set = eventProperties.entrySet();
            for (Map.Entry entry : set) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null) continue;
                properties.put(Logs.toString(key), Logs.toString(value));
            }
            MavenCoordinates.addMavenCoord(properties);
            answer.setProperties(properties);
        }
        try {
            PaxLocationInfo locationInformation = event.getLocationInformation();
            if (locationInformation != null) {
                answer.setClassName(locationInformation.getClassName());
                answer.setFileName(locationInformation.getFileName());
                answer.setMethodName(locationInformation.getMethodName());
                answer.setLineNumber(locationInformation.getLineNumber());
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return answer;
    }

    protected static String toString(Object value) {
        return value.toString();
    }

    public static Predicate<PaxLoggingEvent> createPredicate(LogFilter filter) {
        String matchesText;
        Long after;
        Long before;
        if (filter == null) {
            return null;
        }
        final ArrayList<Object> predicates = new ArrayList<Object>();
        final Set levels = filter.getLevelsSet();
        if (levels.size() > 0) {
            predicates.add(new Predicate<PaxLoggingEvent>(){

                public boolean matches(PaxLoggingEvent event) {
                    PaxLevel level = event.getLevel();
                    return level != null && levels.contains(level.toString());
                }
            });
        }
        if ((before = filter.getBeforeTimestamp()) != null) {
            predicates.add(new Predicate<PaxLoggingEvent>(){

                public boolean matches(PaxLoggingEvent event) {
                    long time = event.getTimeStamp();
                    return time < before;
                }
            });
        }
        if ((after = filter.getAfterTimestamp()) != null) {
            predicates.add(new Predicate<PaxLoggingEvent>(){

                public boolean matches(PaxLoggingEvent event) {
                    long time = event.getTimeStamp();
                    return time > after;
                }
            });
        }
        if ((matchesText = filter.getMatchesText()) != null && matchesText.length() > 0) {
            predicates.add(new Predicate<PaxLoggingEvent>(){

                public boolean matches(PaxLoggingEvent event) {
                    if (Objects.contains((String)matchesText, (String[])new String[]{event.getFQNOfLoggerClass(), event.getMessage(), event.getLoggerName(), event.getThreadName()})) {
                        return true;
                    }
                    String[] throwableStrRep = event.getThrowableStrRep();
                    if (throwableStrRep != null && Objects.contains((String)matchesText, (String[])throwableStrRep)) {
                        return true;
                    }
                    Map properties = event.getProperties();
                    return properties != null && Objects.contains((String)matchesText, (String[])new String[]{properties.toString()});
                }
            });
        }
        if (predicates.size() == 0) {
            return null;
        }
        if (predicates.size() == 1) {
            return (Predicate)predicates.get(0);
        }
        return new Predicate<PaxLoggingEvent>(){

            public String toString() {
                return "AndPredicate" + predicates;
            }

            public boolean matches(PaxLoggingEvent event) {
                for (Predicate predicate : predicates) {
                    if (predicate.matches((Object)event)) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

