/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.snmpmetadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.model.snmpmetadata.SnmpMetadataBase;
import org.opennms.netmgt.model.snmpmetadata.SnmpMetadataEntry;

@XmlRootElement(name="snmp-metadata-table")
public class SnmpMetadataTable
extends SnmpMetadataBase {
    private String name;
    private List<SnmpMetadataEntry> entries = new ArrayList<SnmpMetadataEntry>();

    public SnmpMetadataTable() {
    }

    public SnmpMetadataTable(String name) {
        this.name = this.trimName(name);
    }

    public SnmpMetadataEntry addEntry(String index, String key, String value) {
        SnmpMetadataEntry snmpMetadataEntry;
        Optional<SnmpMetadataEntry> optionalEntry = this.entries.stream().filter(e -> index.equals(e.getIndex())).findAny();
        if (optionalEntry.isPresent()) {
            snmpMetadataEntry = optionalEntry.get();
        } else {
            snmpMetadataEntry = new SnmpMetadataEntry(index);
            snmpMetadataEntry.setParent(this);
            this.entries.add(snmpMetadataEntry);
        }
        snmpMetadataEntry.addValue(key, value);
        return snmpMetadataEntry;
    }

    public SnmpMetadataEntry addEntry(String index) {
        SnmpMetadataEntry snmpMetadataEntry;
        Optional<SnmpMetadataEntry> optionalEntry = this.entries.stream().filter(e -> index.equals(e.getIndex())).findAny();
        if (optionalEntry.isPresent()) {
            snmpMetadataEntry = optionalEntry.get();
        } else {
            snmpMetadataEntry = new SnmpMetadataEntry(index);
            snmpMetadataEntry.setParent(this);
            this.entries.add(snmpMetadataEntry);
        }
        return snmpMetadataEntry;
    }

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="snmp-metadata-entry")
    public List<SnmpMetadataEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<SnmpMetadataEntry> entries) {
        this.entries = entries;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SnmpMetadataTable that = (SnmpMetadataTable)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.entries, that.entries);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.entries);
    }
}

