/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.kvstore.blob.cassandra;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.opennms.features.distributed.cassandra.api.CassandraSchemaManagerFactory;
import org.opennms.features.distributed.cassandra.api.CassandraSession;
import org.opennms.features.distributed.cassandra.api.CassandraSessionFactory;
import org.opennms.features.distributed.kvstore.api.AbstractKeyValueStore;
import org.opennms.features.distributed.kvstore.api.BlobStore;

public class CassandraBlobStore
extends AbstractKeyValueStore<byte[]>
implements BlobStore {
    private static final String KEY_COLUMN = "key";
    private static final String CONTEXT_COLUMN = "context";
    private static final String VALUE_COLUMN = "value";
    private static final String TIMESTAMP_COLUMN = "lastUpdated";
    private static final String TABLE_NAME = "kvstore_blob";
    private final CassandraSession session;
    private final PreparedStatement insertStmt;
    private final PreparedStatement insertWithTtlStmt;
    private final PreparedStatement selectStmt;
    private final PreparedStatement timestampStmt;
    private final PreparedStatement enumerateStatement;
    private final PreparedStatement deleteStatement;
    private final Executor asyncDeleteExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("cassandra-async-delete-%d").build());

    public CassandraBlobStore(CassandraSessionFactory sessionFactory, CassandraSchemaManagerFactory cassandraSchemaManagerFactory) throws IOException {
        Objects.requireNonNull(sessionFactory);
        Objects.requireNonNull(cassandraSchemaManagerFactory);
        cassandraSchemaManagerFactory.getSchemaManager().create(() -> ((Object)((Object)this)).getClass().getResourceAsStream("/cql/kv.cql"));
        this.session = sessionFactory.getSession();
        this.insertStmt = this.session.prepare(String.format("INSERT INTO %s (%s, %s, %s, %s) VALUES (?, ?, ?, ?)", TABLE_NAME, KEY_COLUMN, CONTEXT_COLUMN, VALUE_COLUMN, TIMESTAMP_COLUMN));
        this.insertWithTtlStmt = this.session.prepare(String.format("INSERT INTO %s (%s, %s, %s, %s) VALUES (?, ?, ?, ?) USING TTL ?", TABLE_NAME, KEY_COLUMN, CONTEXT_COLUMN, VALUE_COLUMN, TIMESTAMP_COLUMN));
        this.selectStmt = this.session.prepare(String.format("SELECT %s FROM %s WHERE %s = ? AND %s = ?", VALUE_COLUMN, TABLE_NAME, KEY_COLUMN, CONTEXT_COLUMN));
        this.timestampStmt = this.session.prepare(String.format("SELECT %s FROM %s WHERE %s = ? AND %s = ?", TIMESTAMP_COLUMN, TABLE_NAME, KEY_COLUMN, CONTEXT_COLUMN));
        this.enumerateStatement = this.session.prepare(String.format("SELECT %s, %s FROM %s WHERE %s = ?", KEY_COLUMN, VALUE_COLUMN, TABLE_NAME, CONTEXT_COLUMN));
        this.deleteStatement = this.session.prepare(String.format("DELETE FROM %s WHERE %s = ? and %s = ?", TABLE_NAME, KEY_COLUMN, CONTEXT_COLUMN));
    }

    public long put(String key, byte[] value, String context, Integer ttlInSeconds) {
        long timestamp = System.currentTimeMillis();
        Statement<?> statement = this.getStatementForInsert(key, context, ByteBuffer.wrap(value), timestamp, ttlInSeconds);
        this.session.execute(statement);
        return timestamp;
    }

    public Optional<byte[]> get(String key, String context) {
        ResultSet resultSet = this.session.execute((Statement)this.selectStmt.bind(new Object[]{key, context}));
        Row row = (Row)resultSet.one();
        if (row == null) {
            return Optional.empty();
        }
        ByteBuffer value = (ByteBuffer)row.get(VALUE_COLUMN, TypeCodecs.BLOB);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(value.array());
    }

    public CompletableFuture<Long> putAsync(String key, byte[] value, String context, Integer ttlInSeconds) {
        long timestamp = System.currentTimeMillis();
        Statement<?> statement = this.getStatementForInsert(key, context, ByteBuffer.wrap(value), timestamp, ttlInSeconds);
        return this.session.executeAsync(statement).thenApply(e -> timestamp).toCompletableFuture();
    }

    public CompletableFuture<Optional<byte[]>> getAsync(String key, String context) {
        return this.session.executeAsync((Statement)this.selectStmt.bind(new Object[]{key, context})).toCompletableFuture().thenApply(resultSet -> {
            Row row = (Row)resultSet.one();
            if (row == null) {
                return Optional.empty();
            }
            ByteBuffer bytes = (ByteBuffer)row.get(VALUE_COLUMN, TypeCodecs.BLOB);
            if (bytes == null) {
                return Optional.empty();
            }
            return Optional.of(bytes.array());
        });
    }

    public Optional<Optional<byte[]>> getIfStale(String key, String context, long timestamp) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        OptionalLong lastUpdated = this.getLastUpdated(key, context);
        if (lastUpdated.isEmpty()) {
            return Optional.empty();
        }
        if (timestamp >= lastUpdated.getAsLong()) {
            return Optional.of(Optional.empty());
        }
        Optional<byte[]> value = this.get(key, context);
        if (value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public OptionalLong getLastUpdated(String key, String context) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        ResultSet resultSet = this.session.execute((Statement)this.timestampStmt.bind(new Object[]{key, context}));
        Row row = (Row)resultSet.one();
        if (row == null) {
            return OptionalLong.empty();
        }
        Instant lastUpdated = (Instant)row.get(TIMESTAMP_COLUMN, TypeCodecs.TIMESTAMP);
        if (lastUpdated == null) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(lastUpdated.toEpochMilli());
    }

    public CompletableFuture<Optional<Optional<byte[]>>> getIfStaleAsync(String key, String context, long timestamp) {
        CompletableFuture<Optional<Optional<byte[]>>> getIfStaleFuture = new CompletableFuture<Optional<Optional<byte[]>>>();
        this.getLastUpdatedAsync(key, context).whenComplete((lastUpdated, t) -> {
            if (t != null) {
                getIfStaleFuture.completeExceptionally((Throwable)t);
                return;
            }
            if (lastUpdated.isEmpty()) {
                getIfStaleFuture.complete(Optional.empty());
                return;
            }
            if (timestamp >= lastUpdated.getAsLong()) {
                getIfStaleFuture.complete(Optional.of(Optional.empty()));
                return;
            }
            this.getAsync(key, context).whenComplete((val, th) -> {
                if (th != null) {
                    getIfStaleFuture.completeExceptionally((Throwable)th);
                    return;
                }
                if (val.isEmpty()) {
                    getIfStaleFuture.complete(Optional.empty());
                }
                getIfStaleFuture.complete(Optional.of(val));
            });
        });
        return getIfStaleFuture;
    }

    public CompletableFuture<OptionalLong> getLastUpdatedAsync(String key, String context) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        return this.session.executeAsync((Statement)this.timestampStmt.bind(new Object[]{key, context})).toCompletableFuture().thenApply(resultSet -> {
            Row row = (Row)resultSet.one();
            if (row == null) {
                return OptionalLong.empty();
            }
            Instant lastUpdate = (Instant)row.get(TIMESTAMP_COLUMN, TypeCodecs.TIMESTAMP);
            if (lastUpdate == null) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(lastUpdate.toEpochMilli());
        });
    }

    public Map<String, byte[]> enumerateContext(String context) {
        Objects.requireNonNull(context);
        HashMap resultMap = new HashMap();
        this.session.execute((Statement)this.enumerateStatement.bind(new Object[]{context})).forEach(row -> resultMap.put(row.getString(KEY_COLUMN), ((ByteBuffer)row.get(VALUE_COLUMN, TypeCodecs.BLOB)).array()));
        return Collections.unmodifiableMap(resultMap);
    }

    public void delete(String key, String context) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        this.session.execute((Statement)this.deleteStatement.bind(new Object[]{key, context}));
    }

    public CompletableFuture<Map<String, byte[]>> enumerateContextAsync(String context) {
        Objects.requireNonNull(context);
        HashMap resultMap = new HashMap();
        return this.session.executeAsync((Statement)this.enumerateStatement.bind(new Object[]{context})).thenCompose(rs -> this.enumerateContext((AsyncResultSet)rs, resultMap)).toCompletableFuture();
    }

    private CompletionStage<Map<String, byte[]>> enumerateContext(AsyncResultSet resultSet, Map<String, byte[]> resultMap) {
        for (Row row : resultSet.currentPage()) {
            ByteBuffer value;
            String key = row.getString(KEY_COLUMN);
            if (key == null || (value = (ByteBuffer)row.get(VALUE_COLUMN, TypeCodecs.BLOB)) == null) continue;
            resultMap.put(key, value.array());
        }
        if (resultSet.hasMorePages()) {
            return resultSet.fetchNextPage().thenCompose(rs -> this.enumerateContext((AsyncResultSet)rs, resultMap));
        }
        return CompletableFuture.completedFuture(resultMap);
    }

    public CompletableFuture<Void> deleteAsync(String key, String context) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        return this.session.executeAsync((Statement)this.deleteStatement.bind(new Object[]{key, context})).toCompletableFuture().thenApply(res -> null);
    }

    public CompletableFuture<Void> truncateContextAsync(String context) {
        Objects.requireNonNull(context);
        CompletableFuture<Void> truncateFuture = new CompletableFuture<Void>();
        this.enumerateContextAsync(context).whenCompleteAsync((enumerateResult, enumerateThrowable) -> {
            if (enumerateThrowable != null) {
                truncateFuture.completeExceptionally((Throwable)enumerateThrowable);
                return;
            }
            enumerateResult.keySet().forEach(key -> {
                try {
                    this.delete((String)key, context);
                }
                catch (Exception e) {
                    truncateFuture.completeExceptionally(e);
                }
            });
            truncateFuture.complete(null);
        }, this.asyncDeleteExecutor);
        return truncateFuture;
    }

    private Statement<?> getStatementForInsert(String key, String context, ByteBuffer serializedValue, long timestamp, Integer ttlInSeconds) {
        BoundStatement statement;
        if (ttlInSeconds != null) {
            if (ttlInSeconds <= 0) {
                throw new IllegalArgumentException("TTL must be positive and greater than 0");
            }
            statement = this.insertWithTtlStmt.bind(new Object[]{key, context, serializedValue, Instant.ofEpochMilli(timestamp), ttlInSeconds});
        } else {
            statement = this.insertStmt.bind(new Object[]{key, context, serializedValue, Instant.ofEpochMilli(timestamp)});
        }
        return statement;
    }

    public String getName() {
        return "Cassandra";
    }
}

