/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.elastic.client;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.opennms.features.elastic.client.model.BulkRequest;
import org.opennms.features.elastic.client.model.BulkResponse;
import org.opennms.features.elastic.client.model.SearchRequest;
import org.opennms.features.elastic.client.model.SearchResponse;

public interface ElasticRestClient {
    public String health() throws IOException;

    public Map<String, String> listTemplates() throws IOException;

    public void close() throws IOException;

    public boolean applyILMPolicy(String var1, String var2) throws IOException;

    public boolean applyComponentTemplate(String var1, String var2) throws IOException;

    public boolean applyComposableIndexTemplate(String var1, String var2) throws IOException;

    public int applyAllTemplatesFromDirectory(String var1) throws IOException;

    public BulkResponse executeBulk(BulkRequest var1) throws IOException;

    public CompletableFuture<BulkResponse> executeBulkAsync(BulkRequest var1);

    public SearchResponse search(SearchRequest var1) throws IOException;

    public CompletableFuture<SearchResponse> searchAsync(SearchRequest var1);

    public boolean applyLegacyIndexTemplate(String var1, String var2) throws IOException;

    public String getServerVersion() throws IOException;

    public boolean deleteIndex(String var1) throws IOException;
}

