/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.filters;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.filters.FilterException;
import io.pkts.filters.SipFilter;
import io.pkts.packet.Packet;
import io.pkts.packet.PacketParseException;
import io.pkts.packet.sip.SipPacket;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.protocol.Protocol;
import java.io.IOException;
import java.util.Optional;

public class SipHeaderFilter
extends SipFilter {
    private final Buffer name;
    private final Buffer value;

    public SipHeaderFilter(String name, String value) {
        this.name = Buffers.wrap((String)name);
        this.value = Buffers.wrap((String)value);
    }

    @Override
    public boolean accept(Packet packet) throws FilterException {
        try {
            if (super.accept(packet)) {
                SipPacket msg = (SipPacket)packet.getPacket(Protocol.SIP);
                Optional<SipHeader> header = msg.getHeader(this.name);
                if (header.isPresent()) {
                    return false;
                }
                return header.get().getValue().equals((Object)this.value);
            }
        }
        catch (IOException e) {
            throw new FilterException("Unable to process the frame due to IOException", e);
        }
        catch (PacketParseException e) {
            throw new FilterException("Unable to process the frame due to parse issue of the SIP Message", e);
        }
        return false;
    }
}

