/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.events.sink.dispatcher;

import com.google.common.base.Strings;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.events.EventBuilder;

@Command(scope="opennms", name="send-event", description="Send event with specified uei and params")
@Service
public class EventSendCommand
implements Action {
    @Reference
    private EventForwarder eventForwarder;
    @Option(name="-n", aliases={"--nodeid"}, description="Database ID of associated node (or use parameters _foreignSource, _foreignId)", required=false, multiValued=false)
    private Long nodeId;
    @Option(name="-i", aliases={"--interface"}, description="IP address of associated interface", required=false, multiValued=false)
    private String ipinterface;
    @Option(name="-s", aliases={"--service"}, description="Name of the associated service", required=false, multiValued=false)
    private String service;
    @Option(name="-f", aliases={"--ifindex"}, description="ifIndex of the associated L2 interface", required=false, multiValued=false)
    private Integer ifIndex;
    @Option(name="-x", aliases={"--severity"}, description="Severity of the event (Indeterminate|Cleared|Normal|Warning|Minor|Major|Critical)", required=false, multiValued=false)
    private String severity;
    @Option(name="-d", aliases={"--description"}, description="A description for the event browser", required=false, multiValued=false)
    private String descr;
    @Option(name="-l", aliases={"--logmsg"}, description="A short logmsg for the event browser (secure field by default)", required=false, multiValued=false)
    private String logmsg;
    @Option(name="-p", aliases={"--parameter"}, description="Parameter in key=value form", required=false, multiValued=true)
    List<String> params;
    @Argument(index=0, name="uei", description="Event UEI", required=true, multiValued=false)
    private String eventUei;

    public Object execute() {
        if (this.eventUei == null) {
            System.out.println("Event uei need to specified with -u or --uei option");
        }
        EventBuilder eventBuilder = new EventBuilder(this.eventUei, "KarafShell_send-event");
        if (this.nodeId != null) {
            eventBuilder.setNodeid(this.nodeId.longValue());
        }
        if (!Strings.isNullOrEmpty((String)this.ipinterface)) {
            try {
                eventBuilder.setInterface(InetAddress.getByName(this.ipinterface));
            }
            catch (UnknownHostException uhe) {
                System.out.println(String.format("Error: %s", uhe.getMessage()));
                return null;
            }
        }
        if (!Strings.isNullOrEmpty((String)this.service)) {
            eventBuilder.setService(this.service);
        }
        if (this.ifIndex != null) {
            eventBuilder.setIfIndex(this.ifIndex.intValue());
        }
        if (!Strings.isNullOrEmpty((String)this.severity)) {
            eventBuilder.setSeverity(this.canonicalizeSeverity(this.severity));
        }
        if (!Strings.isNullOrEmpty((String)this.descr)) {
            eventBuilder.setDescription(this.descr);
        }
        if (!Strings.isNullOrEmpty((String)this.logmsg)) {
            eventBuilder.setLogMessage(this.logmsg);
        }
        Map<String, String> parameters = EventSendCommand.parseParams(this.params);
        parameters.forEach((arg_0, arg_1) -> ((EventBuilder)eventBuilder).addParam(arg_0, arg_1));
        this.eventForwarder.sendNow(eventBuilder.getEvent());
        System.out.printf("Event with uei '%s' is being sent asynchronously \n ", this.eventUei);
        return null;
    }

    private static Map<String, String> parseParams(List<String> params) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (params != null) {
            for (String keyValue : params) {
                int splitAt = keyValue.indexOf("=");
                if (splitAt <= 0) {
                    throw new IllegalArgumentException("Invalid param " + keyValue);
                }
                String key = keyValue.substring(0, splitAt);
                String value = keyValue.substring(splitAt + 1, keyValue.length());
                properties.put(key, value);
            }
        }
        return properties;
    }

    private String canonicalizeSeverity(String input) {
        if (Strings.isNullOrEmpty((String)input)) {
            return "Indeterminate";
        }
        switch (input.toLowerCase()) {
            case "indeterminate": {
                return "Indeterminate";
            }
            case "cleared": {
                return "Cleared";
            }
            case "normal": {
                return "Normal";
            }
            case "warning": {
                return "Warning";
            }
            case "minor": {
                return "Minor";
            }
            case "major": {
                return "Major";
            }
            case "critical": {
                return "Critical";
            }
        }
        return "Indeterminate";
    }
}

