/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.poller;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.pagesequence.PageSequence;
import org.opennms.netmgt.config.poller.Monitor;
import org.opennms.netmgt.config.poller.NodeOutage;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Service;

@XmlRootElement(name="poller-configuration")
@ValidateUsing(value="poller-configuration.xsd")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlSeeAlso(value={PageSequence.class})
public class PollerConfiguration
implements Serializable {
    private static final long serialVersionUID = 3402898044699865749L;
    @XmlAttribute(name="threads")
    private Integer m_threads = 30;
    @XmlAttribute(name="nextOutageId")
    private String m_nextOutageId = "SELECT nextval('outageNxtId')";
    @XmlAttribute(name="serviceUnresponsiveEnabled")
    private String m_serviceUnresponsiveEnabled = "false";
    @XmlAttribute(name="pathOutageEnabled")
    private String m_pathOutageEnabled = "false";
    @XmlAttribute(name="defaultCriticalPathIp")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    private InetAddress m_defaultCriticalPathIp;
    @XmlAttribute(name="defaultCriticalPathTimeout")
    private Integer m_defaultCriticalPathTimeout;
    @XmlAttribute(name="defaultCriticalPathRetries")
    private Integer m_defaultCriticalPathRetries;
    @XmlAttribute(name="asyncPollingEngineEnabled")
    private Boolean m_asyncPollingEngineEnabled;
    @XmlAttribute(name="maxConcurrentAsyncPolls")
    private Integer m_maxConcurrentAsyncPolls;
    @XmlElement(name="node-outage")
    private NodeOutage m_nodeOutage;
    @XmlElement(name="package")
    private List<Package> m_packages = new ArrayList<Package>();
    @XmlElement(name="monitor")
    private List<Monitor> m_monitors = new ArrayList<Monitor>();

    public Integer getThreads() {
        return this.m_threads == null ? 0 : this.m_threads;
    }

    public void setThreads(Integer threads) {
        this.m_threads = threads;
    }

    public String getNextOutageId() {
        return this.m_nextOutageId == null ? "SELECT nextval('outageNxtId')" : this.m_nextOutageId;
    }

    public void setNextOutageId(String nextOutageId) {
        this.m_nextOutageId = nextOutageId;
    }

    public String getServiceUnresponsiveEnabled() {
        return this.m_serviceUnresponsiveEnabled;
    }

    public void setServiceUnresponsiveEnabled(String serviceUnresponsiveEnabled) {
        this.m_serviceUnresponsiveEnabled = serviceUnresponsiveEnabled;
    }

    public String getPathOutageEnabled() {
        return this.m_pathOutageEnabled == null ? "false" : this.m_pathOutageEnabled;
    }

    public void setPathOutageEnabled(String pathOutageEnabled) {
        this.m_pathOutageEnabled = pathOutageEnabled;
    }

    public NodeOutage getNodeOutage() {
        return this.m_nodeOutage;
    }

    public void setNodeOutage(NodeOutage nodeOutage) {
        this.m_nodeOutage = nodeOutage;
    }

    public List<Package> getPackages() {
        if (this.m_packages == null) {
            this.m_packages = new ArrayList<Package>();
        }
        return this.m_packages;
    }

    public void setPackages(List<Package> packages) {
        this.m_packages = new ArrayList<Package>(packages);
    }

    public void addPackage(Package pack) throws IndexOutOfBoundsException {
        this.getPackages().add(pack);
    }

    public boolean removePackage(Package pack) {
        return this.getPackages().remove(pack);
    }

    public Package getPackage(String packageName) {
        for (Package pkg : this.getPackages()) {
            if (!pkg.getName().equals(packageName)) continue;
            return pkg;
        }
        return null;
    }

    public List<Monitor> getMonitors() {
        if (this.m_monitors == null) {
            this.m_monitors = new ArrayList<Monitor>();
        }
        return this.m_monitors;
    }

    public void setMonitors(List<Monitor> monitors) {
        this.m_monitors = new ArrayList<Monitor>(monitors);
    }

    public void addMonitor(Monitor monitor) throws IndexOutOfBoundsException {
        this.getMonitors().add(monitor);
    }

    public void addMonitor(String service, String className) {
        this.addMonitor(new Monitor(service, className));
    }

    public boolean removeMonitor(Monitor monitor) {
        return this.getMonitors().remove(monitor);
    }

    public PollerConfiguration getPollerConfigurationForPackages(List<String> pollingPackageNames) {
        if (pollingPackageNames == null || pollingPackageNames.size() < 1) {
            return null;
        }
        HashSet<String> seenMonitors = new HashSet<String>();
        PollerConfiguration newConfig = new PollerConfiguration();
        newConfig.setThreads(this.getThreads());
        newConfig.setNextOutageId(this.getNextOutageId());
        newConfig.setServiceUnresponsiveEnabled(this.getServiceUnresponsiveEnabled());
        newConfig.setPathOutageEnabled(this.getPathOutageEnabled());
        newConfig.setNodeOutage(this.getNodeOutage());
        boolean foundPackage = false;
        for (String pollingPackageName : pollingPackageNames) {
            Package pkg = this.getPackage(pollingPackageName);
            if (pkg == null) continue;
            newConfig.addPackage(pkg);
            foundPackage = true;
            for (Service service : pkg.getServices()) {
                seenMonitors.add(service.getName());
            }
        }
        if (!foundPackage) {
            return null;
        }
        for (Monitor monitor : this.getMonitors()) {
            if (!seenMonitors.contains(monitor.getService())) continue;
            newConfig.addMonitor(monitor);
        }
        return newConfig;
    }

    public InetAddress getDefaultCriticalPathIp() {
        return this.m_defaultCriticalPathIp;
    }

    public void setDefaultCriticalPathIp(InetAddress ip) {
        this.m_defaultCriticalPathIp = ip;
    }

    public Integer getDefaultCriticalPathTimeout() {
        return this.m_defaultCriticalPathTimeout == null ? 1500 : this.m_defaultCriticalPathTimeout;
    }

    public void setDefaultCriticalPathTimeout(Integer timeout) {
        this.m_defaultCriticalPathTimeout = timeout;
    }

    public int getDefaultCriticalPathRetries() {
        return this.m_defaultCriticalPathRetries == null ? 0 : this.m_defaultCriticalPathRetries;
    }

    public void setDefaultCriticalPathRetries(Integer retries) {
        this.m_defaultCriticalPathRetries = retries;
    }

    public Boolean getAsyncPollingEngineEnabled() {
        return Objects.requireNonNullElse(this.m_asyncPollingEngineEnabled, false);
    }

    public void setAsyncPollingEngineEnabled(Boolean asyncPollingEngineEnabled) {
        this.m_asyncPollingEngineEnabled = asyncPollingEngineEnabled;
    }

    public Integer getMaxConcurrentAsyncPolls() {
        return Objects.requireNonNullElse(this.m_maxConcurrentAsyncPolls, 100);
    }

    public void setMaxConcurrentAsyncPolls(Integer maxConcurrentAsyncPolls) {
        this.m_maxConcurrentAsyncPolls = maxConcurrentAsyncPolls;
    }

    public int hashCode() {
        return Objects.hash(this.getThreads(), this.getNextOutageId(), this.getServiceUnresponsiveEnabled(), this.getPathOutageEnabled(), this.getDefaultCriticalPathIp(), this.getDefaultCriticalPathTimeout(), this.getDefaultCriticalPathRetries(), this.getNodeOutage(), this.getPackages(), this.getMonitors(), this.getAsyncPollingEngineEnabled(), this.getMaxConcurrentAsyncPolls());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PollerConfiguration that = (PollerConfiguration)o;
        return Objects.equals(this.getThreads(), that.getThreads()) && Objects.equals(this.getNextOutageId(), that.getNextOutageId()) && Objects.equals(this.getServiceUnresponsiveEnabled(), that.getServiceUnresponsiveEnabled()) && Objects.equals(this.getPathOutageEnabled(), that.getPathOutageEnabled()) && Objects.equals(this.getDefaultCriticalPathIp(), that.getDefaultCriticalPathIp()) && Objects.equals(this.getDefaultCriticalPathTimeout(), that.getDefaultCriticalPathTimeout()) && Objects.equals(this.getDefaultCriticalPathRetries(), that.getDefaultCriticalPathRetries()) && Objects.equals(this.getNodeOutage(), that.getNodeOutage()) && Objects.equals(this.getPackages(), that.getPackages()) && Objects.equals(this.getMonitors(), that.getMonitors()) && Objects.equals(this.getAsyncPollingEngineEnabled(), that.getAsyncPollingEngineEnabled()) && Objects.equals(this.getMaxConcurrentAsyncPolls(), that.getMaxConcurrentAsyncPolls());
    }

    public String toString() {
        return "PollerConfiguration[threads=" + this.getThreads() + ",nextOutageId=" + this.getNextOutageId() + ",serviceUnresponsiveEnabled=" + this.getServiceUnresponsiveEnabled() + ",pathOutageEnabled=" + this.getPathOutageEnabled() + ",pathOutageDefaultCriticalPathIp=" + String.valueOf(this.getDefaultCriticalPathIp()) + ",pathOutageDefaultCriticalPathTimeout=" + this.getDefaultCriticalPathTimeout() + ",pathOutageDefaultCriticalPathRetries=" + this.getDefaultCriticalPathRetries() + ",nodeOutage=" + String.valueOf(this.getNodeOutage()) + ",packages=" + String.valueOf(this.getPackages()) + ",monitors=" + String.valueOf(this.getMonitors()) + ",asyncPollingEngineEnabled=" + this.getAsyncPollingEngineEnabled() + ",maxConcurrentAsyncPolls=" + this.getMaxConcurrentAsyncPolls() + "]";
    }
}

