/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import com.google.common.base.MoreObjects;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collection.support.builder.PerspectiveResponseTimeResource;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.model.perspectivepolling.ApplicationServiceStatus;
import org.opennms.netmgt.model.perspectivepolling.ApplicationStatus;
import org.opennms.netmgt.model.perspectivepolling.Location;

public class ApplicationStatusUtil {
    private static List<DowntimeInterval> mergeDowntimeIntervals(List<DowntimeInterval> intervals) {
        ArrayList<DowntimeInterval> resultList = new ArrayList<DowntimeInterval>();
        Collections.sort(intervals, (donwtimeInterval1, donwtimeInterval2) -> Long.signum(donwtimeInterval1.start - donwtimeInterval2.start) != 0 ? Long.signum(donwtimeInterval1.start - donwtimeInterval2.start) : Long.signum(donwtimeInterval1.end - donwtimeInterval2.end));
        for (int i = 0; i < intervals.size(); ++i) {
            DowntimeInterval mergedInterval = intervals.get(i);
            ++i;
            while (i < intervals.size() && ApplicationStatusUtil.intervalsOverlap(mergedInterval, intervals.get(i))) {
                mergedInterval.start = Math.min(mergedInterval.start, intervals.get((int)i).start);
                mergedInterval.end = Math.max(mergedInterval.end, intervals.get((int)i).end);
                ++i;
            }
            --i;
            resultList.add(mergedInterval);
        }
        return resultList;
    }

    private static boolean intervalsOverlap(DowntimeInterval downtimeInterval1, DowntimeInterval downtimeInterval2) {
        return Math.max(downtimeInterval1.start, downtimeInterval2.start) <= Math.min(downtimeInterval1.end, downtimeInterval2.end);
    }

    private static double calculateApplicationPercentageUptime(List<DowntimeInterval> intervals, long start, long end) {
        double totalTimeMillis;
        double uptimeMillis = totalTimeMillis = (double)(end - start);
        for (DowntimeInterval interval : intervals) {
            uptimeMillis -= (double)(Math.min(interval.end, end) - Math.max(interval.start, start));
        }
        return uptimeMillis / totalTimeMillis;
    }

    public static ApplicationStatus buildApplicationStatus(OnmsApplication onmsApplication, Collection<OnmsOutage> onmsOutages, long start, long end) {
        HashMap m = new HashMap();
        for (OnmsMonitoringLocation onmsMonitoringLocation : onmsApplication.getPerspectiveLocations()) {
            m.put(onmsMonitoringLocation, new ArrayList());
        }
        for (OnmsOutage onmsOutage : onmsOutages) {
            ((List)m.get(onmsOutage.getPerspective())).add(new DowntimeInterval(onmsOutage, start, end));
        }
        ApplicationStatus applicationStatus = new ApplicationStatus();
        applicationStatus.setStart(Long.valueOf(start));
        applicationStatus.setEnd(Long.valueOf(end));
        applicationStatus.setApplicationId(onmsApplication.getId());
        applicationStatus.setOverallStatus(Double.valueOf(100.0 * ApplicationStatusUtil.calculateApplicationPercentageUptime(ApplicationStatusUtil.mergeDowntimeIntervals(m.values().stream().flatMap(e -> e.stream()).collect(Collectors.toList())), start, end)));
        for (OnmsMonitoringLocation onmsMonitoringLocation : onmsApplication.getPerspectiveLocations()) {
            Location location = new Location();
            location.setName(onmsMonitoringLocation.getLocationName());
            List<DowntimeInterval> mergedDowntimeIntervals = ApplicationStatusUtil.mergeDowntimeIntervals((List)m.get(onmsMonitoringLocation));
            location.setAggregatedStatus(Double.valueOf(100.0 * ApplicationStatusUtil.calculateApplicationPercentageUptime(mergedDowntimeIntervals, start, end)));
            applicationStatus.getLocations().add(location);
        }
        return applicationStatus;
    }

    public static ApplicationServiceStatus buildApplicationServiceStatus(MonitoredServiceDao monitoredServiceDao, OnmsApplication onmsApplication, Integer monitoredServiceId, Collection<OnmsOutage> onmsOutages, long start, long end) {
        OnmsMonitoredService onmsMonitoredService = (OnmsMonitoredService)monitoredServiceDao.get(monitoredServiceId);
        HashMap m = new HashMap();
        for (OnmsMonitoringLocation onmsMonitoringLocation : onmsApplication.getPerspectiveLocations()) {
            m.put(onmsMonitoringLocation, new ArrayList());
        }
        for (OnmsOutage onmsOutage : onmsOutages) {
            if (!monitoredServiceId.equals(onmsOutage.getMonitoredService().getId())) continue;
            ((List)m.get(onmsOutage.getPerspective())).add(new DowntimeInterval(onmsOutage, start, end));
        }
        ApplicationServiceStatus applicationServiceStatus = new ApplicationServiceStatus();
        applicationServiceStatus.setStart(Long.valueOf(start));
        applicationServiceStatus.setEnd(Long.valueOf(end));
        applicationServiceStatus.setApplicationId(onmsApplication.getId());
        applicationServiceStatus.setMonitoredServiceId(monitoredServiceId);
        for (OnmsMonitoringLocation onmsMonitoringLocation : onmsApplication.getPerspectiveLocations()) {
            Location location = new Location();
            location.setName(onmsMonitoringLocation.getLocationName());
            List<DowntimeInterval> mergedDowntimeIntervals = ApplicationStatusUtil.mergeDowntimeIntervals((List)m.get(onmsMonitoringLocation));
            location.setAggregatedStatus(Double.valueOf(100.0 * ApplicationStatusUtil.calculateApplicationPercentageUptime(mergedDowntimeIntervals, start, end)));
            PerspectiveResponseTimeResource remoteLatencyResource = new PerspectiveResponseTimeResource(location.getName(), InetAddressUtils.toIpAddrString((InetAddress)onmsMonitoredService.getIpAddress()), onmsMonitoredService.getServiceType().getName());
            location.setResponseResourceId(remoteLatencyResource.getInstance());
            applicationServiceStatus.getLocations().add(location);
        }
        return applicationServiceStatus;
    }

    static class DowntimeInterval {
        public long start;
        public long end;

        public DowntimeInterval(OnmsOutage onmsOutage, long start, long end) {
            this.start = onmsOutage.getIfLostService().getTime();
            if (this.start < start) {
                this.start = start;
            }
            long l = this.end = onmsOutage.getIfRegainedService() != null ? onmsOutage.getIfRegainedService().getTime() : end;
            if (this.end > end) {
                this.end = end;
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("start", this.start).add("end", this.end).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DowntimeInterval that = (DowntimeInterval)o;
            return this.start == that.start && this.end == that.end;
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }
    }
}

