/*
 * Licensed to The OpenNMS Group, Inc (TOG) under one or more
 * contributor license agreements.  See the LICENSE.md file
 * distributed with this work for additional information
 * regarding copyright ownership.
 *
 * TOG licenses this file to You under the GNU Affero General
 * Public License Version 3 (the "License") or (at your option)
 * any later version.  You may not use this file except in
 * compliance with the License.  You may obtain a copy of the
 * License at:
 *
 *      https://www.gnu.org/licenses/agpl-3.0.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.  See the License for the specific
 * language governing permissions and limitations under the
 * License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: gnmi.proto

package org.opennms.features.openconfig.proto.gnmi;

public final class Gnmi {
  private Gnmi() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
    registry.add(org.opennms.features.openconfig.proto.gnmi.Gnmi.gnmiService);
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Encoding defines the value encoding formats that are supported by the gNMI
   * protocol. These encodings are used by both the client (when sending Set
   * messages to modify the state of the target) and the target when serializing
   * data to be returned to the client (in both Subscribe and Get RPCs).
   * Reference: gNMI Specification Section 2.3
   * </pre>
   *
   * Protobuf enum {@code gnmi.Encoding}
   */
  public enum Encoding
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * JSON encoded text.
     * </pre>
     *
     * <code>JSON = 0;</code>
     */
    JSON(0),
    /**
     * <pre>
     * Arbitrarily encoded bytes.
     * </pre>
     *
     * <code>BYTES = 1;</code>
     */
    BYTES(1),
    /**
     * <pre>
     * Encoded according to out-of-band agreed Protobuf.
     * </pre>
     *
     * <code>PROTO = 2;</code>
     */
    PROTO(2),
    /**
     * <pre>
     * ASCII text of an out-of-band agreed format.
     * </pre>
     *
     * <code>ASCII = 3;</code>
     */
    ASCII(3),
    /**
     * <pre>
     * JSON encoded text as per RFC7951.
     * </pre>
     *
     * <code>JSON_IETF = 4;</code>
     */
    JSON_IETF(4),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * JSON encoded text.
     * </pre>
     *
     * <code>JSON = 0;</code>
     */
    public static final int JSON_VALUE = 0;
    /**
     * <pre>
     * Arbitrarily encoded bytes.
     * </pre>
     *
     * <code>BYTES = 1;</code>
     */
    public static final int BYTES_VALUE = 1;
    /**
     * <pre>
     * Encoded according to out-of-band agreed Protobuf.
     * </pre>
     *
     * <code>PROTO = 2;</code>
     */
    public static final int PROTO_VALUE = 2;
    /**
     * <pre>
     * ASCII text of an out-of-band agreed format.
     * </pre>
     *
     * <code>ASCII = 3;</code>
     */
    public static final int ASCII_VALUE = 3;
    /**
     * <pre>
     * JSON encoded text as per RFC7951.
     * </pre>
     *
     * <code>JSON_IETF = 4;</code>
     */
    public static final int JSON_IETF_VALUE = 4;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Encoding valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Encoding forNumber(int value) {
      switch (value) {
        case 0: return JSON;
        case 1: return BYTES;
        case 2: return PROTO;
        case 3: return ASCII;
        case 4: return JSON_IETF;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Encoding>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        Encoding> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Encoding>() {
            public Encoding findValueByNumber(int number) {
              return Encoding.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.getDescriptor().getEnumTypes().get(0);
    }

    private static final Encoding[] VALUES = values();

    public static Encoding valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Encoding(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:gnmi.Encoding)
  }

  /**
   * <pre>
   * SubscriptionMode is the mode of the subscription, specifying how the
   * target must return values in a subscription.
   * Reference: gNMI Specification Section 3.5.1.3
   * </pre>
   *
   * Protobuf enum {@code gnmi.SubscriptionMode}
   */
  public enum SubscriptionMode
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * The target selects the relevant mode for each element.
     * </pre>
     *
     * <code>TARGET_DEFINED = 0;</code>
     */
    TARGET_DEFINED(0),
    /**
     * <pre>
     * The target sends an update on element value change.
     * </pre>
     *
     * <code>ON_CHANGE = 1;</code>
     */
    ON_CHANGE(1),
    /**
     * <pre>
     * The target samples values according to the interval.
     * </pre>
     *
     * <code>SAMPLE = 2;</code>
     */
    SAMPLE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * The target selects the relevant mode for each element.
     * </pre>
     *
     * <code>TARGET_DEFINED = 0;</code>
     */
    public static final int TARGET_DEFINED_VALUE = 0;
    /**
     * <pre>
     * The target sends an update on element value change.
     * </pre>
     *
     * <code>ON_CHANGE = 1;</code>
     */
    public static final int ON_CHANGE_VALUE = 1;
    /**
     * <pre>
     * The target samples values according to the interval.
     * </pre>
     *
     * <code>SAMPLE = 2;</code>
     */
    public static final int SAMPLE_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SubscriptionMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SubscriptionMode forNumber(int value) {
      switch (value) {
        case 0: return TARGET_DEFINED;
        case 1: return ON_CHANGE;
        case 2: return SAMPLE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SubscriptionMode>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        SubscriptionMode> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<SubscriptionMode>() {
            public SubscriptionMode findValueByNumber(int number) {
              return SubscriptionMode.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.getDescriptor().getEnumTypes().get(1);
    }

    private static final SubscriptionMode[] VALUES = values();

    public static SubscriptionMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SubscriptionMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:gnmi.SubscriptionMode)
  }

  public interface NotificationOrBuilder extends
      // @@protoc_insertion_point(interface_extends:gnmi.Notification)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Timestamp in nanoseconds since Epoch.
     * </pre>
     *
     * <code>int64 timestamp = 1;</code>
     * @return The timestamp.
     */
    long getTimestamp();

    /**
     * <pre>
     * Prefix used for paths in the message.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 2;</code>
     * @return Whether the prefix field is set.
     */
    boolean hasPrefix();
    /**
     * <pre>
     * Prefix used for paths in the message.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 2;</code>
     * @return The prefix.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPrefix();
    /**
     * <pre>
     * Prefix used for paths in the message.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 2;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPrefixOrBuilder();

    /**
     * <pre>
     * An alias for the path specified in the prefix field.
     * Reference: gNMI Specification Section 2.4.2
     * </pre>
     *
     * <code>string alias = 3;</code>
     * @return The alias.
     */
    java.lang.String getAlias();
    /**
     * <pre>
     * An alias for the path specified in the prefix field.
     * Reference: gNMI Specification Section 2.4.2
     * </pre>
     *
     * <code>string alias = 3;</code>
     * @return The bytes for alias.
     */
    com.google.protobuf.ByteString
        getAliasBytes();

    /**
     * <pre>
     * Data elements that have changed values.
     * </pre>
     *
     * <code>repeated .gnmi.Update update = 4;</code>
     */
    java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Update> 
        getUpdateList();
    /**
     * <pre>
     * Data elements that have changed values.
     * </pre>
     *
     * <code>repeated .gnmi.Update update = 4;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Update getUpdate(int index);
    /**
     * <pre>
     * Data elements that have changed values.
     * </pre>
     *
     * <code>repeated .gnmi.Update update = 4;</code>
     */
    int getUpdateCount();
    /**
     * <pre>
     * Data elements that have changed values.
     * </pre>
     *
     * <code>repeated .gnmi.Update update = 4;</code>
     */
    java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder> 
        getUpdateOrBuilderList();
    /**
     * <pre>
     * Data elements that have changed values.
     * </pre>
     *
     * <code>repeated .gnmi.Update update = 4;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder getUpdateOrBuilder(
        int index);

    /**
     * <pre>
     * Data elements that have been deleted.
     * </pre>
     *
     * <code>repeated .gnmi.Path delete = 5;</code>
     */
    java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Path> 
        getDeleteList();
    /**
     * <pre>
     * Data elements that have been deleted.
     * </pre>
     *
     * <code>repeated .gnmi.Path delete = 5;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getDelete(int index);
    /**
     * <pre>
     * Data elements that have been deleted.
     * </pre>
     *
     * <code>repeated .gnmi.Path delete = 5;</code>
     */
    int getDeleteCount();
    /**
     * <pre>
     * Data elements that have been deleted.
     * </pre>
     *
     * <code>repeated .gnmi.Path delete = 5;</code>
     */
    java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> 
        getDeleteOrBuilderList();
    /**
     * <pre>
     * Data elements that have been deleted.
     * </pre>
     *
     * <code>repeated .gnmi.Path delete = 5;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getDeleteOrBuilder(
        int index);

    /**
     * <pre>
     * This notification contains a set of paths that are always updated together
     * referenced by a globally unique prefix.
     * </pre>
     *
     * <code>bool atomic = 6;</code>
     * @return The atomic.
     */
    boolean getAtomic();
  }
  /**
   * <pre>
   * Notification is a re-usable message that is used to encode data from the
   * target to the client. A Notification carries two types of changes to the data
   * tree:
   *  - Deleted values (delete) - a set of paths that have been removed from the
   *    data tree.
   *  - Updated values (update) - a set of path-value pairs indicating the path
   *    whose value has changed in the data tree.
   * Reference: gNMI Specification Section 2.1
   * </pre>
   *
   * Protobuf type {@code gnmi.Notification}
   */
  public static final class Notification extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:gnmi.Notification)
      NotificationOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Notification.newBuilder() to construct.
    private Notification(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Notification() {
      alias_ = "";
      update_ = java.util.Collections.emptyList();
      delete_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Notification();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Notification_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Notification_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification.Builder.class);
    }

    private int bitField0_;
    public static final int TIMESTAMP_FIELD_NUMBER = 1;
    private long timestamp_ = 0L;
    /**
     * <pre>
     * Timestamp in nanoseconds since Epoch.
     * </pre>
     *
     * <code>int64 timestamp = 1;</code>
     * @return The timestamp.
     */
    @java.lang.Override
    public long getTimestamp() {
      return timestamp_;
    }

    public static final int PREFIX_FIELD_NUMBER = 2;
    private org.opennms.features.openconfig.proto.gnmi.Gnmi.Path prefix_;
    /**
     * <pre>
     * Prefix used for paths in the message.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 2;</code>
     * @return Whether the prefix field is set.
     */
    @java.lang.Override
    public boolean hasPrefix() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Prefix used for paths in the message.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 2;</code>
     * @return The prefix.
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPrefix() {
      return prefix_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : prefix_;
    }
    /**
     * <pre>
     * Prefix used for paths in the message.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 2;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPrefixOrBuilder() {
      return prefix_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : prefix_;
    }

    public static final int ALIAS_FIELD_NUMBER = 3;
    @SuppressWarnings("serial")
    private volatile java.lang.Object alias_ = "";
    /**
     * <pre>
     * An alias for the path specified in the prefix field.
     * Reference: gNMI Specification Section 2.4.2
     * </pre>
     *
     * <code>string alias = 3;</code>
     * @return The alias.
     */
    @java.lang.Override
    public java.lang.String getAlias() {
      java.lang.Object ref = alias_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        alias_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * An alias for the path specified in the prefix field.
     * Reference: gNMI Specification Section 2.4.2
     * </pre>
     *
     * <code>string alias = 3;</code>
     * @return The bytes for alias.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getAliasBytes() {
      java.lang.Object ref = alias_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        alias_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int UPDATE_FIELD_NUMBER = 4;
    @SuppressWarnings("serial")
    private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Update> update_;
    /**
     * <pre>
     * Data elements that have changed values.
     * </pre>
     *
     * <code>repeated .gnmi.Update update = 4;</code>
     */
    @java.lang.Override
    public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Update> getUpdateList() {
      return update_;
    }
    /**
     * <pre>
     * Data elements that have changed values.
     * </pre>
     *
     * <code>repeated .gnmi.Update update = 4;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder> 
        getUpdateOrBuilderList() {
      return update_;
    }
    /**
     * <pre>
     * Data elements that have changed values.
     * </pre>
     *
     * <code>repeated .gnmi.Update update = 4;</code>
     */
    @java.lang.Override
    public int getUpdateCount() {
      return update_.size();
    }
    /**
     * <pre>
     * Data elements that have changed values.
     * </pre>
     *
     * <code>repeated .gnmi.Update update = 4;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Update getUpdate(int index) {
      return update_.get(index);
    }
    /**
     * <pre>
     * Data elements that have changed values.
     * </pre>
     *
     * <code>repeated .gnmi.Update update = 4;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder getUpdateOrBuilder(
        int index) {
      return update_.get(index);
    }

    public static final int DELETE_FIELD_NUMBER = 5;
    @SuppressWarnings("serial")
    private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Path> delete_;
    /**
     * <pre>
     * Data elements that have been deleted.
     * </pre>
     *
     * <code>repeated .gnmi.Path delete = 5;</code>
     */
    @java.lang.Override
    public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Path> getDeleteList() {
      return delete_;
    }
    /**
     * <pre>
     * Data elements that have been deleted.
     * </pre>
     *
     * <code>repeated .gnmi.Path delete = 5;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> 
        getDeleteOrBuilderList() {
      return delete_;
    }
    /**
     * <pre>
     * Data elements that have been deleted.
     * </pre>
     *
     * <code>repeated .gnmi.Path delete = 5;</code>
     */
    @java.lang.Override
    public int getDeleteCount() {
      return delete_.size();
    }
    /**
     * <pre>
     * Data elements that have been deleted.
     * </pre>
     *
     * <code>repeated .gnmi.Path delete = 5;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getDelete(int index) {
      return delete_.get(index);
    }
    /**
     * <pre>
     * Data elements that have been deleted.
     * </pre>
     *
     * <code>repeated .gnmi.Path delete = 5;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getDeleteOrBuilder(
        int index) {
      return delete_.get(index);
    }

    public static final int ATOMIC_FIELD_NUMBER = 6;
    private boolean atomic_ = false;
    /**
     * <pre>
     * This notification contains a set of paths that are always updated together
     * referenced by a globally unique prefix.
     * </pre>
     *
     * <code>bool atomic = 6;</code>
     * @return The atomic.
     */
    @java.lang.Override
    public boolean getAtomic() {
      return atomic_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (timestamp_ != 0L) {
        output.writeInt64(1, timestamp_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getPrefix());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(alias_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, alias_);
      }
      for (int i = 0; i < update_.size(); i++) {
        output.writeMessage(4, update_.get(i));
      }
      for (int i = 0; i < delete_.size(); i++) {
        output.writeMessage(5, delete_.get(i));
      }
      if (atomic_ != false) {
        output.writeBool(6, atomic_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (timestamp_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt64Size(1, timestamp_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getPrefix());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(alias_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, alias_);
      }
      for (int i = 0; i < update_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, update_.get(i));
      }
      for (int i = 0; i < delete_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, delete_.get(i));
      }
      if (atomic_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(6, atomic_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification)) {
        return super.equals(obj);
      }
      org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification other = (org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification) obj;

      if (getTimestamp()
          != other.getTimestamp()) return false;
      if (hasPrefix() != other.hasPrefix()) return false;
      if (hasPrefix()) {
        if (!getPrefix()
            .equals(other.getPrefix())) return false;
      }
      if (!getAlias()
          .equals(other.getAlias())) return false;
      if (!getUpdateList()
          .equals(other.getUpdateList())) return false;
      if (!getDeleteList()
          .equals(other.getDeleteList())) return false;
      if (getAtomic()
          != other.getAtomic()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getTimestamp());
      if (hasPrefix()) {
        hash = (37 * hash) + PREFIX_FIELD_NUMBER;
        hash = (53 * hash) + getPrefix().hashCode();
      }
      hash = (37 * hash) + ALIAS_FIELD_NUMBER;
      hash = (53 * hash) + getAlias().hashCode();
      if (getUpdateCount() > 0) {
        hash = (37 * hash) + UPDATE_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateList().hashCode();
      }
      if (getDeleteCount() > 0) {
        hash = (37 * hash) + DELETE_FIELD_NUMBER;
        hash = (53 * hash) + getDeleteList().hashCode();
      }
      hash = (37 * hash) + ATOMIC_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAtomic());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Notification is a re-usable message that is used to encode data from the
     * target to the client. A Notification carries two types of changes to the data
     * tree:
     *  - Deleted values (delete) - a set of paths that have been removed from the
     *    data tree.
     *  - Updated values (update) - a set of path-value pairs indicating the path
     *    whose value has changed in the data tree.
     * Reference: gNMI Specification Section 2.1
     * </pre>
     *
     * Protobuf type {@code gnmi.Notification}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:gnmi.Notification)
        org.opennms.features.openconfig.proto.gnmi.Gnmi.NotificationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Notification_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Notification_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification.Builder.class);
      }

      // Construct using org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getPrefixFieldBuilder();
          getUpdateFieldBuilder();
          getDeleteFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        timestamp_ = 0L;
        prefix_ = null;
        if (prefixBuilder_ != null) {
          prefixBuilder_.dispose();
          prefixBuilder_ = null;
        }
        alias_ = "";
        if (updateBuilder_ == null) {
          update_ = java.util.Collections.emptyList();
        } else {
          update_ = null;
          updateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        if (deleteBuilder_ == null) {
          delete_ = java.util.Collections.emptyList();
        } else {
          delete_ = null;
          deleteBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        atomic_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Notification_descriptor;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification getDefaultInstanceForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification.getDefaultInstance();
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification build() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification buildPartial() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification result = new org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification result) {
        if (updateBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            update_ = java.util.Collections.unmodifiableList(update_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.update_ = update_;
        } else {
          result.update_ = updateBuilder_.build();
        }
        if (deleteBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)) {
            delete_ = java.util.Collections.unmodifiableList(delete_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.delete_ = delete_;
        } else {
          result.delete_ = deleteBuilder_.build();
        }
      }

      private void buildPartial0(org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.timestamp_ = timestamp_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.prefix_ = prefixBuilder_ == null
              ? prefix_
              : prefixBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.alias_ = alias_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.atomic_ = atomic_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification) {
          return mergeFrom((org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification other) {
        if (other == org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification.getDefaultInstance()) return this;
        if (other.getTimestamp() != 0L) {
          setTimestamp(other.getTimestamp());
        }
        if (other.hasPrefix()) {
          mergePrefix(other.getPrefix());
        }
        if (!other.getAlias().isEmpty()) {
          alias_ = other.alias_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (updateBuilder_ == null) {
          if (!other.update_.isEmpty()) {
            if (update_.isEmpty()) {
              update_ = other.update_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureUpdateIsMutable();
              update_.addAll(other.update_);
            }
            onChanged();
          }
        } else {
          if (!other.update_.isEmpty()) {
            if (updateBuilder_.isEmpty()) {
              updateBuilder_.dispose();
              updateBuilder_ = null;
              update_ = other.update_;
              bitField0_ = (bitField0_ & ~0x00000008);
              updateBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getUpdateFieldBuilder() : null;
            } else {
              updateBuilder_.addAllMessages(other.update_);
            }
          }
        }
        if (deleteBuilder_ == null) {
          if (!other.delete_.isEmpty()) {
            if (delete_.isEmpty()) {
              delete_ = other.delete_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureDeleteIsMutable();
              delete_.addAll(other.delete_);
            }
            onChanged();
          }
        } else {
          if (!other.delete_.isEmpty()) {
            if (deleteBuilder_.isEmpty()) {
              deleteBuilder_.dispose();
              deleteBuilder_ = null;
              delete_ = other.delete_;
              bitField0_ = (bitField0_ & ~0x00000010);
              deleteBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getDeleteFieldBuilder() : null;
            } else {
              deleteBuilder_.addAllMessages(other.delete_);
            }
          }
        }
        if (other.getAtomic() != false) {
          setAtomic(other.getAtomic());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                timestamp_ = input.readInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              case 18: {
                input.readMessage(
                    getPrefixFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                alias_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              case 34: {
                org.opennms.features.openconfig.proto.gnmi.Gnmi.Update m =
                    input.readMessage(
                        org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.parser(),
                        extensionRegistry);
                if (updateBuilder_ == null) {
                  ensureUpdateIsMutable();
                  update_.add(m);
                } else {
                  updateBuilder_.addMessage(m);
                }
                break;
              } // case 34
              case 42: {
                org.opennms.features.openconfig.proto.gnmi.Gnmi.Path m =
                    input.readMessage(
                        org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.parser(),
                        extensionRegistry);
                if (deleteBuilder_ == null) {
                  ensureDeleteIsMutable();
                  delete_.add(m);
                } else {
                  deleteBuilder_.addMessage(m);
                }
                break;
              } // case 42
              case 48: {
                atomic_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private long timestamp_ ;
      /**
       * <pre>
       * Timestamp in nanoseconds since Epoch.
       * </pre>
       *
       * <code>int64 timestamp = 1;</code>
       * @return The timestamp.
       */
      @java.lang.Override
      public long getTimestamp() {
        return timestamp_;
      }
      /**
       * <pre>
       * Timestamp in nanoseconds since Epoch.
       * </pre>
       *
       * <code>int64 timestamp = 1;</code>
       * @param value The timestamp to set.
       * @return This builder for chaining.
       */
      public Builder setTimestamp(long value) {

        timestamp_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Timestamp in nanoseconds since Epoch.
       * </pre>
       *
       * <code>int64 timestamp = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearTimestamp() {
        bitField0_ = (bitField0_ & ~0x00000001);
        timestamp_ = 0L;
        onChanged();
        return this;
      }

      private org.opennms.features.openconfig.proto.gnmi.Gnmi.Path prefix_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> prefixBuilder_;
      /**
       * <pre>
       * Prefix used for paths in the message.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 2;</code>
       * @return Whether the prefix field is set.
       */
      public boolean hasPrefix() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * Prefix used for paths in the message.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 2;</code>
       * @return The prefix.
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPrefix() {
        if (prefixBuilder_ == null) {
          return prefix_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : prefix_;
        } else {
          return prefixBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Prefix used for paths in the message.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 2;</code>
       */
      public Builder setPrefix(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (prefixBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          prefix_ = value;
        } else {
          prefixBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Prefix used for paths in the message.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 2;</code>
       */
      public Builder setPrefix(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder builderForValue) {
        if (prefixBuilder_ == null) {
          prefix_ = builderForValue.build();
        } else {
          prefixBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Prefix used for paths in the message.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 2;</code>
       */
      public Builder mergePrefix(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (prefixBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            prefix_ != null &&
            prefix_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance()) {
            getPrefixBuilder().mergeFrom(value);
          } else {
            prefix_ = value;
          }
        } else {
          prefixBuilder_.mergeFrom(value);
        }
        if (prefix_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * Prefix used for paths in the message.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 2;</code>
       */
      public Builder clearPrefix() {
        bitField0_ = (bitField0_ & ~0x00000002);
        prefix_ = null;
        if (prefixBuilder_ != null) {
          prefixBuilder_.dispose();
          prefixBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Prefix used for paths in the message.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 2;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder getPrefixBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getPrefixFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Prefix used for paths in the message.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 2;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPrefixOrBuilder() {
        if (prefixBuilder_ != null) {
          return prefixBuilder_.getMessageOrBuilder();
        } else {
          return prefix_ == null ?
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : prefix_;
        }
      }
      /**
       * <pre>
       * Prefix used for paths in the message.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> 
          getPrefixFieldBuilder() {
        if (prefixBuilder_ == null) {
          prefixBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder>(
                  getPrefix(),
                  getParentForChildren(),
                  isClean());
          prefix_ = null;
        }
        return prefixBuilder_;
      }

      private java.lang.Object alias_ = "";
      /**
       * <pre>
       * An alias for the path specified in the prefix field.
       * Reference: gNMI Specification Section 2.4.2
       * </pre>
       *
       * <code>string alias = 3;</code>
       * @return The alias.
       */
      public java.lang.String getAlias() {
        java.lang.Object ref = alias_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          alias_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * An alias for the path specified in the prefix field.
       * Reference: gNMI Specification Section 2.4.2
       * </pre>
       *
       * <code>string alias = 3;</code>
       * @return The bytes for alias.
       */
      public com.google.protobuf.ByteString
          getAliasBytes() {
        java.lang.Object ref = alias_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          alias_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * An alias for the path specified in the prefix field.
       * Reference: gNMI Specification Section 2.4.2
       * </pre>
       *
       * <code>string alias = 3;</code>
       * @param value The alias to set.
       * @return This builder for chaining.
       */
      public Builder setAlias(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        alias_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * An alias for the path specified in the prefix field.
       * Reference: gNMI Specification Section 2.4.2
       * </pre>
       *
       * <code>string alias = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearAlias() {
        alias_ = getDefaultInstance().getAlias();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * An alias for the path specified in the prefix field.
       * Reference: gNMI Specification Section 2.4.2
       * </pre>
       *
       * <code>string alias = 3;</code>
       * @param value The bytes for alias to set.
       * @return This builder for chaining.
       */
      public Builder setAliasBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        alias_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Update> update_ =
        java.util.Collections.emptyList();
      private void ensureUpdateIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          update_ = new java.util.ArrayList<org.opennms.features.openconfig.proto.gnmi.Gnmi.Update>(update_);
          bitField0_ |= 0x00000008;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Update, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder> updateBuilder_;

      /**
       * <pre>
       * Data elements that have changed values.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Update> getUpdateList() {
        if (updateBuilder_ == null) {
          return java.util.Collections.unmodifiableList(update_);
        } else {
          return updateBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Data elements that have changed values.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public int getUpdateCount() {
        if (updateBuilder_ == null) {
          return update_.size();
        } else {
          return updateBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Data elements that have changed values.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Update getUpdate(int index) {
        if (updateBuilder_ == null) {
          return update_.get(index);
        } else {
          return updateBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Data elements that have changed values.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public Builder setUpdate(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update value) {
        if (updateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUpdateIsMutable();
          update_.set(index, value);
          onChanged();
        } else {
          updateBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Data elements that have changed values.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public Builder setUpdate(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder builderForValue) {
        if (updateBuilder_ == null) {
          ensureUpdateIsMutable();
          update_.set(index, builderForValue.build());
          onChanged();
        } else {
          updateBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Data elements that have changed values.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public Builder addUpdate(org.opennms.features.openconfig.proto.gnmi.Gnmi.Update value) {
        if (updateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUpdateIsMutable();
          update_.add(value);
          onChanged();
        } else {
          updateBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Data elements that have changed values.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public Builder addUpdate(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update value) {
        if (updateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUpdateIsMutable();
          update_.add(index, value);
          onChanged();
        } else {
          updateBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Data elements that have changed values.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public Builder addUpdate(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder builderForValue) {
        if (updateBuilder_ == null) {
          ensureUpdateIsMutable();
          update_.add(builderForValue.build());
          onChanged();
        } else {
          updateBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Data elements that have changed values.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public Builder addUpdate(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder builderForValue) {
        if (updateBuilder_ == null) {
          ensureUpdateIsMutable();
          update_.add(index, builderForValue.build());
          onChanged();
        } else {
          updateBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Data elements that have changed values.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public Builder addAllUpdate(
          java.lang.Iterable<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.Update> values) {
        if (updateBuilder_ == null) {
          ensureUpdateIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, update_);
          onChanged();
        } else {
          updateBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Data elements that have changed values.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public Builder clearUpdate() {
        if (updateBuilder_ == null) {
          update_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          updateBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Data elements that have changed values.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public Builder removeUpdate(int index) {
        if (updateBuilder_ == null) {
          ensureUpdateIsMutable();
          update_.remove(index);
          onChanged();
        } else {
          updateBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Data elements that have changed values.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder getUpdateBuilder(
          int index) {
        return getUpdateFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Data elements that have changed values.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder getUpdateOrBuilder(
          int index) {
        if (updateBuilder_ == null) {
          return update_.get(index);  } else {
          return updateBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Data elements that have changed values.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder> 
           getUpdateOrBuilderList() {
        if (updateBuilder_ != null) {
          return updateBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(update_);
        }
      }
      /**
       * <pre>
       * Data elements that have changed values.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder addUpdateBuilder() {
        return getUpdateFieldBuilder().addBuilder(
            org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.getDefaultInstance());
      }
      /**
       * <pre>
       * Data elements that have changed values.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder addUpdateBuilder(
          int index) {
        return getUpdateFieldBuilder().addBuilder(
            index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.getDefaultInstance());
      }
      /**
       * <pre>
       * Data elements that have changed values.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder> 
           getUpdateBuilderList() {
        return getUpdateFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Update, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder> 
          getUpdateFieldBuilder() {
        if (updateBuilder_ == null) {
          updateBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Update, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder>(
                  update_,
                  ((bitField0_ & 0x00000008) != 0),
                  getParentForChildren(),
                  isClean());
          update_ = null;
        }
        return updateBuilder_;
      }

      private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Path> delete_ =
        java.util.Collections.emptyList();
      private void ensureDeleteIsMutable() {
        if (!((bitField0_ & 0x00000010) != 0)) {
          delete_ = new java.util.ArrayList<org.opennms.features.openconfig.proto.gnmi.Gnmi.Path>(delete_);
          bitField0_ |= 0x00000010;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> deleteBuilder_;

      /**
       * <pre>
       * Data elements that have been deleted.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 5;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Path> getDeleteList() {
        if (deleteBuilder_ == null) {
          return java.util.Collections.unmodifiableList(delete_);
        } else {
          return deleteBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Data elements that have been deleted.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 5;</code>
       */
      public int getDeleteCount() {
        if (deleteBuilder_ == null) {
          return delete_.size();
        } else {
          return deleteBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Data elements that have been deleted.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getDelete(int index) {
        if (deleteBuilder_ == null) {
          return delete_.get(index);
        } else {
          return deleteBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Data elements that have been deleted.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 5;</code>
       */
      public Builder setDelete(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (deleteBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDeleteIsMutable();
          delete_.set(index, value);
          onChanged();
        } else {
          deleteBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Data elements that have been deleted.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 5;</code>
       */
      public Builder setDelete(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder builderForValue) {
        if (deleteBuilder_ == null) {
          ensureDeleteIsMutable();
          delete_.set(index, builderForValue.build());
          onChanged();
        } else {
          deleteBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Data elements that have been deleted.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 5;</code>
       */
      public Builder addDelete(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (deleteBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDeleteIsMutable();
          delete_.add(value);
          onChanged();
        } else {
          deleteBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Data elements that have been deleted.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 5;</code>
       */
      public Builder addDelete(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (deleteBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDeleteIsMutable();
          delete_.add(index, value);
          onChanged();
        } else {
          deleteBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Data elements that have been deleted.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 5;</code>
       */
      public Builder addDelete(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder builderForValue) {
        if (deleteBuilder_ == null) {
          ensureDeleteIsMutable();
          delete_.add(builderForValue.build());
          onChanged();
        } else {
          deleteBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Data elements that have been deleted.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 5;</code>
       */
      public Builder addDelete(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder builderForValue) {
        if (deleteBuilder_ == null) {
          ensureDeleteIsMutable();
          delete_.add(index, builderForValue.build());
          onChanged();
        } else {
          deleteBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Data elements that have been deleted.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 5;</code>
       */
      public Builder addAllDelete(
          java.lang.Iterable<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.Path> values) {
        if (deleteBuilder_ == null) {
          ensureDeleteIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, delete_);
          onChanged();
        } else {
          deleteBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Data elements that have been deleted.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 5;</code>
       */
      public Builder clearDelete() {
        if (deleteBuilder_ == null) {
          delete_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          deleteBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Data elements that have been deleted.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 5;</code>
       */
      public Builder removeDelete(int index) {
        if (deleteBuilder_ == null) {
          ensureDeleteIsMutable();
          delete_.remove(index);
          onChanged();
        } else {
          deleteBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Data elements that have been deleted.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder getDeleteBuilder(
          int index) {
        return getDeleteFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Data elements that have been deleted.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getDeleteOrBuilder(
          int index) {
        if (deleteBuilder_ == null) {
          return delete_.get(index);  } else {
          return deleteBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Data elements that have been deleted.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 5;</code>
       */
      public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> 
           getDeleteOrBuilderList() {
        if (deleteBuilder_ != null) {
          return deleteBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(delete_);
        }
      }
      /**
       * <pre>
       * Data elements that have been deleted.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder addDeleteBuilder() {
        return getDeleteFieldBuilder().addBuilder(
            org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance());
      }
      /**
       * <pre>
       * Data elements that have been deleted.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder addDeleteBuilder(
          int index) {
        return getDeleteFieldBuilder().addBuilder(
            index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance());
      }
      /**
       * <pre>
       * Data elements that have been deleted.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 5;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder> 
           getDeleteBuilderList() {
        return getDeleteFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> 
          getDeleteFieldBuilder() {
        if (deleteBuilder_ == null) {
          deleteBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder>(
                  delete_,
                  ((bitField0_ & 0x00000010) != 0),
                  getParentForChildren(),
                  isClean());
          delete_ = null;
        }
        return deleteBuilder_;
      }

      private boolean atomic_ ;
      /**
       * <pre>
       * This notification contains a set of paths that are always updated together
       * referenced by a globally unique prefix.
       * </pre>
       *
       * <code>bool atomic = 6;</code>
       * @return The atomic.
       */
      @java.lang.Override
      public boolean getAtomic() {
        return atomic_;
      }
      /**
       * <pre>
       * This notification contains a set of paths that are always updated together
       * referenced by a globally unique prefix.
       * </pre>
       *
       * <code>bool atomic = 6;</code>
       * @param value The atomic to set.
       * @return This builder for chaining.
       */
      public Builder setAtomic(boolean value) {

        atomic_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * This notification contains a set of paths that are always updated together
       * referenced by a globally unique prefix.
       * </pre>
       *
       * <code>bool atomic = 6;</code>
       * @return This builder for chaining.
       */
      public Builder clearAtomic() {
        bitField0_ = (bitField0_ & ~0x00000020);
        atomic_ = false;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:gnmi.Notification)
    }

    // @@protoc_insertion_point(class_scope:gnmi.Notification)
    private static final org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification();
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Notification>
        PARSER = new com.google.protobuf.AbstractParser<Notification>() {
      @java.lang.Override
      public Notification parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Notification> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Notification> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface UpdateOrBuilder extends
      // @@protoc_insertion_point(interface_extends:gnmi.Update)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The path (key) for the update.
     * </pre>
     *
     * <code>.gnmi.Path path = 1;</code>
     * @return Whether the path field is set.
     */
    boolean hasPath();
    /**
     * <pre>
     * The path (key) for the update.
     * </pre>
     *
     * <code>.gnmi.Path path = 1;</code>
     * @return The path.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPath();
    /**
     * <pre>
     * The path (key) for the update.
     * </pre>
     *
     * <code>.gnmi.Path path = 1;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPathOrBuilder();

    /**
     * <pre>
     * The value (value) for the update.
     * </pre>
     *
     * <code>.gnmi.Value value = 2 [deprecated = true];</code>
     * @deprecated gnmi.Update.value is deprecated.
     *     See gnmi.proto;l=97
     * @return Whether the value field is set.
     */
    @java.lang.Deprecated boolean hasValue();
    /**
     * <pre>
     * The value (value) for the update.
     * </pre>
     *
     * <code>.gnmi.Value value = 2 [deprecated = true];</code>
     * @deprecated gnmi.Update.value is deprecated.
     *     See gnmi.proto;l=97
     * @return The value.
     */
    @java.lang.Deprecated org.opennms.features.openconfig.proto.gnmi.Gnmi.Value getValue();
    /**
     * <pre>
     * The value (value) for the update.
     * </pre>
     *
     * <code>.gnmi.Value value = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated org.opennms.features.openconfig.proto.gnmi.Gnmi.ValueOrBuilder getValueOrBuilder();

    /**
     * <pre>
     * The explicitly typed update value.
     * </pre>
     *
     * <code>.gnmi.TypedValue val = 3;</code>
     * @return Whether the val field is set.
     */
    boolean hasVal();
    /**
     * <pre>
     * The explicitly typed update value.
     * </pre>
     *
     * <code>.gnmi.TypedValue val = 3;</code>
     * @return The val.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue getVal();
    /**
     * <pre>
     * The explicitly typed update value.
     * </pre>
     *
     * <code>.gnmi.TypedValue val = 3;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValueOrBuilder getValOrBuilder();

    /**
     * <pre>
     * Number of coalesced duplicates.
     * </pre>
     *
     * <code>uint32 duplicates = 4;</code>
     * @return The duplicates.
     */
    int getDuplicates();
  }
  /**
   * <pre>
   * Update is a re-usable message that is used to store a particular Path,
   * Value pair.
   * Reference: gNMI Specification Section 2.1
   * </pre>
   *
   * Protobuf type {@code gnmi.Update}
   */
  public static final class Update extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:gnmi.Update)
      UpdateOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Update.newBuilder() to construct.
    private Update(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Update() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Update();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Update_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Update_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder.class);
    }

    private int bitField0_;
    public static final int PATH_FIELD_NUMBER = 1;
    private org.opennms.features.openconfig.proto.gnmi.Gnmi.Path path_;
    /**
     * <pre>
     * The path (key) for the update.
     * </pre>
     *
     * <code>.gnmi.Path path = 1;</code>
     * @return Whether the path field is set.
     */
    @java.lang.Override
    public boolean hasPath() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * The path (key) for the update.
     * </pre>
     *
     * <code>.gnmi.Path path = 1;</code>
     * @return The path.
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPath() {
      return path_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : path_;
    }
    /**
     * <pre>
     * The path (key) for the update.
     * </pre>
     *
     * <code>.gnmi.Path path = 1;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPathOrBuilder() {
      return path_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : path_;
    }

    public static final int VALUE_FIELD_NUMBER = 2;
    private org.opennms.features.openconfig.proto.gnmi.Gnmi.Value value_;
    /**
     * <pre>
     * The value (value) for the update.
     * </pre>
     *
     * <code>.gnmi.Value value = 2 [deprecated = true];</code>
     * @deprecated gnmi.Update.value is deprecated.
     *     See gnmi.proto;l=97
     * @return Whether the value field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated public boolean hasValue() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * The value (value) for the update.
     * </pre>
     *
     * <code>.gnmi.Value value = 2 [deprecated = true];</code>
     * @deprecated gnmi.Update.value is deprecated.
     *     See gnmi.proto;l=97
     * @return The value.
     */
    @java.lang.Override
    @java.lang.Deprecated public org.opennms.features.openconfig.proto.gnmi.Gnmi.Value getValue() {
      return value_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Value.getDefaultInstance() : value_;
    }
    /**
     * <pre>
     * The value (value) for the update.
     * </pre>
     *
     * <code>.gnmi.Value value = 2 [deprecated = true];</code>
     */
    @java.lang.Override
    @java.lang.Deprecated public org.opennms.features.openconfig.proto.gnmi.Gnmi.ValueOrBuilder getValueOrBuilder() {
      return value_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Value.getDefaultInstance() : value_;
    }

    public static final int VAL_FIELD_NUMBER = 3;
    private org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue val_;
    /**
     * <pre>
     * The explicitly typed update value.
     * </pre>
     *
     * <code>.gnmi.TypedValue val = 3;</code>
     * @return Whether the val field is set.
     */
    @java.lang.Override
    public boolean hasVal() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * The explicitly typed update value.
     * </pre>
     *
     * <code>.gnmi.TypedValue val = 3;</code>
     * @return The val.
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue getVal() {
      return val_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.getDefaultInstance() : val_;
    }
    /**
     * <pre>
     * The explicitly typed update value.
     * </pre>
     *
     * <code>.gnmi.TypedValue val = 3;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValueOrBuilder getValOrBuilder() {
      return val_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.getDefaultInstance() : val_;
    }

    public static final int DUPLICATES_FIELD_NUMBER = 4;
    private int duplicates_ = 0;
    /**
     * <pre>
     * Number of coalesced duplicates.
     * </pre>
     *
     * <code>uint32 duplicates = 4;</code>
     * @return The duplicates.
     */
    @java.lang.Override
    public int getDuplicates() {
      return duplicates_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getPath());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getValue());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(3, getVal());
      }
      if (duplicates_ != 0) {
        output.writeUInt32(4, duplicates_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getPath());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getValue());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getVal());
      }
      if (duplicates_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(4, duplicates_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.Update)) {
        return super.equals(obj);
      }
      org.opennms.features.openconfig.proto.gnmi.Gnmi.Update other = (org.opennms.features.openconfig.proto.gnmi.Gnmi.Update) obj;

      if (hasPath() != other.hasPath()) return false;
      if (hasPath()) {
        if (!getPath()
            .equals(other.getPath())) return false;
      }
      if (hasValue() != other.hasValue()) return false;
      if (hasValue()) {
        if (!getValue()
            .equals(other.getValue())) return false;
      }
      if (hasVal() != other.hasVal()) return false;
      if (hasVal()) {
        if (!getVal()
            .equals(other.getVal())) return false;
      }
      if (getDuplicates()
          != other.getDuplicates()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPath()) {
        hash = (37 * hash) + PATH_FIELD_NUMBER;
        hash = (53 * hash) + getPath().hashCode();
      }
      if (hasValue()) {
        hash = (37 * hash) + VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getValue().hashCode();
      }
      if (hasVal()) {
        hash = (37 * hash) + VAL_FIELD_NUMBER;
        hash = (53 * hash) + getVal().hashCode();
      }
      hash = (37 * hash) + DUPLICATES_FIELD_NUMBER;
      hash = (53 * hash) + getDuplicates();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Update parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Update parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Update parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Update parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Update parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Update parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Update parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Update parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Update parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Update parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Update parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Update parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.openconfig.proto.gnmi.Gnmi.Update prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Update is a re-usable message that is used to store a particular Path,
     * Value pair.
     * Reference: gNMI Specification Section 2.1
     * </pre>
     *
     * Protobuf type {@code gnmi.Update}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:gnmi.Update)
        org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Update_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Update_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder.class);
      }

      // Construct using org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getPathFieldBuilder();
          getValueFieldBuilder();
          getValFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        path_ = null;
        if (pathBuilder_ != null) {
          pathBuilder_.dispose();
          pathBuilder_ = null;
        }
        value_ = null;
        if (valueBuilder_ != null) {
          valueBuilder_.dispose();
          valueBuilder_ = null;
        }
        val_ = null;
        if (valBuilder_ != null) {
          valBuilder_.dispose();
          valBuilder_ = null;
        }
        duplicates_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Update_descriptor;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Update getDefaultInstanceForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.getDefaultInstance();
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Update build() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.Update result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Update buildPartial() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.Update result = new org.opennms.features.openconfig.proto.gnmi.Gnmi.Update(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.opennms.features.openconfig.proto.gnmi.Gnmi.Update result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.path_ = pathBuilder_ == null
              ? path_
              : pathBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.value_ = valueBuilder_ == null
              ? value_
              : valueBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.val_ = valBuilder_ == null
              ? val_
              : valBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.duplicates_ = duplicates_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.Update) {
          return mergeFrom((org.opennms.features.openconfig.proto.gnmi.Gnmi.Update)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.openconfig.proto.gnmi.Gnmi.Update other) {
        if (other == org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.getDefaultInstance()) return this;
        if (other.hasPath()) {
          mergePath(other.getPath());
        }
        if (other.hasValue()) {
          mergeValue(other.getValue());
        }
        if (other.hasVal()) {
          mergeVal(other.getVal());
        }
        if (other.getDuplicates() != 0) {
          setDuplicates(other.getDuplicates());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getPathFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                input.readMessage(
                    getValueFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                input.readMessage(
                    getValFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              case 32: {
                duplicates_ = input.readUInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.opennms.features.openconfig.proto.gnmi.Gnmi.Path path_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> pathBuilder_;
      /**
       * <pre>
       * The path (key) for the update.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       * @return Whether the path field is set.
       */
      public boolean hasPath() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * The path (key) for the update.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       * @return The path.
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPath() {
        if (pathBuilder_ == null) {
          return path_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : path_;
        } else {
          return pathBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * The path (key) for the update.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       */
      public Builder setPath(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (pathBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          path_ = value;
        } else {
          pathBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The path (key) for the update.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       */
      public Builder setPath(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder builderForValue) {
        if (pathBuilder_ == null) {
          path_ = builderForValue.build();
        } else {
          pathBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The path (key) for the update.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       */
      public Builder mergePath(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (pathBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            path_ != null &&
            path_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance()) {
            getPathBuilder().mergeFrom(value);
          } else {
            path_ = value;
          }
        } else {
          pathBuilder_.mergeFrom(value);
        }
        if (path_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * The path (key) for the update.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       */
      public Builder clearPath() {
        bitField0_ = (bitField0_ & ~0x00000001);
        path_ = null;
        if (pathBuilder_ != null) {
          pathBuilder_.dispose();
          pathBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The path (key) for the update.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder getPathBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getPathFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * The path (key) for the update.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPathOrBuilder() {
        if (pathBuilder_ != null) {
          return pathBuilder_.getMessageOrBuilder();
        } else {
          return path_ == null ?
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : path_;
        }
      }
      /**
       * <pre>
       * The path (key) for the update.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> 
          getPathFieldBuilder() {
        if (pathBuilder_ == null) {
          pathBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder>(
                  getPath(),
                  getParentForChildren(),
                  isClean());
          path_ = null;
        }
        return pathBuilder_;
      }

      private org.opennms.features.openconfig.proto.gnmi.Gnmi.Value value_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Value, org.opennms.features.openconfig.proto.gnmi.Gnmi.Value.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.ValueOrBuilder> valueBuilder_;
      /**
       * <pre>
       * The value (value) for the update.
       * </pre>
       *
       * <code>.gnmi.Value value = 2 [deprecated = true];</code>
       * @deprecated gnmi.Update.value is deprecated.
       *     See gnmi.proto;l=97
       * @return Whether the value field is set.
       */
      @java.lang.Deprecated public boolean hasValue() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * The value (value) for the update.
       * </pre>
       *
       * <code>.gnmi.Value value = 2 [deprecated = true];</code>
       * @deprecated gnmi.Update.value is deprecated.
       *     See gnmi.proto;l=97
       * @return The value.
       */
      @java.lang.Deprecated public org.opennms.features.openconfig.proto.gnmi.Gnmi.Value getValue() {
        if (valueBuilder_ == null) {
          return value_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Value.getDefaultInstance() : value_;
        } else {
          return valueBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * The value (value) for the update.
       * </pre>
       *
       * <code>.gnmi.Value value = 2 [deprecated = true];</code>
       */
      @java.lang.Deprecated public Builder setValue(org.opennms.features.openconfig.proto.gnmi.Gnmi.Value value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          value_ = value;
        } else {
          valueBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The value (value) for the update.
       * </pre>
       *
       * <code>.gnmi.Value value = 2 [deprecated = true];</code>
       */
      @java.lang.Deprecated public Builder setValue(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Value.Builder builderForValue) {
        if (valueBuilder_ == null) {
          value_ = builderForValue.build();
        } else {
          valueBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The value (value) for the update.
       * </pre>
       *
       * <code>.gnmi.Value value = 2 [deprecated = true];</code>
       */
      @java.lang.Deprecated public Builder mergeValue(org.opennms.features.openconfig.proto.gnmi.Gnmi.Value value) {
        if (valueBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            value_ != null &&
            value_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.Value.getDefaultInstance()) {
            getValueBuilder().mergeFrom(value);
          } else {
            value_ = value;
          }
        } else {
          valueBuilder_.mergeFrom(value);
        }
        if (value_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * The value (value) for the update.
       * </pre>
       *
       * <code>.gnmi.Value value = 2 [deprecated = true];</code>
       */
      @java.lang.Deprecated public Builder clearValue() {
        bitField0_ = (bitField0_ & ~0x00000002);
        value_ = null;
        if (valueBuilder_ != null) {
          valueBuilder_.dispose();
          valueBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The value (value) for the update.
       * </pre>
       *
       * <code>.gnmi.Value value = 2 [deprecated = true];</code>
       */
      @java.lang.Deprecated public org.opennms.features.openconfig.proto.gnmi.Gnmi.Value.Builder getValueBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getValueFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * The value (value) for the update.
       * </pre>
       *
       * <code>.gnmi.Value value = 2 [deprecated = true];</code>
       */
      @java.lang.Deprecated public org.opennms.features.openconfig.proto.gnmi.Gnmi.ValueOrBuilder getValueOrBuilder() {
        if (valueBuilder_ != null) {
          return valueBuilder_.getMessageOrBuilder();
        } else {
          return value_ == null ?
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Value.getDefaultInstance() : value_;
        }
      }
      /**
       * <pre>
       * The value (value) for the update.
       * </pre>
       *
       * <code>.gnmi.Value value = 2 [deprecated = true];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Value, org.opennms.features.openconfig.proto.gnmi.Gnmi.Value.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.ValueOrBuilder> 
          getValueFieldBuilder() {
        if (valueBuilder_ == null) {
          valueBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Value, org.opennms.features.openconfig.proto.gnmi.Gnmi.Value.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.ValueOrBuilder>(
                  getValue(),
                  getParentForChildren(),
                  isClean());
          value_ = null;
        }
        return valueBuilder_;
      }

      private org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue val_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue, org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValueOrBuilder> valBuilder_;
      /**
       * <pre>
       * The explicitly typed update value.
       * </pre>
       *
       * <code>.gnmi.TypedValue val = 3;</code>
       * @return Whether the val field is set.
       */
      public boolean hasVal() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * The explicitly typed update value.
       * </pre>
       *
       * <code>.gnmi.TypedValue val = 3;</code>
       * @return The val.
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue getVal() {
        if (valBuilder_ == null) {
          return val_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.getDefaultInstance() : val_;
        } else {
          return valBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * The explicitly typed update value.
       * </pre>
       *
       * <code>.gnmi.TypedValue val = 3;</code>
       */
      public Builder setVal(org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue value) {
        if (valBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          val_ = value;
        } else {
          valBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The explicitly typed update value.
       * </pre>
       *
       * <code>.gnmi.TypedValue val = 3;</code>
       */
      public Builder setVal(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.Builder builderForValue) {
        if (valBuilder_ == null) {
          val_ = builderForValue.build();
        } else {
          valBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The explicitly typed update value.
       * </pre>
       *
       * <code>.gnmi.TypedValue val = 3;</code>
       */
      public Builder mergeVal(org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue value) {
        if (valBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0) &&
            val_ != null &&
            val_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.getDefaultInstance()) {
            getValBuilder().mergeFrom(value);
          } else {
            val_ = value;
          }
        } else {
          valBuilder_.mergeFrom(value);
        }
        if (val_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * The explicitly typed update value.
       * </pre>
       *
       * <code>.gnmi.TypedValue val = 3;</code>
       */
      public Builder clearVal() {
        bitField0_ = (bitField0_ & ~0x00000004);
        val_ = null;
        if (valBuilder_ != null) {
          valBuilder_.dispose();
          valBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The explicitly typed update value.
       * </pre>
       *
       * <code>.gnmi.TypedValue val = 3;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.Builder getValBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getValFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * The explicitly typed update value.
       * </pre>
       *
       * <code>.gnmi.TypedValue val = 3;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValueOrBuilder getValOrBuilder() {
        if (valBuilder_ != null) {
          return valBuilder_.getMessageOrBuilder();
        } else {
          return val_ == null ?
              org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.getDefaultInstance() : val_;
        }
      }
      /**
       * <pre>
       * The explicitly typed update value.
       * </pre>
       *
       * <code>.gnmi.TypedValue val = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue, org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValueOrBuilder> 
          getValFieldBuilder() {
        if (valBuilder_ == null) {
          valBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue, org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValueOrBuilder>(
                  getVal(),
                  getParentForChildren(),
                  isClean());
          val_ = null;
        }
        return valBuilder_;
      }

      private int duplicates_ ;
      /**
       * <pre>
       * Number of coalesced duplicates.
       * </pre>
       *
       * <code>uint32 duplicates = 4;</code>
       * @return The duplicates.
       */
      @java.lang.Override
      public int getDuplicates() {
        return duplicates_;
      }
      /**
       * <pre>
       * Number of coalesced duplicates.
       * </pre>
       *
       * <code>uint32 duplicates = 4;</code>
       * @param value The duplicates to set.
       * @return This builder for chaining.
       */
      public Builder setDuplicates(int value) {

        duplicates_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Number of coalesced duplicates.
       * </pre>
       *
       * <code>uint32 duplicates = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearDuplicates() {
        bitField0_ = (bitField0_ & ~0x00000008);
        duplicates_ = 0;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:gnmi.Update)
    }

    // @@protoc_insertion_point(class_scope:gnmi.Update)
    private static final org.opennms.features.openconfig.proto.gnmi.Gnmi.Update DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.openconfig.proto.gnmi.Gnmi.Update();
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Update getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Update>
        PARSER = new com.google.protobuf.AbstractParser<Update>() {
      @java.lang.Override
      public Update parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Update> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Update> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Update getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface TypedValueOrBuilder extends
      // @@protoc_insertion_point(interface_extends:gnmi.TypedValue)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * String value.
     * </pre>
     *
     * <code>string string_val = 1;</code>
     * @return Whether the stringVal field is set.
     */
    boolean hasStringVal();
    /**
     * <pre>
     * String value.
     * </pre>
     *
     * <code>string string_val = 1;</code>
     * @return The stringVal.
     */
    java.lang.String getStringVal();
    /**
     * <pre>
     * String value.
     * </pre>
     *
     * <code>string string_val = 1;</code>
     * @return The bytes for stringVal.
     */
    com.google.protobuf.ByteString
        getStringValBytes();

    /**
     * <pre>
     * Integer value.
     * </pre>
     *
     * <code>int64 int_val = 2;</code>
     * @return Whether the intVal field is set.
     */
    boolean hasIntVal();
    /**
     * <pre>
     * Integer value.
     * </pre>
     *
     * <code>int64 int_val = 2;</code>
     * @return The intVal.
     */
    long getIntVal();

    /**
     * <pre>
     * Unsigned integer value.
     * </pre>
     *
     * <code>uint64 uint_val = 3;</code>
     * @return Whether the uintVal field is set.
     */
    boolean hasUintVal();
    /**
     * <pre>
     * Unsigned integer value.
     * </pre>
     *
     * <code>uint64 uint_val = 3;</code>
     * @return The uintVal.
     */
    long getUintVal();

    /**
     * <pre>
     * Bool value.
     * </pre>
     *
     * <code>bool bool_val = 4;</code>
     * @return Whether the boolVal field is set.
     */
    boolean hasBoolVal();
    /**
     * <pre>
     * Bool value.
     * </pre>
     *
     * <code>bool bool_val = 4;</code>
     * @return The boolVal.
     */
    boolean getBoolVal();

    /**
     * <pre>
     * Arbitrary byte sequence value.
     * </pre>
     *
     * <code>bytes bytes_val = 5;</code>
     * @return Whether the bytesVal field is set.
     */
    boolean hasBytesVal();
    /**
     * <pre>
     * Arbitrary byte sequence value.
     * </pre>
     *
     * <code>bytes bytes_val = 5;</code>
     * @return The bytesVal.
     */
    com.google.protobuf.ByteString getBytesVal();

    /**
     * <pre>
     * Floating point value.
     * </pre>
     *
     * <code>float float_val = 6;</code>
     * @return Whether the floatVal field is set.
     */
    boolean hasFloatVal();
    /**
     * <pre>
     * Floating point value.
     * </pre>
     *
     * <code>float float_val = 6;</code>
     * @return The floatVal.
     */
    float getFloatVal();

    /**
     * <pre>
     * Decimal64 encoded value.
     * </pre>
     *
     * <code>.gnmi.Decimal64 decimal_val = 7;</code>
     * @return Whether the decimalVal field is set.
     */
    boolean hasDecimalVal();
    /**
     * <pre>
     * Decimal64 encoded value.
     * </pre>
     *
     * <code>.gnmi.Decimal64 decimal_val = 7;</code>
     * @return The decimalVal.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 getDecimalVal();
    /**
     * <pre>
     * Decimal64 encoded value.
     * </pre>
     *
     * <code>.gnmi.Decimal64 decimal_val = 7;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64OrBuilder getDecimalValOrBuilder();

    /**
     * <pre>
     * Mixed type scalar array value.
     * </pre>
     *
     * <code>.gnmi.ScalarArray leaflist_val = 8;</code>
     * @return Whether the leaflistVal field is set.
     */
    boolean hasLeaflistVal();
    /**
     * <pre>
     * Mixed type scalar array value.
     * </pre>
     *
     * <code>.gnmi.ScalarArray leaflist_val = 8;</code>
     * @return The leaflistVal.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray getLeaflistVal();
    /**
     * <pre>
     * Mixed type scalar array value.
     * </pre>
     *
     * <code>.gnmi.ScalarArray leaflist_val = 8;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArrayOrBuilder getLeaflistValOrBuilder();

    /**
     * <pre>
     * protobuf.Any encoded bytes.
     * </pre>
     *
     * <code>.google.protobuf.Any any_val = 9;</code>
     * @return Whether the anyVal field is set.
     */
    boolean hasAnyVal();
    /**
     * <pre>
     * protobuf.Any encoded bytes.
     * </pre>
     *
     * <code>.google.protobuf.Any any_val = 9;</code>
     * @return The anyVal.
     */
    com.google.protobuf.Any getAnyVal();
    /**
     * <pre>
     * protobuf.Any encoded bytes.
     * </pre>
     *
     * <code>.google.protobuf.Any any_val = 9;</code>
     */
    com.google.protobuf.AnyOrBuilder getAnyValOrBuilder();

    /**
     * <pre>
     * JSON-encoded text.
     * </pre>
     *
     * <code>bytes json_val = 10;</code>
     * @return Whether the jsonVal field is set.
     */
    boolean hasJsonVal();
    /**
     * <pre>
     * JSON-encoded text.
     * </pre>
     *
     * <code>bytes json_val = 10;</code>
     * @return The jsonVal.
     */
    com.google.protobuf.ByteString getJsonVal();

    /**
     * <pre>
     * JSON-encoded text per RFC7951.
     * </pre>
     *
     * <code>bytes json_ietf_val = 11;</code>
     * @return Whether the jsonIetfVal field is set.
     */
    boolean hasJsonIetfVal();
    /**
     * <pre>
     * JSON-encoded text per RFC7951.
     * </pre>
     *
     * <code>bytes json_ietf_val = 11;</code>
     * @return The jsonIetfVal.
     */
    com.google.protobuf.ByteString getJsonIetfVal();

    /**
     * <pre>
     * Arbitrary ASCII text.
     * </pre>
     *
     * <code>string ascii_val = 12;</code>
     * @return Whether the asciiVal field is set.
     */
    boolean hasAsciiVal();
    /**
     * <pre>
     * Arbitrary ASCII text.
     * </pre>
     *
     * <code>string ascii_val = 12;</code>
     * @return The asciiVal.
     */
    java.lang.String getAsciiVal();
    /**
     * <pre>
     * Arbitrary ASCII text.
     * </pre>
     *
     * <code>string ascii_val = 12;</code>
     * @return The bytes for asciiVal.
     */
    com.google.protobuf.ByteString
        getAsciiValBytes();

    /**
     * <pre>
     * Protobuf binary encoded bytes. The message type is not included.
     * See the specification at
     * github.com/openconfig/reference/blob/master/rpc/gnmi/protobuf-vals.md
     * for a complete specification.
     * </pre>
     *
     * <code>bytes proto_bytes = 13;</code>
     * @return Whether the protoBytes field is set.
     */
    boolean hasProtoBytes();
    /**
     * <pre>
     * Protobuf binary encoded bytes. The message type is not included.
     * See the specification at
     * github.com/openconfig/reference/blob/master/rpc/gnmi/protobuf-vals.md
     * for a complete specification.
     * </pre>
     *
     * <code>bytes proto_bytes = 13;</code>
     * @return The protoBytes.
     */
    com.google.protobuf.ByteString getProtoBytes();

    org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.ValueCase getValueCase();
  }
  /**
   * <pre>
   * TypedValue is used to encode a value being sent between the client and
   * target (originated by either entity).
   * </pre>
   *
   * Protobuf type {@code gnmi.TypedValue}
   */
  public static final class TypedValue extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:gnmi.TypedValue)
      TypedValueOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use TypedValue.newBuilder() to construct.
    private TypedValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private TypedValue() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new TypedValue();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_TypedValue_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_TypedValue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.Builder.class);
    }

    private int valueCase_ = 0;
    @SuppressWarnings("serial")
    private java.lang.Object value_;
    public enum ValueCase
        implements com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      STRING_VAL(1),
      INT_VAL(2),
      UINT_VAL(3),
      BOOL_VAL(4),
      BYTES_VAL(5),
      FLOAT_VAL(6),
      DECIMAL_VAL(7),
      LEAFLIST_VAL(8),
      ANY_VAL(9),
      JSON_VAL(10),
      JSON_IETF_VAL(11),
      ASCII_VAL(12),
      PROTO_BYTES(13),
      VALUE_NOT_SET(0);
      private final int value;
      private ValueCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ValueCase valueOf(int value) {
        return forNumber(value);
      }

      public static ValueCase forNumber(int value) {
        switch (value) {
          case 1: return STRING_VAL;
          case 2: return INT_VAL;
          case 3: return UINT_VAL;
          case 4: return BOOL_VAL;
          case 5: return BYTES_VAL;
          case 6: return FLOAT_VAL;
          case 7: return DECIMAL_VAL;
          case 8: return LEAFLIST_VAL;
          case 9: return ANY_VAL;
          case 10: return JSON_VAL;
          case 11: return JSON_IETF_VAL;
          case 12: return ASCII_VAL;
          case 13: return PROTO_BYTES;
          case 0: return VALUE_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public ValueCase
    getValueCase() {
      return ValueCase.forNumber(
          valueCase_);
    }

    public static final int STRING_VAL_FIELD_NUMBER = 1;
    /**
     * <pre>
     * String value.
     * </pre>
     *
     * <code>string string_val = 1;</code>
     * @return Whether the stringVal field is set.
     */
    public boolean hasStringVal() {
      return valueCase_ == 1;
    }
    /**
     * <pre>
     * String value.
     * </pre>
     *
     * <code>string string_val = 1;</code>
     * @return The stringVal.
     */
    public java.lang.String getStringVal() {
      java.lang.Object ref = "";
      if (valueCase_ == 1) {
        ref = value_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (valueCase_ == 1) {
          value_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * String value.
     * </pre>
     *
     * <code>string string_val = 1;</code>
     * @return The bytes for stringVal.
     */
    public com.google.protobuf.ByteString
        getStringValBytes() {
      java.lang.Object ref = "";
      if (valueCase_ == 1) {
        ref = value_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (valueCase_ == 1) {
          value_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INT_VAL_FIELD_NUMBER = 2;
    /**
     * <pre>
     * Integer value.
     * </pre>
     *
     * <code>int64 int_val = 2;</code>
     * @return Whether the intVal field is set.
     */
    @java.lang.Override
    public boolean hasIntVal() {
      return valueCase_ == 2;
    }
    /**
     * <pre>
     * Integer value.
     * </pre>
     *
     * <code>int64 int_val = 2;</code>
     * @return The intVal.
     */
    @java.lang.Override
    public long getIntVal() {
      if (valueCase_ == 2) {
        return (java.lang.Long) value_;
      }
      return 0L;
    }

    public static final int UINT_VAL_FIELD_NUMBER = 3;
    /**
     * <pre>
     * Unsigned integer value.
     * </pre>
     *
     * <code>uint64 uint_val = 3;</code>
     * @return Whether the uintVal field is set.
     */
    @java.lang.Override
    public boolean hasUintVal() {
      return valueCase_ == 3;
    }
    /**
     * <pre>
     * Unsigned integer value.
     * </pre>
     *
     * <code>uint64 uint_val = 3;</code>
     * @return The uintVal.
     */
    @java.lang.Override
    public long getUintVal() {
      if (valueCase_ == 3) {
        return (java.lang.Long) value_;
      }
      return 0L;
    }

    public static final int BOOL_VAL_FIELD_NUMBER = 4;
    /**
     * <pre>
     * Bool value.
     * </pre>
     *
     * <code>bool bool_val = 4;</code>
     * @return Whether the boolVal field is set.
     */
    @java.lang.Override
    public boolean hasBoolVal() {
      return valueCase_ == 4;
    }
    /**
     * <pre>
     * Bool value.
     * </pre>
     *
     * <code>bool bool_val = 4;</code>
     * @return The boolVal.
     */
    @java.lang.Override
    public boolean getBoolVal() {
      if (valueCase_ == 4) {
        return (java.lang.Boolean) value_;
      }
      return false;
    }

    public static final int BYTES_VAL_FIELD_NUMBER = 5;
    /**
     * <pre>
     * Arbitrary byte sequence value.
     * </pre>
     *
     * <code>bytes bytes_val = 5;</code>
     * @return Whether the bytesVal field is set.
     */
    @java.lang.Override
    public boolean hasBytesVal() {
      return valueCase_ == 5;
    }
    /**
     * <pre>
     * Arbitrary byte sequence value.
     * </pre>
     *
     * <code>bytes bytes_val = 5;</code>
     * @return The bytesVal.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBytesVal() {
      if (valueCase_ == 5) {
        return (com.google.protobuf.ByteString) value_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }

    public static final int FLOAT_VAL_FIELD_NUMBER = 6;
    /**
     * <pre>
     * Floating point value.
     * </pre>
     *
     * <code>float float_val = 6;</code>
     * @return Whether the floatVal field is set.
     */
    @java.lang.Override
    public boolean hasFloatVal() {
      return valueCase_ == 6;
    }
    /**
     * <pre>
     * Floating point value.
     * </pre>
     *
     * <code>float float_val = 6;</code>
     * @return The floatVal.
     */
    @java.lang.Override
    public float getFloatVal() {
      if (valueCase_ == 6) {
        return (java.lang.Float) value_;
      }
      return 0F;
    }

    public static final int DECIMAL_VAL_FIELD_NUMBER = 7;
    /**
     * <pre>
     * Decimal64 encoded value.
     * </pre>
     *
     * <code>.gnmi.Decimal64 decimal_val = 7;</code>
     * @return Whether the decimalVal field is set.
     */
    @java.lang.Override
    public boolean hasDecimalVal() {
      return valueCase_ == 7;
    }
    /**
     * <pre>
     * Decimal64 encoded value.
     * </pre>
     *
     * <code>.gnmi.Decimal64 decimal_val = 7;</code>
     * @return The decimalVal.
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 getDecimalVal() {
      if (valueCase_ == 7) {
         return (org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64) value_;
      }
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64.getDefaultInstance();
    }
    /**
     * <pre>
     * Decimal64 encoded value.
     * </pre>
     *
     * <code>.gnmi.Decimal64 decimal_val = 7;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64OrBuilder getDecimalValOrBuilder() {
      if (valueCase_ == 7) {
         return (org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64) value_;
      }
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64.getDefaultInstance();
    }

    public static final int LEAFLIST_VAL_FIELD_NUMBER = 8;
    /**
     * <pre>
     * Mixed type scalar array value.
     * </pre>
     *
     * <code>.gnmi.ScalarArray leaflist_val = 8;</code>
     * @return Whether the leaflistVal field is set.
     */
    @java.lang.Override
    public boolean hasLeaflistVal() {
      return valueCase_ == 8;
    }
    /**
     * <pre>
     * Mixed type scalar array value.
     * </pre>
     *
     * <code>.gnmi.ScalarArray leaflist_val = 8;</code>
     * @return The leaflistVal.
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray getLeaflistVal() {
      if (valueCase_ == 8) {
         return (org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray) value_;
      }
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray.getDefaultInstance();
    }
    /**
     * <pre>
     * Mixed type scalar array value.
     * </pre>
     *
     * <code>.gnmi.ScalarArray leaflist_val = 8;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArrayOrBuilder getLeaflistValOrBuilder() {
      if (valueCase_ == 8) {
         return (org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray) value_;
      }
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray.getDefaultInstance();
    }

    public static final int ANY_VAL_FIELD_NUMBER = 9;
    /**
     * <pre>
     * protobuf.Any encoded bytes.
     * </pre>
     *
     * <code>.google.protobuf.Any any_val = 9;</code>
     * @return Whether the anyVal field is set.
     */
    @java.lang.Override
    public boolean hasAnyVal() {
      return valueCase_ == 9;
    }
    /**
     * <pre>
     * protobuf.Any encoded bytes.
     * </pre>
     *
     * <code>.google.protobuf.Any any_val = 9;</code>
     * @return The anyVal.
     */
    @java.lang.Override
    public com.google.protobuf.Any getAnyVal() {
      if (valueCase_ == 9) {
         return (com.google.protobuf.Any) value_;
      }
      return com.google.protobuf.Any.getDefaultInstance();
    }
    /**
     * <pre>
     * protobuf.Any encoded bytes.
     * </pre>
     *
     * <code>.google.protobuf.Any any_val = 9;</code>
     */
    @java.lang.Override
    public com.google.protobuf.AnyOrBuilder getAnyValOrBuilder() {
      if (valueCase_ == 9) {
         return (com.google.protobuf.Any) value_;
      }
      return com.google.protobuf.Any.getDefaultInstance();
    }

    public static final int JSON_VAL_FIELD_NUMBER = 10;
    /**
     * <pre>
     * JSON-encoded text.
     * </pre>
     *
     * <code>bytes json_val = 10;</code>
     * @return Whether the jsonVal field is set.
     */
    @java.lang.Override
    public boolean hasJsonVal() {
      return valueCase_ == 10;
    }
    /**
     * <pre>
     * JSON-encoded text.
     * </pre>
     *
     * <code>bytes json_val = 10;</code>
     * @return The jsonVal.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getJsonVal() {
      if (valueCase_ == 10) {
        return (com.google.protobuf.ByteString) value_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }

    public static final int JSON_IETF_VAL_FIELD_NUMBER = 11;
    /**
     * <pre>
     * JSON-encoded text per RFC7951.
     * </pre>
     *
     * <code>bytes json_ietf_val = 11;</code>
     * @return Whether the jsonIetfVal field is set.
     */
    @java.lang.Override
    public boolean hasJsonIetfVal() {
      return valueCase_ == 11;
    }
    /**
     * <pre>
     * JSON-encoded text per RFC7951.
     * </pre>
     *
     * <code>bytes json_ietf_val = 11;</code>
     * @return The jsonIetfVal.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getJsonIetfVal() {
      if (valueCase_ == 11) {
        return (com.google.protobuf.ByteString) value_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }

    public static final int ASCII_VAL_FIELD_NUMBER = 12;
    /**
     * <pre>
     * Arbitrary ASCII text.
     * </pre>
     *
     * <code>string ascii_val = 12;</code>
     * @return Whether the asciiVal field is set.
     */
    public boolean hasAsciiVal() {
      return valueCase_ == 12;
    }
    /**
     * <pre>
     * Arbitrary ASCII text.
     * </pre>
     *
     * <code>string ascii_val = 12;</code>
     * @return The asciiVal.
     */
    public java.lang.String getAsciiVal() {
      java.lang.Object ref = "";
      if (valueCase_ == 12) {
        ref = value_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (valueCase_ == 12) {
          value_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * Arbitrary ASCII text.
     * </pre>
     *
     * <code>string ascii_val = 12;</code>
     * @return The bytes for asciiVal.
     */
    public com.google.protobuf.ByteString
        getAsciiValBytes() {
      java.lang.Object ref = "";
      if (valueCase_ == 12) {
        ref = value_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (valueCase_ == 12) {
          value_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PROTO_BYTES_FIELD_NUMBER = 13;
    /**
     * <pre>
     * Protobuf binary encoded bytes. The message type is not included.
     * See the specification at
     * github.com/openconfig/reference/blob/master/rpc/gnmi/protobuf-vals.md
     * for a complete specification.
     * </pre>
     *
     * <code>bytes proto_bytes = 13;</code>
     * @return Whether the protoBytes field is set.
     */
    @java.lang.Override
    public boolean hasProtoBytes() {
      return valueCase_ == 13;
    }
    /**
     * <pre>
     * Protobuf binary encoded bytes. The message type is not included.
     * See the specification at
     * github.com/openconfig/reference/blob/master/rpc/gnmi/protobuf-vals.md
     * for a complete specification.
     * </pre>
     *
     * <code>bytes proto_bytes = 13;</code>
     * @return The protoBytes.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProtoBytes() {
      if (valueCase_ == 13) {
        return (com.google.protobuf.ByteString) value_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (valueCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, value_);
      }
      if (valueCase_ == 2) {
        output.writeInt64(
            2, (long)((java.lang.Long) value_));
      }
      if (valueCase_ == 3) {
        output.writeUInt64(
            3, (long)((java.lang.Long) value_));
      }
      if (valueCase_ == 4) {
        output.writeBool(
            4, (boolean)((java.lang.Boolean) value_));
      }
      if (valueCase_ == 5) {
        output.writeBytes(
            5, (com.google.protobuf.ByteString) value_);
      }
      if (valueCase_ == 6) {
        output.writeFloat(
            6, (float)((java.lang.Float) value_));
      }
      if (valueCase_ == 7) {
        output.writeMessage(7, (org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64) value_);
      }
      if (valueCase_ == 8) {
        output.writeMessage(8, (org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray) value_);
      }
      if (valueCase_ == 9) {
        output.writeMessage(9, (com.google.protobuf.Any) value_);
      }
      if (valueCase_ == 10) {
        output.writeBytes(
            10, (com.google.protobuf.ByteString) value_);
      }
      if (valueCase_ == 11) {
        output.writeBytes(
            11, (com.google.protobuf.ByteString) value_);
      }
      if (valueCase_ == 12) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 12, value_);
      }
      if (valueCase_ == 13) {
        output.writeBytes(
            13, (com.google.protobuf.ByteString) value_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (valueCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, value_);
      }
      if (valueCase_ == 2) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt64Size(
              2, (long)((java.lang.Long) value_));
      }
      if (valueCase_ == 3) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(
              3, (long)((java.lang.Long) value_));
      }
      if (valueCase_ == 4) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(
              4, (boolean)((java.lang.Boolean) value_));
      }
      if (valueCase_ == 5) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(
              5, (com.google.protobuf.ByteString) value_);
      }
      if (valueCase_ == 6) {
        size += com.google.protobuf.CodedOutputStream
          .computeFloatSize(
              6, (float)((java.lang.Float) value_));
      }
      if (valueCase_ == 7) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, (org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64) value_);
      }
      if (valueCase_ == 8) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(8, (org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray) value_);
      }
      if (valueCase_ == 9) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(9, (com.google.protobuf.Any) value_);
      }
      if (valueCase_ == 10) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(
              10, (com.google.protobuf.ByteString) value_);
      }
      if (valueCase_ == 11) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(
              11, (com.google.protobuf.ByteString) value_);
      }
      if (valueCase_ == 12) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, value_);
      }
      if (valueCase_ == 13) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(
              13, (com.google.protobuf.ByteString) value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue)) {
        return super.equals(obj);
      }
      org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue other = (org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue) obj;

      if (!getValueCase().equals(other.getValueCase())) return false;
      switch (valueCase_) {
        case 1:
          if (!getStringVal()
              .equals(other.getStringVal())) return false;
          break;
        case 2:
          if (getIntVal()
              != other.getIntVal()) return false;
          break;
        case 3:
          if (getUintVal()
              != other.getUintVal()) return false;
          break;
        case 4:
          if (getBoolVal()
              != other.getBoolVal()) return false;
          break;
        case 5:
          if (!getBytesVal()
              .equals(other.getBytesVal())) return false;
          break;
        case 6:
          if (java.lang.Float.floatToIntBits(getFloatVal())
              != java.lang.Float.floatToIntBits(
                  other.getFloatVal())) return false;
          break;
        case 7:
          if (!getDecimalVal()
              .equals(other.getDecimalVal())) return false;
          break;
        case 8:
          if (!getLeaflistVal()
              .equals(other.getLeaflistVal())) return false;
          break;
        case 9:
          if (!getAnyVal()
              .equals(other.getAnyVal())) return false;
          break;
        case 10:
          if (!getJsonVal()
              .equals(other.getJsonVal())) return false;
          break;
        case 11:
          if (!getJsonIetfVal()
              .equals(other.getJsonIetfVal())) return false;
          break;
        case 12:
          if (!getAsciiVal()
              .equals(other.getAsciiVal())) return false;
          break;
        case 13:
          if (!getProtoBytes()
              .equals(other.getProtoBytes())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (valueCase_) {
        case 1:
          hash = (37 * hash) + STRING_VAL_FIELD_NUMBER;
          hash = (53 * hash) + getStringVal().hashCode();
          break;
        case 2:
          hash = (37 * hash) + INT_VAL_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
              getIntVal());
          break;
        case 3:
          hash = (37 * hash) + UINT_VAL_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
              getUintVal());
          break;
        case 4:
          hash = (37 * hash) + BOOL_VAL_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
              getBoolVal());
          break;
        case 5:
          hash = (37 * hash) + BYTES_VAL_FIELD_NUMBER;
          hash = (53 * hash) + getBytesVal().hashCode();
          break;
        case 6:
          hash = (37 * hash) + FLOAT_VAL_FIELD_NUMBER;
          hash = (53 * hash) + java.lang.Float.floatToIntBits(
              getFloatVal());
          break;
        case 7:
          hash = (37 * hash) + DECIMAL_VAL_FIELD_NUMBER;
          hash = (53 * hash) + getDecimalVal().hashCode();
          break;
        case 8:
          hash = (37 * hash) + LEAFLIST_VAL_FIELD_NUMBER;
          hash = (53 * hash) + getLeaflistVal().hashCode();
          break;
        case 9:
          hash = (37 * hash) + ANY_VAL_FIELD_NUMBER;
          hash = (53 * hash) + getAnyVal().hashCode();
          break;
        case 10:
          hash = (37 * hash) + JSON_VAL_FIELD_NUMBER;
          hash = (53 * hash) + getJsonVal().hashCode();
          break;
        case 11:
          hash = (37 * hash) + JSON_IETF_VAL_FIELD_NUMBER;
          hash = (53 * hash) + getJsonIetfVal().hashCode();
          break;
        case 12:
          hash = (37 * hash) + ASCII_VAL_FIELD_NUMBER;
          hash = (53 * hash) + getAsciiVal().hashCode();
          break;
        case 13:
          hash = (37 * hash) + PROTO_BYTES_FIELD_NUMBER;
          hash = (53 * hash) + getProtoBytes().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * TypedValue is used to encode a value being sent between the client and
     * target (originated by either entity).
     * </pre>
     *
     * Protobuf type {@code gnmi.TypedValue}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:gnmi.TypedValue)
        org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValueOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_TypedValue_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_TypedValue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.Builder.class);
      }

      // Construct using org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (decimalValBuilder_ != null) {
          decimalValBuilder_.clear();
        }
        if (leaflistValBuilder_ != null) {
          leaflistValBuilder_.clear();
        }
        if (anyValBuilder_ != null) {
          anyValBuilder_.clear();
        }
        valueCase_ = 0;
        value_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_TypedValue_descriptor;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue getDefaultInstanceForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.getDefaultInstance();
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue build() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue buildPartial() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue result = new org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue result) {
        result.valueCase_ = valueCase_;
        result.value_ = this.value_;
        if (valueCase_ == 7 &&
            decimalValBuilder_ != null) {
          result.value_ = decimalValBuilder_.build();
        }
        if (valueCase_ == 8 &&
            leaflistValBuilder_ != null) {
          result.value_ = leaflistValBuilder_.build();
        }
        if (valueCase_ == 9 &&
            anyValBuilder_ != null) {
          result.value_ = anyValBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue) {
          return mergeFrom((org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue other) {
        if (other == org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.getDefaultInstance()) return this;
        switch (other.getValueCase()) {
          case STRING_VAL: {
            valueCase_ = 1;
            value_ = other.value_;
            onChanged();
            break;
          }
          case INT_VAL: {
            setIntVal(other.getIntVal());
            break;
          }
          case UINT_VAL: {
            setUintVal(other.getUintVal());
            break;
          }
          case BOOL_VAL: {
            setBoolVal(other.getBoolVal());
            break;
          }
          case BYTES_VAL: {
            setBytesVal(other.getBytesVal());
            break;
          }
          case FLOAT_VAL: {
            setFloatVal(other.getFloatVal());
            break;
          }
          case DECIMAL_VAL: {
            mergeDecimalVal(other.getDecimalVal());
            break;
          }
          case LEAFLIST_VAL: {
            mergeLeaflistVal(other.getLeaflistVal());
            break;
          }
          case ANY_VAL: {
            mergeAnyVal(other.getAnyVal());
            break;
          }
          case JSON_VAL: {
            setJsonVal(other.getJsonVal());
            break;
          }
          case JSON_IETF_VAL: {
            setJsonIetfVal(other.getJsonIetfVal());
            break;
          }
          case ASCII_VAL: {
            valueCase_ = 12;
            value_ = other.value_;
            onChanged();
            break;
          }
          case PROTO_BYTES: {
            setProtoBytes(other.getProtoBytes());
            break;
          }
          case VALUE_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                java.lang.String s = input.readStringRequireUtf8();
                valueCase_ = 1;
                value_ = s;
                break;
              } // case 10
              case 16: {
                value_ = input.readInt64();
                valueCase_ = 2;
                break;
              } // case 16
              case 24: {
                value_ = input.readUInt64();
                valueCase_ = 3;
                break;
              } // case 24
              case 32: {
                value_ = input.readBool();
                valueCase_ = 4;
                break;
              } // case 32
              case 42: {
                value_ = input.readBytes();
                valueCase_ = 5;
                break;
              } // case 42
              case 53: {
                value_ = input.readFloat();
                valueCase_ = 6;
                break;
              } // case 53
              case 58: {
                input.readMessage(
                    getDecimalValFieldBuilder().getBuilder(),
                    extensionRegistry);
                valueCase_ = 7;
                break;
              } // case 58
              case 66: {
                input.readMessage(
                    getLeaflistValFieldBuilder().getBuilder(),
                    extensionRegistry);
                valueCase_ = 8;
                break;
              } // case 66
              case 74: {
                input.readMessage(
                    getAnyValFieldBuilder().getBuilder(),
                    extensionRegistry);
                valueCase_ = 9;
                break;
              } // case 74
              case 82: {
                value_ = input.readBytes();
                valueCase_ = 10;
                break;
              } // case 82
              case 90: {
                value_ = input.readBytes();
                valueCase_ = 11;
                break;
              } // case 90
              case 98: {
                java.lang.String s = input.readStringRequireUtf8();
                valueCase_ = 12;
                value_ = s;
                break;
              } // case 98
              case 106: {
                value_ = input.readBytes();
                valueCase_ = 13;
                break;
              } // case 106
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int valueCase_ = 0;
      private java.lang.Object value_;
      public ValueCase
          getValueCase() {
        return ValueCase.forNumber(
            valueCase_);
      }

      public Builder clearValue() {
        valueCase_ = 0;
        value_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       * <pre>
       * String value.
       * </pre>
       *
       * <code>string string_val = 1;</code>
       * @return Whether the stringVal field is set.
       */
      @java.lang.Override
      public boolean hasStringVal() {
        return valueCase_ == 1;
      }
      /**
       * <pre>
       * String value.
       * </pre>
       *
       * <code>string string_val = 1;</code>
       * @return The stringVal.
       */
      @java.lang.Override
      public java.lang.String getStringVal() {
        java.lang.Object ref = "";
        if (valueCase_ == 1) {
          ref = value_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (valueCase_ == 1) {
            value_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * String value.
       * </pre>
       *
       * <code>string string_val = 1;</code>
       * @return The bytes for stringVal.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getStringValBytes() {
        java.lang.Object ref = "";
        if (valueCase_ == 1) {
          ref = value_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          if (valueCase_ == 1) {
            value_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * String value.
       * </pre>
       *
       * <code>string string_val = 1;</code>
       * @param value The stringVal to set.
       * @return This builder for chaining.
       */
      public Builder setStringVal(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        valueCase_ = 1;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * String value.
       * </pre>
       *
       * <code>string string_val = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearStringVal() {
        if (valueCase_ == 1) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * String value.
       * </pre>
       *
       * <code>string string_val = 1;</code>
       * @param value The bytes for stringVal to set.
       * @return This builder for chaining.
       */
      public Builder setStringValBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        valueCase_ = 1;
        value_ = value;
        onChanged();
        return this;
      }

      /**
       * <pre>
       * Integer value.
       * </pre>
       *
       * <code>int64 int_val = 2;</code>
       * @return Whether the intVal field is set.
       */
      public boolean hasIntVal() {
        return valueCase_ == 2;
      }
      /**
       * <pre>
       * Integer value.
       * </pre>
       *
       * <code>int64 int_val = 2;</code>
       * @return The intVal.
       */
      public long getIntVal() {
        if (valueCase_ == 2) {
          return (java.lang.Long) value_;
        }
        return 0L;
      }
      /**
       * <pre>
       * Integer value.
       * </pre>
       *
       * <code>int64 int_val = 2;</code>
       * @param value The intVal to set.
       * @return This builder for chaining.
       */
      public Builder setIntVal(long value) {

        valueCase_ = 2;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Integer value.
       * </pre>
       *
       * <code>int64 int_val = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearIntVal() {
        if (valueCase_ == 2) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      /**
       * <pre>
       * Unsigned integer value.
       * </pre>
       *
       * <code>uint64 uint_val = 3;</code>
       * @return Whether the uintVal field is set.
       */
      public boolean hasUintVal() {
        return valueCase_ == 3;
      }
      /**
       * <pre>
       * Unsigned integer value.
       * </pre>
       *
       * <code>uint64 uint_val = 3;</code>
       * @return The uintVal.
       */
      public long getUintVal() {
        if (valueCase_ == 3) {
          return (java.lang.Long) value_;
        }
        return 0L;
      }
      /**
       * <pre>
       * Unsigned integer value.
       * </pre>
       *
       * <code>uint64 uint_val = 3;</code>
       * @param value The uintVal to set.
       * @return This builder for chaining.
       */
      public Builder setUintVal(long value) {

        valueCase_ = 3;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Unsigned integer value.
       * </pre>
       *
       * <code>uint64 uint_val = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearUintVal() {
        if (valueCase_ == 3) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      /**
       * <pre>
       * Bool value.
       * </pre>
       *
       * <code>bool bool_val = 4;</code>
       * @return Whether the boolVal field is set.
       */
      public boolean hasBoolVal() {
        return valueCase_ == 4;
      }
      /**
       * <pre>
       * Bool value.
       * </pre>
       *
       * <code>bool bool_val = 4;</code>
       * @return The boolVal.
       */
      public boolean getBoolVal() {
        if (valueCase_ == 4) {
          return (java.lang.Boolean) value_;
        }
        return false;
      }
      /**
       * <pre>
       * Bool value.
       * </pre>
       *
       * <code>bool bool_val = 4;</code>
       * @param value The boolVal to set.
       * @return This builder for chaining.
       */
      public Builder setBoolVal(boolean value) {

        valueCase_ = 4;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Bool value.
       * </pre>
       *
       * <code>bool bool_val = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearBoolVal() {
        if (valueCase_ == 4) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      /**
       * <pre>
       * Arbitrary byte sequence value.
       * </pre>
       *
       * <code>bytes bytes_val = 5;</code>
       * @return Whether the bytesVal field is set.
       */
      public boolean hasBytesVal() {
        return valueCase_ == 5;
      }
      /**
       * <pre>
       * Arbitrary byte sequence value.
       * </pre>
       *
       * <code>bytes bytes_val = 5;</code>
       * @return The bytesVal.
       */
      public com.google.protobuf.ByteString getBytesVal() {
        if (valueCase_ == 5) {
          return (com.google.protobuf.ByteString) value_;
        }
        return com.google.protobuf.ByteString.EMPTY;
      }
      /**
       * <pre>
       * Arbitrary byte sequence value.
       * </pre>
       *
       * <code>bytes bytes_val = 5;</code>
       * @param value The bytesVal to set.
       * @return This builder for chaining.
       */
      public Builder setBytesVal(com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        valueCase_ = 5;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Arbitrary byte sequence value.
       * </pre>
       *
       * <code>bytes bytes_val = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearBytesVal() {
        if (valueCase_ == 5) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      /**
       * <pre>
       * Floating point value.
       * </pre>
       *
       * <code>float float_val = 6;</code>
       * @return Whether the floatVal field is set.
       */
      public boolean hasFloatVal() {
        return valueCase_ == 6;
      }
      /**
       * <pre>
       * Floating point value.
       * </pre>
       *
       * <code>float float_val = 6;</code>
       * @return The floatVal.
       */
      public float getFloatVal() {
        if (valueCase_ == 6) {
          return (java.lang.Float) value_;
        }
        return 0F;
      }
      /**
       * <pre>
       * Floating point value.
       * </pre>
       *
       * <code>float float_val = 6;</code>
       * @param value The floatVal to set.
       * @return This builder for chaining.
       */
      public Builder setFloatVal(float value) {

        valueCase_ = 6;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Floating point value.
       * </pre>
       *
       * <code>float float_val = 6;</code>
       * @return This builder for chaining.
       */
      public Builder clearFloatVal() {
        if (valueCase_ == 6) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64, org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64OrBuilder> decimalValBuilder_;
      /**
       * <pre>
       * Decimal64 encoded value.
       * </pre>
       *
       * <code>.gnmi.Decimal64 decimal_val = 7;</code>
       * @return Whether the decimalVal field is set.
       */
      @java.lang.Override
      public boolean hasDecimalVal() {
        return valueCase_ == 7;
      }
      /**
       * <pre>
       * Decimal64 encoded value.
       * </pre>
       *
       * <code>.gnmi.Decimal64 decimal_val = 7;</code>
       * @return The decimalVal.
       */
      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 getDecimalVal() {
        if (decimalValBuilder_ == null) {
          if (valueCase_ == 7) {
            return (org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64) value_;
          }
          return org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64.getDefaultInstance();
        } else {
          if (valueCase_ == 7) {
            return decimalValBuilder_.getMessage();
          }
          return org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Decimal64 encoded value.
       * </pre>
       *
       * <code>.gnmi.Decimal64 decimal_val = 7;</code>
       */
      public Builder setDecimalVal(org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 value) {
        if (decimalValBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          value_ = value;
          onChanged();
        } else {
          decimalValBuilder_.setMessage(value);
        }
        valueCase_ = 7;
        return this;
      }
      /**
       * <pre>
       * Decimal64 encoded value.
       * </pre>
       *
       * <code>.gnmi.Decimal64 decimal_val = 7;</code>
       */
      public Builder setDecimalVal(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64.Builder builderForValue) {
        if (decimalValBuilder_ == null) {
          value_ = builderForValue.build();
          onChanged();
        } else {
          decimalValBuilder_.setMessage(builderForValue.build());
        }
        valueCase_ = 7;
        return this;
      }
      /**
       * <pre>
       * Decimal64 encoded value.
       * </pre>
       *
       * <code>.gnmi.Decimal64 decimal_val = 7;</code>
       */
      public Builder mergeDecimalVal(org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 value) {
        if (decimalValBuilder_ == null) {
          if (valueCase_ == 7 &&
              value_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64.getDefaultInstance()) {
            value_ = org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64.newBuilder((org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64) value_)
                .mergeFrom(value).buildPartial();
          } else {
            value_ = value;
          }
          onChanged();
        } else {
          if (valueCase_ == 7) {
            decimalValBuilder_.mergeFrom(value);
          } else {
            decimalValBuilder_.setMessage(value);
          }
        }
        valueCase_ = 7;
        return this;
      }
      /**
       * <pre>
       * Decimal64 encoded value.
       * </pre>
       *
       * <code>.gnmi.Decimal64 decimal_val = 7;</code>
       */
      public Builder clearDecimalVal() {
        if (decimalValBuilder_ == null) {
          if (valueCase_ == 7) {
            valueCase_ = 0;
            value_ = null;
            onChanged();
          }
        } else {
          if (valueCase_ == 7) {
            valueCase_ = 0;
            value_ = null;
          }
          decimalValBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Decimal64 encoded value.
       * </pre>
       *
       * <code>.gnmi.Decimal64 decimal_val = 7;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64.Builder getDecimalValBuilder() {
        return getDecimalValFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Decimal64 encoded value.
       * </pre>
       *
       * <code>.gnmi.Decimal64 decimal_val = 7;</code>
       */
      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64OrBuilder getDecimalValOrBuilder() {
        if ((valueCase_ == 7) && (decimalValBuilder_ != null)) {
          return decimalValBuilder_.getMessageOrBuilder();
        } else {
          if (valueCase_ == 7) {
            return (org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64) value_;
          }
          return org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Decimal64 encoded value.
       * </pre>
       *
       * <code>.gnmi.Decimal64 decimal_val = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64, org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64OrBuilder> 
          getDecimalValFieldBuilder() {
        if (decimalValBuilder_ == null) {
          if (!(valueCase_ == 7)) {
            value_ = org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64.getDefaultInstance();
          }
          decimalValBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64, org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64OrBuilder>(
                  (org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64) value_,
                  getParentForChildren(),
                  isClean());
          value_ = null;
        }
        valueCase_ = 7;
        onChanged();
        return decimalValBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray, org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArrayOrBuilder> leaflistValBuilder_;
      /**
       * <pre>
       * Mixed type scalar array value.
       * </pre>
       *
       * <code>.gnmi.ScalarArray leaflist_val = 8;</code>
       * @return Whether the leaflistVal field is set.
       */
      @java.lang.Override
      public boolean hasLeaflistVal() {
        return valueCase_ == 8;
      }
      /**
       * <pre>
       * Mixed type scalar array value.
       * </pre>
       *
       * <code>.gnmi.ScalarArray leaflist_val = 8;</code>
       * @return The leaflistVal.
       */
      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray getLeaflistVal() {
        if (leaflistValBuilder_ == null) {
          if (valueCase_ == 8) {
            return (org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray) value_;
          }
          return org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray.getDefaultInstance();
        } else {
          if (valueCase_ == 8) {
            return leaflistValBuilder_.getMessage();
          }
          return org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Mixed type scalar array value.
       * </pre>
       *
       * <code>.gnmi.ScalarArray leaflist_val = 8;</code>
       */
      public Builder setLeaflistVal(org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray value) {
        if (leaflistValBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          value_ = value;
          onChanged();
        } else {
          leaflistValBuilder_.setMessage(value);
        }
        valueCase_ = 8;
        return this;
      }
      /**
       * <pre>
       * Mixed type scalar array value.
       * </pre>
       *
       * <code>.gnmi.ScalarArray leaflist_val = 8;</code>
       */
      public Builder setLeaflistVal(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray.Builder builderForValue) {
        if (leaflistValBuilder_ == null) {
          value_ = builderForValue.build();
          onChanged();
        } else {
          leaflistValBuilder_.setMessage(builderForValue.build());
        }
        valueCase_ = 8;
        return this;
      }
      /**
       * <pre>
       * Mixed type scalar array value.
       * </pre>
       *
       * <code>.gnmi.ScalarArray leaflist_val = 8;</code>
       */
      public Builder mergeLeaflistVal(org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray value) {
        if (leaflistValBuilder_ == null) {
          if (valueCase_ == 8 &&
              value_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray.getDefaultInstance()) {
            value_ = org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray.newBuilder((org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray) value_)
                .mergeFrom(value).buildPartial();
          } else {
            value_ = value;
          }
          onChanged();
        } else {
          if (valueCase_ == 8) {
            leaflistValBuilder_.mergeFrom(value);
          } else {
            leaflistValBuilder_.setMessage(value);
          }
        }
        valueCase_ = 8;
        return this;
      }
      /**
       * <pre>
       * Mixed type scalar array value.
       * </pre>
       *
       * <code>.gnmi.ScalarArray leaflist_val = 8;</code>
       */
      public Builder clearLeaflistVal() {
        if (leaflistValBuilder_ == null) {
          if (valueCase_ == 8) {
            valueCase_ = 0;
            value_ = null;
            onChanged();
          }
        } else {
          if (valueCase_ == 8) {
            valueCase_ = 0;
            value_ = null;
          }
          leaflistValBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Mixed type scalar array value.
       * </pre>
       *
       * <code>.gnmi.ScalarArray leaflist_val = 8;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray.Builder getLeaflistValBuilder() {
        return getLeaflistValFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Mixed type scalar array value.
       * </pre>
       *
       * <code>.gnmi.ScalarArray leaflist_val = 8;</code>
       */
      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArrayOrBuilder getLeaflistValOrBuilder() {
        if ((valueCase_ == 8) && (leaflistValBuilder_ != null)) {
          return leaflistValBuilder_.getMessageOrBuilder();
        } else {
          if (valueCase_ == 8) {
            return (org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray) value_;
          }
          return org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Mixed type scalar array value.
       * </pre>
       *
       * <code>.gnmi.ScalarArray leaflist_val = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray, org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArrayOrBuilder> 
          getLeaflistValFieldBuilder() {
        if (leaflistValBuilder_ == null) {
          if (!(valueCase_ == 8)) {
            value_ = org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray.getDefaultInstance();
          }
          leaflistValBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray, org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArrayOrBuilder>(
                  (org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray) value_,
                  getParentForChildren(),
                  isClean());
          value_ = null;
        }
        valueCase_ = 8;
        onChanged();
        return leaflistValBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.Any, com.google.protobuf.Any.Builder, com.google.protobuf.AnyOrBuilder> anyValBuilder_;
      /**
       * <pre>
       * protobuf.Any encoded bytes.
       * </pre>
       *
       * <code>.google.protobuf.Any any_val = 9;</code>
       * @return Whether the anyVal field is set.
       */
      @java.lang.Override
      public boolean hasAnyVal() {
        return valueCase_ == 9;
      }
      /**
       * <pre>
       * protobuf.Any encoded bytes.
       * </pre>
       *
       * <code>.google.protobuf.Any any_val = 9;</code>
       * @return The anyVal.
       */
      @java.lang.Override
      public com.google.protobuf.Any getAnyVal() {
        if (anyValBuilder_ == null) {
          if (valueCase_ == 9) {
            return (com.google.protobuf.Any) value_;
          }
          return com.google.protobuf.Any.getDefaultInstance();
        } else {
          if (valueCase_ == 9) {
            return anyValBuilder_.getMessage();
          }
          return com.google.protobuf.Any.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * protobuf.Any encoded bytes.
       * </pre>
       *
       * <code>.google.protobuf.Any any_val = 9;</code>
       */
      public Builder setAnyVal(com.google.protobuf.Any value) {
        if (anyValBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          value_ = value;
          onChanged();
        } else {
          anyValBuilder_.setMessage(value);
        }
        valueCase_ = 9;
        return this;
      }
      /**
       * <pre>
       * protobuf.Any encoded bytes.
       * </pre>
       *
       * <code>.google.protobuf.Any any_val = 9;</code>
       */
      public Builder setAnyVal(
          com.google.protobuf.Any.Builder builderForValue) {
        if (anyValBuilder_ == null) {
          value_ = builderForValue.build();
          onChanged();
        } else {
          anyValBuilder_.setMessage(builderForValue.build());
        }
        valueCase_ = 9;
        return this;
      }
      /**
       * <pre>
       * protobuf.Any encoded bytes.
       * </pre>
       *
       * <code>.google.protobuf.Any any_val = 9;</code>
       */
      public Builder mergeAnyVal(com.google.protobuf.Any value) {
        if (anyValBuilder_ == null) {
          if (valueCase_ == 9 &&
              value_ != com.google.protobuf.Any.getDefaultInstance()) {
            value_ = com.google.protobuf.Any.newBuilder((com.google.protobuf.Any) value_)
                .mergeFrom(value).buildPartial();
          } else {
            value_ = value;
          }
          onChanged();
        } else {
          if (valueCase_ == 9) {
            anyValBuilder_.mergeFrom(value);
          } else {
            anyValBuilder_.setMessage(value);
          }
        }
        valueCase_ = 9;
        return this;
      }
      /**
       * <pre>
       * protobuf.Any encoded bytes.
       * </pre>
       *
       * <code>.google.protobuf.Any any_val = 9;</code>
       */
      public Builder clearAnyVal() {
        if (anyValBuilder_ == null) {
          if (valueCase_ == 9) {
            valueCase_ = 0;
            value_ = null;
            onChanged();
          }
        } else {
          if (valueCase_ == 9) {
            valueCase_ = 0;
            value_ = null;
          }
          anyValBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * protobuf.Any encoded bytes.
       * </pre>
       *
       * <code>.google.protobuf.Any any_val = 9;</code>
       */
      public com.google.protobuf.Any.Builder getAnyValBuilder() {
        return getAnyValFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * protobuf.Any encoded bytes.
       * </pre>
       *
       * <code>.google.protobuf.Any any_val = 9;</code>
       */
      @java.lang.Override
      public com.google.protobuf.AnyOrBuilder getAnyValOrBuilder() {
        if ((valueCase_ == 9) && (anyValBuilder_ != null)) {
          return anyValBuilder_.getMessageOrBuilder();
        } else {
          if (valueCase_ == 9) {
            return (com.google.protobuf.Any) value_;
          }
          return com.google.protobuf.Any.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * protobuf.Any encoded bytes.
       * </pre>
       *
       * <code>.google.protobuf.Any any_val = 9;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.Any, com.google.protobuf.Any.Builder, com.google.protobuf.AnyOrBuilder> 
          getAnyValFieldBuilder() {
        if (anyValBuilder_ == null) {
          if (!(valueCase_ == 9)) {
            value_ = com.google.protobuf.Any.getDefaultInstance();
          }
          anyValBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Any, com.google.protobuf.Any.Builder, com.google.protobuf.AnyOrBuilder>(
                  (com.google.protobuf.Any) value_,
                  getParentForChildren(),
                  isClean());
          value_ = null;
        }
        valueCase_ = 9;
        onChanged();
        return anyValBuilder_;
      }

      /**
       * <pre>
       * JSON-encoded text.
       * </pre>
       *
       * <code>bytes json_val = 10;</code>
       * @return Whether the jsonVal field is set.
       */
      public boolean hasJsonVal() {
        return valueCase_ == 10;
      }
      /**
       * <pre>
       * JSON-encoded text.
       * </pre>
       *
       * <code>bytes json_val = 10;</code>
       * @return The jsonVal.
       */
      public com.google.protobuf.ByteString getJsonVal() {
        if (valueCase_ == 10) {
          return (com.google.protobuf.ByteString) value_;
        }
        return com.google.protobuf.ByteString.EMPTY;
      }
      /**
       * <pre>
       * JSON-encoded text.
       * </pre>
       *
       * <code>bytes json_val = 10;</code>
       * @param value The jsonVal to set.
       * @return This builder for chaining.
       */
      public Builder setJsonVal(com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        valueCase_ = 10;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * JSON-encoded text.
       * </pre>
       *
       * <code>bytes json_val = 10;</code>
       * @return This builder for chaining.
       */
      public Builder clearJsonVal() {
        if (valueCase_ == 10) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      /**
       * <pre>
       * JSON-encoded text per RFC7951.
       * </pre>
       *
       * <code>bytes json_ietf_val = 11;</code>
       * @return Whether the jsonIetfVal field is set.
       */
      public boolean hasJsonIetfVal() {
        return valueCase_ == 11;
      }
      /**
       * <pre>
       * JSON-encoded text per RFC7951.
       * </pre>
       *
       * <code>bytes json_ietf_val = 11;</code>
       * @return The jsonIetfVal.
       */
      public com.google.protobuf.ByteString getJsonIetfVal() {
        if (valueCase_ == 11) {
          return (com.google.protobuf.ByteString) value_;
        }
        return com.google.protobuf.ByteString.EMPTY;
      }
      /**
       * <pre>
       * JSON-encoded text per RFC7951.
       * </pre>
       *
       * <code>bytes json_ietf_val = 11;</code>
       * @param value The jsonIetfVal to set.
       * @return This builder for chaining.
       */
      public Builder setJsonIetfVal(com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        valueCase_ = 11;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * JSON-encoded text per RFC7951.
       * </pre>
       *
       * <code>bytes json_ietf_val = 11;</code>
       * @return This builder for chaining.
       */
      public Builder clearJsonIetfVal() {
        if (valueCase_ == 11) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      /**
       * <pre>
       * Arbitrary ASCII text.
       * </pre>
       *
       * <code>string ascii_val = 12;</code>
       * @return Whether the asciiVal field is set.
       */
      @java.lang.Override
      public boolean hasAsciiVal() {
        return valueCase_ == 12;
      }
      /**
       * <pre>
       * Arbitrary ASCII text.
       * </pre>
       *
       * <code>string ascii_val = 12;</code>
       * @return The asciiVal.
       */
      @java.lang.Override
      public java.lang.String getAsciiVal() {
        java.lang.Object ref = "";
        if (valueCase_ == 12) {
          ref = value_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (valueCase_ == 12) {
            value_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Arbitrary ASCII text.
       * </pre>
       *
       * <code>string ascii_val = 12;</code>
       * @return The bytes for asciiVal.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getAsciiValBytes() {
        java.lang.Object ref = "";
        if (valueCase_ == 12) {
          ref = value_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          if (valueCase_ == 12) {
            value_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Arbitrary ASCII text.
       * </pre>
       *
       * <code>string ascii_val = 12;</code>
       * @param value The asciiVal to set.
       * @return This builder for chaining.
       */
      public Builder setAsciiVal(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        valueCase_ = 12;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Arbitrary ASCII text.
       * </pre>
       *
       * <code>string ascii_val = 12;</code>
       * @return This builder for chaining.
       */
      public Builder clearAsciiVal() {
        if (valueCase_ == 12) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * Arbitrary ASCII text.
       * </pre>
       *
       * <code>string ascii_val = 12;</code>
       * @param value The bytes for asciiVal to set.
       * @return This builder for chaining.
       */
      public Builder setAsciiValBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        valueCase_ = 12;
        value_ = value;
        onChanged();
        return this;
      }

      /**
       * <pre>
       * Protobuf binary encoded bytes. The message type is not included.
       * See the specification at
       * github.com/openconfig/reference/blob/master/rpc/gnmi/protobuf-vals.md
       * for a complete specification.
       * </pre>
       *
       * <code>bytes proto_bytes = 13;</code>
       * @return Whether the protoBytes field is set.
       */
      public boolean hasProtoBytes() {
        return valueCase_ == 13;
      }
      /**
       * <pre>
       * Protobuf binary encoded bytes. The message type is not included.
       * See the specification at
       * github.com/openconfig/reference/blob/master/rpc/gnmi/protobuf-vals.md
       * for a complete specification.
       * </pre>
       *
       * <code>bytes proto_bytes = 13;</code>
       * @return The protoBytes.
       */
      public com.google.protobuf.ByteString getProtoBytes() {
        if (valueCase_ == 13) {
          return (com.google.protobuf.ByteString) value_;
        }
        return com.google.protobuf.ByteString.EMPTY;
      }
      /**
       * <pre>
       * Protobuf binary encoded bytes. The message type is not included.
       * See the specification at
       * github.com/openconfig/reference/blob/master/rpc/gnmi/protobuf-vals.md
       * for a complete specification.
       * </pre>
       *
       * <code>bytes proto_bytes = 13;</code>
       * @param value The protoBytes to set.
       * @return This builder for chaining.
       */
      public Builder setProtoBytes(com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        valueCase_ = 13;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Protobuf binary encoded bytes. The message type is not included.
       * See the specification at
       * github.com/openconfig/reference/blob/master/rpc/gnmi/protobuf-vals.md
       * for a complete specification.
       * </pre>
       *
       * <code>bytes proto_bytes = 13;</code>
       * @return This builder for chaining.
       */
      public Builder clearProtoBytes() {
        if (valueCase_ == 13) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:gnmi.TypedValue)
    }

    // @@protoc_insertion_point(class_scope:gnmi.TypedValue)
    private static final org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue();
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TypedValue>
        PARSER = new com.google.protobuf.AbstractParser<TypedValue>() {
      @java.lang.Override
      public TypedValue parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<TypedValue> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TypedValue> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface PathOrBuilder extends
      // @@protoc_insertion_point(interface_extends:gnmi.Path)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Elements of the path are no longer encoded as a string, but rather within
     * the elem field as a PathElem message.
     * </pre>
     *
     * <code>repeated string element = 1 [deprecated = true];</code>
     * @deprecated gnmi.Path.element is deprecated.
     *     See gnmi.proto;l=138
     * @return A list containing the element.
     */
    @java.lang.Deprecated java.util.List<java.lang.String>
        getElementList();
    /**
     * <pre>
     * Elements of the path are no longer encoded as a string, but rather within
     * the elem field as a PathElem message.
     * </pre>
     *
     * <code>repeated string element = 1 [deprecated = true];</code>
     * @deprecated gnmi.Path.element is deprecated.
     *     See gnmi.proto;l=138
     * @return The count of element.
     */
    @java.lang.Deprecated int getElementCount();
    /**
     * <pre>
     * Elements of the path are no longer encoded as a string, but rather within
     * the elem field as a PathElem message.
     * </pre>
     *
     * <code>repeated string element = 1 [deprecated = true];</code>
     * @deprecated gnmi.Path.element is deprecated.
     *     See gnmi.proto;l=138
     * @param index The index of the element to return.
     * @return The element at the given index.
     */
    @java.lang.Deprecated java.lang.String getElement(int index);
    /**
     * <pre>
     * Elements of the path are no longer encoded as a string, but rather within
     * the elem field as a PathElem message.
     * </pre>
     *
     * <code>repeated string element = 1 [deprecated = true];</code>
     * @deprecated gnmi.Path.element is deprecated.
     *     See gnmi.proto;l=138
     * @param index The index of the value to return.
     * @return The bytes of the element at the given index.
     */
    @java.lang.Deprecated com.google.protobuf.ByteString
        getElementBytes(int index);

    /**
     * <pre>
     * Label to disambiguate path.
     * </pre>
     *
     * <code>string origin = 2;</code>
     * @return The origin.
     */
    java.lang.String getOrigin();
    /**
     * <pre>
     * Label to disambiguate path.
     * </pre>
     *
     * <code>string origin = 2;</code>
     * @return The bytes for origin.
     */
    com.google.protobuf.ByteString
        getOriginBytes();

    /**
     * <pre>
     * Elements of the path.
     * </pre>
     *
     * <code>repeated .gnmi.PathElem elem = 3;</code>
     */
    java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem> 
        getElemList();
    /**
     * <pre>
     * Elements of the path.
     * </pre>
     *
     * <code>repeated .gnmi.PathElem elem = 3;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem getElem(int index);
    /**
     * <pre>
     * Elements of the path.
     * </pre>
     *
     * <code>repeated .gnmi.PathElem elem = 3;</code>
     */
    int getElemCount();
    /**
     * <pre>
     * Elements of the path.
     * </pre>
     *
     * <code>repeated .gnmi.PathElem elem = 3;</code>
     */
    java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElemOrBuilder> 
        getElemOrBuilderList();
    /**
     * <pre>
     * Elements of the path.
     * </pre>
     *
     * <code>repeated .gnmi.PathElem elem = 3;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElemOrBuilder getElemOrBuilder(
        int index);

    /**
     * <pre>
     * The name of the target
     * </pre>
     *
     * <code>string target = 4;</code>
     * @return The target.
     */
    java.lang.String getTarget();
    /**
     * <pre>
     * The name of the target
     * </pre>
     *
     * <code>string target = 4;</code>
     * @return The bytes for target.
     */
    com.google.protobuf.ByteString
        getTargetBytes();
  }
  /**
   * <pre>
   * Path encodes a data tree path as a series of repeated strings, with
   * each element of the path representing a data tree node name and the
   * associated attributes.
   * Reference: gNMI Specification Section 2.2.2.
   * </pre>
   *
   * Protobuf type {@code gnmi.Path}
   */
  public static final class Path extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:gnmi.Path)
      PathOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Path.newBuilder() to construct.
    private Path(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Path() {
      element_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      origin_ = "";
      elem_ = java.util.Collections.emptyList();
      target_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Path();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Path_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Path_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder.class);
    }

    public static final int ELEMENT_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList element_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     * <pre>
     * Elements of the path are no longer encoded as a string, but rather within
     * the elem field as a PathElem message.
     * </pre>
     *
     * <code>repeated string element = 1 [deprecated = true];</code>
     * @deprecated gnmi.Path.element is deprecated.
     *     See gnmi.proto;l=138
     * @return A list containing the element.
     */
    @java.lang.Deprecated public com.google.protobuf.ProtocolStringList
        getElementList() {
      return element_;
    }
    /**
     * <pre>
     * Elements of the path are no longer encoded as a string, but rather within
     * the elem field as a PathElem message.
     * </pre>
     *
     * <code>repeated string element = 1 [deprecated = true];</code>
     * @deprecated gnmi.Path.element is deprecated.
     *     See gnmi.proto;l=138
     * @return The count of element.
     */
    @java.lang.Deprecated public int getElementCount() {
      return element_.size();
    }
    /**
     * <pre>
     * Elements of the path are no longer encoded as a string, but rather within
     * the elem field as a PathElem message.
     * </pre>
     *
     * <code>repeated string element = 1 [deprecated = true];</code>
     * @deprecated gnmi.Path.element is deprecated.
     *     See gnmi.proto;l=138
     * @param index The index of the element to return.
     * @return The element at the given index.
     */
    @java.lang.Deprecated public java.lang.String getElement(int index) {
      return element_.get(index);
    }
    /**
     * <pre>
     * Elements of the path are no longer encoded as a string, but rather within
     * the elem field as a PathElem message.
     * </pre>
     *
     * <code>repeated string element = 1 [deprecated = true];</code>
     * @deprecated gnmi.Path.element is deprecated.
     *     See gnmi.proto;l=138
     * @param index The index of the value to return.
     * @return The bytes of the element at the given index.
     */
    @java.lang.Deprecated public com.google.protobuf.ByteString
        getElementBytes(int index) {
      return element_.getByteString(index);
    }

    public static final int ORIGIN_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private volatile java.lang.Object origin_ = "";
    /**
     * <pre>
     * Label to disambiguate path.
     * </pre>
     *
     * <code>string origin = 2;</code>
     * @return The origin.
     */
    @java.lang.Override
    public java.lang.String getOrigin() {
      java.lang.Object ref = origin_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        origin_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Label to disambiguate path.
     * </pre>
     *
     * <code>string origin = 2;</code>
     * @return The bytes for origin.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getOriginBytes() {
      java.lang.Object ref = origin_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        origin_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ELEM_FIELD_NUMBER = 3;
    @SuppressWarnings("serial")
    private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem> elem_;
    /**
     * <pre>
     * Elements of the path.
     * </pre>
     *
     * <code>repeated .gnmi.PathElem elem = 3;</code>
     */
    @java.lang.Override
    public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem> getElemList() {
      return elem_;
    }
    /**
     * <pre>
     * Elements of the path.
     * </pre>
     *
     * <code>repeated .gnmi.PathElem elem = 3;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElemOrBuilder> 
        getElemOrBuilderList() {
      return elem_;
    }
    /**
     * <pre>
     * Elements of the path.
     * </pre>
     *
     * <code>repeated .gnmi.PathElem elem = 3;</code>
     */
    @java.lang.Override
    public int getElemCount() {
      return elem_.size();
    }
    /**
     * <pre>
     * Elements of the path.
     * </pre>
     *
     * <code>repeated .gnmi.PathElem elem = 3;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem getElem(int index) {
      return elem_.get(index);
    }
    /**
     * <pre>
     * Elements of the path.
     * </pre>
     *
     * <code>repeated .gnmi.PathElem elem = 3;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElemOrBuilder getElemOrBuilder(
        int index) {
      return elem_.get(index);
    }

    public static final int TARGET_FIELD_NUMBER = 4;
    @SuppressWarnings("serial")
    private volatile java.lang.Object target_ = "";
    /**
     * <pre>
     * The name of the target
     * </pre>
     *
     * <code>string target = 4;</code>
     * @return The target.
     */
    @java.lang.Override
    public java.lang.String getTarget() {
      java.lang.Object ref = target_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        target_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * The name of the target
     * </pre>
     *
     * <code>string target = 4;</code>
     * @return The bytes for target.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getTargetBytes() {
      java.lang.Object ref = target_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        target_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < element_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, element_.getRaw(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(origin_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, origin_);
      }
      for (int i = 0; i < elem_.size(); i++) {
        output.writeMessage(3, elem_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(target_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, target_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < element_.size(); i++) {
          dataSize += computeStringSizeNoTag(element_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getElementList().size();
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(origin_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, origin_);
      }
      for (int i = 0; i < elem_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, elem_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(target_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, target_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.Path)) {
        return super.equals(obj);
      }
      org.opennms.features.openconfig.proto.gnmi.Gnmi.Path other = (org.opennms.features.openconfig.proto.gnmi.Gnmi.Path) obj;

      if (!getElementList()
          .equals(other.getElementList())) return false;
      if (!getOrigin()
          .equals(other.getOrigin())) return false;
      if (!getElemList()
          .equals(other.getElemList())) return false;
      if (!getTarget()
          .equals(other.getTarget())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getElementCount() > 0) {
        hash = (37 * hash) + ELEMENT_FIELD_NUMBER;
        hash = (53 * hash) + getElementList().hashCode();
      }
      hash = (37 * hash) + ORIGIN_FIELD_NUMBER;
      hash = (53 * hash) + getOrigin().hashCode();
      if (getElemCount() > 0) {
        hash = (37 * hash) + ELEM_FIELD_NUMBER;
        hash = (53 * hash) + getElemList().hashCode();
      }
      hash = (37 * hash) + TARGET_FIELD_NUMBER;
      hash = (53 * hash) + getTarget().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Path parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Path parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Path parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Path parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Path parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Path parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Path parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Path parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Path parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Path parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Path parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Path parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Path encodes a data tree path as a series of repeated strings, with
     * each element of the path representing a data tree node name and the
     * associated attributes.
     * Reference: gNMI Specification Section 2.2.2.
     * </pre>
     *
     * Protobuf type {@code gnmi.Path}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:gnmi.Path)
        org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Path_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Path_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder.class);
      }

      // Construct using org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        element_ =
            com.google.protobuf.LazyStringArrayList.emptyList();
        origin_ = "";
        if (elemBuilder_ == null) {
          elem_ = java.util.Collections.emptyList();
        } else {
          elem_ = null;
          elemBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        target_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Path_descriptor;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getDefaultInstanceForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance();
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path build() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.Path result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path buildPartial() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.Path result = new org.opennms.features.openconfig.proto.gnmi.Gnmi.Path(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path result) {
        if (elemBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            elem_ = java.util.Collections.unmodifiableList(elem_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.elem_ = elem_;
        } else {
          result.elem_ = elemBuilder_.build();
        }
      }

      private void buildPartial0(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          element_.makeImmutable();
          result.element_ = element_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.origin_ = origin_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.target_ = target_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.Path) {
          return mergeFrom((org.opennms.features.openconfig.proto.gnmi.Gnmi.Path)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path other) {
        if (other == org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance()) return this;
        if (!other.element_.isEmpty()) {
          if (element_.isEmpty()) {
            element_ = other.element_;
            bitField0_ |= 0x00000001;
          } else {
            ensureElementIsMutable();
            element_.addAll(other.element_);
          }
          onChanged();
        }
        if (!other.getOrigin().isEmpty()) {
          origin_ = other.origin_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (elemBuilder_ == null) {
          if (!other.elem_.isEmpty()) {
            if (elem_.isEmpty()) {
              elem_ = other.elem_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureElemIsMutable();
              elem_.addAll(other.elem_);
            }
            onChanged();
          }
        } else {
          if (!other.elem_.isEmpty()) {
            if (elemBuilder_.isEmpty()) {
              elemBuilder_.dispose();
              elemBuilder_ = null;
              elem_ = other.elem_;
              bitField0_ = (bitField0_ & ~0x00000004);
              elemBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getElemFieldBuilder() : null;
            } else {
              elemBuilder_.addAllMessages(other.elem_);
            }
          }
        }
        if (!other.getTarget().isEmpty()) {
          target_ = other.target_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                java.lang.String s = input.readStringRequireUtf8();
                ensureElementIsMutable();
                element_.add(s);
                break;
              } // case 10
              case 18: {
                origin_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem m =
                    input.readMessage(
                        org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem.parser(),
                        extensionRegistry);
                if (elemBuilder_ == null) {
                  ensureElemIsMutable();
                  elem_.add(m);
                } else {
                  elemBuilder_.addMessage(m);
                }
                break;
              } // case 26
              case 34: {
                target_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList element_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      private void ensureElementIsMutable() {
        if (!element_.isModifiable()) {
          element_ = new com.google.protobuf.LazyStringArrayList(element_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       * <pre>
       * Elements of the path are no longer encoded as a string, but rather within
       * the elem field as a PathElem message.
       * </pre>
       *
       * <code>repeated string element = 1 [deprecated = true];</code>
       * @deprecated gnmi.Path.element is deprecated.
       *     See gnmi.proto;l=138
       * @return A list containing the element.
       */
      @java.lang.Deprecated public com.google.protobuf.ProtocolStringList
          getElementList() {
        element_.makeImmutable();
        return element_;
      }
      /**
       * <pre>
       * Elements of the path are no longer encoded as a string, but rather within
       * the elem field as a PathElem message.
       * </pre>
       *
       * <code>repeated string element = 1 [deprecated = true];</code>
       * @deprecated gnmi.Path.element is deprecated.
       *     See gnmi.proto;l=138
       * @return The count of element.
       */
      @java.lang.Deprecated public int getElementCount() {
        return element_.size();
      }
      /**
       * <pre>
       * Elements of the path are no longer encoded as a string, but rather within
       * the elem field as a PathElem message.
       * </pre>
       *
       * <code>repeated string element = 1 [deprecated = true];</code>
       * @deprecated gnmi.Path.element is deprecated.
       *     See gnmi.proto;l=138
       * @param index The index of the element to return.
       * @return The element at the given index.
       */
      @java.lang.Deprecated public java.lang.String getElement(int index) {
        return element_.get(index);
      }
      /**
       * <pre>
       * Elements of the path are no longer encoded as a string, but rather within
       * the elem field as a PathElem message.
       * </pre>
       *
       * <code>repeated string element = 1 [deprecated = true];</code>
       * @deprecated gnmi.Path.element is deprecated.
       *     See gnmi.proto;l=138
       * @param index The index of the value to return.
       * @return The bytes of the element at the given index.
       */
      @java.lang.Deprecated public com.google.protobuf.ByteString
          getElementBytes(int index) {
        return element_.getByteString(index);
      }
      /**
       * <pre>
       * Elements of the path are no longer encoded as a string, but rather within
       * the elem field as a PathElem message.
       * </pre>
       *
       * <code>repeated string element = 1 [deprecated = true];</code>
       * @deprecated gnmi.Path.element is deprecated.
       *     See gnmi.proto;l=138
       * @param index The index to set the value at.
       * @param value The element to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated public Builder setElement(
          int index, java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureElementIsMutable();
        element_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Elements of the path are no longer encoded as a string, but rather within
       * the elem field as a PathElem message.
       * </pre>
       *
       * <code>repeated string element = 1 [deprecated = true];</code>
       * @deprecated gnmi.Path.element is deprecated.
       *     See gnmi.proto;l=138
       * @param value The element to add.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated public Builder addElement(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        ensureElementIsMutable();
        element_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Elements of the path are no longer encoded as a string, but rather within
       * the elem field as a PathElem message.
       * </pre>
       *
       * <code>repeated string element = 1 [deprecated = true];</code>
       * @deprecated gnmi.Path.element is deprecated.
       *     See gnmi.proto;l=138
       * @param values The element to add.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated public Builder addAllElement(
          java.lang.Iterable<java.lang.String> values) {
        ensureElementIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, element_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Elements of the path are no longer encoded as a string, but rather within
       * the elem field as a PathElem message.
       * </pre>
       *
       * <code>repeated string element = 1 [deprecated = true];</code>
       * @deprecated gnmi.Path.element is deprecated.
       *     See gnmi.proto;l=138
       * @return This builder for chaining.
       */
      @java.lang.Deprecated public Builder clearElement() {
        element_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Elements of the path are no longer encoded as a string, but rather within
       * the elem field as a PathElem message.
       * </pre>
       *
       * <code>repeated string element = 1 [deprecated = true];</code>
       * @deprecated gnmi.Path.element is deprecated.
       *     See gnmi.proto;l=138
       * @param value The bytes of the element to add.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated public Builder addElementBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        ensureElementIsMutable();
        element_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object origin_ = "";
      /**
       * <pre>
       * Label to disambiguate path.
       * </pre>
       *
       * <code>string origin = 2;</code>
       * @return The origin.
       */
      public java.lang.String getOrigin() {
        java.lang.Object ref = origin_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          origin_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Label to disambiguate path.
       * </pre>
       *
       * <code>string origin = 2;</code>
       * @return The bytes for origin.
       */
      public com.google.protobuf.ByteString
          getOriginBytes() {
        java.lang.Object ref = origin_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          origin_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Label to disambiguate path.
       * </pre>
       *
       * <code>string origin = 2;</code>
       * @param value The origin to set.
       * @return This builder for chaining.
       */
      public Builder setOrigin(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        origin_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Label to disambiguate path.
       * </pre>
       *
       * <code>string origin = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearOrigin() {
        origin_ = getDefaultInstance().getOrigin();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Label to disambiguate path.
       * </pre>
       *
       * <code>string origin = 2;</code>
       * @param value The bytes for origin to set.
       * @return This builder for chaining.
       */
      public Builder setOriginBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        origin_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem> elem_ =
        java.util.Collections.emptyList();
      private void ensureElemIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          elem_ = new java.util.ArrayList<org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem>(elem_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElemOrBuilder> elemBuilder_;

      /**
       * <pre>
       * Elements of the path.
       * </pre>
       *
       * <code>repeated .gnmi.PathElem elem = 3;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem> getElemList() {
        if (elemBuilder_ == null) {
          return java.util.Collections.unmodifiableList(elem_);
        } else {
          return elemBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Elements of the path.
       * </pre>
       *
       * <code>repeated .gnmi.PathElem elem = 3;</code>
       */
      public int getElemCount() {
        if (elemBuilder_ == null) {
          return elem_.size();
        } else {
          return elemBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Elements of the path.
       * </pre>
       *
       * <code>repeated .gnmi.PathElem elem = 3;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem getElem(int index) {
        if (elemBuilder_ == null) {
          return elem_.get(index);
        } else {
          return elemBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Elements of the path.
       * </pre>
       *
       * <code>repeated .gnmi.PathElem elem = 3;</code>
       */
      public Builder setElem(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem value) {
        if (elemBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureElemIsMutable();
          elem_.set(index, value);
          onChanged();
        } else {
          elemBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Elements of the path.
       * </pre>
       *
       * <code>repeated .gnmi.PathElem elem = 3;</code>
       */
      public Builder setElem(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem.Builder builderForValue) {
        if (elemBuilder_ == null) {
          ensureElemIsMutable();
          elem_.set(index, builderForValue.build());
          onChanged();
        } else {
          elemBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Elements of the path.
       * </pre>
       *
       * <code>repeated .gnmi.PathElem elem = 3;</code>
       */
      public Builder addElem(org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem value) {
        if (elemBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureElemIsMutable();
          elem_.add(value);
          onChanged();
        } else {
          elemBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Elements of the path.
       * </pre>
       *
       * <code>repeated .gnmi.PathElem elem = 3;</code>
       */
      public Builder addElem(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem value) {
        if (elemBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureElemIsMutable();
          elem_.add(index, value);
          onChanged();
        } else {
          elemBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Elements of the path.
       * </pre>
       *
       * <code>repeated .gnmi.PathElem elem = 3;</code>
       */
      public Builder addElem(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem.Builder builderForValue) {
        if (elemBuilder_ == null) {
          ensureElemIsMutable();
          elem_.add(builderForValue.build());
          onChanged();
        } else {
          elemBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Elements of the path.
       * </pre>
       *
       * <code>repeated .gnmi.PathElem elem = 3;</code>
       */
      public Builder addElem(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem.Builder builderForValue) {
        if (elemBuilder_ == null) {
          ensureElemIsMutable();
          elem_.add(index, builderForValue.build());
          onChanged();
        } else {
          elemBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Elements of the path.
       * </pre>
       *
       * <code>repeated .gnmi.PathElem elem = 3;</code>
       */
      public Builder addAllElem(
          java.lang.Iterable<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem> values) {
        if (elemBuilder_ == null) {
          ensureElemIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, elem_);
          onChanged();
        } else {
          elemBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Elements of the path.
       * </pre>
       *
       * <code>repeated .gnmi.PathElem elem = 3;</code>
       */
      public Builder clearElem() {
        if (elemBuilder_ == null) {
          elem_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          elemBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Elements of the path.
       * </pre>
       *
       * <code>repeated .gnmi.PathElem elem = 3;</code>
       */
      public Builder removeElem(int index) {
        if (elemBuilder_ == null) {
          ensureElemIsMutable();
          elem_.remove(index);
          onChanged();
        } else {
          elemBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Elements of the path.
       * </pre>
       *
       * <code>repeated .gnmi.PathElem elem = 3;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem.Builder getElemBuilder(
          int index) {
        return getElemFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Elements of the path.
       * </pre>
       *
       * <code>repeated .gnmi.PathElem elem = 3;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElemOrBuilder getElemOrBuilder(
          int index) {
        if (elemBuilder_ == null) {
          return elem_.get(index);  } else {
          return elemBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Elements of the path.
       * </pre>
       *
       * <code>repeated .gnmi.PathElem elem = 3;</code>
       */
      public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElemOrBuilder> 
           getElemOrBuilderList() {
        if (elemBuilder_ != null) {
          return elemBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(elem_);
        }
      }
      /**
       * <pre>
       * Elements of the path.
       * </pre>
       *
       * <code>repeated .gnmi.PathElem elem = 3;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem.Builder addElemBuilder() {
        return getElemFieldBuilder().addBuilder(
            org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem.getDefaultInstance());
      }
      /**
       * <pre>
       * Elements of the path.
       * </pre>
       *
       * <code>repeated .gnmi.PathElem elem = 3;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem.Builder addElemBuilder(
          int index) {
        return getElemFieldBuilder().addBuilder(
            index, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem.getDefaultInstance());
      }
      /**
       * <pre>
       * Elements of the path.
       * </pre>
       *
       * <code>repeated .gnmi.PathElem elem = 3;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem.Builder> 
           getElemBuilderList() {
        return getElemFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElemOrBuilder> 
          getElemFieldBuilder() {
        if (elemBuilder_ == null) {
          elemBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElemOrBuilder>(
                  elem_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          elem_ = null;
        }
        return elemBuilder_;
      }

      private java.lang.Object target_ = "";
      /**
       * <pre>
       * The name of the target
       * </pre>
       *
       * <code>string target = 4;</code>
       * @return The target.
       */
      public java.lang.String getTarget() {
        java.lang.Object ref = target_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          target_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The name of the target
       * </pre>
       *
       * <code>string target = 4;</code>
       * @return The bytes for target.
       */
      public com.google.protobuf.ByteString
          getTargetBytes() {
        java.lang.Object ref = target_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          target_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The name of the target
       * </pre>
       *
       * <code>string target = 4;</code>
       * @param value The target to set.
       * @return This builder for chaining.
       */
      public Builder setTarget(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        target_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The name of the target
       * </pre>
       *
       * <code>string target = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearTarget() {
        target_ = getDefaultInstance().getTarget();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The name of the target
       * </pre>
       *
       * <code>string target = 4;</code>
       * @param value The bytes for target to set.
       * @return This builder for chaining.
       */
      public Builder setTargetBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        target_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:gnmi.Path)
    }

    // @@protoc_insertion_point(class_scope:gnmi.Path)
    private static final org.opennms.features.openconfig.proto.gnmi.Gnmi.Path DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.openconfig.proto.gnmi.Gnmi.Path();
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Path>
        PARSER = new com.google.protobuf.AbstractParser<Path>() {
      @java.lang.Override
      public Path parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Path> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Path> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface PathElemOrBuilder extends
      // @@protoc_insertion_point(interface_extends:gnmi.PathElem)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The name of the element in the path.
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The name.
     */
    java.lang.String getName();
    /**
     * <pre>
     * The name of the element in the path.
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <pre>
     * Map of key (attribute) name to value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; key = 2;</code>
     */
    int getKeyCount();
    /**
     * <pre>
     * Map of key (attribute) name to value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; key = 2;</code>
     */
    boolean containsKey(
        java.lang.String key);
    /**
     * Use {@link #getKeyMap()} instead.
     */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String>
    getKey();
    /**
     * <pre>
     * Map of key (attribute) name to value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; key = 2;</code>
     */
    java.util.Map<java.lang.String, java.lang.String>
    getKeyMap();
    /**
     * <pre>
     * Map of key (attribute) name to value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; key = 2;</code>
     */
    /* nullable */
java.lang.String getKeyOrDefault(
        java.lang.String key,
        /* nullable */
java.lang.String defaultValue);
    /**
     * <pre>
     * Map of key (attribute) name to value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; key = 2;</code>
     */
    java.lang.String getKeyOrThrow(
        java.lang.String key);
  }
  /**
   * <pre>
   * PathElem encodes an element of a gNMI path, along with any attributes (keys)
   * that may be associated with it.
   * Reference: gNMI Specification Section 2.2.2.
   * </pre>
   *
   * Protobuf type {@code gnmi.PathElem}
   */
  public static final class PathElem extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:gnmi.PathElem)
      PathElemOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use PathElem.newBuilder() to construct.
    private PathElem(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private PathElem() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new PathElem();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_PathElem_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetKey();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_PathElem_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     * <pre>
     * The name of the element in the path.
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * The name of the element in the path.
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int KEY_FIELD_NUMBER = 2;
    private static final class KeyDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
          java.lang.String, java.lang.String> defaultEntry =
              com.google.protobuf.MapEntry
              .<java.lang.String, java.lang.String>newDefaultInstance(
                  org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_PathElem_KeyEntry_descriptor, 
                  com.google.protobuf.WireFormat.FieldType.STRING,
                  "",
                  com.google.protobuf.WireFormat.FieldType.STRING,
                  "");
    }
    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
        java.lang.String, java.lang.String> key_;
    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
    internalGetKey() {
      if (key_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            KeyDefaultEntryHolder.defaultEntry);
      }
      return key_;
    }
    public int getKeyCount() {
      return internalGetKey().getMap().size();
    }
    /**
     * <pre>
     * Map of key (attribute) name to value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; key = 2;</code>
     */
    @java.lang.Override
    public boolean containsKey(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      return internalGetKey().getMap().containsKey(key);
    }
    /**
     * Use {@link #getKeyMap()} instead.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getKey() {
      return getKeyMap();
    }
    /**
     * <pre>
     * Map of key (attribute) name to value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; key = 2;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getKeyMap() {
      return internalGetKey().getMap();
    }
    /**
     * <pre>
     * Map of key (attribute) name to value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; key = 2;</code>
     */
    @java.lang.Override
    public /* nullable */
java.lang.String getKeyOrDefault(
        java.lang.String key,
        /* nullable */
java.lang.String defaultValue) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetKey().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * Map of key (attribute) name to value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; key = 2;</code>
     */
    @java.lang.Override
    public java.lang.String getKeyOrThrow(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetKey().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      com.google.protobuf.GeneratedMessageV3
        .serializeStringMapTo(
          output,
          internalGetKey(),
          KeyDefaultEntryHolder.defaultEntry,
          2);
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry
           : internalGetKey().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
        key__ = KeyDefaultEntryHolder.defaultEntry.newBuilderForType()
            .setKey(entry.getKey())
            .setValue(entry.getValue())
            .build();
        size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(2, key__);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem)) {
        return super.equals(obj);
      }
      org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem other = (org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem) obj;

      if (!getName()
          .equals(other.getName())) return false;
      if (!internalGetKey().equals(
          other.internalGetKey())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      if (!internalGetKey().getMap().isEmpty()) {
        hash = (37 * hash) + KEY_FIELD_NUMBER;
        hash = (53 * hash) + internalGetKey().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * PathElem encodes an element of a gNMI path, along with any attributes (keys)
     * that may be associated with it.
     * Reference: gNMI Specification Section 2.2.2.
     * </pre>
     *
     * Protobuf type {@code gnmi.PathElem}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:gnmi.PathElem)
        org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElemOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_PathElem_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 2:
            return internalGetKey();
          default:
            throw new RuntimeException(
                "Invalid map field number: " + number);
        }
      }
      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 2:
            return internalGetMutableKey();
          default:
            throw new RuntimeException(
                "Invalid map field number: " + number);
        }
      }
      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_PathElem_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem.Builder.class);
      }

      // Construct using org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        internalGetMutableKey().clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_PathElem_descriptor;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem getDefaultInstanceForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem.getDefaultInstance();
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem build() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem buildPartial() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem result = new org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.key_ = internalGetKey();
          result.key_.makeImmutable();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem) {
          return mergeFrom((org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem other) {
        if (other == org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem.getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        internalGetMutableKey().mergeFrom(
            other.internalGetKey());
        bitField0_ |= 0x00000002;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                key__ = input.readMessage(
                    KeyDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                internalGetMutableKey().getMutableMap().put(
                    key__.getKey(), key__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <pre>
       * The name of the element in the path.
       * </pre>
       *
       * <code>string name = 1;</code>
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The name of the element in the path.
       * </pre>
       *
       * <code>string name = 1;</code>
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The name of the element in the path.
       * </pre>
       *
       * <code>string name = 1;</code>
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The name of the element in the path.
       * </pre>
       *
       * <code>string name = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The name of the element in the path.
       * </pre>
       *
       * <code>string name = 1;</code>
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<
          java.lang.String, java.lang.String> key_;
      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetKey() {
        if (key_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              KeyDefaultEntryHolder.defaultEntry);
        }
        return key_;
      }
      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableKey() {
        if (key_ == null) {
          key_ = com.google.protobuf.MapField.newMapField(
              KeyDefaultEntryHolder.defaultEntry);
        }
        if (!key_.isMutable()) {
          key_ = key_.copy();
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return key_;
      }
      public int getKeyCount() {
        return internalGetKey().getMap().size();
      }
      /**
       * <pre>
       * Map of key (attribute) name to value.
       * </pre>
       *
       * <code>map&lt;string, string&gt; key = 2;</code>
       */
      @java.lang.Override
      public boolean containsKey(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        return internalGetKey().getMap().containsKey(key);
      }
      /**
       * Use {@link #getKeyMap()} instead.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getKey() {
        return getKeyMap();
      }
      /**
       * <pre>
       * Map of key (attribute) name to value.
       * </pre>
       *
       * <code>map&lt;string, string&gt; key = 2;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getKeyMap() {
        return internalGetKey().getMap();
      }
      /**
       * <pre>
       * Map of key (attribute) name to value.
       * </pre>
       *
       * <code>map&lt;string, string&gt; key = 2;</code>
       */
      @java.lang.Override
      public /* nullable */
java.lang.String getKeyOrDefault(
          java.lang.String key,
          /* nullable */
java.lang.String defaultValue) {
        if (key == null) { throw new NullPointerException("map key"); }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetKey().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       * <pre>
       * Map of key (attribute) name to value.
       * </pre>
       *
       * <code>map&lt;string, string&gt; key = 2;</code>
       */
      @java.lang.Override
      public java.lang.String getKeyOrThrow(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetKey().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }
      public Builder clearKey() {
        bitField0_ = (bitField0_ & ~0x00000002);
        internalGetMutableKey().getMutableMap()
            .clear();
        return this;
      }
      /**
       * <pre>
       * Map of key (attribute) name to value.
       * </pre>
       *
       * <code>map&lt;string, string&gt; key = 2;</code>
       */
      public Builder removeKey(
          java.lang.String key) {
        if (key == null) { throw new NullPointerException("map key"); }
        internalGetMutableKey().getMutableMap()
            .remove(key);
        return this;
      }
      /**
       * Use alternate mutation accessors instead.
       */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String>
          getMutableKey() {
        bitField0_ |= 0x00000002;
        return internalGetMutableKey().getMutableMap();
      }
      /**
       * <pre>
       * Map of key (attribute) name to value.
       * </pre>
       *
       * <code>map&lt;string, string&gt; key = 2;</code>
       */
      public Builder putKey(
          java.lang.String key,
          java.lang.String value) {
        if (key == null) { throw new NullPointerException("map key"); }
        if (value == null) { throw new NullPointerException("map value"); }
        internalGetMutableKey().getMutableMap()
            .put(key, value);
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <pre>
       * Map of key (attribute) name to value.
       * </pre>
       *
       * <code>map&lt;string, string&gt; key = 2;</code>
       */
      public Builder putAllKey(
          java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableKey().getMutableMap()
            .putAll(values);
        bitField0_ |= 0x00000002;
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:gnmi.PathElem)
    }

    // @@protoc_insertion_point(class_scope:gnmi.PathElem)
    private static final org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem();
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PathElem>
        PARSER = new com.google.protobuf.AbstractParser<PathElem>() {
      @java.lang.Override
      public PathElem parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<PathElem> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PathElem> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathElem getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  @java.lang.Deprecated public interface ValueOrBuilder extends
      // @@protoc_insertion_point(interface_extends:gnmi.Value)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Value of the variable being transmitted.
     * </pre>
     *
     * <code>bytes value = 1;</code>
     * @return The value.
     */
    com.google.protobuf.ByteString getValue();

    /**
     * <pre>
     * Encoding used for the value field.
     * </pre>
     *
     * <code>.gnmi.Encoding type = 2;</code>
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();
    /**
     * <pre>
     * Encoding used for the value field.
     * </pre>
     *
     * <code>.gnmi.Encoding type = 2;</code>
     * @return The type.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding getType();
  }
  /**
   * <pre>
   * Value encodes a data tree node's value - along with the way in which
   * the value is encoded. This message is deprecated by gNMI 0.3.0.
   * Reference: gNMI Specification Section 2.2.3.
   * </pre>
   *
   * Protobuf type {@code gnmi.Value}
   */
  @java.lang.Deprecated public static final class Value extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:gnmi.Value)
      ValueOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Value.newBuilder() to construct.
    private Value(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Value() {
      value_ = com.google.protobuf.ByteString.EMPTY;
      type_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Value();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Value_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Value_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Value.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.Value.Builder.class);
    }

    public static final int VALUE_FIELD_NUMBER = 1;
    private com.google.protobuf.ByteString value_ = com.google.protobuf.ByteString.EMPTY;
    /**
     * <pre>
     * Value of the variable being transmitted.
     * </pre>
     *
     * <code>bytes value = 1;</code>
     * @return The value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getValue() {
      return value_;
    }

    public static final int TYPE_FIELD_NUMBER = 2;
    private int type_ = 0;
    /**
     * <pre>
     * Encoding used for the value field.
     * </pre>
     *
     * <code>.gnmi.Encoding type = 2;</code>
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Encoding used for the value field.
     * </pre>
     *
     * <code>.gnmi.Encoding type = 2;</code>
     * @return The type.
     */
    @java.lang.Override public org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding getType() {
      org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding result = org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding.forNumber(type_);
      return result == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding.UNRECOGNIZED : result;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!value_.isEmpty()) {
        output.writeBytes(1, value_);
      }
      if (type_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding.JSON.getNumber()) {
        output.writeEnum(2, type_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!value_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, value_);
      }
      if (type_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding.JSON.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, type_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.Value)) {
        return super.equals(obj);
      }
      org.opennms.features.openconfig.proto.gnmi.Gnmi.Value other = (org.opennms.features.openconfig.proto.gnmi.Gnmi.Value) obj;

      if (!getValue()
          .equals(other.getValue())) return false;
      if (type_ != other.type_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Value parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Value parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Value parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Value parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Value parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Value parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Value parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Value parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Value parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Value parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Value parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Value parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.openconfig.proto.gnmi.Gnmi.Value prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Value encodes a data tree node's value - along with the way in which
     * the value is encoded. This message is deprecated by gNMI 0.3.0.
     * Reference: gNMI Specification Section 2.2.3.
     * </pre>
     *
     * Protobuf type {@code gnmi.Value}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:gnmi.Value)
        org.opennms.features.openconfig.proto.gnmi.Gnmi.ValueOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Value_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Value_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.openconfig.proto.gnmi.Gnmi.Value.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.Value.Builder.class);
      }

      // Construct using org.opennms.features.openconfig.proto.gnmi.Gnmi.Value.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        value_ = com.google.protobuf.ByteString.EMPTY;
        type_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Value_descriptor;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Value getDefaultInstanceForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.Value.getDefaultInstance();
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Value build() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.Value result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Value buildPartial() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.Value result = new org.opennms.features.openconfig.proto.gnmi.Gnmi.Value(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.opennms.features.openconfig.proto.gnmi.Gnmi.Value result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.value_ = value_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.type_ = type_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.Value) {
          return mergeFrom((org.opennms.features.openconfig.proto.gnmi.Gnmi.Value)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.openconfig.proto.gnmi.Gnmi.Value other) {
        if (other == org.opennms.features.openconfig.proto.gnmi.Gnmi.Value.getDefaultInstance()) return this;
        if (other.getValue() != com.google.protobuf.ByteString.EMPTY) {
          setValue(other.getValue());
        }
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                value_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 16: {
                type_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private com.google.protobuf.ByteString value_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <pre>
       * Value of the variable being transmitted.
       * </pre>
       *
       * <code>bytes value = 1;</code>
       * @return The value.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getValue() {
        return value_;
      }
      /**
       * <pre>
       * Value of the variable being transmitted.
       * </pre>
       *
       * <code>bytes value = 1;</code>
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        value_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Value of the variable being transmitted.
       * </pre>
       *
       * <code>bytes value = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        bitField0_ = (bitField0_ & ~0x00000001);
        value_ = getDefaultInstance().getValue();
        onChanged();
        return this;
      }

      private int type_ = 0;
      /**
       * <pre>
       * Encoding used for the value field.
       * </pre>
       *
       * <code>.gnmi.Encoding type = 2;</code>
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override public int getTypeValue() {
        return type_;
      }
      /**
       * <pre>
       * Encoding used for the value field.
       * </pre>
       *
       * <code>.gnmi.Encoding type = 2;</code>
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Encoding used for the value field.
       * </pre>
       *
       * <code>.gnmi.Encoding type = 2;</code>
       * @return The type.
       */
      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding getType() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding result = org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding.forNumber(type_);
        return result == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Encoding used for the value field.
       * </pre>
       *
       * <code>.gnmi.Encoding type = 2;</code>
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Encoding used for the value field.
       * </pre>
       *
       * <code>.gnmi.Encoding type = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000002);
        type_ = 0;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:gnmi.Value)
    }

    // @@protoc_insertion_point(class_scope:gnmi.Value)
    private static final org.opennms.features.openconfig.proto.gnmi.Gnmi.Value DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.openconfig.proto.gnmi.Gnmi.Value();
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Value getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Value>
        PARSER = new com.google.protobuf.AbstractParser<Value>() {
      @java.lang.Override
      public Value parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Value> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Value> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Value getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  @java.lang.Deprecated public interface ErrorOrBuilder extends
      // @@protoc_insertion_point(interface_extends:gnmi.Error)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Canonical gRPC error code.
     * </pre>
     *
     * <code>uint32 code = 1;</code>
     * @return The code.
     */
    int getCode();

    /**
     * <pre>
     * Human readable error.
     * </pre>
     *
     * <code>string message = 2;</code>
     * @return The message.
     */
    java.lang.String getMessage();
    /**
     * <pre>
     * Human readable error.
     * </pre>
     *
     * <code>string message = 2;</code>
     * @return The bytes for message.
     */
    com.google.protobuf.ByteString
        getMessageBytes();

    /**
     * <pre>
     * Optional additional information.
     * </pre>
     *
     * <code>.google.protobuf.Any data = 3;</code>
     * @return Whether the data field is set.
     */
    boolean hasData();
    /**
     * <pre>
     * Optional additional information.
     * </pre>
     *
     * <code>.google.protobuf.Any data = 3;</code>
     * @return The data.
     */
    com.google.protobuf.Any getData();
    /**
     * <pre>
     * Optional additional information.
     * </pre>
     *
     * <code>.google.protobuf.Any data = 3;</code>
     */
    com.google.protobuf.AnyOrBuilder getDataOrBuilder();
  }
  /**
   * <pre>
   * Error message previously utilised to return errors to the client. Deprecated
   * in favour of using the google.golang.org/genproto/googleapis/rpc/status
   * message in the RPC response.
   * Reference: gNMI Specification Section 2.5
   * </pre>
   *
   * Protobuf type {@code gnmi.Error}
   */
  @java.lang.Deprecated public static final class Error extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:gnmi.Error)
      ErrorOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Error.newBuilder() to construct.
    private Error(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Error() {
      message_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Error();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Error_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Error_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.Builder.class);
    }

    private int bitField0_;
    public static final int CODE_FIELD_NUMBER = 1;
    private int code_ = 0;
    /**
     * <pre>
     * Canonical gRPC error code.
     * </pre>
     *
     * <code>uint32 code = 1;</code>
     * @return The code.
     */
    @java.lang.Override
    public int getCode() {
      return code_;
    }

    public static final int MESSAGE_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private volatile java.lang.Object message_ = "";
    /**
     * <pre>
     * Human readable error.
     * </pre>
     *
     * <code>string message = 2;</code>
     * @return The message.
     */
    @java.lang.Override
    public java.lang.String getMessage() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        message_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Human readable error.
     * </pre>
     *
     * <code>string message = 2;</code>
     * @return The bytes for message.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getMessageBytes() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        message_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DATA_FIELD_NUMBER = 3;
    private com.google.protobuf.Any data_;
    /**
     * <pre>
     * Optional additional information.
     * </pre>
     *
     * <code>.google.protobuf.Any data = 3;</code>
     * @return Whether the data field is set.
     */
    @java.lang.Override
    public boolean hasData() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Optional additional information.
     * </pre>
     *
     * <code>.google.protobuf.Any data = 3;</code>
     * @return The data.
     */
    @java.lang.Override
    public com.google.protobuf.Any getData() {
      return data_ == null ? com.google.protobuf.Any.getDefaultInstance() : data_;
    }
    /**
     * <pre>
     * Optional additional information.
     * </pre>
     *
     * <code>.google.protobuf.Any data = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.AnyOrBuilder getDataOrBuilder() {
      return data_ == null ? com.google.protobuf.Any.getDefaultInstance() : data_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (code_ != 0) {
        output.writeUInt32(1, code_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, message_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getData());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (code_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(1, code_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, message_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getData());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.Error)) {
        return super.equals(obj);
      }
      org.opennms.features.openconfig.proto.gnmi.Gnmi.Error other = (org.opennms.features.openconfig.proto.gnmi.Gnmi.Error) obj;

      if (getCode()
          != other.getCode()) return false;
      if (!getMessage()
          .equals(other.getMessage())) return false;
      if (hasData() != other.hasData()) return false;
      if (hasData()) {
        if (!getData()
            .equals(other.getData())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CODE_FIELD_NUMBER;
      hash = (53 * hash) + getCode();
      hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getMessage().hashCode();
      if (hasData()) {
        hash = (37 * hash) + DATA_FIELD_NUMBER;
        hash = (53 * hash) + getData().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Error parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Error parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Error parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Error parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Error parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Error parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Error parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Error parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Error parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Error parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Error parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Error parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.openconfig.proto.gnmi.Gnmi.Error prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Error message previously utilised to return errors to the client. Deprecated
     * in favour of using the google.golang.org/genproto/googleapis/rpc/status
     * message in the RPC response.
     * Reference: gNMI Specification Section 2.5
     * </pre>
     *
     * Protobuf type {@code gnmi.Error}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:gnmi.Error)
        org.opennms.features.openconfig.proto.gnmi.Gnmi.ErrorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Error_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Error_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.Builder.class);
      }

      // Construct using org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getDataFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        code_ = 0;
        message_ = "";
        data_ = null;
        if (dataBuilder_ != null) {
          dataBuilder_.dispose();
          dataBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Error_descriptor;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Error getDefaultInstanceForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.getDefaultInstance();
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Error build() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.Error result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Error buildPartial() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.Error result = new org.opennms.features.openconfig.proto.gnmi.Gnmi.Error(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.opennms.features.openconfig.proto.gnmi.Gnmi.Error result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.code_ = code_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.message_ = message_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.data_ = dataBuilder_ == null
              ? data_
              : dataBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.Error) {
          return mergeFrom((org.opennms.features.openconfig.proto.gnmi.Gnmi.Error)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.openconfig.proto.gnmi.Gnmi.Error other) {
        if (other == org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.getDefaultInstance()) return this;
        if (other.getCode() != 0) {
          setCode(other.getCode());
        }
        if (!other.getMessage().isEmpty()) {
          message_ = other.message_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasData()) {
          mergeData(other.getData());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                code_ = input.readUInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              case 18: {
                message_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                input.readMessage(
                    getDataFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int code_ ;
      /**
       * <pre>
       * Canonical gRPC error code.
       * </pre>
       *
       * <code>uint32 code = 1;</code>
       * @return The code.
       */
      @java.lang.Override
      public int getCode() {
        return code_;
      }
      /**
       * <pre>
       * Canonical gRPC error code.
       * </pre>
       *
       * <code>uint32 code = 1;</code>
       * @param value The code to set.
       * @return This builder for chaining.
       */
      public Builder setCode(int value) {

        code_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Canonical gRPC error code.
       * </pre>
       *
       * <code>uint32 code = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearCode() {
        bitField0_ = (bitField0_ & ~0x00000001);
        code_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object message_ = "";
      /**
       * <pre>
       * Human readable error.
       * </pre>
       *
       * <code>string message = 2;</code>
       * @return The message.
       */
      public java.lang.String getMessage() {
        java.lang.Object ref = message_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          message_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Human readable error.
       * </pre>
       *
       * <code>string message = 2;</code>
       * @return The bytes for message.
       */
      public com.google.protobuf.ByteString
          getMessageBytes() {
        java.lang.Object ref = message_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          message_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Human readable error.
       * </pre>
       *
       * <code>string message = 2;</code>
       * @param value The message to set.
       * @return This builder for chaining.
       */
      public Builder setMessage(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        message_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Human readable error.
       * </pre>
       *
       * <code>string message = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearMessage() {
        message_ = getDefaultInstance().getMessage();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Human readable error.
       * </pre>
       *
       * <code>string message = 2;</code>
       * @param value The bytes for message to set.
       * @return This builder for chaining.
       */
      public Builder setMessageBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        message_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.Any data_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.Any, com.google.protobuf.Any.Builder, com.google.protobuf.AnyOrBuilder> dataBuilder_;
      /**
       * <pre>
       * Optional additional information.
       * </pre>
       *
       * <code>.google.protobuf.Any data = 3;</code>
       * @return Whether the data field is set.
       */
      public boolean hasData() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * Optional additional information.
       * </pre>
       *
       * <code>.google.protobuf.Any data = 3;</code>
       * @return The data.
       */
      public com.google.protobuf.Any getData() {
        if (dataBuilder_ == null) {
          return data_ == null ? com.google.protobuf.Any.getDefaultInstance() : data_;
        } else {
          return dataBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Optional additional information.
       * </pre>
       *
       * <code>.google.protobuf.Any data = 3;</code>
       */
      public Builder setData(com.google.protobuf.Any value) {
        if (dataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          data_ = value;
        } else {
          dataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Optional additional information.
       * </pre>
       *
       * <code>.google.protobuf.Any data = 3;</code>
       */
      public Builder setData(
          com.google.protobuf.Any.Builder builderForValue) {
        if (dataBuilder_ == null) {
          data_ = builderForValue.build();
        } else {
          dataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Optional additional information.
       * </pre>
       *
       * <code>.google.protobuf.Any data = 3;</code>
       */
      public Builder mergeData(com.google.protobuf.Any value) {
        if (dataBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0) &&
            data_ != null &&
            data_ != com.google.protobuf.Any.getDefaultInstance()) {
            getDataBuilder().mergeFrom(value);
          } else {
            data_ = value;
          }
        } else {
          dataBuilder_.mergeFrom(value);
        }
        if (data_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * Optional additional information.
       * </pre>
       *
       * <code>.google.protobuf.Any data = 3;</code>
       */
      public Builder clearData() {
        bitField0_ = (bitField0_ & ~0x00000004);
        data_ = null;
        if (dataBuilder_ != null) {
          dataBuilder_.dispose();
          dataBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Optional additional information.
       * </pre>
       *
       * <code>.google.protobuf.Any data = 3;</code>
       */
      public com.google.protobuf.Any.Builder getDataBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getDataFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Optional additional information.
       * </pre>
       *
       * <code>.google.protobuf.Any data = 3;</code>
       */
      public com.google.protobuf.AnyOrBuilder getDataOrBuilder() {
        if (dataBuilder_ != null) {
          return dataBuilder_.getMessageOrBuilder();
        } else {
          return data_ == null ?
              com.google.protobuf.Any.getDefaultInstance() : data_;
        }
      }
      /**
       * <pre>
       * Optional additional information.
       * </pre>
       *
       * <code>.google.protobuf.Any data = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.Any, com.google.protobuf.Any.Builder, com.google.protobuf.AnyOrBuilder> 
          getDataFieldBuilder() {
        if (dataBuilder_ == null) {
          dataBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Any, com.google.protobuf.Any.Builder, com.google.protobuf.AnyOrBuilder>(
                  getData(),
                  getParentForChildren(),
                  isClean());
          data_ = null;
        }
        return dataBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:gnmi.Error)
    }

    // @@protoc_insertion_point(class_scope:gnmi.Error)
    private static final org.opennms.features.openconfig.proto.gnmi.Gnmi.Error DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.openconfig.proto.gnmi.Gnmi.Error();
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Error getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Error>
        PARSER = new com.google.protobuf.AbstractParser<Error>() {
      @java.lang.Override
      public Error parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Error> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Error> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Error getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface Decimal64OrBuilder extends
      // @@protoc_insertion_point(interface_extends:gnmi.Decimal64)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Set of digits.
     * </pre>
     *
     * <code>int64 digits = 1;</code>
     * @return The digits.
     */
    long getDigits();

    /**
     * <pre>
     * Number of digits following the decimal point.
     * </pre>
     *
     * <code>uint32 precision = 2;</code>
     * @return The precision.
     */
    int getPrecision();
  }
  /**
   * <pre>
   * Decimal64 is used to encode a fixed precision decimal number. The value
   * is expressed as a set of digits with the precision specifying the
   * number of digits following the decimal point in the digit set.
   * </pre>
   *
   * Protobuf type {@code gnmi.Decimal64}
   */
  public static final class Decimal64 extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:gnmi.Decimal64)
      Decimal64OrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Decimal64.newBuilder() to construct.
    private Decimal64(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Decimal64() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Decimal64();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Decimal64_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Decimal64_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64.Builder.class);
    }

    public static final int DIGITS_FIELD_NUMBER = 1;
    private long digits_ = 0L;
    /**
     * <pre>
     * Set of digits.
     * </pre>
     *
     * <code>int64 digits = 1;</code>
     * @return The digits.
     */
    @java.lang.Override
    public long getDigits() {
      return digits_;
    }

    public static final int PRECISION_FIELD_NUMBER = 2;
    private int precision_ = 0;
    /**
     * <pre>
     * Number of digits following the decimal point.
     * </pre>
     *
     * <code>uint32 precision = 2;</code>
     * @return The precision.
     */
    @java.lang.Override
    public int getPrecision() {
      return precision_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (digits_ != 0L) {
        output.writeInt64(1, digits_);
      }
      if (precision_ != 0) {
        output.writeUInt32(2, precision_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (digits_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt64Size(1, digits_);
      }
      if (precision_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(2, precision_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64)) {
        return super.equals(obj);
      }
      org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 other = (org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64) obj;

      if (getDigits()
          != other.getDigits()) return false;
      if (getPrecision()
          != other.getPrecision()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DIGITS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getDigits());
      hash = (37 * hash) + PRECISION_FIELD_NUMBER;
      hash = (53 * hash) + getPrecision();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Decimal64 is used to encode a fixed precision decimal number. The value
     * is expressed as a set of digits with the precision specifying the
     * number of digits following the decimal point in the digit set.
     * </pre>
     *
     * Protobuf type {@code gnmi.Decimal64}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:gnmi.Decimal64)
        org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64OrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Decimal64_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Decimal64_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64.Builder.class);
      }

      // Construct using org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        digits_ = 0L;
        precision_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Decimal64_descriptor;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 getDefaultInstanceForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64.getDefaultInstance();
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 build() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 buildPartial() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 result = new org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.digits_ = digits_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.precision_ = precision_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64) {
          return mergeFrom((org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 other) {
        if (other == org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64.getDefaultInstance()) return this;
        if (other.getDigits() != 0L) {
          setDigits(other.getDigits());
        }
        if (other.getPrecision() != 0) {
          setPrecision(other.getPrecision());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                digits_ = input.readInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              case 16: {
                precision_ = input.readUInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private long digits_ ;
      /**
       * <pre>
       * Set of digits.
       * </pre>
       *
       * <code>int64 digits = 1;</code>
       * @return The digits.
       */
      @java.lang.Override
      public long getDigits() {
        return digits_;
      }
      /**
       * <pre>
       * Set of digits.
       * </pre>
       *
       * <code>int64 digits = 1;</code>
       * @param value The digits to set.
       * @return This builder for chaining.
       */
      public Builder setDigits(long value) {

        digits_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Set of digits.
       * </pre>
       *
       * <code>int64 digits = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearDigits() {
        bitField0_ = (bitField0_ & ~0x00000001);
        digits_ = 0L;
        onChanged();
        return this;
      }

      private int precision_ ;
      /**
       * <pre>
       * Number of digits following the decimal point.
       * </pre>
       *
       * <code>uint32 precision = 2;</code>
       * @return The precision.
       */
      @java.lang.Override
      public int getPrecision() {
        return precision_;
      }
      /**
       * <pre>
       * Number of digits following the decimal point.
       * </pre>
       *
       * <code>uint32 precision = 2;</code>
       * @param value The precision to set.
       * @return This builder for chaining.
       */
      public Builder setPrecision(int value) {

        precision_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Number of digits following the decimal point.
       * </pre>
       *
       * <code>uint32 precision = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearPrecision() {
        bitField0_ = (bitField0_ & ~0x00000002);
        precision_ = 0;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:gnmi.Decimal64)
    }

    // @@protoc_insertion_point(class_scope:gnmi.Decimal64)
    private static final org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64();
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Decimal64>
        PARSER = new com.google.protobuf.AbstractParser<Decimal64>() {
      @java.lang.Override
      public Decimal64 parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Decimal64> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Decimal64> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Decimal64 getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ScalarArrayOrBuilder extends
      // @@protoc_insertion_point(interface_extends:gnmi.ScalarArray)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The set of elements within the array. Each TypedValue message should
     * specify only elements that have a field identifier of 1-7 (i.e., the
     * values are scalar values).
     * </pre>
     *
     * <code>repeated .gnmi.TypedValue element = 1;</code>
     */
    java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue> 
        getElementList();
    /**
     * <pre>
     * The set of elements within the array. Each TypedValue message should
     * specify only elements that have a field identifier of 1-7 (i.e., the
     * values are scalar values).
     * </pre>
     *
     * <code>repeated .gnmi.TypedValue element = 1;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue getElement(int index);
    /**
     * <pre>
     * The set of elements within the array. Each TypedValue message should
     * specify only elements that have a field identifier of 1-7 (i.e., the
     * values are scalar values).
     * </pre>
     *
     * <code>repeated .gnmi.TypedValue element = 1;</code>
     */
    int getElementCount();
    /**
     * <pre>
     * The set of elements within the array. Each TypedValue message should
     * specify only elements that have a field identifier of 1-7 (i.e., the
     * values are scalar values).
     * </pre>
     *
     * <code>repeated .gnmi.TypedValue element = 1;</code>
     */
    java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValueOrBuilder> 
        getElementOrBuilderList();
    /**
     * <pre>
     * The set of elements within the array. Each TypedValue message should
     * specify only elements that have a field identifier of 1-7 (i.e., the
     * values are scalar values).
     * </pre>
     *
     * <code>repeated .gnmi.TypedValue element = 1;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValueOrBuilder getElementOrBuilder(
        int index);
  }
  /**
   * <pre>
   * ScalarArray is used to encode a mixed-type array of values.
   * </pre>
   *
   * Protobuf type {@code gnmi.ScalarArray}
   */
  public static final class ScalarArray extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:gnmi.ScalarArray)
      ScalarArrayOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ScalarArray.newBuilder() to construct.
    private ScalarArray(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ScalarArray() {
      element_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new ScalarArray();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_ScalarArray_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_ScalarArray_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray.Builder.class);
    }

    public static final int ELEMENT_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue> element_;
    /**
     * <pre>
     * The set of elements within the array. Each TypedValue message should
     * specify only elements that have a field identifier of 1-7 (i.e., the
     * values are scalar values).
     * </pre>
     *
     * <code>repeated .gnmi.TypedValue element = 1;</code>
     */
    @java.lang.Override
    public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue> getElementList() {
      return element_;
    }
    /**
     * <pre>
     * The set of elements within the array. Each TypedValue message should
     * specify only elements that have a field identifier of 1-7 (i.e., the
     * values are scalar values).
     * </pre>
     *
     * <code>repeated .gnmi.TypedValue element = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValueOrBuilder> 
        getElementOrBuilderList() {
      return element_;
    }
    /**
     * <pre>
     * The set of elements within the array. Each TypedValue message should
     * specify only elements that have a field identifier of 1-7 (i.e., the
     * values are scalar values).
     * </pre>
     *
     * <code>repeated .gnmi.TypedValue element = 1;</code>
     */
    @java.lang.Override
    public int getElementCount() {
      return element_.size();
    }
    /**
     * <pre>
     * The set of elements within the array. Each TypedValue message should
     * specify only elements that have a field identifier of 1-7 (i.e., the
     * values are scalar values).
     * </pre>
     *
     * <code>repeated .gnmi.TypedValue element = 1;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue getElement(int index) {
      return element_.get(index);
    }
    /**
     * <pre>
     * The set of elements within the array. Each TypedValue message should
     * specify only elements that have a field identifier of 1-7 (i.e., the
     * values are scalar values).
     * </pre>
     *
     * <code>repeated .gnmi.TypedValue element = 1;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValueOrBuilder getElementOrBuilder(
        int index) {
      return element_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < element_.size(); i++) {
        output.writeMessage(1, element_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < element_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, element_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray)) {
        return super.equals(obj);
      }
      org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray other = (org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray) obj;

      if (!getElementList()
          .equals(other.getElementList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getElementCount() > 0) {
        hash = (37 * hash) + ELEMENT_FIELD_NUMBER;
        hash = (53 * hash) + getElementList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * ScalarArray is used to encode a mixed-type array of values.
     * </pre>
     *
     * Protobuf type {@code gnmi.ScalarArray}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:gnmi.ScalarArray)
        org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArrayOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_ScalarArray_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_ScalarArray_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray.Builder.class);
      }

      // Construct using org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (elementBuilder_ == null) {
          element_ = java.util.Collections.emptyList();
        } else {
          element_ = null;
          elementBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_ScalarArray_descriptor;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray getDefaultInstanceForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray.getDefaultInstance();
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray build() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray buildPartial() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray result = new org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray result) {
        if (elementBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            element_ = java.util.Collections.unmodifiableList(element_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.element_ = element_;
        } else {
          result.element_ = elementBuilder_.build();
        }
      }

      private void buildPartial0(org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray) {
          return mergeFrom((org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray other) {
        if (other == org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray.getDefaultInstance()) return this;
        if (elementBuilder_ == null) {
          if (!other.element_.isEmpty()) {
            if (element_.isEmpty()) {
              element_ = other.element_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureElementIsMutable();
              element_.addAll(other.element_);
            }
            onChanged();
          }
        } else {
          if (!other.element_.isEmpty()) {
            if (elementBuilder_.isEmpty()) {
              elementBuilder_.dispose();
              elementBuilder_ = null;
              element_ = other.element_;
              bitField0_ = (bitField0_ & ~0x00000001);
              elementBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getElementFieldBuilder() : null;
            } else {
              elementBuilder_.addAllMessages(other.element_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue m =
                    input.readMessage(
                        org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.parser(),
                        extensionRegistry);
                if (elementBuilder_ == null) {
                  ensureElementIsMutable();
                  element_.add(m);
                } else {
                  elementBuilder_.addMessage(m);
                }
                break;
              } // case 10
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue> element_ =
        java.util.Collections.emptyList();
      private void ensureElementIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          element_ = new java.util.ArrayList<org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue>(element_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue, org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValueOrBuilder> elementBuilder_;

      /**
       * <pre>
       * The set of elements within the array. Each TypedValue message should
       * specify only elements that have a field identifier of 1-7 (i.e., the
       * values are scalar values).
       * </pre>
       *
       * <code>repeated .gnmi.TypedValue element = 1;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue> getElementList() {
        if (elementBuilder_ == null) {
          return java.util.Collections.unmodifiableList(element_);
        } else {
          return elementBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * The set of elements within the array. Each TypedValue message should
       * specify only elements that have a field identifier of 1-7 (i.e., the
       * values are scalar values).
       * </pre>
       *
       * <code>repeated .gnmi.TypedValue element = 1;</code>
       */
      public int getElementCount() {
        if (elementBuilder_ == null) {
          return element_.size();
        } else {
          return elementBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * The set of elements within the array. Each TypedValue message should
       * specify only elements that have a field identifier of 1-7 (i.e., the
       * values are scalar values).
       * </pre>
       *
       * <code>repeated .gnmi.TypedValue element = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue getElement(int index) {
        if (elementBuilder_ == null) {
          return element_.get(index);
        } else {
          return elementBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * The set of elements within the array. Each TypedValue message should
       * specify only elements that have a field identifier of 1-7 (i.e., the
       * values are scalar values).
       * </pre>
       *
       * <code>repeated .gnmi.TypedValue element = 1;</code>
       */
      public Builder setElement(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue value) {
        if (elementBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureElementIsMutable();
          element_.set(index, value);
          onChanged();
        } else {
          elementBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * The set of elements within the array. Each TypedValue message should
       * specify only elements that have a field identifier of 1-7 (i.e., the
       * values are scalar values).
       * </pre>
       *
       * <code>repeated .gnmi.TypedValue element = 1;</code>
       */
      public Builder setElement(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.Builder builderForValue) {
        if (elementBuilder_ == null) {
          ensureElementIsMutable();
          element_.set(index, builderForValue.build());
          onChanged();
        } else {
          elementBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * The set of elements within the array. Each TypedValue message should
       * specify only elements that have a field identifier of 1-7 (i.e., the
       * values are scalar values).
       * </pre>
       *
       * <code>repeated .gnmi.TypedValue element = 1;</code>
       */
      public Builder addElement(org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue value) {
        if (elementBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureElementIsMutable();
          element_.add(value);
          onChanged();
        } else {
          elementBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * The set of elements within the array. Each TypedValue message should
       * specify only elements that have a field identifier of 1-7 (i.e., the
       * values are scalar values).
       * </pre>
       *
       * <code>repeated .gnmi.TypedValue element = 1;</code>
       */
      public Builder addElement(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue value) {
        if (elementBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureElementIsMutable();
          element_.add(index, value);
          onChanged();
        } else {
          elementBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * The set of elements within the array. Each TypedValue message should
       * specify only elements that have a field identifier of 1-7 (i.e., the
       * values are scalar values).
       * </pre>
       *
       * <code>repeated .gnmi.TypedValue element = 1;</code>
       */
      public Builder addElement(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.Builder builderForValue) {
        if (elementBuilder_ == null) {
          ensureElementIsMutable();
          element_.add(builderForValue.build());
          onChanged();
        } else {
          elementBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * The set of elements within the array. Each TypedValue message should
       * specify only elements that have a field identifier of 1-7 (i.e., the
       * values are scalar values).
       * </pre>
       *
       * <code>repeated .gnmi.TypedValue element = 1;</code>
       */
      public Builder addElement(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.Builder builderForValue) {
        if (elementBuilder_ == null) {
          ensureElementIsMutable();
          element_.add(index, builderForValue.build());
          onChanged();
        } else {
          elementBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * The set of elements within the array. Each TypedValue message should
       * specify only elements that have a field identifier of 1-7 (i.e., the
       * values are scalar values).
       * </pre>
       *
       * <code>repeated .gnmi.TypedValue element = 1;</code>
       */
      public Builder addAllElement(
          java.lang.Iterable<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue> values) {
        if (elementBuilder_ == null) {
          ensureElementIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, element_);
          onChanged();
        } else {
          elementBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * The set of elements within the array. Each TypedValue message should
       * specify only elements that have a field identifier of 1-7 (i.e., the
       * values are scalar values).
       * </pre>
       *
       * <code>repeated .gnmi.TypedValue element = 1;</code>
       */
      public Builder clearElement() {
        if (elementBuilder_ == null) {
          element_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          elementBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * The set of elements within the array. Each TypedValue message should
       * specify only elements that have a field identifier of 1-7 (i.e., the
       * values are scalar values).
       * </pre>
       *
       * <code>repeated .gnmi.TypedValue element = 1;</code>
       */
      public Builder removeElement(int index) {
        if (elementBuilder_ == null) {
          ensureElementIsMutable();
          element_.remove(index);
          onChanged();
        } else {
          elementBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * The set of elements within the array. Each TypedValue message should
       * specify only elements that have a field identifier of 1-7 (i.e., the
       * values are scalar values).
       * </pre>
       *
       * <code>repeated .gnmi.TypedValue element = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.Builder getElementBuilder(
          int index) {
        return getElementFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * The set of elements within the array. Each TypedValue message should
       * specify only elements that have a field identifier of 1-7 (i.e., the
       * values are scalar values).
       * </pre>
       *
       * <code>repeated .gnmi.TypedValue element = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValueOrBuilder getElementOrBuilder(
          int index) {
        if (elementBuilder_ == null) {
          return element_.get(index);  } else {
          return elementBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * The set of elements within the array. Each TypedValue message should
       * specify only elements that have a field identifier of 1-7 (i.e., the
       * values are scalar values).
       * </pre>
       *
       * <code>repeated .gnmi.TypedValue element = 1;</code>
       */
      public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValueOrBuilder> 
           getElementOrBuilderList() {
        if (elementBuilder_ != null) {
          return elementBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(element_);
        }
      }
      /**
       * <pre>
       * The set of elements within the array. Each TypedValue message should
       * specify only elements that have a field identifier of 1-7 (i.e., the
       * values are scalar values).
       * </pre>
       *
       * <code>repeated .gnmi.TypedValue element = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.Builder addElementBuilder() {
        return getElementFieldBuilder().addBuilder(
            org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.getDefaultInstance());
      }
      /**
       * <pre>
       * The set of elements within the array. Each TypedValue message should
       * specify only elements that have a field identifier of 1-7 (i.e., the
       * values are scalar values).
       * </pre>
       *
       * <code>repeated .gnmi.TypedValue element = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.Builder addElementBuilder(
          int index) {
        return getElementFieldBuilder().addBuilder(
            index, org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.getDefaultInstance());
      }
      /**
       * <pre>
       * The set of elements within the array. Each TypedValue message should
       * specify only elements that have a field identifier of 1-7 (i.e., the
       * values are scalar values).
       * </pre>
       *
       * <code>repeated .gnmi.TypedValue element = 1;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.Builder> 
           getElementBuilderList() {
        return getElementFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue, org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValueOrBuilder> 
          getElementFieldBuilder() {
        if (elementBuilder_ == null) {
          elementBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue, org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValue.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.TypedValueOrBuilder>(
                  element_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          element_ = null;
        }
        return elementBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:gnmi.ScalarArray)
    }

    // @@protoc_insertion_point(class_scope:gnmi.ScalarArray)
    private static final org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray();
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ScalarArray>
        PARSER = new com.google.protobuf.AbstractParser<ScalarArray>() {
      @java.lang.Override
      public ScalarArray parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<ScalarArray> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ScalarArray> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.ScalarArray getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface SubscribeRequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:gnmi.SubscribeRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Specify the paths within a subscription.
     * </pre>
     *
     * <code>.gnmi.SubscriptionList subscribe = 1;</code>
     * @return Whether the subscribe field is set.
     */
    boolean hasSubscribe();
    /**
     * <pre>
     * Specify the paths within a subscription.
     * </pre>
     *
     * <code>.gnmi.SubscriptionList subscribe = 1;</code>
     * @return The subscribe.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList getSubscribe();
    /**
     * <pre>
     * Specify the paths within a subscription.
     * </pre>
     *
     * <code>.gnmi.SubscriptionList subscribe = 1;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionListOrBuilder getSubscribeOrBuilder();

    /**
     * <pre>
     * Trigger a polled update.
     * </pre>
     *
     * <code>.gnmi.Poll poll = 3;</code>
     * @return Whether the poll field is set.
     */
    boolean hasPoll();
    /**
     * <pre>
     * Trigger a polled update.
     * </pre>
     *
     * <code>.gnmi.Poll poll = 3;</code>
     * @return The poll.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll getPoll();
    /**
     * <pre>
     * Trigger a polled update.
     * </pre>
     *
     * <code>.gnmi.Poll poll = 3;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.PollOrBuilder getPollOrBuilder();

    /**
     * <pre>
     * Aliases to be created.
     * </pre>
     *
     * <code>.gnmi.AliasList aliases = 4;</code>
     * @return Whether the aliases field is set.
     */
    boolean hasAliases();
    /**
     * <pre>
     * Aliases to be created.
     * </pre>
     *
     * <code>.gnmi.AliasList aliases = 4;</code>
     * @return The aliases.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList getAliases();
    /**
     * <pre>
     * Aliases to be created.
     * </pre>
     *
     * <code>.gnmi.AliasList aliases = 4;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasListOrBuilder getAliasesOrBuilder();

    /**
     * <pre>
     * Extension messages associated with the SubscribeRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> 
        getExtensionList();
    /**
     * <pre>
     * Extension messages associated with the SubscribeRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension getExtension(int index);
    /**
     * <pre>
     * Extension messages associated with the SubscribeRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    int getExtensionCount();
    /**
     * <pre>
     * Extension messages associated with the SubscribeRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> 
        getExtensionOrBuilderList();
    /**
     * <pre>
     * Extension messages associated with the SubscribeRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder getExtensionOrBuilder(
        int index);

    org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest.RequestCase getRequestCase();
  }
  /**
   * <pre>
   * SubscribeRequest is the message sent by the client to the target when
   * initiating a subscription to a set of paths within the data tree. The
   * request field must be populated and the initial message must specify a
   * SubscriptionList to initiate a subscription. The message is subsequently
   * used to define aliases or trigger polled data to be sent by the target.
   * Reference: gNMI Specification Section 3.5.1.1
   * </pre>
   *
   * Protobuf type {@code gnmi.SubscribeRequest}
   */
  public static final class SubscribeRequest extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:gnmi.SubscribeRequest)
      SubscribeRequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use SubscribeRequest.newBuilder() to construct.
    private SubscribeRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private SubscribeRequest() {
      extension_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new SubscribeRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SubscribeRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SubscribeRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest.Builder.class);
    }

    private int requestCase_ = 0;
    @SuppressWarnings("serial")
    private java.lang.Object request_;
    public enum RequestCase
        implements com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      SUBSCRIBE(1),
      POLL(3),
      ALIASES(4),
      REQUEST_NOT_SET(0);
      private final int value;
      private RequestCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static RequestCase valueOf(int value) {
        return forNumber(value);
      }

      public static RequestCase forNumber(int value) {
        switch (value) {
          case 1: return SUBSCRIBE;
          case 3: return POLL;
          case 4: return ALIASES;
          case 0: return REQUEST_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public RequestCase
    getRequestCase() {
      return RequestCase.forNumber(
          requestCase_);
    }

    public static final int SUBSCRIBE_FIELD_NUMBER = 1;
    /**
     * <pre>
     * Specify the paths within a subscription.
     * </pre>
     *
     * <code>.gnmi.SubscriptionList subscribe = 1;</code>
     * @return Whether the subscribe field is set.
     */
    @java.lang.Override
    public boolean hasSubscribe() {
      return requestCase_ == 1;
    }
    /**
     * <pre>
     * Specify the paths within a subscription.
     * </pre>
     *
     * <code>.gnmi.SubscriptionList subscribe = 1;</code>
     * @return The subscribe.
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList getSubscribe() {
      if (requestCase_ == 1) {
         return (org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList) request_;
      }
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.getDefaultInstance();
    }
    /**
     * <pre>
     * Specify the paths within a subscription.
     * </pre>
     *
     * <code>.gnmi.SubscriptionList subscribe = 1;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionListOrBuilder getSubscribeOrBuilder() {
      if (requestCase_ == 1) {
         return (org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList) request_;
      }
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.getDefaultInstance();
    }

    public static final int POLL_FIELD_NUMBER = 3;
    /**
     * <pre>
     * Trigger a polled update.
     * </pre>
     *
     * <code>.gnmi.Poll poll = 3;</code>
     * @return Whether the poll field is set.
     */
    @java.lang.Override
    public boolean hasPoll() {
      return requestCase_ == 3;
    }
    /**
     * <pre>
     * Trigger a polled update.
     * </pre>
     *
     * <code>.gnmi.Poll poll = 3;</code>
     * @return The poll.
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll getPoll() {
      if (requestCase_ == 3) {
         return (org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll) request_;
      }
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll.getDefaultInstance();
    }
    /**
     * <pre>
     * Trigger a polled update.
     * </pre>
     *
     * <code>.gnmi.Poll poll = 3;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.PollOrBuilder getPollOrBuilder() {
      if (requestCase_ == 3) {
         return (org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll) request_;
      }
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll.getDefaultInstance();
    }

    public static final int ALIASES_FIELD_NUMBER = 4;
    /**
     * <pre>
     * Aliases to be created.
     * </pre>
     *
     * <code>.gnmi.AliasList aliases = 4;</code>
     * @return Whether the aliases field is set.
     */
    @java.lang.Override
    public boolean hasAliases() {
      return requestCase_ == 4;
    }
    /**
     * <pre>
     * Aliases to be created.
     * </pre>
     *
     * <code>.gnmi.AliasList aliases = 4;</code>
     * @return The aliases.
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList getAliases() {
      if (requestCase_ == 4) {
         return (org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList) request_;
      }
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList.getDefaultInstance();
    }
    /**
     * <pre>
     * Aliases to be created.
     * </pre>
     *
     * <code>.gnmi.AliasList aliases = 4;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasListOrBuilder getAliasesOrBuilder() {
      if (requestCase_ == 4) {
         return (org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList) request_;
      }
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList.getDefaultInstance();
    }

    public static final int EXTENSION_FIELD_NUMBER = 5;
    @SuppressWarnings("serial")
    private java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> extension_;
    /**
     * <pre>
     * Extension messages associated with the SubscribeRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    @java.lang.Override
    public java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> getExtensionList() {
      return extension_;
    }
    /**
     * <pre>
     * Extension messages associated with the SubscribeRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> 
        getExtensionOrBuilderList() {
      return extension_;
    }
    /**
     * <pre>
     * Extension messages associated with the SubscribeRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    @java.lang.Override
    public int getExtensionCount() {
      return extension_.size();
    }
    /**
     * <pre>
     * Extension messages associated with the SubscribeRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension getExtension(int index) {
      return extension_.get(index);
    }
    /**
     * <pre>
     * Extension messages associated with the SubscribeRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder getExtensionOrBuilder(
        int index) {
      return extension_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (requestCase_ == 1) {
        output.writeMessage(1, (org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList) request_);
      }
      if (requestCase_ == 3) {
        output.writeMessage(3, (org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll) request_);
      }
      if (requestCase_ == 4) {
        output.writeMessage(4, (org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList) request_);
      }
      for (int i = 0; i < extension_.size(); i++) {
        output.writeMessage(5, extension_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (requestCase_ == 1) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, (org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList) request_);
      }
      if (requestCase_ == 3) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, (org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll) request_);
      }
      if (requestCase_ == 4) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, (org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList) request_);
      }
      for (int i = 0; i < extension_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, extension_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest)) {
        return super.equals(obj);
      }
      org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest other = (org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest) obj;

      if (!getExtensionList()
          .equals(other.getExtensionList())) return false;
      if (!getRequestCase().equals(other.getRequestCase())) return false;
      switch (requestCase_) {
        case 1:
          if (!getSubscribe()
              .equals(other.getSubscribe())) return false;
          break;
        case 3:
          if (!getPoll()
              .equals(other.getPoll())) return false;
          break;
        case 4:
          if (!getAliases()
              .equals(other.getAliases())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getExtensionCount() > 0) {
        hash = (37 * hash) + EXTENSION_FIELD_NUMBER;
        hash = (53 * hash) + getExtensionList().hashCode();
      }
      switch (requestCase_) {
        case 1:
          hash = (37 * hash) + SUBSCRIBE_FIELD_NUMBER;
          hash = (53 * hash) + getSubscribe().hashCode();
          break;
        case 3:
          hash = (37 * hash) + POLL_FIELD_NUMBER;
          hash = (53 * hash) + getPoll().hashCode();
          break;
        case 4:
          hash = (37 * hash) + ALIASES_FIELD_NUMBER;
          hash = (53 * hash) + getAliases().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * SubscribeRequest is the message sent by the client to the target when
     * initiating a subscription to a set of paths within the data tree. The
     * request field must be populated and the initial message must specify a
     * SubscriptionList to initiate a subscription. The message is subsequently
     * used to define aliases or trigger polled data to be sent by the target.
     * Reference: gNMI Specification Section 3.5.1.1
     * </pre>
     *
     * Protobuf type {@code gnmi.SubscribeRequest}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:gnmi.SubscribeRequest)
        org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SubscribeRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SubscribeRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest.Builder.class);
      }

      // Construct using org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (subscribeBuilder_ != null) {
          subscribeBuilder_.clear();
        }
        if (pollBuilder_ != null) {
          pollBuilder_.clear();
        }
        if (aliasesBuilder_ != null) {
          aliasesBuilder_.clear();
        }
        if (extensionBuilder_ == null) {
          extension_ = java.util.Collections.emptyList();
        } else {
          extension_ = null;
          extensionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        requestCase_ = 0;
        request_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SubscribeRequest_descriptor;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest getDefaultInstanceForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest.getDefaultInstance();
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest build() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest buildPartial() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest result = new org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest result) {
        if (extensionBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            extension_ = java.util.Collections.unmodifiableList(extension_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.extension_ = extension_;
        } else {
          result.extension_ = extensionBuilder_.build();
        }
      }

      private void buildPartial0(org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest result) {
        result.requestCase_ = requestCase_;
        result.request_ = this.request_;
        if (requestCase_ == 1 &&
            subscribeBuilder_ != null) {
          result.request_ = subscribeBuilder_.build();
        }
        if (requestCase_ == 3 &&
            pollBuilder_ != null) {
          result.request_ = pollBuilder_.build();
        }
        if (requestCase_ == 4 &&
            aliasesBuilder_ != null) {
          result.request_ = aliasesBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest) {
          return mergeFrom((org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest other) {
        if (other == org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest.getDefaultInstance()) return this;
        if (extensionBuilder_ == null) {
          if (!other.extension_.isEmpty()) {
            if (extension_.isEmpty()) {
              extension_ = other.extension_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureExtensionIsMutable();
              extension_.addAll(other.extension_);
            }
            onChanged();
          }
        } else {
          if (!other.extension_.isEmpty()) {
            if (extensionBuilder_.isEmpty()) {
              extensionBuilder_.dispose();
              extensionBuilder_ = null;
              extension_ = other.extension_;
              bitField0_ = (bitField0_ & ~0x00000008);
              extensionBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getExtensionFieldBuilder() : null;
            } else {
              extensionBuilder_.addAllMessages(other.extension_);
            }
          }
        }
        switch (other.getRequestCase()) {
          case SUBSCRIBE: {
            mergeSubscribe(other.getSubscribe());
            break;
          }
          case POLL: {
            mergePoll(other.getPoll());
            break;
          }
          case ALIASES: {
            mergeAliases(other.getAliases());
            break;
          }
          case REQUEST_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getSubscribeFieldBuilder().getBuilder(),
                    extensionRegistry);
                requestCase_ = 1;
                break;
              } // case 10
              case 26: {
                input.readMessage(
                    getPollFieldBuilder().getBuilder(),
                    extensionRegistry);
                requestCase_ = 3;
                break;
              } // case 26
              case 34: {
                input.readMessage(
                    getAliasesFieldBuilder().getBuilder(),
                    extensionRegistry);
                requestCase_ = 4;
                break;
              } // case 34
              case 42: {
                org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension m =
                    input.readMessage(
                        org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.parser(),
                        extensionRegistry);
                if (extensionBuilder_ == null) {
                  ensureExtensionIsMutable();
                  extension_.add(m);
                } else {
                  extensionBuilder_.addMessage(m);
                }
                break;
              } // case 42
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int requestCase_ = 0;
      private java.lang.Object request_;
      public RequestCase
          getRequestCase() {
        return RequestCase.forNumber(
            requestCase_);
      }

      public Builder clearRequest() {
        requestCase_ = 0;
        request_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList, org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionListOrBuilder> subscribeBuilder_;
      /**
       * <pre>
       * Specify the paths within a subscription.
       * </pre>
       *
       * <code>.gnmi.SubscriptionList subscribe = 1;</code>
       * @return Whether the subscribe field is set.
       */
      @java.lang.Override
      public boolean hasSubscribe() {
        return requestCase_ == 1;
      }
      /**
       * <pre>
       * Specify the paths within a subscription.
       * </pre>
       *
       * <code>.gnmi.SubscriptionList subscribe = 1;</code>
       * @return The subscribe.
       */
      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList getSubscribe() {
        if (subscribeBuilder_ == null) {
          if (requestCase_ == 1) {
            return (org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList) request_;
          }
          return org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.getDefaultInstance();
        } else {
          if (requestCase_ == 1) {
            return subscribeBuilder_.getMessage();
          }
          return org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Specify the paths within a subscription.
       * </pre>
       *
       * <code>.gnmi.SubscriptionList subscribe = 1;</code>
       */
      public Builder setSubscribe(org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList value) {
        if (subscribeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          request_ = value;
          onChanged();
        } else {
          subscribeBuilder_.setMessage(value);
        }
        requestCase_ = 1;
        return this;
      }
      /**
       * <pre>
       * Specify the paths within a subscription.
       * </pre>
       *
       * <code>.gnmi.SubscriptionList subscribe = 1;</code>
       */
      public Builder setSubscribe(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.Builder builderForValue) {
        if (subscribeBuilder_ == null) {
          request_ = builderForValue.build();
          onChanged();
        } else {
          subscribeBuilder_.setMessage(builderForValue.build());
        }
        requestCase_ = 1;
        return this;
      }
      /**
       * <pre>
       * Specify the paths within a subscription.
       * </pre>
       *
       * <code>.gnmi.SubscriptionList subscribe = 1;</code>
       */
      public Builder mergeSubscribe(org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList value) {
        if (subscribeBuilder_ == null) {
          if (requestCase_ == 1 &&
              request_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.getDefaultInstance()) {
            request_ = org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.newBuilder((org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList) request_)
                .mergeFrom(value).buildPartial();
          } else {
            request_ = value;
          }
          onChanged();
        } else {
          if (requestCase_ == 1) {
            subscribeBuilder_.mergeFrom(value);
          } else {
            subscribeBuilder_.setMessage(value);
          }
        }
        requestCase_ = 1;
        return this;
      }
      /**
       * <pre>
       * Specify the paths within a subscription.
       * </pre>
       *
       * <code>.gnmi.SubscriptionList subscribe = 1;</code>
       */
      public Builder clearSubscribe() {
        if (subscribeBuilder_ == null) {
          if (requestCase_ == 1) {
            requestCase_ = 0;
            request_ = null;
            onChanged();
          }
        } else {
          if (requestCase_ == 1) {
            requestCase_ = 0;
            request_ = null;
          }
          subscribeBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Specify the paths within a subscription.
       * </pre>
       *
       * <code>.gnmi.SubscriptionList subscribe = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.Builder getSubscribeBuilder() {
        return getSubscribeFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specify the paths within a subscription.
       * </pre>
       *
       * <code>.gnmi.SubscriptionList subscribe = 1;</code>
       */
      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionListOrBuilder getSubscribeOrBuilder() {
        if ((requestCase_ == 1) && (subscribeBuilder_ != null)) {
          return subscribeBuilder_.getMessageOrBuilder();
        } else {
          if (requestCase_ == 1) {
            return (org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList) request_;
          }
          return org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Specify the paths within a subscription.
       * </pre>
       *
       * <code>.gnmi.SubscriptionList subscribe = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList, org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionListOrBuilder> 
          getSubscribeFieldBuilder() {
        if (subscribeBuilder_ == null) {
          if (!(requestCase_ == 1)) {
            request_ = org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.getDefaultInstance();
          }
          subscribeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList, org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionListOrBuilder>(
                  (org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList) request_,
                  getParentForChildren(),
                  isClean());
          request_ = null;
        }
        requestCase_ = 1;
        onChanged();
        return subscribeBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll, org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PollOrBuilder> pollBuilder_;
      /**
       * <pre>
       * Trigger a polled update.
       * </pre>
       *
       * <code>.gnmi.Poll poll = 3;</code>
       * @return Whether the poll field is set.
       */
      @java.lang.Override
      public boolean hasPoll() {
        return requestCase_ == 3;
      }
      /**
       * <pre>
       * Trigger a polled update.
       * </pre>
       *
       * <code>.gnmi.Poll poll = 3;</code>
       * @return The poll.
       */
      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll getPoll() {
        if (pollBuilder_ == null) {
          if (requestCase_ == 3) {
            return (org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll) request_;
          }
          return org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll.getDefaultInstance();
        } else {
          if (requestCase_ == 3) {
            return pollBuilder_.getMessage();
          }
          return org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Trigger a polled update.
       * </pre>
       *
       * <code>.gnmi.Poll poll = 3;</code>
       */
      public Builder setPoll(org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll value) {
        if (pollBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          request_ = value;
          onChanged();
        } else {
          pollBuilder_.setMessage(value);
        }
        requestCase_ = 3;
        return this;
      }
      /**
       * <pre>
       * Trigger a polled update.
       * </pre>
       *
       * <code>.gnmi.Poll poll = 3;</code>
       */
      public Builder setPoll(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll.Builder builderForValue) {
        if (pollBuilder_ == null) {
          request_ = builderForValue.build();
          onChanged();
        } else {
          pollBuilder_.setMessage(builderForValue.build());
        }
        requestCase_ = 3;
        return this;
      }
      /**
       * <pre>
       * Trigger a polled update.
       * </pre>
       *
       * <code>.gnmi.Poll poll = 3;</code>
       */
      public Builder mergePoll(org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll value) {
        if (pollBuilder_ == null) {
          if (requestCase_ == 3 &&
              request_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll.getDefaultInstance()) {
            request_ = org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll.newBuilder((org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll) request_)
                .mergeFrom(value).buildPartial();
          } else {
            request_ = value;
          }
          onChanged();
        } else {
          if (requestCase_ == 3) {
            pollBuilder_.mergeFrom(value);
          } else {
            pollBuilder_.setMessage(value);
          }
        }
        requestCase_ = 3;
        return this;
      }
      /**
       * <pre>
       * Trigger a polled update.
       * </pre>
       *
       * <code>.gnmi.Poll poll = 3;</code>
       */
      public Builder clearPoll() {
        if (pollBuilder_ == null) {
          if (requestCase_ == 3) {
            requestCase_ = 0;
            request_ = null;
            onChanged();
          }
        } else {
          if (requestCase_ == 3) {
            requestCase_ = 0;
            request_ = null;
          }
          pollBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Trigger a polled update.
       * </pre>
       *
       * <code>.gnmi.Poll poll = 3;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll.Builder getPollBuilder() {
        return getPollFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Trigger a polled update.
       * </pre>
       *
       * <code>.gnmi.Poll poll = 3;</code>
       */
      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.PollOrBuilder getPollOrBuilder() {
        if ((requestCase_ == 3) && (pollBuilder_ != null)) {
          return pollBuilder_.getMessageOrBuilder();
        } else {
          if (requestCase_ == 3) {
            return (org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll) request_;
          }
          return org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Trigger a polled update.
       * </pre>
       *
       * <code>.gnmi.Poll poll = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll, org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PollOrBuilder> 
          getPollFieldBuilder() {
        if (pollBuilder_ == null) {
          if (!(requestCase_ == 3)) {
            request_ = org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll.getDefaultInstance();
          }
          pollBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll, org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PollOrBuilder>(
                  (org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll) request_,
                  getParentForChildren(),
                  isClean());
          request_ = null;
        }
        requestCase_ = 3;
        onChanged();
        return pollBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList, org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasListOrBuilder> aliasesBuilder_;
      /**
       * <pre>
       * Aliases to be created.
       * </pre>
       *
       * <code>.gnmi.AliasList aliases = 4;</code>
       * @return Whether the aliases field is set.
       */
      @java.lang.Override
      public boolean hasAliases() {
        return requestCase_ == 4;
      }
      /**
       * <pre>
       * Aliases to be created.
       * </pre>
       *
       * <code>.gnmi.AliasList aliases = 4;</code>
       * @return The aliases.
       */
      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList getAliases() {
        if (aliasesBuilder_ == null) {
          if (requestCase_ == 4) {
            return (org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList) request_;
          }
          return org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList.getDefaultInstance();
        } else {
          if (requestCase_ == 4) {
            return aliasesBuilder_.getMessage();
          }
          return org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Aliases to be created.
       * </pre>
       *
       * <code>.gnmi.AliasList aliases = 4;</code>
       */
      public Builder setAliases(org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList value) {
        if (aliasesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          request_ = value;
          onChanged();
        } else {
          aliasesBuilder_.setMessage(value);
        }
        requestCase_ = 4;
        return this;
      }
      /**
       * <pre>
       * Aliases to be created.
       * </pre>
       *
       * <code>.gnmi.AliasList aliases = 4;</code>
       */
      public Builder setAliases(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList.Builder builderForValue) {
        if (aliasesBuilder_ == null) {
          request_ = builderForValue.build();
          onChanged();
        } else {
          aliasesBuilder_.setMessage(builderForValue.build());
        }
        requestCase_ = 4;
        return this;
      }
      /**
       * <pre>
       * Aliases to be created.
       * </pre>
       *
       * <code>.gnmi.AliasList aliases = 4;</code>
       */
      public Builder mergeAliases(org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList value) {
        if (aliasesBuilder_ == null) {
          if (requestCase_ == 4 &&
              request_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList.getDefaultInstance()) {
            request_ = org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList.newBuilder((org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList) request_)
                .mergeFrom(value).buildPartial();
          } else {
            request_ = value;
          }
          onChanged();
        } else {
          if (requestCase_ == 4) {
            aliasesBuilder_.mergeFrom(value);
          } else {
            aliasesBuilder_.setMessage(value);
          }
        }
        requestCase_ = 4;
        return this;
      }
      /**
       * <pre>
       * Aliases to be created.
       * </pre>
       *
       * <code>.gnmi.AliasList aliases = 4;</code>
       */
      public Builder clearAliases() {
        if (aliasesBuilder_ == null) {
          if (requestCase_ == 4) {
            requestCase_ = 0;
            request_ = null;
            onChanged();
          }
        } else {
          if (requestCase_ == 4) {
            requestCase_ = 0;
            request_ = null;
          }
          aliasesBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Aliases to be created.
       * </pre>
       *
       * <code>.gnmi.AliasList aliases = 4;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList.Builder getAliasesBuilder() {
        return getAliasesFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Aliases to be created.
       * </pre>
       *
       * <code>.gnmi.AliasList aliases = 4;</code>
       */
      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasListOrBuilder getAliasesOrBuilder() {
        if ((requestCase_ == 4) && (aliasesBuilder_ != null)) {
          return aliasesBuilder_.getMessageOrBuilder();
        } else {
          if (requestCase_ == 4) {
            return (org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList) request_;
          }
          return org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Aliases to be created.
       * </pre>
       *
       * <code>.gnmi.AliasList aliases = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList, org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasListOrBuilder> 
          getAliasesFieldBuilder() {
        if (aliasesBuilder_ == null) {
          if (!(requestCase_ == 4)) {
            request_ = org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList.getDefaultInstance();
          }
          aliasesBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList, org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasListOrBuilder>(
                  (org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList) request_,
                  getParentForChildren(),
                  isClean());
          request_ = null;
        }
        requestCase_ = 4;
        onChanged();
        return aliasesBuilder_;
      }

      private java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> extension_ =
        java.util.Collections.emptyList();
      private void ensureExtensionIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          extension_ = new java.util.ArrayList<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension>(extension_);
          bitField0_ |= 0x00000008;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder, org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> extensionBuilder_;

      /**
       * <pre>
       * Extension messages associated with the SubscribeRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> getExtensionList() {
        if (extensionBuilder_ == null) {
          return java.util.Collections.unmodifiableList(extension_);
        } else {
          return extensionBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public int getExtensionCount() {
        if (extensionBuilder_ == null) {
          return extension_.size();
        } else {
          return extensionBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension getExtension(int index) {
        if (extensionBuilder_ == null) {
          return extension_.get(index);
        } else {
          return extensionBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder setExtension(
          int index, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension value) {
        if (extensionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureExtensionIsMutable();
          extension_.set(index, value);
          onChanged();
        } else {
          extensionBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder setExtension(
          int index, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder builderForValue) {
        if (extensionBuilder_ == null) {
          ensureExtensionIsMutable();
          extension_.set(index, builderForValue.build());
          onChanged();
        } else {
          extensionBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder addExtension(org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension value) {
        if (extensionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureExtensionIsMutable();
          extension_.add(value);
          onChanged();
        } else {
          extensionBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder addExtension(
          int index, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension value) {
        if (extensionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureExtensionIsMutable();
          extension_.add(index, value);
          onChanged();
        } else {
          extensionBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder addExtension(
          org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder builderForValue) {
        if (extensionBuilder_ == null) {
          ensureExtensionIsMutable();
          extension_.add(builderForValue.build());
          onChanged();
        } else {
          extensionBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder addExtension(
          int index, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder builderForValue) {
        if (extensionBuilder_ == null) {
          ensureExtensionIsMutable();
          extension_.add(index, builderForValue.build());
          onChanged();
        } else {
          extensionBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder addAllExtension(
          java.lang.Iterable<? extends org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> values) {
        if (extensionBuilder_ == null) {
          ensureExtensionIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, extension_);
          onChanged();
        } else {
          extensionBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder clearExtension() {
        if (extensionBuilder_ == null) {
          extension_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          extensionBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder removeExtension(int index) {
        if (extensionBuilder_ == null) {
          ensureExtensionIsMutable();
          extension_.remove(index);
          onChanged();
        } else {
          extensionBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder getExtensionBuilder(
          int index) {
        return getExtensionFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder getExtensionOrBuilder(
          int index) {
        if (extensionBuilder_ == null) {
          return extension_.get(index);  } else {
          return extensionBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> 
           getExtensionOrBuilderList() {
        if (extensionBuilder_ != null) {
          return extensionBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(extension_);
        }
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder addExtensionBuilder() {
        return getExtensionFieldBuilder().addBuilder(
            org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.getDefaultInstance());
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder addExtensionBuilder(
          int index) {
        return getExtensionFieldBuilder().addBuilder(
            index, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.getDefaultInstance());
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder> 
           getExtensionBuilderList() {
        return getExtensionFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder, org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> 
          getExtensionFieldBuilder() {
        if (extensionBuilder_ == null) {
          extensionBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder, org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder>(
                  extension_,
                  ((bitField0_ & 0x00000008) != 0),
                  getParentForChildren(),
                  isClean());
          extension_ = null;
        }
        return extensionBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:gnmi.SubscribeRequest)
    }

    // @@protoc_insertion_point(class_scope:gnmi.SubscribeRequest)
    private static final org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest();
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SubscribeRequest>
        PARSER = new com.google.protobuf.AbstractParser<SubscribeRequest>() {
      @java.lang.Override
      public SubscribeRequest parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<SubscribeRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SubscribeRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeRequest getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface PollOrBuilder extends
      // @@protoc_insertion_point(interface_extends:gnmi.Poll)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * <pre>
   * Poll is sent within a SubscribeRequest to trigger the device to
   * send telemetry updates for the paths that are associated with the
   * subscription.
   * Reference: gNMI Specification Section Section 3.5.1.4
   * </pre>
   *
   * Protobuf type {@code gnmi.Poll}
   */
  public static final class Poll extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:gnmi.Poll)
      PollOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Poll.newBuilder() to construct.
    private Poll(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Poll() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Poll();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Poll_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Poll_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll.Builder.class);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll)) {
        return super.equals(obj);
      }
      org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll other = (org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Poll is sent within a SubscribeRequest to trigger the device to
     * send telemetry updates for the paths that are associated with the
     * subscription.
     * Reference: gNMI Specification Section Section 3.5.1.4
     * </pre>
     *
     * Protobuf type {@code gnmi.Poll}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:gnmi.Poll)
        org.opennms.features.openconfig.proto.gnmi.Gnmi.PollOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Poll_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Poll_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll.Builder.class);
      }

      // Construct using org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Poll_descriptor;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll getDefaultInstanceForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll.getDefaultInstance();
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll build() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll buildPartial() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll result = new org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll) {
          return mergeFrom((org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll other) {
        if (other == org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:gnmi.Poll)
    }

    // @@protoc_insertion_point(class_scope:gnmi.Poll)
    private static final org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll();
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Poll>
        PARSER = new com.google.protobuf.AbstractParser<Poll>() {
      @java.lang.Override
      public Poll parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Poll> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Poll> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Poll getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface SubscribeResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:gnmi.SubscribeResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Changed or sampled value for a path.
     * </pre>
     *
     * <code>.gnmi.Notification update = 1;</code>
     * @return Whether the update field is set.
     */
    boolean hasUpdate();
    /**
     * <pre>
     * Changed or sampled value for a path.
     * </pre>
     *
     * <code>.gnmi.Notification update = 1;</code>
     * @return The update.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification getUpdate();
    /**
     * <pre>
     * Changed or sampled value for a path.
     * </pre>
     *
     * <code>.gnmi.Notification update = 1;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.NotificationOrBuilder getUpdateOrBuilder();

    /**
     * <pre>
     * Indicate target has sent all values associated with the subscription
     * at least once.
     * </pre>
     *
     * <code>bool sync_response = 3;</code>
     * @return Whether the syncResponse field is set.
     */
    boolean hasSyncResponse();
    /**
     * <pre>
     * Indicate target has sent all values associated with the subscription
     * at least once.
     * </pre>
     *
     * <code>bool sync_response = 3;</code>
     * @return The syncResponse.
     */
    boolean getSyncResponse();

    /**
     * <pre>
     * Deprecated in favour of google.golang.org/genproto/googleapis/rpc/status
     * </pre>
     *
     * <code>.gnmi.Error error = 4 [deprecated = true];</code>
     * @deprecated gnmi.SubscribeResponse.error is deprecated.
     *     See gnmi.proto;l=239
     * @return Whether the error field is set.
     */
    @java.lang.Deprecated boolean hasError();
    /**
     * <pre>
     * Deprecated in favour of google.golang.org/genproto/googleapis/rpc/status
     * </pre>
     *
     * <code>.gnmi.Error error = 4 [deprecated = true];</code>
     * @deprecated gnmi.SubscribeResponse.error is deprecated.
     *     See gnmi.proto;l=239
     * @return The error.
     */
    @java.lang.Deprecated org.opennms.features.openconfig.proto.gnmi.Gnmi.Error getError();
    /**
     * <pre>
     * Deprecated in favour of google.golang.org/genproto/googleapis/rpc/status
     * </pre>
     *
     * <code>.gnmi.Error error = 4 [deprecated = true];</code>
     */
    @java.lang.Deprecated org.opennms.features.openconfig.proto.gnmi.Gnmi.ErrorOrBuilder getErrorOrBuilder();

    /**
     * <pre>
     * Extension messages associated with the SubscribeResponse. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> 
        getExtensionList();
    /**
     * <pre>
     * Extension messages associated with the SubscribeResponse. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension getExtension(int index);
    /**
     * <pre>
     * Extension messages associated with the SubscribeResponse. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    int getExtensionCount();
    /**
     * <pre>
     * Extension messages associated with the SubscribeResponse. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> 
        getExtensionOrBuilderList();
    /**
     * <pre>
     * Extension messages associated with the SubscribeResponse. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder getExtensionOrBuilder(
        int index);

    org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse.ResponseCase getResponseCase();
  }
  /**
   * <pre>
   * SubscribeResponse is the message used by the target within a Subscribe RPC.
   * The target includes a Notification message which is used to transmit values
   * of the path(s) that are associated with the subscription. The same message
   * is to indicate that the target has sent all data values once (is
   * synchronized).
   * Reference: gNMI Specification Section 3.5.1.4
   * </pre>
   *
   * Protobuf type {@code gnmi.SubscribeResponse}
   */
  public static final class SubscribeResponse extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:gnmi.SubscribeResponse)
      SubscribeResponseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use SubscribeResponse.newBuilder() to construct.
    private SubscribeResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private SubscribeResponse() {
      extension_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new SubscribeResponse();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SubscribeResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SubscribeResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse.Builder.class);
    }

    private int responseCase_ = 0;
    @SuppressWarnings("serial")
    private java.lang.Object response_;
    public enum ResponseCase
        implements com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      UPDATE(1),
      SYNC_RESPONSE(3),
      @java.lang.Deprecated ERROR(4),
      RESPONSE_NOT_SET(0);
      private final int value;
      private ResponseCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ResponseCase valueOf(int value) {
        return forNumber(value);
      }

      public static ResponseCase forNumber(int value) {
        switch (value) {
          case 1: return UPDATE;
          case 3: return SYNC_RESPONSE;
          case 4: return ERROR;
          case 0: return RESPONSE_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public ResponseCase
    getResponseCase() {
      return ResponseCase.forNumber(
          responseCase_);
    }

    public static final int UPDATE_FIELD_NUMBER = 1;
    /**
     * <pre>
     * Changed or sampled value for a path.
     * </pre>
     *
     * <code>.gnmi.Notification update = 1;</code>
     * @return Whether the update field is set.
     */
    @java.lang.Override
    public boolean hasUpdate() {
      return responseCase_ == 1;
    }
    /**
     * <pre>
     * Changed or sampled value for a path.
     * </pre>
     *
     * <code>.gnmi.Notification update = 1;</code>
     * @return The update.
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification getUpdate() {
      if (responseCase_ == 1) {
         return (org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification) response_;
      }
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification.getDefaultInstance();
    }
    /**
     * <pre>
     * Changed or sampled value for a path.
     * </pre>
     *
     * <code>.gnmi.Notification update = 1;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.NotificationOrBuilder getUpdateOrBuilder() {
      if (responseCase_ == 1) {
         return (org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification) response_;
      }
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification.getDefaultInstance();
    }

    public static final int SYNC_RESPONSE_FIELD_NUMBER = 3;
    /**
     * <pre>
     * Indicate target has sent all values associated with the subscription
     * at least once.
     * </pre>
     *
     * <code>bool sync_response = 3;</code>
     * @return Whether the syncResponse field is set.
     */
    @java.lang.Override
    public boolean hasSyncResponse() {
      return responseCase_ == 3;
    }
    /**
     * <pre>
     * Indicate target has sent all values associated with the subscription
     * at least once.
     * </pre>
     *
     * <code>bool sync_response = 3;</code>
     * @return The syncResponse.
     */
    @java.lang.Override
    public boolean getSyncResponse() {
      if (responseCase_ == 3) {
        return (java.lang.Boolean) response_;
      }
      return false;
    }

    public static final int ERROR_FIELD_NUMBER = 4;
    /**
     * <pre>
     * Deprecated in favour of google.golang.org/genproto/googleapis/rpc/status
     * </pre>
     *
     * <code>.gnmi.Error error = 4 [deprecated = true];</code>
     * @deprecated gnmi.SubscribeResponse.error is deprecated.
     *     See gnmi.proto;l=239
     * @return Whether the error field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated public boolean hasError() {
      return responseCase_ == 4;
    }
    /**
     * <pre>
     * Deprecated in favour of google.golang.org/genproto/googleapis/rpc/status
     * </pre>
     *
     * <code>.gnmi.Error error = 4 [deprecated = true];</code>
     * @deprecated gnmi.SubscribeResponse.error is deprecated.
     *     See gnmi.proto;l=239
     * @return The error.
     */
    @java.lang.Override
    @java.lang.Deprecated public org.opennms.features.openconfig.proto.gnmi.Gnmi.Error getError() {
      if (responseCase_ == 4) {
         return (org.opennms.features.openconfig.proto.gnmi.Gnmi.Error) response_;
      }
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.getDefaultInstance();
    }
    /**
     * <pre>
     * Deprecated in favour of google.golang.org/genproto/googleapis/rpc/status
     * </pre>
     *
     * <code>.gnmi.Error error = 4 [deprecated = true];</code>
     */
    @java.lang.Override
    @java.lang.Deprecated public org.opennms.features.openconfig.proto.gnmi.Gnmi.ErrorOrBuilder getErrorOrBuilder() {
      if (responseCase_ == 4) {
         return (org.opennms.features.openconfig.proto.gnmi.Gnmi.Error) response_;
      }
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.getDefaultInstance();
    }

    public static final int EXTENSION_FIELD_NUMBER = 5;
    @SuppressWarnings("serial")
    private java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> extension_;
    /**
     * <pre>
     * Extension messages associated with the SubscribeResponse. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    @java.lang.Override
    public java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> getExtensionList() {
      return extension_;
    }
    /**
     * <pre>
     * Extension messages associated with the SubscribeResponse. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> 
        getExtensionOrBuilderList() {
      return extension_;
    }
    /**
     * <pre>
     * Extension messages associated with the SubscribeResponse. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    @java.lang.Override
    public int getExtensionCount() {
      return extension_.size();
    }
    /**
     * <pre>
     * Extension messages associated with the SubscribeResponse. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension getExtension(int index) {
      return extension_.get(index);
    }
    /**
     * <pre>
     * Extension messages associated with the SubscribeResponse. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder getExtensionOrBuilder(
        int index) {
      return extension_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (responseCase_ == 1) {
        output.writeMessage(1, (org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification) response_);
      }
      if (responseCase_ == 3) {
        output.writeBool(
            3, (boolean)((java.lang.Boolean) response_));
      }
      if (responseCase_ == 4) {
        output.writeMessage(4, (org.opennms.features.openconfig.proto.gnmi.Gnmi.Error) response_);
      }
      for (int i = 0; i < extension_.size(); i++) {
        output.writeMessage(5, extension_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (responseCase_ == 1) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, (org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification) response_);
      }
      if (responseCase_ == 3) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(
              3, (boolean)((java.lang.Boolean) response_));
      }
      if (responseCase_ == 4) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, (org.opennms.features.openconfig.proto.gnmi.Gnmi.Error) response_);
      }
      for (int i = 0; i < extension_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, extension_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse)) {
        return super.equals(obj);
      }
      org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse other = (org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse) obj;

      if (!getExtensionList()
          .equals(other.getExtensionList())) return false;
      if (!getResponseCase().equals(other.getResponseCase())) return false;
      switch (responseCase_) {
        case 1:
          if (!getUpdate()
              .equals(other.getUpdate())) return false;
          break;
        case 3:
          if (getSyncResponse()
              != other.getSyncResponse()) return false;
          break;
        case 4:
          if (!getError()
              .equals(other.getError())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getExtensionCount() > 0) {
        hash = (37 * hash) + EXTENSION_FIELD_NUMBER;
        hash = (53 * hash) + getExtensionList().hashCode();
      }
      switch (responseCase_) {
        case 1:
          hash = (37 * hash) + UPDATE_FIELD_NUMBER;
          hash = (53 * hash) + getUpdate().hashCode();
          break;
        case 3:
          hash = (37 * hash) + SYNC_RESPONSE_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
              getSyncResponse());
          break;
        case 4:
          hash = (37 * hash) + ERROR_FIELD_NUMBER;
          hash = (53 * hash) + getError().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * SubscribeResponse is the message used by the target within a Subscribe RPC.
     * The target includes a Notification message which is used to transmit values
     * of the path(s) that are associated with the subscription. The same message
     * is to indicate that the target has sent all data values once (is
     * synchronized).
     * Reference: gNMI Specification Section 3.5.1.4
     * </pre>
     *
     * Protobuf type {@code gnmi.SubscribeResponse}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:gnmi.SubscribeResponse)
        org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SubscribeResponse_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SubscribeResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse.Builder.class);
      }

      // Construct using org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (updateBuilder_ != null) {
          updateBuilder_.clear();
        }
        if (errorBuilder_ != null) {
          errorBuilder_.clear();
        }
        if (extensionBuilder_ == null) {
          extension_ = java.util.Collections.emptyList();
        } else {
          extension_ = null;
          extensionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        responseCase_ = 0;
        response_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SubscribeResponse_descriptor;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse getDefaultInstanceForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse.getDefaultInstance();
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse build() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse buildPartial() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse result = new org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse result) {
        if (extensionBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            extension_ = java.util.Collections.unmodifiableList(extension_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.extension_ = extension_;
        } else {
          result.extension_ = extensionBuilder_.build();
        }
      }

      private void buildPartial0(org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse result) {
        result.responseCase_ = responseCase_;
        result.response_ = this.response_;
        if (responseCase_ == 1 &&
            updateBuilder_ != null) {
          result.response_ = updateBuilder_.build();
        }
        if (responseCase_ == 4 &&
            errorBuilder_ != null) {
          result.response_ = errorBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse) {
          return mergeFrom((org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse other) {
        if (other == org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse.getDefaultInstance()) return this;
        if (extensionBuilder_ == null) {
          if (!other.extension_.isEmpty()) {
            if (extension_.isEmpty()) {
              extension_ = other.extension_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureExtensionIsMutable();
              extension_.addAll(other.extension_);
            }
            onChanged();
          }
        } else {
          if (!other.extension_.isEmpty()) {
            if (extensionBuilder_.isEmpty()) {
              extensionBuilder_.dispose();
              extensionBuilder_ = null;
              extension_ = other.extension_;
              bitField0_ = (bitField0_ & ~0x00000008);
              extensionBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getExtensionFieldBuilder() : null;
            } else {
              extensionBuilder_.addAllMessages(other.extension_);
            }
          }
        }
        switch (other.getResponseCase()) {
          case UPDATE: {
            mergeUpdate(other.getUpdate());
            break;
          }
          case SYNC_RESPONSE: {
            setSyncResponse(other.getSyncResponse());
            break;
          }
          case ERROR: {
            mergeError(other.getError());
            break;
          }
          case RESPONSE_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getUpdateFieldBuilder().getBuilder(),
                    extensionRegistry);
                responseCase_ = 1;
                break;
              } // case 10
              case 24: {
                response_ = input.readBool();
                responseCase_ = 3;
                break;
              } // case 24
              case 34: {
                input.readMessage(
                    getErrorFieldBuilder().getBuilder(),
                    extensionRegistry);
                responseCase_ = 4;
                break;
              } // case 34
              case 42: {
                org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension m =
                    input.readMessage(
                        org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.parser(),
                        extensionRegistry);
                if (extensionBuilder_ == null) {
                  ensureExtensionIsMutable();
                  extension_.add(m);
                } else {
                  extensionBuilder_.addMessage(m);
                }
                break;
              } // case 42
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int responseCase_ = 0;
      private java.lang.Object response_;
      public ResponseCase
          getResponseCase() {
        return ResponseCase.forNumber(
            responseCase_);
      }

      public Builder clearResponse() {
        responseCase_ = 0;
        response_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification, org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.NotificationOrBuilder> updateBuilder_;
      /**
       * <pre>
       * Changed or sampled value for a path.
       * </pre>
       *
       * <code>.gnmi.Notification update = 1;</code>
       * @return Whether the update field is set.
       */
      @java.lang.Override
      public boolean hasUpdate() {
        return responseCase_ == 1;
      }
      /**
       * <pre>
       * Changed or sampled value for a path.
       * </pre>
       *
       * <code>.gnmi.Notification update = 1;</code>
       * @return The update.
       */
      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification getUpdate() {
        if (updateBuilder_ == null) {
          if (responseCase_ == 1) {
            return (org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification) response_;
          }
          return org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification.getDefaultInstance();
        } else {
          if (responseCase_ == 1) {
            return updateBuilder_.getMessage();
          }
          return org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Changed or sampled value for a path.
       * </pre>
       *
       * <code>.gnmi.Notification update = 1;</code>
       */
      public Builder setUpdate(org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification value) {
        if (updateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          response_ = value;
          onChanged();
        } else {
          updateBuilder_.setMessage(value);
        }
        responseCase_ = 1;
        return this;
      }
      /**
       * <pre>
       * Changed or sampled value for a path.
       * </pre>
       *
       * <code>.gnmi.Notification update = 1;</code>
       */
      public Builder setUpdate(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification.Builder builderForValue) {
        if (updateBuilder_ == null) {
          response_ = builderForValue.build();
          onChanged();
        } else {
          updateBuilder_.setMessage(builderForValue.build());
        }
        responseCase_ = 1;
        return this;
      }
      /**
       * <pre>
       * Changed or sampled value for a path.
       * </pre>
       *
       * <code>.gnmi.Notification update = 1;</code>
       */
      public Builder mergeUpdate(org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification value) {
        if (updateBuilder_ == null) {
          if (responseCase_ == 1 &&
              response_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification.getDefaultInstance()) {
            response_ = org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification.newBuilder((org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification) response_)
                .mergeFrom(value).buildPartial();
          } else {
            response_ = value;
          }
          onChanged();
        } else {
          if (responseCase_ == 1) {
            updateBuilder_.mergeFrom(value);
          } else {
            updateBuilder_.setMessage(value);
          }
        }
        responseCase_ = 1;
        return this;
      }
      /**
       * <pre>
       * Changed or sampled value for a path.
       * </pre>
       *
       * <code>.gnmi.Notification update = 1;</code>
       */
      public Builder clearUpdate() {
        if (updateBuilder_ == null) {
          if (responseCase_ == 1) {
            responseCase_ = 0;
            response_ = null;
            onChanged();
          }
        } else {
          if (responseCase_ == 1) {
            responseCase_ = 0;
            response_ = null;
          }
          updateBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Changed or sampled value for a path.
       * </pre>
       *
       * <code>.gnmi.Notification update = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification.Builder getUpdateBuilder() {
        return getUpdateFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Changed or sampled value for a path.
       * </pre>
       *
       * <code>.gnmi.Notification update = 1;</code>
       */
      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.NotificationOrBuilder getUpdateOrBuilder() {
        if ((responseCase_ == 1) && (updateBuilder_ != null)) {
          return updateBuilder_.getMessageOrBuilder();
        } else {
          if (responseCase_ == 1) {
            return (org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification) response_;
          }
          return org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Changed or sampled value for a path.
       * </pre>
       *
       * <code>.gnmi.Notification update = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification, org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.NotificationOrBuilder> 
          getUpdateFieldBuilder() {
        if (updateBuilder_ == null) {
          if (!(responseCase_ == 1)) {
            response_ = org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification.getDefaultInstance();
          }
          updateBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification, org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.NotificationOrBuilder>(
                  (org.opennms.features.openconfig.proto.gnmi.Gnmi.Notification) response_,
                  getParentForChildren(),
                  isClean());
          response_ = null;
        }
        responseCase_ = 1;
        onChanged();
        return updateBuilder_;
      }

      /**
       * <pre>
       * Indicate target has sent all values associated with the subscription
       * at least once.
       * </pre>
       *
       * <code>bool sync_response = 3;</code>
       * @return Whether the syncResponse field is set.
       */
      public boolean hasSyncResponse() {
        return responseCase_ == 3;
      }
      /**
       * <pre>
       * Indicate target has sent all values associated with the subscription
       * at least once.
       * </pre>
       *
       * <code>bool sync_response = 3;</code>
       * @return The syncResponse.
       */
      public boolean getSyncResponse() {
        if (responseCase_ == 3) {
          return (java.lang.Boolean) response_;
        }
        return false;
      }
      /**
       * <pre>
       * Indicate target has sent all values associated with the subscription
       * at least once.
       * </pre>
       *
       * <code>bool sync_response = 3;</code>
       * @param value The syncResponse to set.
       * @return This builder for chaining.
       */
      public Builder setSyncResponse(boolean value) {

        responseCase_ = 3;
        response_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Indicate target has sent all values associated with the subscription
       * at least once.
       * </pre>
       *
       * <code>bool sync_response = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearSyncResponse() {
        if (responseCase_ == 3) {
          responseCase_ = 0;
          response_ = null;
          onChanged();
        }
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Error, org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.ErrorOrBuilder> errorBuilder_;
      /**
       * <pre>
       * Deprecated in favour of google.golang.org/genproto/googleapis/rpc/status
       * </pre>
       *
       * <code>.gnmi.Error error = 4 [deprecated = true];</code>
       * @deprecated gnmi.SubscribeResponse.error is deprecated.
       *     See gnmi.proto;l=239
       * @return Whether the error field is set.
       */
      @java.lang.Override
      @java.lang.Deprecated public boolean hasError() {
        return responseCase_ == 4;
      }
      /**
       * <pre>
       * Deprecated in favour of google.golang.org/genproto/googleapis/rpc/status
       * </pre>
       *
       * <code>.gnmi.Error error = 4 [deprecated = true];</code>
       * @deprecated gnmi.SubscribeResponse.error is deprecated.
       *     See gnmi.proto;l=239
       * @return The error.
       */
      @java.lang.Override
      @java.lang.Deprecated public org.opennms.features.openconfig.proto.gnmi.Gnmi.Error getError() {
        if (errorBuilder_ == null) {
          if (responseCase_ == 4) {
            return (org.opennms.features.openconfig.proto.gnmi.Gnmi.Error) response_;
          }
          return org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.getDefaultInstance();
        } else {
          if (responseCase_ == 4) {
            return errorBuilder_.getMessage();
          }
          return org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Deprecated in favour of google.golang.org/genproto/googleapis/rpc/status
       * </pre>
       *
       * <code>.gnmi.Error error = 4 [deprecated = true];</code>
       */
      @java.lang.Deprecated public Builder setError(org.opennms.features.openconfig.proto.gnmi.Gnmi.Error value) {
        if (errorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          response_ = value;
          onChanged();
        } else {
          errorBuilder_.setMessage(value);
        }
        responseCase_ = 4;
        return this;
      }
      /**
       * <pre>
       * Deprecated in favour of google.golang.org/genproto/googleapis/rpc/status
       * </pre>
       *
       * <code>.gnmi.Error error = 4 [deprecated = true];</code>
       */
      @java.lang.Deprecated public Builder setError(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.Builder builderForValue) {
        if (errorBuilder_ == null) {
          response_ = builderForValue.build();
          onChanged();
        } else {
          errorBuilder_.setMessage(builderForValue.build());
        }
        responseCase_ = 4;
        return this;
      }
      /**
       * <pre>
       * Deprecated in favour of google.golang.org/genproto/googleapis/rpc/status
       * </pre>
       *
       * <code>.gnmi.Error error = 4 [deprecated = true];</code>
       */
      @java.lang.Deprecated public Builder mergeError(org.opennms.features.openconfig.proto.gnmi.Gnmi.Error value) {
        if (errorBuilder_ == null) {
          if (responseCase_ == 4 &&
              response_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.getDefaultInstance()) {
            response_ = org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.newBuilder((org.opennms.features.openconfig.proto.gnmi.Gnmi.Error) response_)
                .mergeFrom(value).buildPartial();
          } else {
            response_ = value;
          }
          onChanged();
        } else {
          if (responseCase_ == 4) {
            errorBuilder_.mergeFrom(value);
          } else {
            errorBuilder_.setMessage(value);
          }
        }
        responseCase_ = 4;
        return this;
      }
      /**
       * <pre>
       * Deprecated in favour of google.golang.org/genproto/googleapis/rpc/status
       * </pre>
       *
       * <code>.gnmi.Error error = 4 [deprecated = true];</code>
       */
      @java.lang.Deprecated public Builder clearError() {
        if (errorBuilder_ == null) {
          if (responseCase_ == 4) {
            responseCase_ = 0;
            response_ = null;
            onChanged();
          }
        } else {
          if (responseCase_ == 4) {
            responseCase_ = 0;
            response_ = null;
          }
          errorBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Deprecated in favour of google.golang.org/genproto/googleapis/rpc/status
       * </pre>
       *
       * <code>.gnmi.Error error = 4 [deprecated = true];</code>
       */
      @java.lang.Deprecated public org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.Builder getErrorBuilder() {
        return getErrorFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Deprecated in favour of google.golang.org/genproto/googleapis/rpc/status
       * </pre>
       *
       * <code>.gnmi.Error error = 4 [deprecated = true];</code>
       */
      @java.lang.Override
      @java.lang.Deprecated public org.opennms.features.openconfig.proto.gnmi.Gnmi.ErrorOrBuilder getErrorOrBuilder() {
        if ((responseCase_ == 4) && (errorBuilder_ != null)) {
          return errorBuilder_.getMessageOrBuilder();
        } else {
          if (responseCase_ == 4) {
            return (org.opennms.features.openconfig.proto.gnmi.Gnmi.Error) response_;
          }
          return org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Deprecated in favour of google.golang.org/genproto/googleapis/rpc/status
       * </pre>
       *
       * <code>.gnmi.Error error = 4 [deprecated = true];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Error, org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.ErrorOrBuilder> 
          getErrorFieldBuilder() {
        if (errorBuilder_ == null) {
          if (!(responseCase_ == 4)) {
            response_ = org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.getDefaultInstance();
          }
          errorBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Error, org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.ErrorOrBuilder>(
                  (org.opennms.features.openconfig.proto.gnmi.Gnmi.Error) response_,
                  getParentForChildren(),
                  isClean());
          response_ = null;
        }
        responseCase_ = 4;
        onChanged();
        return errorBuilder_;
      }

      private java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> extension_ =
        java.util.Collections.emptyList();
      private void ensureExtensionIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          extension_ = new java.util.ArrayList<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension>(extension_);
          bitField0_ |= 0x00000008;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder, org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> extensionBuilder_;

      /**
       * <pre>
       * Extension messages associated with the SubscribeResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> getExtensionList() {
        if (extensionBuilder_ == null) {
          return java.util.Collections.unmodifiableList(extension_);
        } else {
          return extensionBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public int getExtensionCount() {
        if (extensionBuilder_ == null) {
          return extension_.size();
        } else {
          return extensionBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension getExtension(int index) {
        if (extensionBuilder_ == null) {
          return extension_.get(index);
        } else {
          return extensionBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder setExtension(
          int index, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension value) {
        if (extensionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureExtensionIsMutable();
          extension_.set(index, value);
          onChanged();
        } else {
          extensionBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder setExtension(
          int index, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder builderForValue) {
        if (extensionBuilder_ == null) {
          ensureExtensionIsMutable();
          extension_.set(index, builderForValue.build());
          onChanged();
        } else {
          extensionBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder addExtension(org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension value) {
        if (extensionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureExtensionIsMutable();
          extension_.add(value);
          onChanged();
        } else {
          extensionBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder addExtension(
          int index, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension value) {
        if (extensionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureExtensionIsMutable();
          extension_.add(index, value);
          onChanged();
        } else {
          extensionBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder addExtension(
          org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder builderForValue) {
        if (extensionBuilder_ == null) {
          ensureExtensionIsMutable();
          extension_.add(builderForValue.build());
          onChanged();
        } else {
          extensionBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder addExtension(
          int index, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder builderForValue) {
        if (extensionBuilder_ == null) {
          ensureExtensionIsMutable();
          extension_.add(index, builderForValue.build());
          onChanged();
        } else {
          extensionBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder addAllExtension(
          java.lang.Iterable<? extends org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> values) {
        if (extensionBuilder_ == null) {
          ensureExtensionIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, extension_);
          onChanged();
        } else {
          extensionBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder clearExtension() {
        if (extensionBuilder_ == null) {
          extension_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          extensionBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder removeExtension(int index) {
        if (extensionBuilder_ == null) {
          ensureExtensionIsMutable();
          extension_.remove(index);
          onChanged();
        } else {
          extensionBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder getExtensionBuilder(
          int index) {
        return getExtensionFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder getExtensionOrBuilder(
          int index) {
        if (extensionBuilder_ == null) {
          return extension_.get(index);  } else {
          return extensionBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> 
           getExtensionOrBuilderList() {
        if (extensionBuilder_ != null) {
          return extensionBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(extension_);
        }
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder addExtensionBuilder() {
        return getExtensionFieldBuilder().addBuilder(
            org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.getDefaultInstance());
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder addExtensionBuilder(
          int index) {
        return getExtensionFieldBuilder().addBuilder(
            index, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.getDefaultInstance());
      }
      /**
       * <pre>
       * Extension messages associated with the SubscribeResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder> 
           getExtensionBuilderList() {
        return getExtensionFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder, org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> 
          getExtensionFieldBuilder() {
        if (extensionBuilder_ == null) {
          extensionBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder, org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder>(
                  extension_,
                  ((bitField0_ & 0x00000008) != 0),
                  getParentForChildren(),
                  isClean());
          extension_ = null;
        }
        return extensionBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:gnmi.SubscribeResponse)
    }

    // @@protoc_insertion_point(class_scope:gnmi.SubscribeResponse)
    private static final org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse();
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SubscribeResponse>
        PARSER = new com.google.protobuf.AbstractParser<SubscribeResponse>() {
      @java.lang.Override
      public SubscribeResponse parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<SubscribeResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SubscribeResponse> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscribeResponse getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface SubscriptionListOrBuilder extends
      // @@protoc_insertion_point(interface_extends:gnmi.SubscriptionList)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Prefix used for paths.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     * @return Whether the prefix field is set.
     */
    boolean hasPrefix();
    /**
     * <pre>
     * Prefix used for paths.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     * @return The prefix.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPrefix();
    /**
     * <pre>
     * Prefix used for paths.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPrefixOrBuilder();

    /**
     * <pre>
     * Set of subscriptions to create.
     * </pre>
     *
     * <code>repeated .gnmi.Subscription subscription = 2;</code>
     */
    java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription> 
        getSubscriptionList();
    /**
     * <pre>
     * Set of subscriptions to create.
     * </pre>
     *
     * <code>repeated .gnmi.Subscription subscription = 2;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription getSubscription(int index);
    /**
     * <pre>
     * Set of subscriptions to create.
     * </pre>
     *
     * <code>repeated .gnmi.Subscription subscription = 2;</code>
     */
    int getSubscriptionCount();
    /**
     * <pre>
     * Set of subscriptions to create.
     * </pre>
     *
     * <code>repeated .gnmi.Subscription subscription = 2;</code>
     */
    java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionOrBuilder> 
        getSubscriptionOrBuilderList();
    /**
     * <pre>
     * Set of subscriptions to create.
     * </pre>
     *
     * <code>repeated .gnmi.Subscription subscription = 2;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionOrBuilder getSubscriptionOrBuilder(
        int index);

    /**
     * <pre>
     * Whether target defined aliases are allowed within the subscription.
     * </pre>
     *
     * <code>bool use_aliases = 3;</code>
     * @return The useAliases.
     */
    boolean getUseAliases();

    /**
     * <pre>
     * DSCP marking to be used.
     * </pre>
     *
     * <code>.gnmi.QOSMarking qos = 4;</code>
     * @return Whether the qos field is set.
     */
    boolean hasQos();
    /**
     * <pre>
     * DSCP marking to be used.
     * </pre>
     *
     * <code>.gnmi.QOSMarking qos = 4;</code>
     * @return The qos.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking getQos();
    /**
     * <pre>
     * DSCP marking to be used.
     * </pre>
     *
     * <code>.gnmi.QOSMarking qos = 4;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarkingOrBuilder getQosOrBuilder();

    /**
     * <code>.gnmi.SubscriptionList.Mode mode = 5;</code>
     * @return The enum numeric value on the wire for mode.
     */
    int getModeValue();
    /**
     * <code>.gnmi.SubscriptionList.Mode mode = 5;</code>
     * @return The mode.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.Mode getMode();

    /**
     * <pre>
     * Whether elements of the schema that are marked as eligible for aggregation
     * should be aggregated or not.
     * </pre>
     *
     * <code>bool allow_aggregation = 6;</code>
     * @return The allowAggregation.
     */
    boolean getAllowAggregation();

    /**
     * <pre>
     * The set of schemas that define the elements of the data tree that should
     * be sent by the target.
     * </pre>
     *
     * <code>repeated .gnmi.ModelData use_models = 7;</code>
     */
    java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData> 
        getUseModelsList();
    /**
     * <pre>
     * The set of schemas that define the elements of the data tree that should
     * be sent by the target.
     * </pre>
     *
     * <code>repeated .gnmi.ModelData use_models = 7;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData getUseModels(int index);
    /**
     * <pre>
     * The set of schemas that define the elements of the data tree that should
     * be sent by the target.
     * </pre>
     *
     * <code>repeated .gnmi.ModelData use_models = 7;</code>
     */
    int getUseModelsCount();
    /**
     * <pre>
     * The set of schemas that define the elements of the data tree that should
     * be sent by the target.
     * </pre>
     *
     * <code>repeated .gnmi.ModelData use_models = 7;</code>
     */
    java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelDataOrBuilder> 
        getUseModelsOrBuilderList();
    /**
     * <pre>
     * The set of schemas that define the elements of the data tree that should
     * be sent by the target.
     * </pre>
     *
     * <code>repeated .gnmi.ModelData use_models = 7;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelDataOrBuilder getUseModelsOrBuilder(
        int index);

    /**
     * <pre>
     * The encoding that the target should use within the Notifications generated
     * corresponding to the SubscriptionList.
     * </pre>
     *
     * <code>.gnmi.Encoding encoding = 8;</code>
     * @return The enum numeric value on the wire for encoding.
     */
    int getEncodingValue();
    /**
     * <pre>
     * The encoding that the target should use within the Notifications generated
     * corresponding to the SubscriptionList.
     * </pre>
     *
     * <code>.gnmi.Encoding encoding = 8;</code>
     * @return The encoding.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding getEncoding();

    /**
     * <pre>
     * An optional field to specify that only updates to current state should be
     * sent to a client. If set, the initial state is not sent to the client but
     * rather only the sync message followed by any subsequent updates to the
     * current state. For ONCE and POLL modes, this causes the server to send only
     * the sync message (Sec. 3.5.2.3).
     * </pre>
     *
     * <code>bool updates_only = 9;</code>
     * @return The updatesOnly.
     */
    boolean getUpdatesOnly();
  }
  /**
   * <pre>
   * SubscriptionList is used within a Subscribe message to specify the list of
   * paths that the client wishes to subscribe to. The message consists of a
   * list of (possibly prefixed) paths, and options that relate to the
   * subscription.
   * Reference: gNMI Specification Section 3.5.1.2
   * </pre>
   *
   * Protobuf type {@code gnmi.SubscriptionList}
   */
  public static final class SubscriptionList extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:gnmi.SubscriptionList)
      SubscriptionListOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use SubscriptionList.newBuilder() to construct.
    private SubscriptionList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private SubscriptionList() {
      subscription_ = java.util.Collections.emptyList();
      mode_ = 0;
      useModels_ = java.util.Collections.emptyList();
      encoding_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new SubscriptionList();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SubscriptionList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SubscriptionList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.Builder.class);
    }

    /**
     * <pre>
     * Mode of the subscription.
     * </pre>
     *
     * Protobuf enum {@code gnmi.SubscriptionList.Mode}
     */
    public enum Mode
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <pre>
       * Values streamed by the target (Sec. 3.5.1.5.2).
       * </pre>
       *
       * <code>STREAM = 0;</code>
       */
      STREAM(0),
      /**
       * <pre>
       * Values sent once-off by the target (Sec. 3.5.1.5.1).
       * </pre>
       *
       * <code>ONCE = 1;</code>
       */
      ONCE(1),
      /**
       * <pre>
       * Values sent in response to a poll request (Sec. 3.5.1.5.3).
       * </pre>
       *
       * <code>POLL = 2;</code>
       */
      POLL(2),
      UNRECOGNIZED(-1),
      ;

      /**
       * <pre>
       * Values streamed by the target (Sec. 3.5.1.5.2).
       * </pre>
       *
       * <code>STREAM = 0;</code>
       */
      public static final int STREAM_VALUE = 0;
      /**
       * <pre>
       * Values sent once-off by the target (Sec. 3.5.1.5.1).
       * </pre>
       *
       * <code>ONCE = 1;</code>
       */
      public static final int ONCE_VALUE = 1;
      /**
       * <pre>
       * Values sent in response to a poll request (Sec. 3.5.1.5.3).
       * </pre>
       *
       * <code>POLL = 2;</code>
       */
      public static final int POLL_VALUE = 2;


      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Mode valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Mode forNumber(int value) {
        switch (value) {
          case 0: return STREAM;
          case 1: return ONCE;
          case 2: return POLL;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Mode>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Mode> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Mode>() {
              public Mode findValueByNumber(int number) {
                return Mode.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.getDescriptor().getEnumTypes().get(0);
      }

      private static final Mode[] VALUES = values();

      public static Mode valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Mode(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:gnmi.SubscriptionList.Mode)
    }

    private int bitField0_;
    public static final int PREFIX_FIELD_NUMBER = 1;
    private org.opennms.features.openconfig.proto.gnmi.Gnmi.Path prefix_;
    /**
     * <pre>
     * Prefix used for paths.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     * @return Whether the prefix field is set.
     */
    @java.lang.Override
    public boolean hasPrefix() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Prefix used for paths.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     * @return The prefix.
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPrefix() {
      return prefix_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : prefix_;
    }
    /**
     * <pre>
     * Prefix used for paths.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPrefixOrBuilder() {
      return prefix_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : prefix_;
    }

    public static final int SUBSCRIPTION_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription> subscription_;
    /**
     * <pre>
     * Set of subscriptions to create.
     * </pre>
     *
     * <code>repeated .gnmi.Subscription subscription = 2;</code>
     */
    @java.lang.Override
    public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription> getSubscriptionList() {
      return subscription_;
    }
    /**
     * <pre>
     * Set of subscriptions to create.
     * </pre>
     *
     * <code>repeated .gnmi.Subscription subscription = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionOrBuilder> 
        getSubscriptionOrBuilderList() {
      return subscription_;
    }
    /**
     * <pre>
     * Set of subscriptions to create.
     * </pre>
     *
     * <code>repeated .gnmi.Subscription subscription = 2;</code>
     */
    @java.lang.Override
    public int getSubscriptionCount() {
      return subscription_.size();
    }
    /**
     * <pre>
     * Set of subscriptions to create.
     * </pre>
     *
     * <code>repeated .gnmi.Subscription subscription = 2;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription getSubscription(int index) {
      return subscription_.get(index);
    }
    /**
     * <pre>
     * Set of subscriptions to create.
     * </pre>
     *
     * <code>repeated .gnmi.Subscription subscription = 2;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionOrBuilder getSubscriptionOrBuilder(
        int index) {
      return subscription_.get(index);
    }

    public static final int USE_ALIASES_FIELD_NUMBER = 3;
    private boolean useAliases_ = false;
    /**
     * <pre>
     * Whether target defined aliases are allowed within the subscription.
     * </pre>
     *
     * <code>bool use_aliases = 3;</code>
     * @return The useAliases.
     */
    @java.lang.Override
    public boolean getUseAliases() {
      return useAliases_;
    }

    public static final int QOS_FIELD_NUMBER = 4;
    private org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking qos_;
    /**
     * <pre>
     * DSCP marking to be used.
     * </pre>
     *
     * <code>.gnmi.QOSMarking qos = 4;</code>
     * @return Whether the qos field is set.
     */
    @java.lang.Override
    public boolean hasQos() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * DSCP marking to be used.
     * </pre>
     *
     * <code>.gnmi.QOSMarking qos = 4;</code>
     * @return The qos.
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking getQos() {
      return qos_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking.getDefaultInstance() : qos_;
    }
    /**
     * <pre>
     * DSCP marking to be used.
     * </pre>
     *
     * <code>.gnmi.QOSMarking qos = 4;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarkingOrBuilder getQosOrBuilder() {
      return qos_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking.getDefaultInstance() : qos_;
    }

    public static final int MODE_FIELD_NUMBER = 5;
    private int mode_ = 0;
    /**
     * <code>.gnmi.SubscriptionList.Mode mode = 5;</code>
     * @return The enum numeric value on the wire for mode.
     */
    @java.lang.Override public int getModeValue() {
      return mode_;
    }
    /**
     * <code>.gnmi.SubscriptionList.Mode mode = 5;</code>
     * @return The mode.
     */
    @java.lang.Override public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.Mode getMode() {
      org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.Mode result = org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.Mode.forNumber(mode_);
      return result == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.Mode.UNRECOGNIZED : result;
    }

    public static final int ALLOW_AGGREGATION_FIELD_NUMBER = 6;
    private boolean allowAggregation_ = false;
    /**
     * <pre>
     * Whether elements of the schema that are marked as eligible for aggregation
     * should be aggregated or not.
     * </pre>
     *
     * <code>bool allow_aggregation = 6;</code>
     * @return The allowAggregation.
     */
    @java.lang.Override
    public boolean getAllowAggregation() {
      return allowAggregation_;
    }

    public static final int USE_MODELS_FIELD_NUMBER = 7;
    @SuppressWarnings("serial")
    private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData> useModels_;
    /**
     * <pre>
     * The set of schemas that define the elements of the data tree that should
     * be sent by the target.
     * </pre>
     *
     * <code>repeated .gnmi.ModelData use_models = 7;</code>
     */
    @java.lang.Override
    public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData> getUseModelsList() {
      return useModels_;
    }
    /**
     * <pre>
     * The set of schemas that define the elements of the data tree that should
     * be sent by the target.
     * </pre>
     *
     * <code>repeated .gnmi.ModelData use_models = 7;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelDataOrBuilder> 
        getUseModelsOrBuilderList() {
      return useModels_;
    }
    /**
     * <pre>
     * The set of schemas that define the elements of the data tree that should
     * be sent by the target.
     * </pre>
     *
     * <code>repeated .gnmi.ModelData use_models = 7;</code>
     */
    @java.lang.Override
    public int getUseModelsCount() {
      return useModels_.size();
    }
    /**
     * <pre>
     * The set of schemas that define the elements of the data tree that should
     * be sent by the target.
     * </pre>
     *
     * <code>repeated .gnmi.ModelData use_models = 7;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData getUseModels(int index) {
      return useModels_.get(index);
    }
    /**
     * <pre>
     * The set of schemas that define the elements of the data tree that should
     * be sent by the target.
     * </pre>
     *
     * <code>repeated .gnmi.ModelData use_models = 7;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelDataOrBuilder getUseModelsOrBuilder(
        int index) {
      return useModels_.get(index);
    }

    public static final int ENCODING_FIELD_NUMBER = 8;
    private int encoding_ = 0;
    /**
     * <pre>
     * The encoding that the target should use within the Notifications generated
     * corresponding to the SubscriptionList.
     * </pre>
     *
     * <code>.gnmi.Encoding encoding = 8;</code>
     * @return The enum numeric value on the wire for encoding.
     */
    @java.lang.Override public int getEncodingValue() {
      return encoding_;
    }
    /**
     * <pre>
     * The encoding that the target should use within the Notifications generated
     * corresponding to the SubscriptionList.
     * </pre>
     *
     * <code>.gnmi.Encoding encoding = 8;</code>
     * @return The encoding.
     */
    @java.lang.Override public org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding getEncoding() {
      org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding result = org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding.forNumber(encoding_);
      return result == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding.UNRECOGNIZED : result;
    }

    public static final int UPDATES_ONLY_FIELD_NUMBER = 9;
    private boolean updatesOnly_ = false;
    /**
     * <pre>
     * An optional field to specify that only updates to current state should be
     * sent to a client. If set, the initial state is not sent to the client but
     * rather only the sync message followed by any subsequent updates to the
     * current state. For ONCE and POLL modes, this causes the server to send only
     * the sync message (Sec. 3.5.2.3).
     * </pre>
     *
     * <code>bool updates_only = 9;</code>
     * @return The updatesOnly.
     */
    @java.lang.Override
    public boolean getUpdatesOnly() {
      return updatesOnly_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getPrefix());
      }
      for (int i = 0; i < subscription_.size(); i++) {
        output.writeMessage(2, subscription_.get(i));
      }
      if (useAliases_ != false) {
        output.writeBool(3, useAliases_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(4, getQos());
      }
      if (mode_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.Mode.STREAM.getNumber()) {
        output.writeEnum(5, mode_);
      }
      if (allowAggregation_ != false) {
        output.writeBool(6, allowAggregation_);
      }
      for (int i = 0; i < useModels_.size(); i++) {
        output.writeMessage(7, useModels_.get(i));
      }
      if (encoding_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding.JSON.getNumber()) {
        output.writeEnum(8, encoding_);
      }
      if (updatesOnly_ != false) {
        output.writeBool(9, updatesOnly_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getPrefix());
      }
      for (int i = 0; i < subscription_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, subscription_.get(i));
      }
      if (useAliases_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(3, useAliases_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getQos());
      }
      if (mode_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.Mode.STREAM.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(5, mode_);
      }
      if (allowAggregation_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(6, allowAggregation_);
      }
      for (int i = 0; i < useModels_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, useModels_.get(i));
      }
      if (encoding_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding.JSON.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(8, encoding_);
      }
      if (updatesOnly_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(9, updatesOnly_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList)) {
        return super.equals(obj);
      }
      org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList other = (org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList) obj;

      if (hasPrefix() != other.hasPrefix()) return false;
      if (hasPrefix()) {
        if (!getPrefix()
            .equals(other.getPrefix())) return false;
      }
      if (!getSubscriptionList()
          .equals(other.getSubscriptionList())) return false;
      if (getUseAliases()
          != other.getUseAliases()) return false;
      if (hasQos() != other.hasQos()) return false;
      if (hasQos()) {
        if (!getQos()
            .equals(other.getQos())) return false;
      }
      if (mode_ != other.mode_) return false;
      if (getAllowAggregation()
          != other.getAllowAggregation()) return false;
      if (!getUseModelsList()
          .equals(other.getUseModelsList())) return false;
      if (encoding_ != other.encoding_) return false;
      if (getUpdatesOnly()
          != other.getUpdatesOnly()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPrefix()) {
        hash = (37 * hash) + PREFIX_FIELD_NUMBER;
        hash = (53 * hash) + getPrefix().hashCode();
      }
      if (getSubscriptionCount() > 0) {
        hash = (37 * hash) + SUBSCRIPTION_FIELD_NUMBER;
        hash = (53 * hash) + getSubscriptionList().hashCode();
      }
      hash = (37 * hash) + USE_ALIASES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUseAliases());
      if (hasQos()) {
        hash = (37 * hash) + QOS_FIELD_NUMBER;
        hash = (53 * hash) + getQos().hashCode();
      }
      hash = (37 * hash) + MODE_FIELD_NUMBER;
      hash = (53 * hash) + mode_;
      hash = (37 * hash) + ALLOW_AGGREGATION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAllowAggregation());
      if (getUseModelsCount() > 0) {
        hash = (37 * hash) + USE_MODELS_FIELD_NUMBER;
        hash = (53 * hash) + getUseModelsList().hashCode();
      }
      hash = (37 * hash) + ENCODING_FIELD_NUMBER;
      hash = (53 * hash) + encoding_;
      hash = (37 * hash) + UPDATES_ONLY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUpdatesOnly());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * SubscriptionList is used within a Subscribe message to specify the list of
     * paths that the client wishes to subscribe to. The message consists of a
     * list of (possibly prefixed) paths, and options that relate to the
     * subscription.
     * Reference: gNMI Specification Section 3.5.1.2
     * </pre>
     *
     * Protobuf type {@code gnmi.SubscriptionList}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:gnmi.SubscriptionList)
        org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionListOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SubscriptionList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SubscriptionList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.Builder.class);
      }

      // Construct using org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getPrefixFieldBuilder();
          getSubscriptionFieldBuilder();
          getQosFieldBuilder();
          getUseModelsFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        prefix_ = null;
        if (prefixBuilder_ != null) {
          prefixBuilder_.dispose();
          prefixBuilder_ = null;
        }
        if (subscriptionBuilder_ == null) {
          subscription_ = java.util.Collections.emptyList();
        } else {
          subscription_ = null;
          subscriptionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        useAliases_ = false;
        qos_ = null;
        if (qosBuilder_ != null) {
          qosBuilder_.dispose();
          qosBuilder_ = null;
        }
        mode_ = 0;
        allowAggregation_ = false;
        if (useModelsBuilder_ == null) {
          useModels_ = java.util.Collections.emptyList();
        } else {
          useModels_ = null;
          useModelsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000040);
        encoding_ = 0;
        updatesOnly_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SubscriptionList_descriptor;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList getDefaultInstanceForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.getDefaultInstance();
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList build() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList buildPartial() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList result = new org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList result) {
        if (subscriptionBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            subscription_ = java.util.Collections.unmodifiableList(subscription_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.subscription_ = subscription_;
        } else {
          result.subscription_ = subscriptionBuilder_.build();
        }
        if (useModelsBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)) {
            useModels_ = java.util.Collections.unmodifiableList(useModels_);
            bitField0_ = (bitField0_ & ~0x00000040);
          }
          result.useModels_ = useModels_;
        } else {
          result.useModels_ = useModelsBuilder_.build();
        }
      }

      private void buildPartial0(org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.prefix_ = prefixBuilder_ == null
              ? prefix_
              : prefixBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.useAliases_ = useAliases_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.qos_ = qosBuilder_ == null
              ? qos_
              : qosBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.mode_ = mode_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.allowAggregation_ = allowAggregation_;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.encoding_ = encoding_;
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.updatesOnly_ = updatesOnly_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList) {
          return mergeFrom((org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList other) {
        if (other == org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.getDefaultInstance()) return this;
        if (other.hasPrefix()) {
          mergePrefix(other.getPrefix());
        }
        if (subscriptionBuilder_ == null) {
          if (!other.subscription_.isEmpty()) {
            if (subscription_.isEmpty()) {
              subscription_ = other.subscription_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureSubscriptionIsMutable();
              subscription_.addAll(other.subscription_);
            }
            onChanged();
          }
        } else {
          if (!other.subscription_.isEmpty()) {
            if (subscriptionBuilder_.isEmpty()) {
              subscriptionBuilder_.dispose();
              subscriptionBuilder_ = null;
              subscription_ = other.subscription_;
              bitField0_ = (bitField0_ & ~0x00000002);
              subscriptionBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getSubscriptionFieldBuilder() : null;
            } else {
              subscriptionBuilder_.addAllMessages(other.subscription_);
            }
          }
        }
        if (other.getUseAliases() != false) {
          setUseAliases(other.getUseAliases());
        }
        if (other.hasQos()) {
          mergeQos(other.getQos());
        }
        if (other.mode_ != 0) {
          setModeValue(other.getModeValue());
        }
        if (other.getAllowAggregation() != false) {
          setAllowAggregation(other.getAllowAggregation());
        }
        if (useModelsBuilder_ == null) {
          if (!other.useModels_.isEmpty()) {
            if (useModels_.isEmpty()) {
              useModels_ = other.useModels_;
              bitField0_ = (bitField0_ & ~0x00000040);
            } else {
              ensureUseModelsIsMutable();
              useModels_.addAll(other.useModels_);
            }
            onChanged();
          }
        } else {
          if (!other.useModels_.isEmpty()) {
            if (useModelsBuilder_.isEmpty()) {
              useModelsBuilder_.dispose();
              useModelsBuilder_ = null;
              useModels_ = other.useModels_;
              bitField0_ = (bitField0_ & ~0x00000040);
              useModelsBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getUseModelsFieldBuilder() : null;
            } else {
              useModelsBuilder_.addAllMessages(other.useModels_);
            }
          }
        }
        if (other.encoding_ != 0) {
          setEncodingValue(other.getEncodingValue());
        }
        if (other.getUpdatesOnly() != false) {
          setUpdatesOnly(other.getUpdatesOnly());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getPrefixFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription m =
                    input.readMessage(
                        org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription.parser(),
                        extensionRegistry);
                if (subscriptionBuilder_ == null) {
                  ensureSubscriptionIsMutable();
                  subscription_.add(m);
                } else {
                  subscriptionBuilder_.addMessage(m);
                }
                break;
              } // case 18
              case 24: {
                useAliases_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
              case 34: {
                input.readMessage(
                    getQosFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
              case 40: {
                mode_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
              case 48: {
                allowAggregation_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
              case 58: {
                org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData m =
                    input.readMessage(
                        org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData.parser(),
                        extensionRegistry);
                if (useModelsBuilder_ == null) {
                  ensureUseModelsIsMutable();
                  useModels_.add(m);
                } else {
                  useModelsBuilder_.addMessage(m);
                }
                break;
              } // case 58
              case 64: {
                encoding_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
              case 72: {
                updatesOnly_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.opennms.features.openconfig.proto.gnmi.Gnmi.Path prefix_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> prefixBuilder_;
      /**
       * <pre>
       * Prefix used for paths.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       * @return Whether the prefix field is set.
       */
      public boolean hasPrefix() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Prefix used for paths.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       * @return The prefix.
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPrefix() {
        if (prefixBuilder_ == null) {
          return prefix_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : prefix_;
        } else {
          return prefixBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Prefix used for paths.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       */
      public Builder setPrefix(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (prefixBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          prefix_ = value;
        } else {
          prefixBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Prefix used for paths.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       */
      public Builder setPrefix(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder builderForValue) {
        if (prefixBuilder_ == null) {
          prefix_ = builderForValue.build();
        } else {
          prefixBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Prefix used for paths.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       */
      public Builder mergePrefix(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (prefixBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            prefix_ != null &&
            prefix_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance()) {
            getPrefixBuilder().mergeFrom(value);
          } else {
            prefix_ = value;
          }
        } else {
          prefixBuilder_.mergeFrom(value);
        }
        if (prefix_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * Prefix used for paths.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       */
      public Builder clearPrefix() {
        bitField0_ = (bitField0_ & ~0x00000001);
        prefix_ = null;
        if (prefixBuilder_ != null) {
          prefixBuilder_.dispose();
          prefixBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Prefix used for paths.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder getPrefixBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getPrefixFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Prefix used for paths.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPrefixOrBuilder() {
        if (prefixBuilder_ != null) {
          return prefixBuilder_.getMessageOrBuilder();
        } else {
          return prefix_ == null ?
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : prefix_;
        }
      }
      /**
       * <pre>
       * Prefix used for paths.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> 
          getPrefixFieldBuilder() {
        if (prefixBuilder_ == null) {
          prefixBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder>(
                  getPrefix(),
                  getParentForChildren(),
                  isClean());
          prefix_ = null;
        }
        return prefixBuilder_;
      }

      private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription> subscription_ =
        java.util.Collections.emptyList();
      private void ensureSubscriptionIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          subscription_ = new java.util.ArrayList<org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription>(subscription_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription, org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionOrBuilder> subscriptionBuilder_;

      /**
       * <pre>
       * Set of subscriptions to create.
       * </pre>
       *
       * <code>repeated .gnmi.Subscription subscription = 2;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription> getSubscriptionList() {
        if (subscriptionBuilder_ == null) {
          return java.util.Collections.unmodifiableList(subscription_);
        } else {
          return subscriptionBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Set of subscriptions to create.
       * </pre>
       *
       * <code>repeated .gnmi.Subscription subscription = 2;</code>
       */
      public int getSubscriptionCount() {
        if (subscriptionBuilder_ == null) {
          return subscription_.size();
        } else {
          return subscriptionBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Set of subscriptions to create.
       * </pre>
       *
       * <code>repeated .gnmi.Subscription subscription = 2;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription getSubscription(int index) {
        if (subscriptionBuilder_ == null) {
          return subscription_.get(index);
        } else {
          return subscriptionBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Set of subscriptions to create.
       * </pre>
       *
       * <code>repeated .gnmi.Subscription subscription = 2;</code>
       */
      public Builder setSubscription(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription value) {
        if (subscriptionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSubscriptionIsMutable();
          subscription_.set(index, value);
          onChanged();
        } else {
          subscriptionBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Set of subscriptions to create.
       * </pre>
       *
       * <code>repeated .gnmi.Subscription subscription = 2;</code>
       */
      public Builder setSubscription(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription.Builder builderForValue) {
        if (subscriptionBuilder_ == null) {
          ensureSubscriptionIsMutable();
          subscription_.set(index, builderForValue.build());
          onChanged();
        } else {
          subscriptionBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Set of subscriptions to create.
       * </pre>
       *
       * <code>repeated .gnmi.Subscription subscription = 2;</code>
       */
      public Builder addSubscription(org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription value) {
        if (subscriptionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSubscriptionIsMutable();
          subscription_.add(value);
          onChanged();
        } else {
          subscriptionBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Set of subscriptions to create.
       * </pre>
       *
       * <code>repeated .gnmi.Subscription subscription = 2;</code>
       */
      public Builder addSubscription(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription value) {
        if (subscriptionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSubscriptionIsMutable();
          subscription_.add(index, value);
          onChanged();
        } else {
          subscriptionBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Set of subscriptions to create.
       * </pre>
       *
       * <code>repeated .gnmi.Subscription subscription = 2;</code>
       */
      public Builder addSubscription(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription.Builder builderForValue) {
        if (subscriptionBuilder_ == null) {
          ensureSubscriptionIsMutable();
          subscription_.add(builderForValue.build());
          onChanged();
        } else {
          subscriptionBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Set of subscriptions to create.
       * </pre>
       *
       * <code>repeated .gnmi.Subscription subscription = 2;</code>
       */
      public Builder addSubscription(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription.Builder builderForValue) {
        if (subscriptionBuilder_ == null) {
          ensureSubscriptionIsMutable();
          subscription_.add(index, builderForValue.build());
          onChanged();
        } else {
          subscriptionBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Set of subscriptions to create.
       * </pre>
       *
       * <code>repeated .gnmi.Subscription subscription = 2;</code>
       */
      public Builder addAllSubscription(
          java.lang.Iterable<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription> values) {
        if (subscriptionBuilder_ == null) {
          ensureSubscriptionIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, subscription_);
          onChanged();
        } else {
          subscriptionBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Set of subscriptions to create.
       * </pre>
       *
       * <code>repeated .gnmi.Subscription subscription = 2;</code>
       */
      public Builder clearSubscription() {
        if (subscriptionBuilder_ == null) {
          subscription_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          subscriptionBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Set of subscriptions to create.
       * </pre>
       *
       * <code>repeated .gnmi.Subscription subscription = 2;</code>
       */
      public Builder removeSubscription(int index) {
        if (subscriptionBuilder_ == null) {
          ensureSubscriptionIsMutable();
          subscription_.remove(index);
          onChanged();
        } else {
          subscriptionBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Set of subscriptions to create.
       * </pre>
       *
       * <code>repeated .gnmi.Subscription subscription = 2;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription.Builder getSubscriptionBuilder(
          int index) {
        return getSubscriptionFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Set of subscriptions to create.
       * </pre>
       *
       * <code>repeated .gnmi.Subscription subscription = 2;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionOrBuilder getSubscriptionOrBuilder(
          int index) {
        if (subscriptionBuilder_ == null) {
          return subscription_.get(index);  } else {
          return subscriptionBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Set of subscriptions to create.
       * </pre>
       *
       * <code>repeated .gnmi.Subscription subscription = 2;</code>
       */
      public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionOrBuilder> 
           getSubscriptionOrBuilderList() {
        if (subscriptionBuilder_ != null) {
          return subscriptionBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(subscription_);
        }
      }
      /**
       * <pre>
       * Set of subscriptions to create.
       * </pre>
       *
       * <code>repeated .gnmi.Subscription subscription = 2;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription.Builder addSubscriptionBuilder() {
        return getSubscriptionFieldBuilder().addBuilder(
            org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription.getDefaultInstance());
      }
      /**
       * <pre>
       * Set of subscriptions to create.
       * </pre>
       *
       * <code>repeated .gnmi.Subscription subscription = 2;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription.Builder addSubscriptionBuilder(
          int index) {
        return getSubscriptionFieldBuilder().addBuilder(
            index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription.getDefaultInstance());
      }
      /**
       * <pre>
       * Set of subscriptions to create.
       * </pre>
       *
       * <code>repeated .gnmi.Subscription subscription = 2;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription.Builder> 
           getSubscriptionBuilderList() {
        return getSubscriptionFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription, org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionOrBuilder> 
          getSubscriptionFieldBuilder() {
        if (subscriptionBuilder_ == null) {
          subscriptionBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription, org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionOrBuilder>(
                  subscription_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          subscription_ = null;
        }
        return subscriptionBuilder_;
      }

      private boolean useAliases_ ;
      /**
       * <pre>
       * Whether target defined aliases are allowed within the subscription.
       * </pre>
       *
       * <code>bool use_aliases = 3;</code>
       * @return The useAliases.
       */
      @java.lang.Override
      public boolean getUseAliases() {
        return useAliases_;
      }
      /**
       * <pre>
       * Whether target defined aliases are allowed within the subscription.
       * </pre>
       *
       * <code>bool use_aliases = 3;</code>
       * @param value The useAliases to set.
       * @return This builder for chaining.
       */
      public Builder setUseAliases(boolean value) {

        useAliases_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Whether target defined aliases are allowed within the subscription.
       * </pre>
       *
       * <code>bool use_aliases = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearUseAliases() {
        bitField0_ = (bitField0_ & ~0x00000004);
        useAliases_ = false;
        onChanged();
        return this;
      }

      private org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking qos_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking, org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarkingOrBuilder> qosBuilder_;
      /**
       * <pre>
       * DSCP marking to be used.
       * </pre>
       *
       * <code>.gnmi.QOSMarking qos = 4;</code>
       * @return Whether the qos field is set.
       */
      public boolean hasQos() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       * DSCP marking to be used.
       * </pre>
       *
       * <code>.gnmi.QOSMarking qos = 4;</code>
       * @return The qos.
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking getQos() {
        if (qosBuilder_ == null) {
          return qos_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking.getDefaultInstance() : qos_;
        } else {
          return qosBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * DSCP marking to be used.
       * </pre>
       *
       * <code>.gnmi.QOSMarking qos = 4;</code>
       */
      public Builder setQos(org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking value) {
        if (qosBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          qos_ = value;
        } else {
          qosBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * DSCP marking to be used.
       * </pre>
       *
       * <code>.gnmi.QOSMarking qos = 4;</code>
       */
      public Builder setQos(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking.Builder builderForValue) {
        if (qosBuilder_ == null) {
          qos_ = builderForValue.build();
        } else {
          qosBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * DSCP marking to be used.
       * </pre>
       *
       * <code>.gnmi.QOSMarking qos = 4;</code>
       */
      public Builder mergeQos(org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking value) {
        if (qosBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0) &&
            qos_ != null &&
            qos_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking.getDefaultInstance()) {
            getQosBuilder().mergeFrom(value);
          } else {
            qos_ = value;
          }
        } else {
          qosBuilder_.mergeFrom(value);
        }
        if (qos_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * DSCP marking to be used.
       * </pre>
       *
       * <code>.gnmi.QOSMarking qos = 4;</code>
       */
      public Builder clearQos() {
        bitField0_ = (bitField0_ & ~0x00000008);
        qos_ = null;
        if (qosBuilder_ != null) {
          qosBuilder_.dispose();
          qosBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * DSCP marking to be used.
       * </pre>
       *
       * <code>.gnmi.QOSMarking qos = 4;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking.Builder getQosBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getQosFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * DSCP marking to be used.
       * </pre>
       *
       * <code>.gnmi.QOSMarking qos = 4;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarkingOrBuilder getQosOrBuilder() {
        if (qosBuilder_ != null) {
          return qosBuilder_.getMessageOrBuilder();
        } else {
          return qos_ == null ?
              org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking.getDefaultInstance() : qos_;
        }
      }
      /**
       * <pre>
       * DSCP marking to be used.
       * </pre>
       *
       * <code>.gnmi.QOSMarking qos = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking, org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarkingOrBuilder> 
          getQosFieldBuilder() {
        if (qosBuilder_ == null) {
          qosBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking, org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarkingOrBuilder>(
                  getQos(),
                  getParentForChildren(),
                  isClean());
          qos_ = null;
        }
        return qosBuilder_;
      }

      private int mode_ = 0;
      /**
       * <code>.gnmi.SubscriptionList.Mode mode = 5;</code>
       * @return The enum numeric value on the wire for mode.
       */
      @java.lang.Override public int getModeValue() {
        return mode_;
      }
      /**
       * <code>.gnmi.SubscriptionList.Mode mode = 5;</code>
       * @param value The enum numeric value on the wire for mode to set.
       * @return This builder for chaining.
       */
      public Builder setModeValue(int value) {
        mode_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <code>.gnmi.SubscriptionList.Mode mode = 5;</code>
       * @return The mode.
       */
      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.Mode getMode() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.Mode result = org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.Mode.forNumber(mode_);
        return result == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.Mode.UNRECOGNIZED : result;
      }
      /**
       * <code>.gnmi.SubscriptionList.Mode mode = 5;</code>
       * @param value The mode to set.
       * @return This builder for chaining.
       */
      public Builder setMode(org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList.Mode value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        mode_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>.gnmi.SubscriptionList.Mode mode = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearMode() {
        bitField0_ = (bitField0_ & ~0x00000010);
        mode_ = 0;
        onChanged();
        return this;
      }

      private boolean allowAggregation_ ;
      /**
       * <pre>
       * Whether elements of the schema that are marked as eligible for aggregation
       * should be aggregated or not.
       * </pre>
       *
       * <code>bool allow_aggregation = 6;</code>
       * @return The allowAggregation.
       */
      @java.lang.Override
      public boolean getAllowAggregation() {
        return allowAggregation_;
      }
      /**
       * <pre>
       * Whether elements of the schema that are marked as eligible for aggregation
       * should be aggregated or not.
       * </pre>
       *
       * <code>bool allow_aggregation = 6;</code>
       * @param value The allowAggregation to set.
       * @return This builder for chaining.
       */
      public Builder setAllowAggregation(boolean value) {

        allowAggregation_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Whether elements of the schema that are marked as eligible for aggregation
       * should be aggregated or not.
       * </pre>
       *
       * <code>bool allow_aggregation = 6;</code>
       * @return This builder for chaining.
       */
      public Builder clearAllowAggregation() {
        bitField0_ = (bitField0_ & ~0x00000020);
        allowAggregation_ = false;
        onChanged();
        return this;
      }

      private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData> useModels_ =
        java.util.Collections.emptyList();
      private void ensureUseModelsIsMutable() {
        if (!((bitField0_ & 0x00000040) != 0)) {
          useModels_ = new java.util.ArrayList<org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData>(useModels_);
          bitField0_ |= 0x00000040;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData, org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelDataOrBuilder> useModelsBuilder_;

      /**
       * <pre>
       * The set of schemas that define the elements of the data tree that should
       * be sent by the target.
       * </pre>
       *
       * <code>repeated .gnmi.ModelData use_models = 7;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData> getUseModelsList() {
        if (useModelsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(useModels_);
        } else {
          return useModelsBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * The set of schemas that define the elements of the data tree that should
       * be sent by the target.
       * </pre>
       *
       * <code>repeated .gnmi.ModelData use_models = 7;</code>
       */
      public int getUseModelsCount() {
        if (useModelsBuilder_ == null) {
          return useModels_.size();
        } else {
          return useModelsBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * The set of schemas that define the elements of the data tree that should
       * be sent by the target.
       * </pre>
       *
       * <code>repeated .gnmi.ModelData use_models = 7;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData getUseModels(int index) {
        if (useModelsBuilder_ == null) {
          return useModels_.get(index);
        } else {
          return useModelsBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * The set of schemas that define the elements of the data tree that should
       * be sent by the target.
       * </pre>
       *
       * <code>repeated .gnmi.ModelData use_models = 7;</code>
       */
      public Builder setUseModels(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData value) {
        if (useModelsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUseModelsIsMutable();
          useModels_.set(index, value);
          onChanged();
        } else {
          useModelsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * The set of schemas that define the elements of the data tree that should
       * be sent by the target.
       * </pre>
       *
       * <code>repeated .gnmi.ModelData use_models = 7;</code>
       */
      public Builder setUseModels(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData.Builder builderForValue) {
        if (useModelsBuilder_ == null) {
          ensureUseModelsIsMutable();
          useModels_.set(index, builderForValue.build());
          onChanged();
        } else {
          useModelsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * The set of schemas that define the elements of the data tree that should
       * be sent by the target.
       * </pre>
       *
       * <code>repeated .gnmi.ModelData use_models = 7;</code>
       */
      public Builder addUseModels(org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData value) {
        if (useModelsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUseModelsIsMutable();
          useModels_.add(value);
          onChanged();
        } else {
          useModelsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * The set of schemas that define the elements of the data tree that should
       * be sent by the target.
       * </pre>
       *
       * <code>repeated .gnmi.ModelData use_models = 7;</code>
       */
      public Builder addUseModels(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData value) {
        if (useModelsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUseModelsIsMutable();
          useModels_.add(index, value);
          onChanged();
        } else {
          useModelsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * The set of schemas that define the elements of the data tree that should
       * be sent by the target.
       * </pre>
       *
       * <code>repeated .gnmi.ModelData use_models = 7;</code>
       */
      public Builder addUseModels(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData.Builder builderForValue) {
        if (useModelsBuilder_ == null) {
          ensureUseModelsIsMutable();
          useModels_.add(builderForValue.build());
          onChanged();
        } else {
          useModelsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * The set of schemas that define the elements of the data tree that should
       * be sent by the target.
       * </pre>
       *
       * <code>repeated .gnmi.ModelData use_models = 7;</code>
       */
      public Builder addUseModels(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData.Builder builderForValue) {
        if (useModelsBuilder_ == null) {
          ensureUseModelsIsMutable();
          useModels_.add(index, builderForValue.build());
          onChanged();
        } else {
          useModelsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * The set of schemas that define the elements of the data tree that should
       * be sent by the target.
       * </pre>
       *
       * <code>repeated .gnmi.ModelData use_models = 7;</code>
       */
      public Builder addAllUseModels(
          java.lang.Iterable<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData> values) {
        if (useModelsBuilder_ == null) {
          ensureUseModelsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, useModels_);
          onChanged();
        } else {
          useModelsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * The set of schemas that define the elements of the data tree that should
       * be sent by the target.
       * </pre>
       *
       * <code>repeated .gnmi.ModelData use_models = 7;</code>
       */
      public Builder clearUseModels() {
        if (useModelsBuilder_ == null) {
          useModels_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000040);
          onChanged();
        } else {
          useModelsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * The set of schemas that define the elements of the data tree that should
       * be sent by the target.
       * </pre>
       *
       * <code>repeated .gnmi.ModelData use_models = 7;</code>
       */
      public Builder removeUseModels(int index) {
        if (useModelsBuilder_ == null) {
          ensureUseModelsIsMutable();
          useModels_.remove(index);
          onChanged();
        } else {
          useModelsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * The set of schemas that define the elements of the data tree that should
       * be sent by the target.
       * </pre>
       *
       * <code>repeated .gnmi.ModelData use_models = 7;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData.Builder getUseModelsBuilder(
          int index) {
        return getUseModelsFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * The set of schemas that define the elements of the data tree that should
       * be sent by the target.
       * </pre>
       *
       * <code>repeated .gnmi.ModelData use_models = 7;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelDataOrBuilder getUseModelsOrBuilder(
          int index) {
        if (useModelsBuilder_ == null) {
          return useModels_.get(index);  } else {
          return useModelsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * The set of schemas that define the elements of the data tree that should
       * be sent by the target.
       * </pre>
       *
       * <code>repeated .gnmi.ModelData use_models = 7;</code>
       */
      public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelDataOrBuilder> 
           getUseModelsOrBuilderList() {
        if (useModelsBuilder_ != null) {
          return useModelsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(useModels_);
        }
      }
      /**
       * <pre>
       * The set of schemas that define the elements of the data tree that should
       * be sent by the target.
       * </pre>
       *
       * <code>repeated .gnmi.ModelData use_models = 7;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData.Builder addUseModelsBuilder() {
        return getUseModelsFieldBuilder().addBuilder(
            org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData.getDefaultInstance());
      }
      /**
       * <pre>
       * The set of schemas that define the elements of the data tree that should
       * be sent by the target.
       * </pre>
       *
       * <code>repeated .gnmi.ModelData use_models = 7;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData.Builder addUseModelsBuilder(
          int index) {
        return getUseModelsFieldBuilder().addBuilder(
            index, org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData.getDefaultInstance());
      }
      /**
       * <pre>
       * The set of schemas that define the elements of the data tree that should
       * be sent by the target.
       * </pre>
       *
       * <code>repeated .gnmi.ModelData use_models = 7;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData.Builder> 
           getUseModelsBuilderList() {
        return getUseModelsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData, org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelDataOrBuilder> 
          getUseModelsFieldBuilder() {
        if (useModelsBuilder_ == null) {
          useModelsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData, org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelDataOrBuilder>(
                  useModels_,
                  ((bitField0_ & 0x00000040) != 0),
                  getParentForChildren(),
                  isClean());
          useModels_ = null;
        }
        return useModelsBuilder_;
      }

      private int encoding_ = 0;
      /**
       * <pre>
       * The encoding that the target should use within the Notifications generated
       * corresponding to the SubscriptionList.
       * </pre>
       *
       * <code>.gnmi.Encoding encoding = 8;</code>
       * @return The enum numeric value on the wire for encoding.
       */
      @java.lang.Override public int getEncodingValue() {
        return encoding_;
      }
      /**
       * <pre>
       * The encoding that the target should use within the Notifications generated
       * corresponding to the SubscriptionList.
       * </pre>
       *
       * <code>.gnmi.Encoding encoding = 8;</code>
       * @param value The enum numeric value on the wire for encoding to set.
       * @return This builder for chaining.
       */
      public Builder setEncodingValue(int value) {
        encoding_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The encoding that the target should use within the Notifications generated
       * corresponding to the SubscriptionList.
       * </pre>
       *
       * <code>.gnmi.Encoding encoding = 8;</code>
       * @return The encoding.
       */
      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding getEncoding() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding result = org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding.forNumber(encoding_);
        return result == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * The encoding that the target should use within the Notifications generated
       * corresponding to the SubscriptionList.
       * </pre>
       *
       * <code>.gnmi.Encoding encoding = 8;</code>
       * @param value The encoding to set.
       * @return This builder for chaining.
       */
      public Builder setEncoding(org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000080;
        encoding_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The encoding that the target should use within the Notifications generated
       * corresponding to the SubscriptionList.
       * </pre>
       *
       * <code>.gnmi.Encoding encoding = 8;</code>
       * @return This builder for chaining.
       */
      public Builder clearEncoding() {
        bitField0_ = (bitField0_ & ~0x00000080);
        encoding_ = 0;
        onChanged();
        return this;
      }

      private boolean updatesOnly_ ;
      /**
       * <pre>
       * An optional field to specify that only updates to current state should be
       * sent to a client. If set, the initial state is not sent to the client but
       * rather only the sync message followed by any subsequent updates to the
       * current state. For ONCE and POLL modes, this causes the server to send only
       * the sync message (Sec. 3.5.2.3).
       * </pre>
       *
       * <code>bool updates_only = 9;</code>
       * @return The updatesOnly.
       */
      @java.lang.Override
      public boolean getUpdatesOnly() {
        return updatesOnly_;
      }
      /**
       * <pre>
       * An optional field to specify that only updates to current state should be
       * sent to a client. If set, the initial state is not sent to the client but
       * rather only the sync message followed by any subsequent updates to the
       * current state. For ONCE and POLL modes, this causes the server to send only
       * the sync message (Sec. 3.5.2.3).
       * </pre>
       *
       * <code>bool updates_only = 9;</code>
       * @param value The updatesOnly to set.
       * @return This builder for chaining.
       */
      public Builder setUpdatesOnly(boolean value) {

        updatesOnly_ = value;
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * An optional field to specify that only updates to current state should be
       * sent to a client. If set, the initial state is not sent to the client but
       * rather only the sync message followed by any subsequent updates to the
       * current state. For ONCE and POLL modes, this causes the server to send only
       * the sync message (Sec. 3.5.2.3).
       * </pre>
       *
       * <code>bool updates_only = 9;</code>
       * @return This builder for chaining.
       */
      public Builder clearUpdatesOnly() {
        bitField0_ = (bitField0_ & ~0x00000100);
        updatesOnly_ = false;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:gnmi.SubscriptionList)
    }

    // @@protoc_insertion_point(class_scope:gnmi.SubscriptionList)
    private static final org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList();
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SubscriptionList>
        PARSER = new com.google.protobuf.AbstractParser<SubscriptionList>() {
      @java.lang.Override
      public SubscriptionList parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<SubscriptionList> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SubscriptionList> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionList getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface SubscriptionOrBuilder extends
      // @@protoc_insertion_point(interface_extends:gnmi.Subscription)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The data tree path.
     * </pre>
     *
     * <code>.gnmi.Path path = 1;</code>
     * @return Whether the path field is set.
     */
    boolean hasPath();
    /**
     * <pre>
     * The data tree path.
     * </pre>
     *
     * <code>.gnmi.Path path = 1;</code>
     * @return The path.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPath();
    /**
     * <pre>
     * The data tree path.
     * </pre>
     *
     * <code>.gnmi.Path path = 1;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPathOrBuilder();

    /**
     * <pre>
     * Subscription mode to be used.
     * </pre>
     *
     * <code>.gnmi.SubscriptionMode mode = 2;</code>
     * @return The enum numeric value on the wire for mode.
     */
    int getModeValue();
    /**
     * <pre>
     * Subscription mode to be used.
     * </pre>
     *
     * <code>.gnmi.SubscriptionMode mode = 2;</code>
     * @return The mode.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionMode getMode();

    /**
     * <pre>
     * ns between samples in SAMPLE mode.
     * </pre>
     *
     * <code>uint64 sample_interval = 3;</code>
     * @return The sampleInterval.
     */
    long getSampleInterval();

    /**
     * <pre>
     * Indicates whether values that have not changed should be sent in a SAMPLE
     * subscription.
     * </pre>
     *
     * <code>bool suppress_redundant = 4;</code>
     * @return The suppressRedundant.
     */
    boolean getSuppressRedundant();

    /**
     * <pre>
     * Specifies the maximum allowable silent period in nanoseconds when
     * suppress_redundant is in use. The target should send a value at least once
     * in the period specified.
     * </pre>
     *
     * <code>uint64 heartbeat_interval = 5;</code>
     * @return The heartbeatInterval.
     */
    long getHeartbeatInterval();
  }
  /**
   * <pre>
   * Subscription is a single request within a SubscriptionList. The path
   * specified is interpreted (along with the prefix) as the elements of the data
   * tree that the client is subscribing to. The mode determines how the target
   * should trigger updates to be sent.
   * Reference: gNMI Specification Section 3.5.1.3
   * </pre>
   *
   * Protobuf type {@code gnmi.Subscription}
   */
  public static final class Subscription extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:gnmi.Subscription)
      SubscriptionOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Subscription.newBuilder() to construct.
    private Subscription(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Subscription() {
      mode_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Subscription();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Subscription_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Subscription_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription.Builder.class);
    }

    private int bitField0_;
    public static final int PATH_FIELD_NUMBER = 1;
    private org.opennms.features.openconfig.proto.gnmi.Gnmi.Path path_;
    /**
     * <pre>
     * The data tree path.
     * </pre>
     *
     * <code>.gnmi.Path path = 1;</code>
     * @return Whether the path field is set.
     */
    @java.lang.Override
    public boolean hasPath() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * The data tree path.
     * </pre>
     *
     * <code>.gnmi.Path path = 1;</code>
     * @return The path.
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPath() {
      return path_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : path_;
    }
    /**
     * <pre>
     * The data tree path.
     * </pre>
     *
     * <code>.gnmi.Path path = 1;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPathOrBuilder() {
      return path_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : path_;
    }

    public static final int MODE_FIELD_NUMBER = 2;
    private int mode_ = 0;
    /**
     * <pre>
     * Subscription mode to be used.
     * </pre>
     *
     * <code>.gnmi.SubscriptionMode mode = 2;</code>
     * @return The enum numeric value on the wire for mode.
     */
    @java.lang.Override public int getModeValue() {
      return mode_;
    }
    /**
     * <pre>
     * Subscription mode to be used.
     * </pre>
     *
     * <code>.gnmi.SubscriptionMode mode = 2;</code>
     * @return The mode.
     */
    @java.lang.Override public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionMode getMode() {
      org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionMode result = org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionMode.forNumber(mode_);
      return result == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionMode.UNRECOGNIZED : result;
    }

    public static final int SAMPLE_INTERVAL_FIELD_NUMBER = 3;
    private long sampleInterval_ = 0L;
    /**
     * <pre>
     * ns between samples in SAMPLE mode.
     * </pre>
     *
     * <code>uint64 sample_interval = 3;</code>
     * @return The sampleInterval.
     */
    @java.lang.Override
    public long getSampleInterval() {
      return sampleInterval_;
    }

    public static final int SUPPRESS_REDUNDANT_FIELD_NUMBER = 4;
    private boolean suppressRedundant_ = false;
    /**
     * <pre>
     * Indicates whether values that have not changed should be sent in a SAMPLE
     * subscription.
     * </pre>
     *
     * <code>bool suppress_redundant = 4;</code>
     * @return The suppressRedundant.
     */
    @java.lang.Override
    public boolean getSuppressRedundant() {
      return suppressRedundant_;
    }

    public static final int HEARTBEAT_INTERVAL_FIELD_NUMBER = 5;
    private long heartbeatInterval_ = 0L;
    /**
     * <pre>
     * Specifies the maximum allowable silent period in nanoseconds when
     * suppress_redundant is in use. The target should send a value at least once
     * in the period specified.
     * </pre>
     *
     * <code>uint64 heartbeat_interval = 5;</code>
     * @return The heartbeatInterval.
     */
    @java.lang.Override
    public long getHeartbeatInterval() {
      return heartbeatInterval_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getPath());
      }
      if (mode_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionMode.TARGET_DEFINED.getNumber()) {
        output.writeEnum(2, mode_);
      }
      if (sampleInterval_ != 0L) {
        output.writeUInt64(3, sampleInterval_);
      }
      if (suppressRedundant_ != false) {
        output.writeBool(4, suppressRedundant_);
      }
      if (heartbeatInterval_ != 0L) {
        output.writeUInt64(5, heartbeatInterval_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getPath());
      }
      if (mode_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionMode.TARGET_DEFINED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, mode_);
      }
      if (sampleInterval_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(3, sampleInterval_);
      }
      if (suppressRedundant_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(4, suppressRedundant_);
      }
      if (heartbeatInterval_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(5, heartbeatInterval_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription)) {
        return super.equals(obj);
      }
      org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription other = (org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription) obj;

      if (hasPath() != other.hasPath()) return false;
      if (hasPath()) {
        if (!getPath()
            .equals(other.getPath())) return false;
      }
      if (mode_ != other.mode_) return false;
      if (getSampleInterval()
          != other.getSampleInterval()) return false;
      if (getSuppressRedundant()
          != other.getSuppressRedundant()) return false;
      if (getHeartbeatInterval()
          != other.getHeartbeatInterval()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPath()) {
        hash = (37 * hash) + PATH_FIELD_NUMBER;
        hash = (53 * hash) + getPath().hashCode();
      }
      hash = (37 * hash) + MODE_FIELD_NUMBER;
      hash = (53 * hash) + mode_;
      hash = (37 * hash) + SAMPLE_INTERVAL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getSampleInterval());
      hash = (37 * hash) + SUPPRESS_REDUNDANT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getSuppressRedundant());
      hash = (37 * hash) + HEARTBEAT_INTERVAL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getHeartbeatInterval());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Subscription is a single request within a SubscriptionList. The path
     * specified is interpreted (along with the prefix) as the elements of the data
     * tree that the client is subscribing to. The mode determines how the target
     * should trigger updates to be sent.
     * Reference: gNMI Specification Section 3.5.1.3
     * </pre>
     *
     * Protobuf type {@code gnmi.Subscription}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:gnmi.Subscription)
        org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Subscription_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Subscription_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription.Builder.class);
      }

      // Construct using org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getPathFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        path_ = null;
        if (pathBuilder_ != null) {
          pathBuilder_.dispose();
          pathBuilder_ = null;
        }
        mode_ = 0;
        sampleInterval_ = 0L;
        suppressRedundant_ = false;
        heartbeatInterval_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Subscription_descriptor;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription getDefaultInstanceForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription.getDefaultInstance();
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription build() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription buildPartial() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription result = new org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.path_ = pathBuilder_ == null
              ? path_
              : pathBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.mode_ = mode_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.sampleInterval_ = sampleInterval_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.suppressRedundant_ = suppressRedundant_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.heartbeatInterval_ = heartbeatInterval_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription) {
          return mergeFrom((org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription other) {
        if (other == org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription.getDefaultInstance()) return this;
        if (other.hasPath()) {
          mergePath(other.getPath());
        }
        if (other.mode_ != 0) {
          setModeValue(other.getModeValue());
        }
        if (other.getSampleInterval() != 0L) {
          setSampleInterval(other.getSampleInterval());
        }
        if (other.getSuppressRedundant() != false) {
          setSuppressRedundant(other.getSuppressRedundant());
        }
        if (other.getHeartbeatInterval() != 0L) {
          setHeartbeatInterval(other.getHeartbeatInterval());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getPathFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 16: {
                mode_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
              case 24: {
                sampleInterval_ = input.readUInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
              case 32: {
                suppressRedundant_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
              case 40: {
                heartbeatInterval_ = input.readUInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.opennms.features.openconfig.proto.gnmi.Gnmi.Path path_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> pathBuilder_;
      /**
       * <pre>
       * The data tree path.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       * @return Whether the path field is set.
       */
      public boolean hasPath() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * The data tree path.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       * @return The path.
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPath() {
        if (pathBuilder_ == null) {
          return path_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : path_;
        } else {
          return pathBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * The data tree path.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       */
      public Builder setPath(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (pathBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          path_ = value;
        } else {
          pathBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The data tree path.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       */
      public Builder setPath(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder builderForValue) {
        if (pathBuilder_ == null) {
          path_ = builderForValue.build();
        } else {
          pathBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The data tree path.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       */
      public Builder mergePath(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (pathBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            path_ != null &&
            path_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance()) {
            getPathBuilder().mergeFrom(value);
          } else {
            path_ = value;
          }
        } else {
          pathBuilder_.mergeFrom(value);
        }
        if (path_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * The data tree path.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       */
      public Builder clearPath() {
        bitField0_ = (bitField0_ & ~0x00000001);
        path_ = null;
        if (pathBuilder_ != null) {
          pathBuilder_.dispose();
          pathBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The data tree path.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder getPathBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getPathFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * The data tree path.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPathOrBuilder() {
        if (pathBuilder_ != null) {
          return pathBuilder_.getMessageOrBuilder();
        } else {
          return path_ == null ?
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : path_;
        }
      }
      /**
       * <pre>
       * The data tree path.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> 
          getPathFieldBuilder() {
        if (pathBuilder_ == null) {
          pathBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder>(
                  getPath(),
                  getParentForChildren(),
                  isClean());
          path_ = null;
        }
        return pathBuilder_;
      }

      private int mode_ = 0;
      /**
       * <pre>
       * Subscription mode to be used.
       * </pre>
       *
       * <code>.gnmi.SubscriptionMode mode = 2;</code>
       * @return The enum numeric value on the wire for mode.
       */
      @java.lang.Override public int getModeValue() {
        return mode_;
      }
      /**
       * <pre>
       * Subscription mode to be used.
       * </pre>
       *
       * <code>.gnmi.SubscriptionMode mode = 2;</code>
       * @param value The enum numeric value on the wire for mode to set.
       * @return This builder for chaining.
       */
      public Builder setModeValue(int value) {
        mode_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Subscription mode to be used.
       * </pre>
       *
       * <code>.gnmi.SubscriptionMode mode = 2;</code>
       * @return The mode.
       */
      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionMode getMode() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionMode result = org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionMode.forNumber(mode_);
        return result == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionMode.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Subscription mode to be used.
       * </pre>
       *
       * <code>.gnmi.SubscriptionMode mode = 2;</code>
       * @param value The mode to set.
       * @return This builder for chaining.
       */
      public Builder setMode(org.opennms.features.openconfig.proto.gnmi.Gnmi.SubscriptionMode value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        mode_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Subscription mode to be used.
       * </pre>
       *
       * <code>.gnmi.SubscriptionMode mode = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearMode() {
        bitField0_ = (bitField0_ & ~0x00000002);
        mode_ = 0;
        onChanged();
        return this;
      }

      private long sampleInterval_ ;
      /**
       * <pre>
       * ns between samples in SAMPLE mode.
       * </pre>
       *
       * <code>uint64 sample_interval = 3;</code>
       * @return The sampleInterval.
       */
      @java.lang.Override
      public long getSampleInterval() {
        return sampleInterval_;
      }
      /**
       * <pre>
       * ns between samples in SAMPLE mode.
       * </pre>
       *
       * <code>uint64 sample_interval = 3;</code>
       * @param value The sampleInterval to set.
       * @return This builder for chaining.
       */
      public Builder setSampleInterval(long value) {

        sampleInterval_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ns between samples in SAMPLE mode.
       * </pre>
       *
       * <code>uint64 sample_interval = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearSampleInterval() {
        bitField0_ = (bitField0_ & ~0x00000004);
        sampleInterval_ = 0L;
        onChanged();
        return this;
      }

      private boolean suppressRedundant_ ;
      /**
       * <pre>
       * Indicates whether values that have not changed should be sent in a SAMPLE
       * subscription.
       * </pre>
       *
       * <code>bool suppress_redundant = 4;</code>
       * @return The suppressRedundant.
       */
      @java.lang.Override
      public boolean getSuppressRedundant() {
        return suppressRedundant_;
      }
      /**
       * <pre>
       * Indicates whether values that have not changed should be sent in a SAMPLE
       * subscription.
       * </pre>
       *
       * <code>bool suppress_redundant = 4;</code>
       * @param value The suppressRedundant to set.
       * @return This builder for chaining.
       */
      public Builder setSuppressRedundant(boolean value) {

        suppressRedundant_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Indicates whether values that have not changed should be sent in a SAMPLE
       * subscription.
       * </pre>
       *
       * <code>bool suppress_redundant = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearSuppressRedundant() {
        bitField0_ = (bitField0_ & ~0x00000008);
        suppressRedundant_ = false;
        onChanged();
        return this;
      }

      private long heartbeatInterval_ ;
      /**
       * <pre>
       * Specifies the maximum allowable silent period in nanoseconds when
       * suppress_redundant is in use. The target should send a value at least once
       * in the period specified.
       * </pre>
       *
       * <code>uint64 heartbeat_interval = 5;</code>
       * @return The heartbeatInterval.
       */
      @java.lang.Override
      public long getHeartbeatInterval() {
        return heartbeatInterval_;
      }
      /**
       * <pre>
       * Specifies the maximum allowable silent period in nanoseconds when
       * suppress_redundant is in use. The target should send a value at least once
       * in the period specified.
       * </pre>
       *
       * <code>uint64 heartbeat_interval = 5;</code>
       * @param value The heartbeatInterval to set.
       * @return This builder for chaining.
       */
      public Builder setHeartbeatInterval(long value) {

        heartbeatInterval_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the maximum allowable silent period in nanoseconds when
       * suppress_redundant is in use. The target should send a value at least once
       * in the period specified.
       * </pre>
       *
       * <code>uint64 heartbeat_interval = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearHeartbeatInterval() {
        bitField0_ = (bitField0_ & ~0x00000010);
        heartbeatInterval_ = 0L;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:gnmi.Subscription)
    }

    // @@protoc_insertion_point(class_scope:gnmi.Subscription)
    private static final org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription();
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Subscription>
        PARSER = new com.google.protobuf.AbstractParser<Subscription>() {
      @java.lang.Override
      public Subscription parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Subscription> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Subscription> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Subscription getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface QOSMarkingOrBuilder extends
      // @@protoc_insertion_point(interface_extends:gnmi.QOSMarking)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>uint32 marking = 1;</code>
     * @return The marking.
     */
    int getMarking();
  }
  /**
   * <pre>
   * QOSMarking specifies the DSCP value to be set on transmitted telemetry
   * updates from the target.
   * Reference: gNMI Specification Section 3.5.1.2
   * </pre>
   *
   * Protobuf type {@code gnmi.QOSMarking}
   */
  public static final class QOSMarking extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:gnmi.QOSMarking)
      QOSMarkingOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use QOSMarking.newBuilder() to construct.
    private QOSMarking(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private QOSMarking() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new QOSMarking();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_QOSMarking_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_QOSMarking_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking.Builder.class);
    }

    public static final int MARKING_FIELD_NUMBER = 1;
    private int marking_ = 0;
    /**
     * <code>uint32 marking = 1;</code>
     * @return The marking.
     */
    @java.lang.Override
    public int getMarking() {
      return marking_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (marking_ != 0) {
        output.writeUInt32(1, marking_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (marking_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(1, marking_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking)) {
        return super.equals(obj);
      }
      org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking other = (org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking) obj;

      if (getMarking()
          != other.getMarking()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MARKING_FIELD_NUMBER;
      hash = (53 * hash) + getMarking();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * QOSMarking specifies the DSCP value to be set on transmitted telemetry
     * updates from the target.
     * Reference: gNMI Specification Section 3.5.1.2
     * </pre>
     *
     * Protobuf type {@code gnmi.QOSMarking}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:gnmi.QOSMarking)
        org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarkingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_QOSMarking_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_QOSMarking_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking.Builder.class);
      }

      // Construct using org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        marking_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_QOSMarking_descriptor;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking getDefaultInstanceForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking.getDefaultInstance();
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking build() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking buildPartial() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking result = new org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.marking_ = marking_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking) {
          return mergeFrom((org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking other) {
        if (other == org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking.getDefaultInstance()) return this;
        if (other.getMarking() != 0) {
          setMarking(other.getMarking());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                marking_ = input.readUInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int marking_ ;
      /**
       * <code>uint32 marking = 1;</code>
       * @return The marking.
       */
      @java.lang.Override
      public int getMarking() {
        return marking_;
      }
      /**
       * <code>uint32 marking = 1;</code>
       * @param value The marking to set.
       * @return This builder for chaining.
       */
      public Builder setMarking(int value) {

        marking_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>uint32 marking = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearMarking() {
        bitField0_ = (bitField0_ & ~0x00000001);
        marking_ = 0;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:gnmi.QOSMarking)
    }

    // @@protoc_insertion_point(class_scope:gnmi.QOSMarking)
    private static final org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking();
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QOSMarking>
        PARSER = new com.google.protobuf.AbstractParser<QOSMarking>() {
      @java.lang.Override
      public QOSMarking parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<QOSMarking> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QOSMarking> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.QOSMarking getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface AliasOrBuilder extends
      // @@protoc_insertion_point(interface_extends:gnmi.Alias)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The path to be aliased.
     * </pre>
     *
     * <code>.gnmi.Path path = 1;</code>
     * @return Whether the path field is set.
     */
    boolean hasPath();
    /**
     * <pre>
     * The path to be aliased.
     * </pre>
     *
     * <code>.gnmi.Path path = 1;</code>
     * @return The path.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPath();
    /**
     * <pre>
     * The path to be aliased.
     * </pre>
     *
     * <code>.gnmi.Path path = 1;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPathOrBuilder();

    /**
     * <pre>
     * The alias value, a string prefixed by "#".
     * </pre>
     *
     * <code>string alias = 2;</code>
     * @return The alias.
     */
    java.lang.String getAlias();
    /**
     * <pre>
     * The alias value, a string prefixed by "#".
     * </pre>
     *
     * <code>string alias = 2;</code>
     * @return The bytes for alias.
     */
    com.google.protobuf.ByteString
        getAliasBytes();
  }
  /**
   * <pre>
   * Alias specifies a data tree path, and an associated string which defines an
   * alias which is to be used for this path in the context of the RPC. The alias
   * is specified as a string which is prefixed with "#" to disambiguate it from
   * data tree element paths.
   * Reference: gNMI Specification Section 2.4.2
   * </pre>
   *
   * Protobuf type {@code gnmi.Alias}
   */
  public static final class Alias extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:gnmi.Alias)
      AliasOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Alias.newBuilder() to construct.
    private Alias(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Alias() {
      alias_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Alias();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Alias_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Alias_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias.Builder.class);
    }

    private int bitField0_;
    public static final int PATH_FIELD_NUMBER = 1;
    private org.opennms.features.openconfig.proto.gnmi.Gnmi.Path path_;
    /**
     * <pre>
     * The path to be aliased.
     * </pre>
     *
     * <code>.gnmi.Path path = 1;</code>
     * @return Whether the path field is set.
     */
    @java.lang.Override
    public boolean hasPath() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * The path to be aliased.
     * </pre>
     *
     * <code>.gnmi.Path path = 1;</code>
     * @return The path.
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPath() {
      return path_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : path_;
    }
    /**
     * <pre>
     * The path to be aliased.
     * </pre>
     *
     * <code>.gnmi.Path path = 1;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPathOrBuilder() {
      return path_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : path_;
    }

    public static final int ALIAS_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private volatile java.lang.Object alias_ = "";
    /**
     * <pre>
     * The alias value, a string prefixed by "#".
     * </pre>
     *
     * <code>string alias = 2;</code>
     * @return The alias.
     */
    @java.lang.Override
    public java.lang.String getAlias() {
      java.lang.Object ref = alias_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        alias_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * The alias value, a string prefixed by "#".
     * </pre>
     *
     * <code>string alias = 2;</code>
     * @return The bytes for alias.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getAliasBytes() {
      java.lang.Object ref = alias_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        alias_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getPath());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(alias_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, alias_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getPath());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(alias_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, alias_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias)) {
        return super.equals(obj);
      }
      org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias other = (org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias) obj;

      if (hasPath() != other.hasPath()) return false;
      if (hasPath()) {
        if (!getPath()
            .equals(other.getPath())) return false;
      }
      if (!getAlias()
          .equals(other.getAlias())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPath()) {
        hash = (37 * hash) + PATH_FIELD_NUMBER;
        hash = (53 * hash) + getPath().hashCode();
      }
      hash = (37 * hash) + ALIAS_FIELD_NUMBER;
      hash = (53 * hash) + getAlias().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Alias specifies a data tree path, and an associated string which defines an
     * alias which is to be used for this path in the context of the RPC. The alias
     * is specified as a string which is prefixed with "#" to disambiguate it from
     * data tree element paths.
     * Reference: gNMI Specification Section 2.4.2
     * </pre>
     *
     * Protobuf type {@code gnmi.Alias}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:gnmi.Alias)
        org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Alias_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Alias_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias.Builder.class);
      }

      // Construct using org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getPathFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        path_ = null;
        if (pathBuilder_ != null) {
          pathBuilder_.dispose();
          pathBuilder_ = null;
        }
        alias_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_Alias_descriptor;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias getDefaultInstanceForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias.getDefaultInstance();
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias build() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias buildPartial() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias result = new org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.path_ = pathBuilder_ == null
              ? path_
              : pathBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.alias_ = alias_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias) {
          return mergeFrom((org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias other) {
        if (other == org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias.getDefaultInstance()) return this;
        if (other.hasPath()) {
          mergePath(other.getPath());
        }
        if (!other.getAlias().isEmpty()) {
          alias_ = other.alias_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getPathFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                alias_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.opennms.features.openconfig.proto.gnmi.Gnmi.Path path_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> pathBuilder_;
      /**
       * <pre>
       * The path to be aliased.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       * @return Whether the path field is set.
       */
      public boolean hasPath() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * The path to be aliased.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       * @return The path.
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPath() {
        if (pathBuilder_ == null) {
          return path_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : path_;
        } else {
          return pathBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * The path to be aliased.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       */
      public Builder setPath(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (pathBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          path_ = value;
        } else {
          pathBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The path to be aliased.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       */
      public Builder setPath(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder builderForValue) {
        if (pathBuilder_ == null) {
          path_ = builderForValue.build();
        } else {
          pathBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The path to be aliased.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       */
      public Builder mergePath(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (pathBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            path_ != null &&
            path_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance()) {
            getPathBuilder().mergeFrom(value);
          } else {
            path_ = value;
          }
        } else {
          pathBuilder_.mergeFrom(value);
        }
        if (path_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * The path to be aliased.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       */
      public Builder clearPath() {
        bitField0_ = (bitField0_ & ~0x00000001);
        path_ = null;
        if (pathBuilder_ != null) {
          pathBuilder_.dispose();
          pathBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The path to be aliased.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder getPathBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getPathFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * The path to be aliased.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPathOrBuilder() {
        if (pathBuilder_ != null) {
          return pathBuilder_.getMessageOrBuilder();
        } else {
          return path_ == null ?
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : path_;
        }
      }
      /**
       * <pre>
       * The path to be aliased.
       * </pre>
       *
       * <code>.gnmi.Path path = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> 
          getPathFieldBuilder() {
        if (pathBuilder_ == null) {
          pathBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder>(
                  getPath(),
                  getParentForChildren(),
                  isClean());
          path_ = null;
        }
        return pathBuilder_;
      }

      private java.lang.Object alias_ = "";
      /**
       * <pre>
       * The alias value, a string prefixed by "#".
       * </pre>
       *
       * <code>string alias = 2;</code>
       * @return The alias.
       */
      public java.lang.String getAlias() {
        java.lang.Object ref = alias_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          alias_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The alias value, a string prefixed by "#".
       * </pre>
       *
       * <code>string alias = 2;</code>
       * @return The bytes for alias.
       */
      public com.google.protobuf.ByteString
          getAliasBytes() {
        java.lang.Object ref = alias_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          alias_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The alias value, a string prefixed by "#".
       * </pre>
       *
       * <code>string alias = 2;</code>
       * @param value The alias to set.
       * @return This builder for chaining.
       */
      public Builder setAlias(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        alias_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The alias value, a string prefixed by "#".
       * </pre>
       *
       * <code>string alias = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearAlias() {
        alias_ = getDefaultInstance().getAlias();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The alias value, a string prefixed by "#".
       * </pre>
       *
       * <code>string alias = 2;</code>
       * @param value The bytes for alias to set.
       * @return This builder for chaining.
       */
      public Builder setAliasBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        checkByteStringIsUtf8(value);
        alias_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:gnmi.Alias)
    }

    // @@protoc_insertion_point(class_scope:gnmi.Alias)
    private static final org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias();
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Alias>
        PARSER = new com.google.protobuf.AbstractParser<Alias>() {
      @java.lang.Override
      public Alias parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Alias> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Alias> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface AliasListOrBuilder extends
      // @@protoc_insertion_point(interface_extends:gnmi.AliasList)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The set of aliases to be created.
     * </pre>
     *
     * <code>repeated .gnmi.Alias alias = 1;</code>
     */
    java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias> 
        getAliasList();
    /**
     * <pre>
     * The set of aliases to be created.
     * </pre>
     *
     * <code>repeated .gnmi.Alias alias = 1;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias getAlias(int index);
    /**
     * <pre>
     * The set of aliases to be created.
     * </pre>
     *
     * <code>repeated .gnmi.Alias alias = 1;</code>
     */
    int getAliasCount();
    /**
     * <pre>
     * The set of aliases to be created.
     * </pre>
     *
     * <code>repeated .gnmi.Alias alias = 1;</code>
     */
    java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasOrBuilder> 
        getAliasOrBuilderList();
    /**
     * <pre>
     * The set of aliases to be created.
     * </pre>
     *
     * <code>repeated .gnmi.Alias alias = 1;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasOrBuilder getAliasOrBuilder(
        int index);
  }
  /**
   * <pre>
   * AliasList specifies a list of aliases. It is used in a SubscribeRequest for
   * a client to create a set of aliases that the target is to utilize.
   * Reference: gNMI Specification Section 3.5.1.6
   * </pre>
   *
   * Protobuf type {@code gnmi.AliasList}
   */
  public static final class AliasList extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:gnmi.AliasList)
      AliasListOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use AliasList.newBuilder() to construct.
    private AliasList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private AliasList() {
      alias_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new AliasList();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_AliasList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_AliasList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList.Builder.class);
    }

    public static final int ALIAS_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias> alias_;
    /**
     * <pre>
     * The set of aliases to be created.
     * </pre>
     *
     * <code>repeated .gnmi.Alias alias = 1;</code>
     */
    @java.lang.Override
    public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias> getAliasList() {
      return alias_;
    }
    /**
     * <pre>
     * The set of aliases to be created.
     * </pre>
     *
     * <code>repeated .gnmi.Alias alias = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasOrBuilder> 
        getAliasOrBuilderList() {
      return alias_;
    }
    /**
     * <pre>
     * The set of aliases to be created.
     * </pre>
     *
     * <code>repeated .gnmi.Alias alias = 1;</code>
     */
    @java.lang.Override
    public int getAliasCount() {
      return alias_.size();
    }
    /**
     * <pre>
     * The set of aliases to be created.
     * </pre>
     *
     * <code>repeated .gnmi.Alias alias = 1;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias getAlias(int index) {
      return alias_.get(index);
    }
    /**
     * <pre>
     * The set of aliases to be created.
     * </pre>
     *
     * <code>repeated .gnmi.Alias alias = 1;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasOrBuilder getAliasOrBuilder(
        int index) {
      return alias_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < alias_.size(); i++) {
        output.writeMessage(1, alias_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < alias_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, alias_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList)) {
        return super.equals(obj);
      }
      org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList other = (org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList) obj;

      if (!getAliasList()
          .equals(other.getAliasList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getAliasCount() > 0) {
        hash = (37 * hash) + ALIAS_FIELD_NUMBER;
        hash = (53 * hash) + getAliasList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * AliasList specifies a list of aliases. It is used in a SubscribeRequest for
     * a client to create a set of aliases that the target is to utilize.
     * Reference: gNMI Specification Section 3.5.1.6
     * </pre>
     *
     * Protobuf type {@code gnmi.AliasList}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:gnmi.AliasList)
        org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasListOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_AliasList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_AliasList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList.Builder.class);
      }

      // Construct using org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (aliasBuilder_ == null) {
          alias_ = java.util.Collections.emptyList();
        } else {
          alias_ = null;
          aliasBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_AliasList_descriptor;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList getDefaultInstanceForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList.getDefaultInstance();
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList build() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList buildPartial() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList result = new org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList result) {
        if (aliasBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            alias_ = java.util.Collections.unmodifiableList(alias_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.alias_ = alias_;
        } else {
          result.alias_ = aliasBuilder_.build();
        }
      }

      private void buildPartial0(org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList) {
          return mergeFrom((org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList other) {
        if (other == org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList.getDefaultInstance()) return this;
        if (aliasBuilder_ == null) {
          if (!other.alias_.isEmpty()) {
            if (alias_.isEmpty()) {
              alias_ = other.alias_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureAliasIsMutable();
              alias_.addAll(other.alias_);
            }
            onChanged();
          }
        } else {
          if (!other.alias_.isEmpty()) {
            if (aliasBuilder_.isEmpty()) {
              aliasBuilder_.dispose();
              aliasBuilder_ = null;
              alias_ = other.alias_;
              bitField0_ = (bitField0_ & ~0x00000001);
              aliasBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getAliasFieldBuilder() : null;
            } else {
              aliasBuilder_.addAllMessages(other.alias_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias m =
                    input.readMessage(
                        org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias.parser(),
                        extensionRegistry);
                if (aliasBuilder_ == null) {
                  ensureAliasIsMutable();
                  alias_.add(m);
                } else {
                  aliasBuilder_.addMessage(m);
                }
                break;
              } // case 10
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias> alias_ =
        java.util.Collections.emptyList();
      private void ensureAliasIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          alias_ = new java.util.ArrayList<org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias>(alias_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias, org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasOrBuilder> aliasBuilder_;

      /**
       * <pre>
       * The set of aliases to be created.
       * </pre>
       *
       * <code>repeated .gnmi.Alias alias = 1;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias> getAliasList() {
        if (aliasBuilder_ == null) {
          return java.util.Collections.unmodifiableList(alias_);
        } else {
          return aliasBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * The set of aliases to be created.
       * </pre>
       *
       * <code>repeated .gnmi.Alias alias = 1;</code>
       */
      public int getAliasCount() {
        if (aliasBuilder_ == null) {
          return alias_.size();
        } else {
          return aliasBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * The set of aliases to be created.
       * </pre>
       *
       * <code>repeated .gnmi.Alias alias = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias getAlias(int index) {
        if (aliasBuilder_ == null) {
          return alias_.get(index);
        } else {
          return aliasBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * The set of aliases to be created.
       * </pre>
       *
       * <code>repeated .gnmi.Alias alias = 1;</code>
       */
      public Builder setAlias(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias value) {
        if (aliasBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAliasIsMutable();
          alias_.set(index, value);
          onChanged();
        } else {
          aliasBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * The set of aliases to be created.
       * </pre>
       *
       * <code>repeated .gnmi.Alias alias = 1;</code>
       */
      public Builder setAlias(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias.Builder builderForValue) {
        if (aliasBuilder_ == null) {
          ensureAliasIsMutable();
          alias_.set(index, builderForValue.build());
          onChanged();
        } else {
          aliasBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * The set of aliases to be created.
       * </pre>
       *
       * <code>repeated .gnmi.Alias alias = 1;</code>
       */
      public Builder addAlias(org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias value) {
        if (aliasBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAliasIsMutable();
          alias_.add(value);
          onChanged();
        } else {
          aliasBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * The set of aliases to be created.
       * </pre>
       *
       * <code>repeated .gnmi.Alias alias = 1;</code>
       */
      public Builder addAlias(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias value) {
        if (aliasBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAliasIsMutable();
          alias_.add(index, value);
          onChanged();
        } else {
          aliasBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * The set of aliases to be created.
       * </pre>
       *
       * <code>repeated .gnmi.Alias alias = 1;</code>
       */
      public Builder addAlias(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias.Builder builderForValue) {
        if (aliasBuilder_ == null) {
          ensureAliasIsMutable();
          alias_.add(builderForValue.build());
          onChanged();
        } else {
          aliasBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * The set of aliases to be created.
       * </pre>
       *
       * <code>repeated .gnmi.Alias alias = 1;</code>
       */
      public Builder addAlias(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias.Builder builderForValue) {
        if (aliasBuilder_ == null) {
          ensureAliasIsMutable();
          alias_.add(index, builderForValue.build());
          onChanged();
        } else {
          aliasBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * The set of aliases to be created.
       * </pre>
       *
       * <code>repeated .gnmi.Alias alias = 1;</code>
       */
      public Builder addAllAlias(
          java.lang.Iterable<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias> values) {
        if (aliasBuilder_ == null) {
          ensureAliasIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, alias_);
          onChanged();
        } else {
          aliasBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * The set of aliases to be created.
       * </pre>
       *
       * <code>repeated .gnmi.Alias alias = 1;</code>
       */
      public Builder clearAlias() {
        if (aliasBuilder_ == null) {
          alias_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          aliasBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * The set of aliases to be created.
       * </pre>
       *
       * <code>repeated .gnmi.Alias alias = 1;</code>
       */
      public Builder removeAlias(int index) {
        if (aliasBuilder_ == null) {
          ensureAliasIsMutable();
          alias_.remove(index);
          onChanged();
        } else {
          aliasBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * The set of aliases to be created.
       * </pre>
       *
       * <code>repeated .gnmi.Alias alias = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias.Builder getAliasBuilder(
          int index) {
        return getAliasFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * The set of aliases to be created.
       * </pre>
       *
       * <code>repeated .gnmi.Alias alias = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasOrBuilder getAliasOrBuilder(
          int index) {
        if (aliasBuilder_ == null) {
          return alias_.get(index);  } else {
          return aliasBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * The set of aliases to be created.
       * </pre>
       *
       * <code>repeated .gnmi.Alias alias = 1;</code>
       */
      public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasOrBuilder> 
           getAliasOrBuilderList() {
        if (aliasBuilder_ != null) {
          return aliasBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(alias_);
        }
      }
      /**
       * <pre>
       * The set of aliases to be created.
       * </pre>
       *
       * <code>repeated .gnmi.Alias alias = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias.Builder addAliasBuilder() {
        return getAliasFieldBuilder().addBuilder(
            org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias.getDefaultInstance());
      }
      /**
       * <pre>
       * The set of aliases to be created.
       * </pre>
       *
       * <code>repeated .gnmi.Alias alias = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias.Builder addAliasBuilder(
          int index) {
        return getAliasFieldBuilder().addBuilder(
            index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias.getDefaultInstance());
      }
      /**
       * <pre>
       * The set of aliases to be created.
       * </pre>
       *
       * <code>repeated .gnmi.Alias alias = 1;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias.Builder> 
           getAliasBuilderList() {
        return getAliasFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias, org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasOrBuilder> 
          getAliasFieldBuilder() {
        if (aliasBuilder_ == null) {
          aliasBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias, org.opennms.features.openconfig.proto.gnmi.Gnmi.Alias.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasOrBuilder>(
                  alias_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          alias_ = null;
        }
        return aliasBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:gnmi.AliasList)
    }

    // @@protoc_insertion_point(class_scope:gnmi.AliasList)
    private static final org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList();
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AliasList>
        PARSER = new com.google.protobuf.AbstractParser<AliasList>() {
      @java.lang.Override
      public AliasList parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<AliasList> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AliasList> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.AliasList getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface SetRequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:gnmi.SetRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Prefix used for paths in the message.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     * @return Whether the prefix field is set.
     */
    boolean hasPrefix();
    /**
     * <pre>
     * Prefix used for paths in the message.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     * @return The prefix.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPrefix();
    /**
     * <pre>
     * Prefix used for paths in the message.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPrefixOrBuilder();

    /**
     * <pre>
     * Paths to be deleted from the data tree.
     * </pre>
     *
     * <code>repeated .gnmi.Path delete = 2;</code>
     */
    java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Path> 
        getDeleteList();
    /**
     * <pre>
     * Paths to be deleted from the data tree.
     * </pre>
     *
     * <code>repeated .gnmi.Path delete = 2;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getDelete(int index);
    /**
     * <pre>
     * Paths to be deleted from the data tree.
     * </pre>
     *
     * <code>repeated .gnmi.Path delete = 2;</code>
     */
    int getDeleteCount();
    /**
     * <pre>
     * Paths to be deleted from the data tree.
     * </pre>
     *
     * <code>repeated .gnmi.Path delete = 2;</code>
     */
    java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> 
        getDeleteOrBuilderList();
    /**
     * <pre>
     * Paths to be deleted from the data tree.
     * </pre>
     *
     * <code>repeated .gnmi.Path delete = 2;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getDeleteOrBuilder(
        int index);

    /**
     * <pre>
     * Updates specifying elements to be replaced.
     * </pre>
     *
     * <code>repeated .gnmi.Update replace = 3;</code>
     */
    java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Update> 
        getReplaceList();
    /**
     * <pre>
     * Updates specifying elements to be replaced.
     * </pre>
     *
     * <code>repeated .gnmi.Update replace = 3;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Update getReplace(int index);
    /**
     * <pre>
     * Updates specifying elements to be replaced.
     * </pre>
     *
     * <code>repeated .gnmi.Update replace = 3;</code>
     */
    int getReplaceCount();
    /**
     * <pre>
     * Updates specifying elements to be replaced.
     * </pre>
     *
     * <code>repeated .gnmi.Update replace = 3;</code>
     */
    java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder> 
        getReplaceOrBuilderList();
    /**
     * <pre>
     * Updates specifying elements to be replaced.
     * </pre>
     *
     * <code>repeated .gnmi.Update replace = 3;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder getReplaceOrBuilder(
        int index);

    /**
     * <pre>
     * Updates specifying elements to updated.
     * </pre>
     *
     * <code>repeated .gnmi.Update update = 4;</code>
     */
    java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Update> 
        getUpdateList();
    /**
     * <pre>
     * Updates specifying elements to updated.
     * </pre>
     *
     * <code>repeated .gnmi.Update update = 4;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Update getUpdate(int index);
    /**
     * <pre>
     * Updates specifying elements to updated.
     * </pre>
     *
     * <code>repeated .gnmi.Update update = 4;</code>
     */
    int getUpdateCount();
    /**
     * <pre>
     * Updates specifying elements to updated.
     * </pre>
     *
     * <code>repeated .gnmi.Update update = 4;</code>
     */
    java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder> 
        getUpdateOrBuilderList();
    /**
     * <pre>
     * Updates specifying elements to updated.
     * </pre>
     *
     * <code>repeated .gnmi.Update update = 4;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder getUpdateOrBuilder(
        int index);

    /**
     * <pre>
     * Extension messages associated with the SetRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> 
        getExtensionList();
    /**
     * <pre>
     * Extension messages associated with the SetRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension getExtension(int index);
    /**
     * <pre>
     * Extension messages associated with the SetRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    int getExtensionCount();
    /**
     * <pre>
     * Extension messages associated with the SetRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> 
        getExtensionOrBuilderList();
    /**
     * <pre>
     * Extension messages associated with the SetRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder getExtensionOrBuilder(
        int index);
  }
  /**
   * <pre>
   * SetRequest is sent from a client to the target to update values in the data
   * tree. Paths are either deleted by the client, or modified by means of being
   * updated, or replaced. Where a replace is used, unspecified values are
   * considered to be replaced, whereas when update is used the changes are
   * considered to be incremental. The set of changes that are specified within
   * a single SetRequest are considered to be a transaction.
   * Reference: gNMI Specification Section 3.4.1
   * </pre>
   *
   * Protobuf type {@code gnmi.SetRequest}
   */
  public static final class SetRequest extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:gnmi.SetRequest)
      SetRequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use SetRequest.newBuilder() to construct.
    private SetRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private SetRequest() {
      delete_ = java.util.Collections.emptyList();
      replace_ = java.util.Collections.emptyList();
      update_ = java.util.Collections.emptyList();
      extension_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new SetRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SetRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SetRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest.Builder.class);
    }

    private int bitField0_;
    public static final int PREFIX_FIELD_NUMBER = 1;
    private org.opennms.features.openconfig.proto.gnmi.Gnmi.Path prefix_;
    /**
     * <pre>
     * Prefix used for paths in the message.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     * @return Whether the prefix field is set.
     */
    @java.lang.Override
    public boolean hasPrefix() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Prefix used for paths in the message.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     * @return The prefix.
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPrefix() {
      return prefix_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : prefix_;
    }
    /**
     * <pre>
     * Prefix used for paths in the message.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPrefixOrBuilder() {
      return prefix_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : prefix_;
    }

    public static final int DELETE_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Path> delete_;
    /**
     * <pre>
     * Paths to be deleted from the data tree.
     * </pre>
     *
     * <code>repeated .gnmi.Path delete = 2;</code>
     */
    @java.lang.Override
    public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Path> getDeleteList() {
      return delete_;
    }
    /**
     * <pre>
     * Paths to be deleted from the data tree.
     * </pre>
     *
     * <code>repeated .gnmi.Path delete = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> 
        getDeleteOrBuilderList() {
      return delete_;
    }
    /**
     * <pre>
     * Paths to be deleted from the data tree.
     * </pre>
     *
     * <code>repeated .gnmi.Path delete = 2;</code>
     */
    @java.lang.Override
    public int getDeleteCount() {
      return delete_.size();
    }
    /**
     * <pre>
     * Paths to be deleted from the data tree.
     * </pre>
     *
     * <code>repeated .gnmi.Path delete = 2;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getDelete(int index) {
      return delete_.get(index);
    }
    /**
     * <pre>
     * Paths to be deleted from the data tree.
     * </pre>
     *
     * <code>repeated .gnmi.Path delete = 2;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getDeleteOrBuilder(
        int index) {
      return delete_.get(index);
    }

    public static final int REPLACE_FIELD_NUMBER = 3;
    @SuppressWarnings("serial")
    private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Update> replace_;
    /**
     * <pre>
     * Updates specifying elements to be replaced.
     * </pre>
     *
     * <code>repeated .gnmi.Update replace = 3;</code>
     */
    @java.lang.Override
    public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Update> getReplaceList() {
      return replace_;
    }
    /**
     * <pre>
     * Updates specifying elements to be replaced.
     * </pre>
     *
     * <code>repeated .gnmi.Update replace = 3;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder> 
        getReplaceOrBuilderList() {
      return replace_;
    }
    /**
     * <pre>
     * Updates specifying elements to be replaced.
     * </pre>
     *
     * <code>repeated .gnmi.Update replace = 3;</code>
     */
    @java.lang.Override
    public int getReplaceCount() {
      return replace_.size();
    }
    /**
     * <pre>
     * Updates specifying elements to be replaced.
     * </pre>
     *
     * <code>repeated .gnmi.Update replace = 3;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Update getReplace(int index) {
      return replace_.get(index);
    }
    /**
     * <pre>
     * Updates specifying elements to be replaced.
     * </pre>
     *
     * <code>repeated .gnmi.Update replace = 3;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder getReplaceOrBuilder(
        int index) {
      return replace_.get(index);
    }

    public static final int UPDATE_FIELD_NUMBER = 4;
    @SuppressWarnings("serial")
    private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Update> update_;
    /**
     * <pre>
     * Updates specifying elements to updated.
     * </pre>
     *
     * <code>repeated .gnmi.Update update = 4;</code>
     */
    @java.lang.Override
    public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Update> getUpdateList() {
      return update_;
    }
    /**
     * <pre>
     * Updates specifying elements to updated.
     * </pre>
     *
     * <code>repeated .gnmi.Update update = 4;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder> 
        getUpdateOrBuilderList() {
      return update_;
    }
    /**
     * <pre>
     * Updates specifying elements to updated.
     * </pre>
     *
     * <code>repeated .gnmi.Update update = 4;</code>
     */
    @java.lang.Override
    public int getUpdateCount() {
      return update_.size();
    }
    /**
     * <pre>
     * Updates specifying elements to updated.
     * </pre>
     *
     * <code>repeated .gnmi.Update update = 4;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Update getUpdate(int index) {
      return update_.get(index);
    }
    /**
     * <pre>
     * Updates specifying elements to updated.
     * </pre>
     *
     * <code>repeated .gnmi.Update update = 4;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder getUpdateOrBuilder(
        int index) {
      return update_.get(index);
    }

    public static final int EXTENSION_FIELD_NUMBER = 5;
    @SuppressWarnings("serial")
    private java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> extension_;
    /**
     * <pre>
     * Extension messages associated with the SetRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    @java.lang.Override
    public java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> getExtensionList() {
      return extension_;
    }
    /**
     * <pre>
     * Extension messages associated with the SetRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> 
        getExtensionOrBuilderList() {
      return extension_;
    }
    /**
     * <pre>
     * Extension messages associated with the SetRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    @java.lang.Override
    public int getExtensionCount() {
      return extension_.size();
    }
    /**
     * <pre>
     * Extension messages associated with the SetRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension getExtension(int index) {
      return extension_.get(index);
    }
    /**
     * <pre>
     * Extension messages associated with the SetRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder getExtensionOrBuilder(
        int index) {
      return extension_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getPrefix());
      }
      for (int i = 0; i < delete_.size(); i++) {
        output.writeMessage(2, delete_.get(i));
      }
      for (int i = 0; i < replace_.size(); i++) {
        output.writeMessage(3, replace_.get(i));
      }
      for (int i = 0; i < update_.size(); i++) {
        output.writeMessage(4, update_.get(i));
      }
      for (int i = 0; i < extension_.size(); i++) {
        output.writeMessage(5, extension_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getPrefix());
      }
      for (int i = 0; i < delete_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, delete_.get(i));
      }
      for (int i = 0; i < replace_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, replace_.get(i));
      }
      for (int i = 0; i < update_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, update_.get(i));
      }
      for (int i = 0; i < extension_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, extension_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest)) {
        return super.equals(obj);
      }
      org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest other = (org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest) obj;

      if (hasPrefix() != other.hasPrefix()) return false;
      if (hasPrefix()) {
        if (!getPrefix()
            .equals(other.getPrefix())) return false;
      }
      if (!getDeleteList()
          .equals(other.getDeleteList())) return false;
      if (!getReplaceList()
          .equals(other.getReplaceList())) return false;
      if (!getUpdateList()
          .equals(other.getUpdateList())) return false;
      if (!getExtensionList()
          .equals(other.getExtensionList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPrefix()) {
        hash = (37 * hash) + PREFIX_FIELD_NUMBER;
        hash = (53 * hash) + getPrefix().hashCode();
      }
      if (getDeleteCount() > 0) {
        hash = (37 * hash) + DELETE_FIELD_NUMBER;
        hash = (53 * hash) + getDeleteList().hashCode();
      }
      if (getReplaceCount() > 0) {
        hash = (37 * hash) + REPLACE_FIELD_NUMBER;
        hash = (53 * hash) + getReplaceList().hashCode();
      }
      if (getUpdateCount() > 0) {
        hash = (37 * hash) + UPDATE_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateList().hashCode();
      }
      if (getExtensionCount() > 0) {
        hash = (37 * hash) + EXTENSION_FIELD_NUMBER;
        hash = (53 * hash) + getExtensionList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * SetRequest is sent from a client to the target to update values in the data
     * tree. Paths are either deleted by the client, or modified by means of being
     * updated, or replaced. Where a replace is used, unspecified values are
     * considered to be replaced, whereas when update is used the changes are
     * considered to be incremental. The set of changes that are specified within
     * a single SetRequest are considered to be a transaction.
     * Reference: gNMI Specification Section 3.4.1
     * </pre>
     *
     * Protobuf type {@code gnmi.SetRequest}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:gnmi.SetRequest)
        org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SetRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SetRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest.Builder.class);
      }

      // Construct using org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getPrefixFieldBuilder();
          getDeleteFieldBuilder();
          getReplaceFieldBuilder();
          getUpdateFieldBuilder();
          getExtensionFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        prefix_ = null;
        if (prefixBuilder_ != null) {
          prefixBuilder_.dispose();
          prefixBuilder_ = null;
        }
        if (deleteBuilder_ == null) {
          delete_ = java.util.Collections.emptyList();
        } else {
          delete_ = null;
          deleteBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (replaceBuilder_ == null) {
          replace_ = java.util.Collections.emptyList();
        } else {
          replace_ = null;
          replaceBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        if (updateBuilder_ == null) {
          update_ = java.util.Collections.emptyList();
        } else {
          update_ = null;
          updateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        if (extensionBuilder_ == null) {
          extension_ = java.util.Collections.emptyList();
        } else {
          extension_ = null;
          extensionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SetRequest_descriptor;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest getDefaultInstanceForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest.getDefaultInstance();
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest build() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest buildPartial() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest result = new org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest result) {
        if (deleteBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            delete_ = java.util.Collections.unmodifiableList(delete_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.delete_ = delete_;
        } else {
          result.delete_ = deleteBuilder_.build();
        }
        if (replaceBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            replace_ = java.util.Collections.unmodifiableList(replace_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.replace_ = replace_;
        } else {
          result.replace_ = replaceBuilder_.build();
        }
        if (updateBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            update_ = java.util.Collections.unmodifiableList(update_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.update_ = update_;
        } else {
          result.update_ = updateBuilder_.build();
        }
        if (extensionBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)) {
            extension_ = java.util.Collections.unmodifiableList(extension_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.extension_ = extension_;
        } else {
          result.extension_ = extensionBuilder_.build();
        }
      }

      private void buildPartial0(org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.prefix_ = prefixBuilder_ == null
              ? prefix_
              : prefixBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest) {
          return mergeFrom((org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest other) {
        if (other == org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest.getDefaultInstance()) return this;
        if (other.hasPrefix()) {
          mergePrefix(other.getPrefix());
        }
        if (deleteBuilder_ == null) {
          if (!other.delete_.isEmpty()) {
            if (delete_.isEmpty()) {
              delete_ = other.delete_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureDeleteIsMutable();
              delete_.addAll(other.delete_);
            }
            onChanged();
          }
        } else {
          if (!other.delete_.isEmpty()) {
            if (deleteBuilder_.isEmpty()) {
              deleteBuilder_.dispose();
              deleteBuilder_ = null;
              delete_ = other.delete_;
              bitField0_ = (bitField0_ & ~0x00000002);
              deleteBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getDeleteFieldBuilder() : null;
            } else {
              deleteBuilder_.addAllMessages(other.delete_);
            }
          }
        }
        if (replaceBuilder_ == null) {
          if (!other.replace_.isEmpty()) {
            if (replace_.isEmpty()) {
              replace_ = other.replace_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureReplaceIsMutable();
              replace_.addAll(other.replace_);
            }
            onChanged();
          }
        } else {
          if (!other.replace_.isEmpty()) {
            if (replaceBuilder_.isEmpty()) {
              replaceBuilder_.dispose();
              replaceBuilder_ = null;
              replace_ = other.replace_;
              bitField0_ = (bitField0_ & ~0x00000004);
              replaceBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getReplaceFieldBuilder() : null;
            } else {
              replaceBuilder_.addAllMessages(other.replace_);
            }
          }
        }
        if (updateBuilder_ == null) {
          if (!other.update_.isEmpty()) {
            if (update_.isEmpty()) {
              update_ = other.update_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureUpdateIsMutable();
              update_.addAll(other.update_);
            }
            onChanged();
          }
        } else {
          if (!other.update_.isEmpty()) {
            if (updateBuilder_.isEmpty()) {
              updateBuilder_.dispose();
              updateBuilder_ = null;
              update_ = other.update_;
              bitField0_ = (bitField0_ & ~0x00000008);
              updateBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getUpdateFieldBuilder() : null;
            } else {
              updateBuilder_.addAllMessages(other.update_);
            }
          }
        }
        if (extensionBuilder_ == null) {
          if (!other.extension_.isEmpty()) {
            if (extension_.isEmpty()) {
              extension_ = other.extension_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureExtensionIsMutable();
              extension_.addAll(other.extension_);
            }
            onChanged();
          }
        } else {
          if (!other.extension_.isEmpty()) {
            if (extensionBuilder_.isEmpty()) {
              extensionBuilder_.dispose();
              extensionBuilder_ = null;
              extension_ = other.extension_;
              bitField0_ = (bitField0_ & ~0x00000010);
              extensionBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getExtensionFieldBuilder() : null;
            } else {
              extensionBuilder_.addAllMessages(other.extension_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getPrefixFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                org.opennms.features.openconfig.proto.gnmi.Gnmi.Path m =
                    input.readMessage(
                        org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.parser(),
                        extensionRegistry);
                if (deleteBuilder_ == null) {
                  ensureDeleteIsMutable();
                  delete_.add(m);
                } else {
                  deleteBuilder_.addMessage(m);
                }
                break;
              } // case 18
              case 26: {
                org.opennms.features.openconfig.proto.gnmi.Gnmi.Update m =
                    input.readMessage(
                        org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.parser(),
                        extensionRegistry);
                if (replaceBuilder_ == null) {
                  ensureReplaceIsMutable();
                  replace_.add(m);
                } else {
                  replaceBuilder_.addMessage(m);
                }
                break;
              } // case 26
              case 34: {
                org.opennms.features.openconfig.proto.gnmi.Gnmi.Update m =
                    input.readMessage(
                        org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.parser(),
                        extensionRegistry);
                if (updateBuilder_ == null) {
                  ensureUpdateIsMutable();
                  update_.add(m);
                } else {
                  updateBuilder_.addMessage(m);
                }
                break;
              } // case 34
              case 42: {
                org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension m =
                    input.readMessage(
                        org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.parser(),
                        extensionRegistry);
                if (extensionBuilder_ == null) {
                  ensureExtensionIsMutable();
                  extension_.add(m);
                } else {
                  extensionBuilder_.addMessage(m);
                }
                break;
              } // case 42
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.opennms.features.openconfig.proto.gnmi.Gnmi.Path prefix_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> prefixBuilder_;
      /**
       * <pre>
       * Prefix used for paths in the message.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       * @return Whether the prefix field is set.
       */
      public boolean hasPrefix() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Prefix used for paths in the message.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       * @return The prefix.
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPrefix() {
        if (prefixBuilder_ == null) {
          return prefix_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : prefix_;
        } else {
          return prefixBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Prefix used for paths in the message.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       */
      public Builder setPrefix(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (prefixBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          prefix_ = value;
        } else {
          prefixBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Prefix used for paths in the message.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       */
      public Builder setPrefix(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder builderForValue) {
        if (prefixBuilder_ == null) {
          prefix_ = builderForValue.build();
        } else {
          prefixBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Prefix used for paths in the message.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       */
      public Builder mergePrefix(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (prefixBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            prefix_ != null &&
            prefix_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance()) {
            getPrefixBuilder().mergeFrom(value);
          } else {
            prefix_ = value;
          }
        } else {
          prefixBuilder_.mergeFrom(value);
        }
        if (prefix_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * Prefix used for paths in the message.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       */
      public Builder clearPrefix() {
        bitField0_ = (bitField0_ & ~0x00000001);
        prefix_ = null;
        if (prefixBuilder_ != null) {
          prefixBuilder_.dispose();
          prefixBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Prefix used for paths in the message.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder getPrefixBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getPrefixFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Prefix used for paths in the message.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPrefixOrBuilder() {
        if (prefixBuilder_ != null) {
          return prefixBuilder_.getMessageOrBuilder();
        } else {
          return prefix_ == null ?
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : prefix_;
        }
      }
      /**
       * <pre>
       * Prefix used for paths in the message.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> 
          getPrefixFieldBuilder() {
        if (prefixBuilder_ == null) {
          prefixBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder>(
                  getPrefix(),
                  getParentForChildren(),
                  isClean());
          prefix_ = null;
        }
        return prefixBuilder_;
      }

      private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Path> delete_ =
        java.util.Collections.emptyList();
      private void ensureDeleteIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          delete_ = new java.util.ArrayList<org.opennms.features.openconfig.proto.gnmi.Gnmi.Path>(delete_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> deleteBuilder_;

      /**
       * <pre>
       * Paths to be deleted from the data tree.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 2;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Path> getDeleteList() {
        if (deleteBuilder_ == null) {
          return java.util.Collections.unmodifiableList(delete_);
        } else {
          return deleteBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Paths to be deleted from the data tree.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 2;</code>
       */
      public int getDeleteCount() {
        if (deleteBuilder_ == null) {
          return delete_.size();
        } else {
          return deleteBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Paths to be deleted from the data tree.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 2;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getDelete(int index) {
        if (deleteBuilder_ == null) {
          return delete_.get(index);
        } else {
          return deleteBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Paths to be deleted from the data tree.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 2;</code>
       */
      public Builder setDelete(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (deleteBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDeleteIsMutable();
          delete_.set(index, value);
          onChanged();
        } else {
          deleteBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Paths to be deleted from the data tree.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 2;</code>
       */
      public Builder setDelete(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder builderForValue) {
        if (deleteBuilder_ == null) {
          ensureDeleteIsMutable();
          delete_.set(index, builderForValue.build());
          onChanged();
        } else {
          deleteBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Paths to be deleted from the data tree.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 2;</code>
       */
      public Builder addDelete(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (deleteBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDeleteIsMutable();
          delete_.add(value);
          onChanged();
        } else {
          deleteBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Paths to be deleted from the data tree.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 2;</code>
       */
      public Builder addDelete(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (deleteBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDeleteIsMutable();
          delete_.add(index, value);
          onChanged();
        } else {
          deleteBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Paths to be deleted from the data tree.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 2;</code>
       */
      public Builder addDelete(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder builderForValue) {
        if (deleteBuilder_ == null) {
          ensureDeleteIsMutable();
          delete_.add(builderForValue.build());
          onChanged();
        } else {
          deleteBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Paths to be deleted from the data tree.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 2;</code>
       */
      public Builder addDelete(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder builderForValue) {
        if (deleteBuilder_ == null) {
          ensureDeleteIsMutable();
          delete_.add(index, builderForValue.build());
          onChanged();
        } else {
          deleteBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Paths to be deleted from the data tree.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 2;</code>
       */
      public Builder addAllDelete(
          java.lang.Iterable<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.Path> values) {
        if (deleteBuilder_ == null) {
          ensureDeleteIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, delete_);
          onChanged();
        } else {
          deleteBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Paths to be deleted from the data tree.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 2;</code>
       */
      public Builder clearDelete() {
        if (deleteBuilder_ == null) {
          delete_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          deleteBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Paths to be deleted from the data tree.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 2;</code>
       */
      public Builder removeDelete(int index) {
        if (deleteBuilder_ == null) {
          ensureDeleteIsMutable();
          delete_.remove(index);
          onChanged();
        } else {
          deleteBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Paths to be deleted from the data tree.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 2;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder getDeleteBuilder(
          int index) {
        return getDeleteFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Paths to be deleted from the data tree.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 2;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getDeleteOrBuilder(
          int index) {
        if (deleteBuilder_ == null) {
          return delete_.get(index);  } else {
          return deleteBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Paths to be deleted from the data tree.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 2;</code>
       */
      public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> 
           getDeleteOrBuilderList() {
        if (deleteBuilder_ != null) {
          return deleteBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(delete_);
        }
      }
      /**
       * <pre>
       * Paths to be deleted from the data tree.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 2;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder addDeleteBuilder() {
        return getDeleteFieldBuilder().addBuilder(
            org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance());
      }
      /**
       * <pre>
       * Paths to be deleted from the data tree.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 2;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder addDeleteBuilder(
          int index) {
        return getDeleteFieldBuilder().addBuilder(
            index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance());
      }
      /**
       * <pre>
       * Paths to be deleted from the data tree.
       * </pre>
       *
       * <code>repeated .gnmi.Path delete = 2;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder> 
           getDeleteBuilderList() {
        return getDeleteFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> 
          getDeleteFieldBuilder() {
        if (deleteBuilder_ == null) {
          deleteBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder>(
                  delete_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          delete_ = null;
        }
        return deleteBuilder_;
      }

      private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Update> replace_ =
        java.util.Collections.emptyList();
      private void ensureReplaceIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          replace_ = new java.util.ArrayList<org.opennms.features.openconfig.proto.gnmi.Gnmi.Update>(replace_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Update, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder> replaceBuilder_;

      /**
       * <pre>
       * Updates specifying elements to be replaced.
       * </pre>
       *
       * <code>repeated .gnmi.Update replace = 3;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Update> getReplaceList() {
        if (replaceBuilder_ == null) {
          return java.util.Collections.unmodifiableList(replace_);
        } else {
          return replaceBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Updates specifying elements to be replaced.
       * </pre>
       *
       * <code>repeated .gnmi.Update replace = 3;</code>
       */
      public int getReplaceCount() {
        if (replaceBuilder_ == null) {
          return replace_.size();
        } else {
          return replaceBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Updates specifying elements to be replaced.
       * </pre>
       *
       * <code>repeated .gnmi.Update replace = 3;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Update getReplace(int index) {
        if (replaceBuilder_ == null) {
          return replace_.get(index);
        } else {
          return replaceBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Updates specifying elements to be replaced.
       * </pre>
       *
       * <code>repeated .gnmi.Update replace = 3;</code>
       */
      public Builder setReplace(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update value) {
        if (replaceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureReplaceIsMutable();
          replace_.set(index, value);
          onChanged();
        } else {
          replaceBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Updates specifying elements to be replaced.
       * </pre>
       *
       * <code>repeated .gnmi.Update replace = 3;</code>
       */
      public Builder setReplace(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder builderForValue) {
        if (replaceBuilder_ == null) {
          ensureReplaceIsMutable();
          replace_.set(index, builderForValue.build());
          onChanged();
        } else {
          replaceBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Updates specifying elements to be replaced.
       * </pre>
       *
       * <code>repeated .gnmi.Update replace = 3;</code>
       */
      public Builder addReplace(org.opennms.features.openconfig.proto.gnmi.Gnmi.Update value) {
        if (replaceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureReplaceIsMutable();
          replace_.add(value);
          onChanged();
        } else {
          replaceBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Updates specifying elements to be replaced.
       * </pre>
       *
       * <code>repeated .gnmi.Update replace = 3;</code>
       */
      public Builder addReplace(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update value) {
        if (replaceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureReplaceIsMutable();
          replace_.add(index, value);
          onChanged();
        } else {
          replaceBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Updates specifying elements to be replaced.
       * </pre>
       *
       * <code>repeated .gnmi.Update replace = 3;</code>
       */
      public Builder addReplace(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder builderForValue) {
        if (replaceBuilder_ == null) {
          ensureReplaceIsMutable();
          replace_.add(builderForValue.build());
          onChanged();
        } else {
          replaceBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Updates specifying elements to be replaced.
       * </pre>
       *
       * <code>repeated .gnmi.Update replace = 3;</code>
       */
      public Builder addReplace(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder builderForValue) {
        if (replaceBuilder_ == null) {
          ensureReplaceIsMutable();
          replace_.add(index, builderForValue.build());
          onChanged();
        } else {
          replaceBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Updates specifying elements to be replaced.
       * </pre>
       *
       * <code>repeated .gnmi.Update replace = 3;</code>
       */
      public Builder addAllReplace(
          java.lang.Iterable<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.Update> values) {
        if (replaceBuilder_ == null) {
          ensureReplaceIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, replace_);
          onChanged();
        } else {
          replaceBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Updates specifying elements to be replaced.
       * </pre>
       *
       * <code>repeated .gnmi.Update replace = 3;</code>
       */
      public Builder clearReplace() {
        if (replaceBuilder_ == null) {
          replace_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          replaceBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Updates specifying elements to be replaced.
       * </pre>
       *
       * <code>repeated .gnmi.Update replace = 3;</code>
       */
      public Builder removeReplace(int index) {
        if (replaceBuilder_ == null) {
          ensureReplaceIsMutable();
          replace_.remove(index);
          onChanged();
        } else {
          replaceBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Updates specifying elements to be replaced.
       * </pre>
       *
       * <code>repeated .gnmi.Update replace = 3;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder getReplaceBuilder(
          int index) {
        return getReplaceFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Updates specifying elements to be replaced.
       * </pre>
       *
       * <code>repeated .gnmi.Update replace = 3;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder getReplaceOrBuilder(
          int index) {
        if (replaceBuilder_ == null) {
          return replace_.get(index);  } else {
          return replaceBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Updates specifying elements to be replaced.
       * </pre>
       *
       * <code>repeated .gnmi.Update replace = 3;</code>
       */
      public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder> 
           getReplaceOrBuilderList() {
        if (replaceBuilder_ != null) {
          return replaceBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(replace_);
        }
      }
      /**
       * <pre>
       * Updates specifying elements to be replaced.
       * </pre>
       *
       * <code>repeated .gnmi.Update replace = 3;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder addReplaceBuilder() {
        return getReplaceFieldBuilder().addBuilder(
            org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.getDefaultInstance());
      }
      /**
       * <pre>
       * Updates specifying elements to be replaced.
       * </pre>
       *
       * <code>repeated .gnmi.Update replace = 3;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder addReplaceBuilder(
          int index) {
        return getReplaceFieldBuilder().addBuilder(
            index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.getDefaultInstance());
      }
      /**
       * <pre>
       * Updates specifying elements to be replaced.
       * </pre>
       *
       * <code>repeated .gnmi.Update replace = 3;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder> 
           getReplaceBuilderList() {
        return getReplaceFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Update, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder> 
          getReplaceFieldBuilder() {
        if (replaceBuilder_ == null) {
          replaceBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Update, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder>(
                  replace_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          replace_ = null;
        }
        return replaceBuilder_;
      }

      private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Update> update_ =
        java.util.Collections.emptyList();
      private void ensureUpdateIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          update_ = new java.util.ArrayList<org.opennms.features.openconfig.proto.gnmi.Gnmi.Update>(update_);
          bitField0_ |= 0x00000008;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Update, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder> updateBuilder_;

      /**
       * <pre>
       * Updates specifying elements to updated.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Update> getUpdateList() {
        if (updateBuilder_ == null) {
          return java.util.Collections.unmodifiableList(update_);
        } else {
          return updateBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Updates specifying elements to updated.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public int getUpdateCount() {
        if (updateBuilder_ == null) {
          return update_.size();
        } else {
          return updateBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Updates specifying elements to updated.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Update getUpdate(int index) {
        if (updateBuilder_ == null) {
          return update_.get(index);
        } else {
          return updateBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Updates specifying elements to updated.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public Builder setUpdate(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update value) {
        if (updateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUpdateIsMutable();
          update_.set(index, value);
          onChanged();
        } else {
          updateBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Updates specifying elements to updated.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public Builder setUpdate(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder builderForValue) {
        if (updateBuilder_ == null) {
          ensureUpdateIsMutable();
          update_.set(index, builderForValue.build());
          onChanged();
        } else {
          updateBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Updates specifying elements to updated.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public Builder addUpdate(org.opennms.features.openconfig.proto.gnmi.Gnmi.Update value) {
        if (updateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUpdateIsMutable();
          update_.add(value);
          onChanged();
        } else {
          updateBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Updates specifying elements to updated.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public Builder addUpdate(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update value) {
        if (updateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUpdateIsMutable();
          update_.add(index, value);
          onChanged();
        } else {
          updateBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Updates specifying elements to updated.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public Builder addUpdate(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder builderForValue) {
        if (updateBuilder_ == null) {
          ensureUpdateIsMutable();
          update_.add(builderForValue.build());
          onChanged();
        } else {
          updateBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Updates specifying elements to updated.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public Builder addUpdate(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder builderForValue) {
        if (updateBuilder_ == null) {
          ensureUpdateIsMutable();
          update_.add(index, builderForValue.build());
          onChanged();
        } else {
          updateBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Updates specifying elements to updated.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public Builder addAllUpdate(
          java.lang.Iterable<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.Update> values) {
        if (updateBuilder_ == null) {
          ensureUpdateIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, update_);
          onChanged();
        } else {
          updateBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Updates specifying elements to updated.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public Builder clearUpdate() {
        if (updateBuilder_ == null) {
          update_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          updateBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Updates specifying elements to updated.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public Builder removeUpdate(int index) {
        if (updateBuilder_ == null) {
          ensureUpdateIsMutable();
          update_.remove(index);
          onChanged();
        } else {
          updateBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Updates specifying elements to updated.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder getUpdateBuilder(
          int index) {
        return getUpdateFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Updates specifying elements to updated.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder getUpdateOrBuilder(
          int index) {
        if (updateBuilder_ == null) {
          return update_.get(index);  } else {
          return updateBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Updates specifying elements to updated.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder> 
           getUpdateOrBuilderList() {
        if (updateBuilder_ != null) {
          return updateBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(update_);
        }
      }
      /**
       * <pre>
       * Updates specifying elements to updated.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder addUpdateBuilder() {
        return getUpdateFieldBuilder().addBuilder(
            org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.getDefaultInstance());
      }
      /**
       * <pre>
       * Updates specifying elements to updated.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder addUpdateBuilder(
          int index) {
        return getUpdateFieldBuilder().addBuilder(
            index, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.getDefaultInstance());
      }
      /**
       * <pre>
       * Updates specifying elements to updated.
       * </pre>
       *
       * <code>repeated .gnmi.Update update = 4;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder> 
           getUpdateBuilderList() {
        return getUpdateFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Update, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder> 
          getUpdateFieldBuilder() {
        if (updateBuilder_ == null) {
          updateBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Update, org.opennms.features.openconfig.proto.gnmi.Gnmi.Update.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateOrBuilder>(
                  update_,
                  ((bitField0_ & 0x00000008) != 0),
                  getParentForChildren(),
                  isClean());
          update_ = null;
        }
        return updateBuilder_;
      }

      private java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> extension_ =
        java.util.Collections.emptyList();
      private void ensureExtensionIsMutable() {
        if (!((bitField0_ & 0x00000010) != 0)) {
          extension_ = new java.util.ArrayList<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension>(extension_);
          bitField0_ |= 0x00000010;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder, org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> extensionBuilder_;

      /**
       * <pre>
       * Extension messages associated with the SetRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> getExtensionList() {
        if (extensionBuilder_ == null) {
          return java.util.Collections.unmodifiableList(extension_);
        } else {
          return extensionBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Extension messages associated with the SetRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public int getExtensionCount() {
        if (extensionBuilder_ == null) {
          return extension_.size();
        } else {
          return extensionBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Extension messages associated with the SetRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension getExtension(int index) {
        if (extensionBuilder_ == null) {
          return extension_.get(index);
        } else {
          return extensionBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Extension messages associated with the SetRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder setExtension(
          int index, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension value) {
        if (extensionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureExtensionIsMutable();
          extension_.set(index, value);
          onChanged();
        } else {
          extensionBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SetRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder setExtension(
          int index, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder builderForValue) {
        if (extensionBuilder_ == null) {
          ensureExtensionIsMutable();
          extension_.set(index, builderForValue.build());
          onChanged();
        } else {
          extensionBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SetRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder addExtension(org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension value) {
        if (extensionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureExtensionIsMutable();
          extension_.add(value);
          onChanged();
        } else {
          extensionBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SetRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder addExtension(
          int index, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension value) {
        if (extensionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureExtensionIsMutable();
          extension_.add(index, value);
          onChanged();
        } else {
          extensionBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SetRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder addExtension(
          org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder builderForValue) {
        if (extensionBuilder_ == null) {
          ensureExtensionIsMutable();
          extension_.add(builderForValue.build());
          onChanged();
        } else {
          extensionBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SetRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder addExtension(
          int index, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder builderForValue) {
        if (extensionBuilder_ == null) {
          ensureExtensionIsMutable();
          extension_.add(index, builderForValue.build());
          onChanged();
        } else {
          extensionBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SetRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder addAllExtension(
          java.lang.Iterable<? extends org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> values) {
        if (extensionBuilder_ == null) {
          ensureExtensionIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, extension_);
          onChanged();
        } else {
          extensionBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SetRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder clearExtension() {
        if (extensionBuilder_ == null) {
          extension_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          extensionBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SetRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder removeExtension(int index) {
        if (extensionBuilder_ == null) {
          ensureExtensionIsMutable();
          extension_.remove(index);
          onChanged();
        } else {
          extensionBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SetRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder getExtensionBuilder(
          int index) {
        return getExtensionFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Extension messages associated with the SetRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder getExtensionOrBuilder(
          int index) {
        if (extensionBuilder_ == null) {
          return extension_.get(index);  } else {
          return extensionBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Extension messages associated with the SetRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> 
           getExtensionOrBuilderList() {
        if (extensionBuilder_ != null) {
          return extensionBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(extension_);
        }
      }
      /**
       * <pre>
       * Extension messages associated with the SetRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder addExtensionBuilder() {
        return getExtensionFieldBuilder().addBuilder(
            org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.getDefaultInstance());
      }
      /**
       * <pre>
       * Extension messages associated with the SetRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder addExtensionBuilder(
          int index) {
        return getExtensionFieldBuilder().addBuilder(
            index, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.getDefaultInstance());
      }
      /**
       * <pre>
       * Extension messages associated with the SetRequest. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder> 
           getExtensionBuilderList() {
        return getExtensionFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder, org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> 
          getExtensionFieldBuilder() {
        if (extensionBuilder_ == null) {
          extensionBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder, org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder>(
                  extension_,
                  ((bitField0_ & 0x00000010) != 0),
                  getParentForChildren(),
                  isClean());
          extension_ = null;
        }
        return extensionBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:gnmi.SetRequest)
    }

    // @@protoc_insertion_point(class_scope:gnmi.SetRequest)
    private static final org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest();
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SetRequest>
        PARSER = new com.google.protobuf.AbstractParser<SetRequest>() {
      @java.lang.Override
      public SetRequest parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<SetRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SetRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.SetRequest getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface SetResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:gnmi.SetResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Prefix used for paths.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     * @return Whether the prefix field is set.
     */
    boolean hasPrefix();
    /**
     * <pre>
     * Prefix used for paths.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     * @return The prefix.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPrefix();
    /**
     * <pre>
     * Prefix used for paths.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPrefixOrBuilder();

    /**
     * <pre>
     * A set of responses specifying the result of the operations specified in
     * the SetRequest.
     * </pre>
     *
     * <code>repeated .gnmi.UpdateResult response = 2;</code>
     */
    java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult> 
        getResponseList();
    /**
     * <pre>
     * A set of responses specifying the result of the operations specified in
     * the SetRequest.
     * </pre>
     *
     * <code>repeated .gnmi.UpdateResult response = 2;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult getResponse(int index);
    /**
     * <pre>
     * A set of responses specifying the result of the operations specified in
     * the SetRequest.
     * </pre>
     *
     * <code>repeated .gnmi.UpdateResult response = 2;</code>
     */
    int getResponseCount();
    /**
     * <pre>
     * A set of responses specifying the result of the operations specified in
     * the SetRequest.
     * </pre>
     *
     * <code>repeated .gnmi.UpdateResult response = 2;</code>
     */
    java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResultOrBuilder> 
        getResponseOrBuilderList();
    /**
     * <pre>
     * A set of responses specifying the result of the operations specified in
     * the SetRequest.
     * </pre>
     *
     * <code>repeated .gnmi.UpdateResult response = 2;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResultOrBuilder getResponseOrBuilder(
        int index);

    /**
     * <pre>
     * The overall status of the transaction.
     * </pre>
     *
     * <code>.gnmi.Error message = 3 [deprecated = true];</code>
     * @deprecated gnmi.SetResponse.message is deprecated.
     *     See gnmi.proto;l=361
     * @return Whether the message field is set.
     */
    @java.lang.Deprecated boolean hasMessage();
    /**
     * <pre>
     * The overall status of the transaction.
     * </pre>
     *
     * <code>.gnmi.Error message = 3 [deprecated = true];</code>
     * @deprecated gnmi.SetResponse.message is deprecated.
     *     See gnmi.proto;l=361
     * @return The message.
     */
    @java.lang.Deprecated org.opennms.features.openconfig.proto.gnmi.Gnmi.Error getMessage();
    /**
     * <pre>
     * The overall status of the transaction.
     * </pre>
     *
     * <code>.gnmi.Error message = 3 [deprecated = true];</code>
     */
    @java.lang.Deprecated org.opennms.features.openconfig.proto.gnmi.Gnmi.ErrorOrBuilder getMessageOrBuilder();

    /**
     * <pre>
     * Timestamp of transaction (ns since epoch).
     * </pre>
     *
     * <code>int64 timestamp = 4;</code>
     * @return The timestamp.
     */
    long getTimestamp();

    /**
     * <pre>
     * Extension messages associated with the SetResponse. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> 
        getExtensionList();
    /**
     * <pre>
     * Extension messages associated with the SetResponse. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension getExtension(int index);
    /**
     * <pre>
     * Extension messages associated with the SetResponse. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    int getExtensionCount();
    /**
     * <pre>
     * Extension messages associated with the SetResponse. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> 
        getExtensionOrBuilderList();
    /**
     * <pre>
     * Extension messages associated with the SetResponse. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder getExtensionOrBuilder(
        int index);
  }
  /**
   * <pre>
   * SetResponse is the response to a SetRequest, sent from the target to the
   * client. It reports the result of the modifications to the data tree that were
   * specified by the client. Errors for this RPC should be reported using the
   * https://github.com/googleapis/googleapis/blob/master/google/rpc/status.proto
   * message in the RPC return. The gnmi.Error message can be used to add additional
   * details where required.
   * Reference: gNMI Specification Section 3.4.2
   * </pre>
   *
   * Protobuf type {@code gnmi.SetResponse}
   */
  public static final class SetResponse extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:gnmi.SetResponse)
      SetResponseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use SetResponse.newBuilder() to construct.
    private SetResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private SetResponse() {
      response_ = java.util.Collections.emptyList();
      extension_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new SetResponse();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SetResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SetResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse.Builder.class);
    }

    private int bitField0_;
    public static final int PREFIX_FIELD_NUMBER = 1;
    private org.opennms.features.openconfig.proto.gnmi.Gnmi.Path prefix_;
    /**
     * <pre>
     * Prefix used for paths.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     * @return Whether the prefix field is set.
     */
    @java.lang.Override
    public boolean hasPrefix() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Prefix used for paths.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     * @return The prefix.
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPrefix() {
      return prefix_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : prefix_;
    }
    /**
     * <pre>
     * Prefix used for paths.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPrefixOrBuilder() {
      return prefix_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : prefix_;
    }

    public static final int RESPONSE_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult> response_;
    /**
     * <pre>
     * A set of responses specifying the result of the operations specified in
     * the SetRequest.
     * </pre>
     *
     * <code>repeated .gnmi.UpdateResult response = 2;</code>
     */
    @java.lang.Override
    public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult> getResponseList() {
      return response_;
    }
    /**
     * <pre>
     * A set of responses specifying the result of the operations specified in
     * the SetRequest.
     * </pre>
     *
     * <code>repeated .gnmi.UpdateResult response = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResultOrBuilder> 
        getResponseOrBuilderList() {
      return response_;
    }
    /**
     * <pre>
     * A set of responses specifying the result of the operations specified in
     * the SetRequest.
     * </pre>
     *
     * <code>repeated .gnmi.UpdateResult response = 2;</code>
     */
    @java.lang.Override
    public int getResponseCount() {
      return response_.size();
    }
    /**
     * <pre>
     * A set of responses specifying the result of the operations specified in
     * the SetRequest.
     * </pre>
     *
     * <code>repeated .gnmi.UpdateResult response = 2;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult getResponse(int index) {
      return response_.get(index);
    }
    /**
     * <pre>
     * A set of responses specifying the result of the operations specified in
     * the SetRequest.
     * </pre>
     *
     * <code>repeated .gnmi.UpdateResult response = 2;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResultOrBuilder getResponseOrBuilder(
        int index) {
      return response_.get(index);
    }

    public static final int MESSAGE_FIELD_NUMBER = 3;
    private org.opennms.features.openconfig.proto.gnmi.Gnmi.Error message_;
    /**
     * <pre>
     * The overall status of the transaction.
     * </pre>
     *
     * <code>.gnmi.Error message = 3 [deprecated = true];</code>
     * @deprecated gnmi.SetResponse.message is deprecated.
     *     See gnmi.proto;l=361
     * @return Whether the message field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated public boolean hasMessage() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * The overall status of the transaction.
     * </pre>
     *
     * <code>.gnmi.Error message = 3 [deprecated = true];</code>
     * @deprecated gnmi.SetResponse.message is deprecated.
     *     See gnmi.proto;l=361
     * @return The message.
     */
    @java.lang.Override
    @java.lang.Deprecated public org.opennms.features.openconfig.proto.gnmi.Gnmi.Error getMessage() {
      return message_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.getDefaultInstance() : message_;
    }
    /**
     * <pre>
     * The overall status of the transaction.
     * </pre>
     *
     * <code>.gnmi.Error message = 3 [deprecated = true];</code>
     */
    @java.lang.Override
    @java.lang.Deprecated public org.opennms.features.openconfig.proto.gnmi.Gnmi.ErrorOrBuilder getMessageOrBuilder() {
      return message_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.getDefaultInstance() : message_;
    }

    public static final int TIMESTAMP_FIELD_NUMBER = 4;
    private long timestamp_ = 0L;
    /**
     * <pre>
     * Timestamp of transaction (ns since epoch).
     * </pre>
     *
     * <code>int64 timestamp = 4;</code>
     * @return The timestamp.
     */
    @java.lang.Override
    public long getTimestamp() {
      return timestamp_;
    }

    public static final int EXTENSION_FIELD_NUMBER = 5;
    @SuppressWarnings("serial")
    private java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> extension_;
    /**
     * <pre>
     * Extension messages associated with the SetResponse. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    @java.lang.Override
    public java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> getExtensionList() {
      return extension_;
    }
    /**
     * <pre>
     * Extension messages associated with the SetResponse. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> 
        getExtensionOrBuilderList() {
      return extension_;
    }
    /**
     * <pre>
     * Extension messages associated with the SetResponse. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    @java.lang.Override
    public int getExtensionCount() {
      return extension_.size();
    }
    /**
     * <pre>
     * Extension messages associated with the SetResponse. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension getExtension(int index) {
      return extension_.get(index);
    }
    /**
     * <pre>
     * Extension messages associated with the SetResponse. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 5;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder getExtensionOrBuilder(
        int index) {
      return extension_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getPrefix());
      }
      for (int i = 0; i < response_.size(); i++) {
        output.writeMessage(2, response_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(3, getMessage());
      }
      if (timestamp_ != 0L) {
        output.writeInt64(4, timestamp_);
      }
      for (int i = 0; i < extension_.size(); i++) {
        output.writeMessage(5, extension_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getPrefix());
      }
      for (int i = 0; i < response_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, response_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getMessage());
      }
      if (timestamp_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt64Size(4, timestamp_);
      }
      for (int i = 0; i < extension_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, extension_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse)) {
        return super.equals(obj);
      }
      org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse other = (org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse) obj;

      if (hasPrefix() != other.hasPrefix()) return false;
      if (hasPrefix()) {
        if (!getPrefix()
            .equals(other.getPrefix())) return false;
      }
      if (!getResponseList()
          .equals(other.getResponseList())) return false;
      if (hasMessage() != other.hasMessage()) return false;
      if (hasMessage()) {
        if (!getMessage()
            .equals(other.getMessage())) return false;
      }
      if (getTimestamp()
          != other.getTimestamp()) return false;
      if (!getExtensionList()
          .equals(other.getExtensionList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPrefix()) {
        hash = (37 * hash) + PREFIX_FIELD_NUMBER;
        hash = (53 * hash) + getPrefix().hashCode();
      }
      if (getResponseCount() > 0) {
        hash = (37 * hash) + RESPONSE_FIELD_NUMBER;
        hash = (53 * hash) + getResponseList().hashCode();
      }
      if (hasMessage()) {
        hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
        hash = (53 * hash) + getMessage().hashCode();
      }
      hash = (37 * hash) + TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getTimestamp());
      if (getExtensionCount() > 0) {
        hash = (37 * hash) + EXTENSION_FIELD_NUMBER;
        hash = (53 * hash) + getExtensionList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * SetResponse is the response to a SetRequest, sent from the target to the
     * client. It reports the result of the modifications to the data tree that were
     * specified by the client. Errors for this RPC should be reported using the
     * https://github.com/googleapis/googleapis/blob/master/google/rpc/status.proto
     * message in the RPC return. The gnmi.Error message can be used to add additional
     * details where required.
     * Reference: gNMI Specification Section 3.4.2
     * </pre>
     *
     * Protobuf type {@code gnmi.SetResponse}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:gnmi.SetResponse)
        org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SetResponse_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SetResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse.Builder.class);
      }

      // Construct using org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getPrefixFieldBuilder();
          getResponseFieldBuilder();
          getMessageFieldBuilder();
          getExtensionFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        prefix_ = null;
        if (prefixBuilder_ != null) {
          prefixBuilder_.dispose();
          prefixBuilder_ = null;
        }
        if (responseBuilder_ == null) {
          response_ = java.util.Collections.emptyList();
        } else {
          response_ = null;
          responseBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        message_ = null;
        if (messageBuilder_ != null) {
          messageBuilder_.dispose();
          messageBuilder_ = null;
        }
        timestamp_ = 0L;
        if (extensionBuilder_ == null) {
          extension_ = java.util.Collections.emptyList();
        } else {
          extension_ = null;
          extensionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_SetResponse_descriptor;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse getDefaultInstanceForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse.getDefaultInstance();
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse build() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse buildPartial() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse result = new org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse result) {
        if (responseBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            response_ = java.util.Collections.unmodifiableList(response_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.response_ = response_;
        } else {
          result.response_ = responseBuilder_.build();
        }
        if (extensionBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)) {
            extension_ = java.util.Collections.unmodifiableList(extension_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.extension_ = extension_;
        } else {
          result.extension_ = extensionBuilder_.build();
        }
      }

      private void buildPartial0(org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.prefix_ = prefixBuilder_ == null
              ? prefix_
              : prefixBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.message_ = messageBuilder_ == null
              ? message_
              : messageBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.timestamp_ = timestamp_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse) {
          return mergeFrom((org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse other) {
        if (other == org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse.getDefaultInstance()) return this;
        if (other.hasPrefix()) {
          mergePrefix(other.getPrefix());
        }
        if (responseBuilder_ == null) {
          if (!other.response_.isEmpty()) {
            if (response_.isEmpty()) {
              response_ = other.response_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureResponseIsMutable();
              response_.addAll(other.response_);
            }
            onChanged();
          }
        } else {
          if (!other.response_.isEmpty()) {
            if (responseBuilder_.isEmpty()) {
              responseBuilder_.dispose();
              responseBuilder_ = null;
              response_ = other.response_;
              bitField0_ = (bitField0_ & ~0x00000002);
              responseBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getResponseFieldBuilder() : null;
            } else {
              responseBuilder_.addAllMessages(other.response_);
            }
          }
        }
        if (other.hasMessage()) {
          mergeMessage(other.getMessage());
        }
        if (other.getTimestamp() != 0L) {
          setTimestamp(other.getTimestamp());
        }
        if (extensionBuilder_ == null) {
          if (!other.extension_.isEmpty()) {
            if (extension_.isEmpty()) {
              extension_ = other.extension_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureExtensionIsMutable();
              extension_.addAll(other.extension_);
            }
            onChanged();
          }
        } else {
          if (!other.extension_.isEmpty()) {
            if (extensionBuilder_.isEmpty()) {
              extensionBuilder_.dispose();
              extensionBuilder_ = null;
              extension_ = other.extension_;
              bitField0_ = (bitField0_ & ~0x00000010);
              extensionBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getExtensionFieldBuilder() : null;
            } else {
              extensionBuilder_.addAllMessages(other.extension_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getPrefixFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult m =
                    input.readMessage(
                        org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.parser(),
                        extensionRegistry);
                if (responseBuilder_ == null) {
                  ensureResponseIsMutable();
                  response_.add(m);
                } else {
                  responseBuilder_.addMessage(m);
                }
                break;
              } // case 18
              case 26: {
                input.readMessage(
                    getMessageFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              case 32: {
                timestamp_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
              case 42: {
                org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension m =
                    input.readMessage(
                        org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.parser(),
                        extensionRegistry);
                if (extensionBuilder_ == null) {
                  ensureExtensionIsMutable();
                  extension_.add(m);
                } else {
                  extensionBuilder_.addMessage(m);
                }
                break;
              } // case 42
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private org.opennms.features.openconfig.proto.gnmi.Gnmi.Path prefix_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> prefixBuilder_;
      /**
       * <pre>
       * Prefix used for paths.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       * @return Whether the prefix field is set.
       */
      public boolean hasPrefix() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Prefix used for paths.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       * @return The prefix.
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPrefix() {
        if (prefixBuilder_ == null) {
          return prefix_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : prefix_;
        } else {
          return prefixBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Prefix used for paths.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       */
      public Builder setPrefix(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (prefixBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          prefix_ = value;
        } else {
          prefixBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Prefix used for paths.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       */
      public Builder setPrefix(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder builderForValue) {
        if (prefixBuilder_ == null) {
          prefix_ = builderForValue.build();
        } else {
          prefixBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Prefix used for paths.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       */
      public Builder mergePrefix(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (prefixBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            prefix_ != null &&
            prefix_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance()) {
            getPrefixBuilder().mergeFrom(value);
          } else {
            prefix_ = value;
          }
        } else {
          prefixBuilder_.mergeFrom(value);
        }
        if (prefix_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * Prefix used for paths.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       */
      public Builder clearPrefix() {
        bitField0_ = (bitField0_ & ~0x00000001);
        prefix_ = null;
        if (prefixBuilder_ != null) {
          prefixBuilder_.dispose();
          prefixBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Prefix used for paths.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder getPrefixBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getPrefixFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Prefix used for paths.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPrefixOrBuilder() {
        if (prefixBuilder_ != null) {
          return prefixBuilder_.getMessageOrBuilder();
        } else {
          return prefix_ == null ?
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : prefix_;
        }
      }
      /**
       * <pre>
       * Prefix used for paths.
       * </pre>
       *
       * <code>.gnmi.Path prefix = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> 
          getPrefixFieldBuilder() {
        if (prefixBuilder_ == null) {
          prefixBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder>(
                  getPrefix(),
                  getParentForChildren(),
                  isClean());
          prefix_ = null;
        }
        return prefixBuilder_;
      }

      private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult> response_ =
        java.util.Collections.emptyList();
      private void ensureResponseIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          response_ = new java.util.ArrayList<org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult>(response_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResultOrBuilder> responseBuilder_;

      /**
       * <pre>
       * A set of responses specifying the result of the operations specified in
       * the SetRequest.
       * </pre>
       *
       * <code>repeated .gnmi.UpdateResult response = 2;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult> getResponseList() {
        if (responseBuilder_ == null) {
          return java.util.Collections.unmodifiableList(response_);
        } else {
          return responseBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * A set of responses specifying the result of the operations specified in
       * the SetRequest.
       * </pre>
       *
       * <code>repeated .gnmi.UpdateResult response = 2;</code>
       */
      public int getResponseCount() {
        if (responseBuilder_ == null) {
          return response_.size();
        } else {
          return responseBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * A set of responses specifying the result of the operations specified in
       * the SetRequest.
       * </pre>
       *
       * <code>repeated .gnmi.UpdateResult response = 2;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult getResponse(int index) {
        if (responseBuilder_ == null) {
          return response_.get(index);
        } else {
          return responseBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * A set of responses specifying the result of the operations specified in
       * the SetRequest.
       * </pre>
       *
       * <code>repeated .gnmi.UpdateResult response = 2;</code>
       */
      public Builder setResponse(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult value) {
        if (responseBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureResponseIsMutable();
          response_.set(index, value);
          onChanged();
        } else {
          responseBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * A set of responses specifying the result of the operations specified in
       * the SetRequest.
       * </pre>
       *
       * <code>repeated .gnmi.UpdateResult response = 2;</code>
       */
      public Builder setResponse(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Builder builderForValue) {
        if (responseBuilder_ == null) {
          ensureResponseIsMutable();
          response_.set(index, builderForValue.build());
          onChanged();
        } else {
          responseBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * A set of responses specifying the result of the operations specified in
       * the SetRequest.
       * </pre>
       *
       * <code>repeated .gnmi.UpdateResult response = 2;</code>
       */
      public Builder addResponse(org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult value) {
        if (responseBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureResponseIsMutable();
          response_.add(value);
          onChanged();
        } else {
          responseBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * A set of responses specifying the result of the operations specified in
       * the SetRequest.
       * </pre>
       *
       * <code>repeated .gnmi.UpdateResult response = 2;</code>
       */
      public Builder addResponse(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult value) {
        if (responseBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureResponseIsMutable();
          response_.add(index, value);
          onChanged();
        } else {
          responseBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * A set of responses specifying the result of the operations specified in
       * the SetRequest.
       * </pre>
       *
       * <code>repeated .gnmi.UpdateResult response = 2;</code>
       */
      public Builder addResponse(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Builder builderForValue) {
        if (responseBuilder_ == null) {
          ensureResponseIsMutable();
          response_.add(builderForValue.build());
          onChanged();
        } else {
          responseBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * A set of responses specifying the result of the operations specified in
       * the SetRequest.
       * </pre>
       *
       * <code>repeated .gnmi.UpdateResult response = 2;</code>
       */
      public Builder addResponse(
          int index, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Builder builderForValue) {
        if (responseBuilder_ == null) {
          ensureResponseIsMutable();
          response_.add(index, builderForValue.build());
          onChanged();
        } else {
          responseBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * A set of responses specifying the result of the operations specified in
       * the SetRequest.
       * </pre>
       *
       * <code>repeated .gnmi.UpdateResult response = 2;</code>
       */
      public Builder addAllResponse(
          java.lang.Iterable<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult> values) {
        if (responseBuilder_ == null) {
          ensureResponseIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, response_);
          onChanged();
        } else {
          responseBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * A set of responses specifying the result of the operations specified in
       * the SetRequest.
       * </pre>
       *
       * <code>repeated .gnmi.UpdateResult response = 2;</code>
       */
      public Builder clearResponse() {
        if (responseBuilder_ == null) {
          response_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          responseBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * A set of responses specifying the result of the operations specified in
       * the SetRequest.
       * </pre>
       *
       * <code>repeated .gnmi.UpdateResult response = 2;</code>
       */
      public Builder removeResponse(int index) {
        if (responseBuilder_ == null) {
          ensureResponseIsMutable();
          response_.remove(index);
          onChanged();
        } else {
          responseBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * A set of responses specifying the result of the operations specified in
       * the SetRequest.
       * </pre>
       *
       * <code>repeated .gnmi.UpdateResult response = 2;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Builder getResponseBuilder(
          int index) {
        return getResponseFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * A set of responses specifying the result of the operations specified in
       * the SetRequest.
       * </pre>
       *
       * <code>repeated .gnmi.UpdateResult response = 2;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResultOrBuilder getResponseOrBuilder(
          int index) {
        if (responseBuilder_ == null) {
          return response_.get(index);  } else {
          return responseBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * A set of responses specifying the result of the operations specified in
       * the SetRequest.
       * </pre>
       *
       * <code>repeated .gnmi.UpdateResult response = 2;</code>
       */
      public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResultOrBuilder> 
           getResponseOrBuilderList() {
        if (responseBuilder_ != null) {
          return responseBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(response_);
        }
      }
      /**
       * <pre>
       * A set of responses specifying the result of the operations specified in
       * the SetRequest.
       * </pre>
       *
       * <code>repeated .gnmi.UpdateResult response = 2;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Builder addResponseBuilder() {
        return getResponseFieldBuilder().addBuilder(
            org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.getDefaultInstance());
      }
      /**
       * <pre>
       * A set of responses specifying the result of the operations specified in
       * the SetRequest.
       * </pre>
       *
       * <code>repeated .gnmi.UpdateResult response = 2;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Builder addResponseBuilder(
          int index) {
        return getResponseFieldBuilder().addBuilder(
            index, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.getDefaultInstance());
      }
      /**
       * <pre>
       * A set of responses specifying the result of the operations specified in
       * the SetRequest.
       * </pre>
       *
       * <code>repeated .gnmi.UpdateResult response = 2;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Builder> 
           getResponseBuilderList() {
        return getResponseFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResultOrBuilder> 
          getResponseFieldBuilder() {
        if (responseBuilder_ == null) {
          responseBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResultOrBuilder>(
                  response_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          response_ = null;
        }
        return responseBuilder_;
      }

      private org.opennms.features.openconfig.proto.gnmi.Gnmi.Error message_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Error, org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.ErrorOrBuilder> messageBuilder_;
      /**
       * <pre>
       * The overall status of the transaction.
       * </pre>
       *
       * <code>.gnmi.Error message = 3 [deprecated = true];</code>
       * @deprecated gnmi.SetResponse.message is deprecated.
       *     See gnmi.proto;l=361
       * @return Whether the message field is set.
       */
      @java.lang.Deprecated public boolean hasMessage() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * The overall status of the transaction.
       * </pre>
       *
       * <code>.gnmi.Error message = 3 [deprecated = true];</code>
       * @deprecated gnmi.SetResponse.message is deprecated.
       *     See gnmi.proto;l=361
       * @return The message.
       */
      @java.lang.Deprecated public org.opennms.features.openconfig.proto.gnmi.Gnmi.Error getMessage() {
        if (messageBuilder_ == null) {
          return message_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.getDefaultInstance() : message_;
        } else {
          return messageBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * The overall status of the transaction.
       * </pre>
       *
       * <code>.gnmi.Error message = 3 [deprecated = true];</code>
       */
      @java.lang.Deprecated public Builder setMessage(org.opennms.features.openconfig.proto.gnmi.Gnmi.Error value) {
        if (messageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          message_ = value;
        } else {
          messageBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The overall status of the transaction.
       * </pre>
       *
       * <code>.gnmi.Error message = 3 [deprecated = true];</code>
       */
      @java.lang.Deprecated public Builder setMessage(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.Builder builderForValue) {
        if (messageBuilder_ == null) {
          message_ = builderForValue.build();
        } else {
          messageBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The overall status of the transaction.
       * </pre>
       *
       * <code>.gnmi.Error message = 3 [deprecated = true];</code>
       */
      @java.lang.Deprecated public Builder mergeMessage(org.opennms.features.openconfig.proto.gnmi.Gnmi.Error value) {
        if (messageBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0) &&
            message_ != null &&
            message_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.getDefaultInstance()) {
            getMessageBuilder().mergeFrom(value);
          } else {
            message_ = value;
          }
        } else {
          messageBuilder_.mergeFrom(value);
        }
        if (message_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * The overall status of the transaction.
       * </pre>
       *
       * <code>.gnmi.Error message = 3 [deprecated = true];</code>
       */
      @java.lang.Deprecated public Builder clearMessage() {
        bitField0_ = (bitField0_ & ~0x00000004);
        message_ = null;
        if (messageBuilder_ != null) {
          messageBuilder_.dispose();
          messageBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The overall status of the transaction.
       * </pre>
       *
       * <code>.gnmi.Error message = 3 [deprecated = true];</code>
       */
      @java.lang.Deprecated public org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.Builder getMessageBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getMessageFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * The overall status of the transaction.
       * </pre>
       *
       * <code>.gnmi.Error message = 3 [deprecated = true];</code>
       */
      @java.lang.Deprecated public org.opennms.features.openconfig.proto.gnmi.Gnmi.ErrorOrBuilder getMessageOrBuilder() {
        if (messageBuilder_ != null) {
          return messageBuilder_.getMessageOrBuilder();
        } else {
          return message_ == null ?
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.getDefaultInstance() : message_;
        }
      }
      /**
       * <pre>
       * The overall status of the transaction.
       * </pre>
       *
       * <code>.gnmi.Error message = 3 [deprecated = true];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Error, org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.ErrorOrBuilder> 
          getMessageFieldBuilder() {
        if (messageBuilder_ == null) {
          messageBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Error, org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.ErrorOrBuilder>(
                  getMessage(),
                  getParentForChildren(),
                  isClean());
          message_ = null;
        }
        return messageBuilder_;
      }

      private long timestamp_ ;
      /**
       * <pre>
       * Timestamp of transaction (ns since epoch).
       * </pre>
       *
       * <code>int64 timestamp = 4;</code>
       * @return The timestamp.
       */
      @java.lang.Override
      public long getTimestamp() {
        return timestamp_;
      }
      /**
       * <pre>
       * Timestamp of transaction (ns since epoch).
       * </pre>
       *
       * <code>int64 timestamp = 4;</code>
       * @param value The timestamp to set.
       * @return This builder for chaining.
       */
      public Builder setTimestamp(long value) {

        timestamp_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Timestamp of transaction (ns since epoch).
       * </pre>
       *
       * <code>int64 timestamp = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearTimestamp() {
        bitField0_ = (bitField0_ & ~0x00000008);
        timestamp_ = 0L;
        onChanged();
        return this;
      }

      private java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> extension_ =
        java.util.Collections.emptyList();
      private void ensureExtensionIsMutable() {
        if (!((bitField0_ & 0x00000010) != 0)) {
          extension_ = new java.util.ArrayList<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension>(extension_);
          bitField0_ |= 0x00000010;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder, org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> extensionBuilder_;

      /**
       * <pre>
       * Extension messages associated with the SetResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> getExtensionList() {
        if (extensionBuilder_ == null) {
          return java.util.Collections.unmodifiableList(extension_);
        } else {
          return extensionBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Extension messages associated with the SetResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public int getExtensionCount() {
        if (extensionBuilder_ == null) {
          return extension_.size();
        } else {
          return extensionBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Extension messages associated with the SetResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension getExtension(int index) {
        if (extensionBuilder_ == null) {
          return extension_.get(index);
        } else {
          return extensionBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Extension messages associated with the SetResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder setExtension(
          int index, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension value) {
        if (extensionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureExtensionIsMutable();
          extension_.set(index, value);
          onChanged();
        } else {
          extensionBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SetResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder setExtension(
          int index, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder builderForValue) {
        if (extensionBuilder_ == null) {
          ensureExtensionIsMutable();
          extension_.set(index, builderForValue.build());
          onChanged();
        } else {
          extensionBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SetResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder addExtension(org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension value) {
        if (extensionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureExtensionIsMutable();
          extension_.add(value);
          onChanged();
        } else {
          extensionBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SetResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder addExtension(
          int index, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension value) {
        if (extensionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureExtensionIsMutable();
          extension_.add(index, value);
          onChanged();
        } else {
          extensionBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SetResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder addExtension(
          org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder builderForValue) {
        if (extensionBuilder_ == null) {
          ensureExtensionIsMutable();
          extension_.add(builderForValue.build());
          onChanged();
        } else {
          extensionBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SetResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder addExtension(
          int index, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder builderForValue) {
        if (extensionBuilder_ == null) {
          ensureExtensionIsMutable();
          extension_.add(index, builderForValue.build());
          onChanged();
        } else {
          extensionBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SetResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder addAllExtension(
          java.lang.Iterable<? extends org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> values) {
        if (extensionBuilder_ == null) {
          ensureExtensionIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, extension_);
          onChanged();
        } else {
          extensionBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SetResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder clearExtension() {
        if (extensionBuilder_ == null) {
          extension_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          extensionBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SetResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public Builder removeExtension(int index) {
        if (extensionBuilder_ == null) {
          ensureExtensionIsMutable();
          extension_.remove(index);
          onChanged();
        } else {
          extensionBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Extension messages associated with the SetResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder getExtensionBuilder(
          int index) {
        return getExtensionFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Extension messages associated with the SetResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder getExtensionOrBuilder(
          int index) {
        if (extensionBuilder_ == null) {
          return extension_.get(index);  } else {
          return extensionBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Extension messages associated with the SetResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> 
           getExtensionOrBuilderList() {
        if (extensionBuilder_ != null) {
          return extensionBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(extension_);
        }
      }
      /**
       * <pre>
       * Extension messages associated with the SetResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder addExtensionBuilder() {
        return getExtensionFieldBuilder().addBuilder(
            org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.getDefaultInstance());
      }
      /**
       * <pre>
       * Extension messages associated with the SetResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder addExtensionBuilder(
          int index) {
        return getExtensionFieldBuilder().addBuilder(
            index, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.getDefaultInstance());
      }
      /**
       * <pre>
       * Extension messages associated with the SetResponse. See the
       * gNMI extension specification for further definition.
       * </pre>
       *
       * <code>repeated .gnmi_ext.Extension extension = 5;</code>
       */
      public java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder> 
           getExtensionBuilderList() {
        return getExtensionFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder, org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> 
          getExtensionFieldBuilder() {
        if (extensionBuilder_ == null) {
          extensionBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension, org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension.Builder, org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder>(
                  extension_,
                  ((bitField0_ & 0x00000010) != 0),
                  getParentForChildren(),
                  isClean());
          extension_ = null;
        }
        return extensionBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:gnmi.SetResponse)
    }

    // @@protoc_insertion_point(class_scope:gnmi.SetResponse)
    private static final org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse();
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SetResponse>
        PARSER = new com.google.protobuf.AbstractParser<SetResponse>() {
      @java.lang.Override
      public SetResponse parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<SetResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SetResponse> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.SetResponse getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface UpdateResultOrBuilder extends
      // @@protoc_insertion_point(interface_extends:gnmi.UpdateResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Deprecated timestamp for the UpdateResult, this field has been
     * replaced by the timestamp within the SetResponse message, since
     * all mutations effected by a set should be applied as a single
     * transaction.
     * </pre>
     *
     * <code>int64 timestamp = 1 [deprecated = true];</code>
     * @deprecated gnmi.UpdateResult.timestamp is deprecated.
     *     See gnmi.proto;l=383
     * @return The timestamp.
     */
    @java.lang.Deprecated long getTimestamp();

    /**
     * <pre>
     * Path associated with the update.
     * </pre>
     *
     * <code>.gnmi.Path path = 2;</code>
     * @return Whether the path field is set.
     */
    boolean hasPath();
    /**
     * <pre>
     * Path associated with the update.
     * </pre>
     *
     * <code>.gnmi.Path path = 2;</code>
     * @return The path.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPath();
    /**
     * <pre>
     * Path associated with the update.
     * </pre>
     *
     * <code>.gnmi.Path path = 2;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPathOrBuilder();

    /**
     * <pre>
     * Status of the update operation.
     * </pre>
     *
     * <code>.gnmi.Error message = 3 [deprecated = true];</code>
     * @deprecated gnmi.UpdateResult.message is deprecated.
     *     See gnmi.proto;l=385
     * @return Whether the message field is set.
     */
    @java.lang.Deprecated boolean hasMessage();
    /**
     * <pre>
     * Status of the update operation.
     * </pre>
     *
     * <code>.gnmi.Error message = 3 [deprecated = true];</code>
     * @deprecated gnmi.UpdateResult.message is deprecated.
     *     See gnmi.proto;l=385
     * @return The message.
     */
    @java.lang.Deprecated org.opennms.features.openconfig.proto.gnmi.Gnmi.Error getMessage();
    /**
     * <pre>
     * Status of the update operation.
     * </pre>
     *
     * <code>.gnmi.Error message = 3 [deprecated = true];</code>
     */
    @java.lang.Deprecated org.opennms.features.openconfig.proto.gnmi.Gnmi.ErrorOrBuilder getMessageOrBuilder();

    /**
     * <pre>
     * Update operation type.
     * </pre>
     *
     * <code>.gnmi.UpdateResult.Operation op = 4;</code>
     * @return The enum numeric value on the wire for op.
     */
    int getOpValue();
    /**
     * <pre>
     * Update operation type.
     * </pre>
     *
     * <code>.gnmi.UpdateResult.Operation op = 4;</code>
     * @return The op.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Operation getOp();
  }
  /**
   * <pre>
   * UpdateResult is used within the SetResponse message to communicate the
   * result of an operation specified within a SetRequest message.
   * Reference: gNMI Specification Section 3.4.2
   * </pre>
   *
   * Protobuf type {@code gnmi.UpdateResult}
   */
  public static final class UpdateResult extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:gnmi.UpdateResult)
      UpdateResultOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use UpdateResult.newBuilder() to construct.
    private UpdateResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private UpdateResult() {
      op_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new UpdateResult();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_UpdateResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_UpdateResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Builder.class);
    }

    /**
     * <pre>
     * The operation that was associated with the Path specified.
     * </pre>
     *
     * Protobuf enum {@code gnmi.UpdateResult.Operation}
     */
    public enum Operation
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>INVALID = 0;</code>
       */
      INVALID(0),
      /**
       * <pre>
       * The result relates to a delete of Path.
       * </pre>
       *
       * <code>DELETE = 1;</code>
       */
      DELETE(1),
      /**
       * <pre>
       * The result relates to a replace of Path.
       * </pre>
       *
       * <code>REPLACE = 2;</code>
       */
      REPLACE(2),
      /**
       * <pre>
       * The result relates to an update of Path.
       * </pre>
       *
       * <code>UPDATE = 3;</code>
       */
      UPDATE(3),
      UNRECOGNIZED(-1),
      ;

      /**
       * <code>INVALID = 0;</code>
       */
      public static final int INVALID_VALUE = 0;
      /**
       * <pre>
       * The result relates to a delete of Path.
       * </pre>
       *
       * <code>DELETE = 1;</code>
       */
      public static final int DELETE_VALUE = 1;
      /**
       * <pre>
       * The result relates to a replace of Path.
       * </pre>
       *
       * <code>REPLACE = 2;</code>
       */
      public static final int REPLACE_VALUE = 2;
      /**
       * <pre>
       * The result relates to an update of Path.
       * </pre>
       *
       * <code>UPDATE = 3;</code>
       */
      public static final int UPDATE_VALUE = 3;


      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Operation valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Operation forNumber(int value) {
        switch (value) {
          case 0: return INVALID;
          case 1: return DELETE;
          case 2: return REPLACE;
          case 3: return UPDATE;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Operation>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Operation> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Operation>() {
              public Operation findValueByNumber(int number) {
                return Operation.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.getDescriptor().getEnumTypes().get(0);
      }

      private static final Operation[] VALUES = values();

      public static Operation valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Operation(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:gnmi.UpdateResult.Operation)
    }

    private int bitField0_;
    public static final int TIMESTAMP_FIELD_NUMBER = 1;
    private long timestamp_ = 0L;
    /**
     * <pre>
     * Deprecated timestamp for the UpdateResult, this field has been
     * replaced by the timestamp within the SetResponse message, since
     * all mutations effected by a set should be applied as a single
     * transaction.
     * </pre>
     *
     * <code>int64 timestamp = 1 [deprecated = true];</code>
     * @deprecated gnmi.UpdateResult.timestamp is deprecated.
     *     See gnmi.proto;l=383
     * @return The timestamp.
     */
    @java.lang.Override
    @java.lang.Deprecated public long getTimestamp() {
      return timestamp_;
    }

    public static final int PATH_FIELD_NUMBER = 2;
    private org.opennms.features.openconfig.proto.gnmi.Gnmi.Path path_;
    /**
     * <pre>
     * Path associated with the update.
     * </pre>
     *
     * <code>.gnmi.Path path = 2;</code>
     * @return Whether the path field is set.
     */
    @java.lang.Override
    public boolean hasPath() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Path associated with the update.
     * </pre>
     *
     * <code>.gnmi.Path path = 2;</code>
     * @return The path.
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPath() {
      return path_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : path_;
    }
    /**
     * <pre>
     * Path associated with the update.
     * </pre>
     *
     * <code>.gnmi.Path path = 2;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPathOrBuilder() {
      return path_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : path_;
    }

    public static final int MESSAGE_FIELD_NUMBER = 3;
    private org.opennms.features.openconfig.proto.gnmi.Gnmi.Error message_;
    /**
     * <pre>
     * Status of the update operation.
     * </pre>
     *
     * <code>.gnmi.Error message = 3 [deprecated = true];</code>
     * @deprecated gnmi.UpdateResult.message is deprecated.
     *     See gnmi.proto;l=385
     * @return Whether the message field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated public boolean hasMessage() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Status of the update operation.
     * </pre>
     *
     * <code>.gnmi.Error message = 3 [deprecated = true];</code>
     * @deprecated gnmi.UpdateResult.message is deprecated.
     *     See gnmi.proto;l=385
     * @return The message.
     */
    @java.lang.Override
    @java.lang.Deprecated public org.opennms.features.openconfig.proto.gnmi.Gnmi.Error getMessage() {
      return message_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.getDefaultInstance() : message_;
    }
    /**
     * <pre>
     * Status of the update operation.
     * </pre>
     *
     * <code>.gnmi.Error message = 3 [deprecated = true];</code>
     */
    @java.lang.Override
    @java.lang.Deprecated public org.opennms.features.openconfig.proto.gnmi.Gnmi.ErrorOrBuilder getMessageOrBuilder() {
      return message_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.getDefaultInstance() : message_;
    }

    public static final int OP_FIELD_NUMBER = 4;
    private int op_ = 0;
    /**
     * <pre>
     * Update operation type.
     * </pre>
     *
     * <code>.gnmi.UpdateResult.Operation op = 4;</code>
     * @return The enum numeric value on the wire for op.
     */
    @java.lang.Override public int getOpValue() {
      return op_;
    }
    /**
     * <pre>
     * Update operation type.
     * </pre>
     *
     * <code>.gnmi.UpdateResult.Operation op = 4;</code>
     * @return The op.
     */
    @java.lang.Override public org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Operation getOp() {
      org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Operation result = org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Operation.forNumber(op_);
      return result == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Operation.UNRECOGNIZED : result;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (timestamp_ != 0L) {
        output.writeInt64(1, timestamp_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getPath());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(3, getMessage());
      }
      if (op_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Operation.INVALID.getNumber()) {
        output.writeEnum(4, op_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (timestamp_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt64Size(1, timestamp_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getPath());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getMessage());
      }
      if (op_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Operation.INVALID.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(4, op_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult)) {
        return super.equals(obj);
      }
      org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult other = (org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult) obj;

      if (getTimestamp()
          != other.getTimestamp()) return false;
      if (hasPath() != other.hasPath()) return false;
      if (hasPath()) {
        if (!getPath()
            .equals(other.getPath())) return false;
      }
      if (hasMessage() != other.hasMessage()) return false;
      if (hasMessage()) {
        if (!getMessage()
            .equals(other.getMessage())) return false;
      }
      if (op_ != other.op_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getTimestamp());
      if (hasPath()) {
        hash = (37 * hash) + PATH_FIELD_NUMBER;
        hash = (53 * hash) + getPath().hashCode();
      }
      if (hasMessage()) {
        hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
        hash = (53 * hash) + getMessage().hashCode();
      }
      hash = (37 * hash) + OP_FIELD_NUMBER;
      hash = (53 * hash) + op_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * UpdateResult is used within the SetResponse message to communicate the
     * result of an operation specified within a SetRequest message.
     * Reference: gNMI Specification Section 3.4.2
     * </pre>
     *
     * Protobuf type {@code gnmi.UpdateResult}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:gnmi.UpdateResult)
        org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_UpdateResult_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_UpdateResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Builder.class);
      }

      // Construct using org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getPathFieldBuilder();
          getMessageFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        timestamp_ = 0L;
        path_ = null;
        if (pathBuilder_ != null) {
          pathBuilder_.dispose();
          pathBuilder_ = null;
        }
        message_ = null;
        if (messageBuilder_ != null) {
          messageBuilder_.dispose();
          messageBuilder_ = null;
        }
        op_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_UpdateResult_descriptor;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult getDefaultInstanceForType() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.getDefaultInstance();
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult build() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult buildPartial() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult result = new org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.timestamp_ = timestamp_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.path_ = pathBuilder_ == null
              ? path_
              : pathBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.message_ = messageBuilder_ == null
              ? message_
              : messageBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.op_ = op_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult) {
          return mergeFrom((org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult other) {
        if (other == org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.getDefaultInstance()) return this;
        if (other.getTimestamp() != 0L) {
          setTimestamp(other.getTimestamp());
        }
        if (other.hasPath()) {
          mergePath(other.getPath());
        }
        if (other.hasMessage()) {
          mergeMessage(other.getMessage());
        }
        if (other.op_ != 0) {
          setOpValue(other.getOpValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                timestamp_ = input.readInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              case 18: {
                input.readMessage(
                    getPathFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                input.readMessage(
                    getMessageFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              case 32: {
                op_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private long timestamp_ ;
      /**
       * <pre>
       * Deprecated timestamp for the UpdateResult, this field has been
       * replaced by the timestamp within the SetResponse message, since
       * all mutations effected by a set should be applied as a single
       * transaction.
       * </pre>
       *
       * <code>int64 timestamp = 1 [deprecated = true];</code>
       * @deprecated gnmi.UpdateResult.timestamp is deprecated.
       *     See gnmi.proto;l=383
       * @return The timestamp.
       */
      @java.lang.Override
      @java.lang.Deprecated public long getTimestamp() {
        return timestamp_;
      }
      /**
       * <pre>
       * Deprecated timestamp for the UpdateResult, this field has been
       * replaced by the timestamp within the SetResponse message, since
       * all mutations effected by a set should be applied as a single
       * transaction.
       * </pre>
       *
       * <code>int64 timestamp = 1 [deprecated = true];</code>
       * @deprecated gnmi.UpdateResult.timestamp is deprecated.
       *     See gnmi.proto;l=383
       * @param value The timestamp to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated public Builder setTimestamp(long value) {

        timestamp_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Deprecated timestamp for the UpdateResult, this field has been
       * replaced by the timestamp within the SetResponse message, since
       * all mutations effected by a set should be applied as a single
       * transaction.
       * </pre>
       *
       * <code>int64 timestamp = 1 [deprecated = true];</code>
       * @deprecated gnmi.UpdateResult.timestamp is deprecated.
       *     See gnmi.proto;l=383
       * @return This builder for chaining.
       */
      @java.lang.Deprecated public Builder clearTimestamp() {
        bitField0_ = (bitField0_ & ~0x00000001);
        timestamp_ = 0L;
        onChanged();
        return this;
      }

      private org.opennms.features.openconfig.proto.gnmi.Gnmi.Path path_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> pathBuilder_;
      /**
       * <pre>
       * Path associated with the update.
       * </pre>
       *
       * <code>.gnmi.Path path = 2;</code>
       * @return Whether the path field is set.
       */
      public boolean hasPath() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * Path associated with the update.
       * </pre>
       *
       * <code>.gnmi.Path path = 2;</code>
       * @return The path.
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPath() {
        if (pathBuilder_ == null) {
          return path_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : path_;
        } else {
          return pathBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Path associated with the update.
       * </pre>
       *
       * <code>.gnmi.Path path = 2;</code>
       */
      public Builder setPath(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (pathBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          path_ = value;
        } else {
          pathBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Path associated with the update.
       * </pre>
       *
       * <code>.gnmi.Path path = 2;</code>
       */
      public Builder setPath(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder builderForValue) {
        if (pathBuilder_ == null) {
          path_ = builderForValue.build();
        } else {
          pathBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Path associated with the update.
       * </pre>
       *
       * <code>.gnmi.Path path = 2;</code>
       */
      public Builder mergePath(org.opennms.features.openconfig.proto.gnmi.Gnmi.Path value) {
        if (pathBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            path_ != null &&
            path_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance()) {
            getPathBuilder().mergeFrom(value);
          } else {
            path_ = value;
          }
        } else {
          pathBuilder_.mergeFrom(value);
        }
        if (path_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * Path associated with the update.
       * </pre>
       *
       * <code>.gnmi.Path path = 2;</code>
       */
      public Builder clearPath() {
        bitField0_ = (bitField0_ & ~0x00000002);
        path_ = null;
        if (pathBuilder_ != null) {
          pathBuilder_.dispose();
          pathBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Path associated with the update.
       * </pre>
       *
       * <code>.gnmi.Path path = 2;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder getPathBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getPathFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Path associated with the update.
       * </pre>
       *
       * <code>.gnmi.Path path = 2;</code>
       */
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPathOrBuilder() {
        if (pathBuilder_ != null) {
          return pathBuilder_.getMessageOrBuilder();
        } else {
          return path_ == null ?
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : path_;
        }
      }
      /**
       * <pre>
       * Path associated with the update.
       * </pre>
       *
       * <code>.gnmi.Path path = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> 
          getPathFieldBuilder() {
        if (pathBuilder_ == null) {
          pathBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Path, org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder>(
                  getPath(),
                  getParentForChildren(),
                  isClean());
          path_ = null;
        }
        return pathBuilder_;
      }

      private org.opennms.features.openconfig.proto.gnmi.Gnmi.Error message_;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Error, org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.ErrorOrBuilder> messageBuilder_;
      /**
       * <pre>
       * Status of the update operation.
       * </pre>
       *
       * <code>.gnmi.Error message = 3 [deprecated = true];</code>
       * @deprecated gnmi.UpdateResult.message is deprecated.
       *     See gnmi.proto;l=385
       * @return Whether the message field is set.
       */
      @java.lang.Deprecated public boolean hasMessage() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * Status of the update operation.
       * </pre>
       *
       * <code>.gnmi.Error message = 3 [deprecated = true];</code>
       * @deprecated gnmi.UpdateResult.message is deprecated.
       *     See gnmi.proto;l=385
       * @return The message.
       */
      @java.lang.Deprecated public org.opennms.features.openconfig.proto.gnmi.Gnmi.Error getMessage() {
        if (messageBuilder_ == null) {
          return message_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.getDefaultInstance() : message_;
        } else {
          return messageBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Status of the update operation.
       * </pre>
       *
       * <code>.gnmi.Error message = 3 [deprecated = true];</code>
       */
      @java.lang.Deprecated public Builder setMessage(org.opennms.features.openconfig.proto.gnmi.Gnmi.Error value) {
        if (messageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          message_ = value;
        } else {
          messageBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Status of the update operation.
       * </pre>
       *
       * <code>.gnmi.Error message = 3 [deprecated = true];</code>
       */
      @java.lang.Deprecated public Builder setMessage(
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.Builder builderForValue) {
        if (messageBuilder_ == null) {
          message_ = builderForValue.build();
        } else {
          messageBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Status of the update operation.
       * </pre>
       *
       * <code>.gnmi.Error message = 3 [deprecated = true];</code>
       */
      @java.lang.Deprecated public Builder mergeMessage(org.opennms.features.openconfig.proto.gnmi.Gnmi.Error value) {
        if (messageBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0) &&
            message_ != null &&
            message_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.getDefaultInstance()) {
            getMessageBuilder().mergeFrom(value);
          } else {
            message_ = value;
          }
        } else {
          messageBuilder_.mergeFrom(value);
        }
        if (message_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * Status of the update operation.
       * </pre>
       *
       * <code>.gnmi.Error message = 3 [deprecated = true];</code>
       */
      @java.lang.Deprecated public Builder clearMessage() {
        bitField0_ = (bitField0_ & ~0x00000004);
        message_ = null;
        if (messageBuilder_ != null) {
          messageBuilder_.dispose();
          messageBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Status of the update operation.
       * </pre>
       *
       * <code>.gnmi.Error message = 3 [deprecated = true];</code>
       */
      @java.lang.Deprecated public org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.Builder getMessageBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getMessageFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Status of the update operation.
       * </pre>
       *
       * <code>.gnmi.Error message = 3 [deprecated = true];</code>
       */
      @java.lang.Deprecated public org.opennms.features.openconfig.proto.gnmi.Gnmi.ErrorOrBuilder getMessageOrBuilder() {
        if (messageBuilder_ != null) {
          return messageBuilder_.getMessageOrBuilder();
        } else {
          return message_ == null ?
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.getDefaultInstance() : message_;
        }
      }
      /**
       * <pre>
       * Status of the update operation.
       * </pre>
       *
       * <code>.gnmi.Error message = 3 [deprecated = true];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.openconfig.proto.gnmi.Gnmi.Error, org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.ErrorOrBuilder> 
          getMessageFieldBuilder() {
        if (messageBuilder_ == null) {
          messageBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.openconfig.proto.gnmi.Gnmi.Error, org.opennms.features.openconfig.proto.gnmi.Gnmi.Error.Builder, org.opennms.features.openconfig.proto.gnmi.Gnmi.ErrorOrBuilder>(
                  getMessage(),
                  getParentForChildren(),
                  isClean());
          message_ = null;
        }
        return messageBuilder_;
      }

      private int op_ = 0;
      /**
       * <pre>
       * Update operation type.
       * </pre>
       *
       * <code>.gnmi.UpdateResult.Operation op = 4;</code>
       * @return The enum numeric value on the wire for op.
       */
      @java.lang.Override public int getOpValue() {
        return op_;
      }
      /**
       * <pre>
       * Update operation type.
       * </pre>
       *
       * <code>.gnmi.UpdateResult.Operation op = 4;</code>
       * @param value The enum numeric value on the wire for op to set.
       * @return This builder for chaining.
       */
      public Builder setOpValue(int value) {
        op_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Update operation type.
       * </pre>
       *
       * <code>.gnmi.UpdateResult.Operation op = 4;</code>
       * @return The op.
       */
      @java.lang.Override
      public org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Operation getOp() {
        org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Operation result = org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Operation.forNumber(op_);
        return result == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Operation.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Update operation type.
       * </pre>
       *
       * <code>.gnmi.UpdateResult.Operation op = 4;</code>
       * @param value The op to set.
       * @return This builder for chaining.
       */
      public Builder setOp(org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult.Operation value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000008;
        op_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Update operation type.
       * </pre>
       *
       * <code>.gnmi.UpdateResult.Operation op = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearOp() {
        bitField0_ = (bitField0_ & ~0x00000008);
        op_ = 0;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:gnmi.UpdateResult)
    }

    // @@protoc_insertion_point(class_scope:gnmi.UpdateResult)
    private static final org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult();
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UpdateResult>
        PARSER = new com.google.protobuf.AbstractParser<UpdateResult>() {
      @java.lang.Override
      public UpdateResult parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<UpdateResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UpdateResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.UpdateResult getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface GetRequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:gnmi.GetRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Prefix used for paths.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     * @return Whether the prefix field is set.
     */
    boolean hasPrefix();
    /**
     * <pre>
     * Prefix used for paths.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     * @return The prefix.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPrefix();
    /**
     * <pre>
     * Prefix used for paths.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPrefixOrBuilder();

    /**
     * <pre>
     * Paths requested by the client.
     * </pre>
     *
     * <code>repeated .gnmi.Path path = 2;</code>
     */
    java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Path> 
        getPathList();
    /**
     * <pre>
     * Paths requested by the client.
     * </pre>
     *
     * <code>repeated .gnmi.Path path = 2;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPath(int index);
    /**
     * <pre>
     * Paths requested by the client.
     * </pre>
     *
     * <code>repeated .gnmi.Path path = 2;</code>
     */
    int getPathCount();
    /**
     * <pre>
     * Paths requested by the client.
     * </pre>
     *
     * <code>repeated .gnmi.Path path = 2;</code>
     */
    java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> 
        getPathOrBuilderList();
    /**
     * <pre>
     * Paths requested by the client.
     * </pre>
     *
     * <code>repeated .gnmi.Path path = 2;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPathOrBuilder(
        int index);

    /**
     * <pre>
     * The type of data being requested.
     * </pre>
     *
     * <code>.gnmi.GetRequest.DataType type = 3;</code>
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();
    /**
     * <pre>
     * The type of data being requested.
     * </pre>
     *
     * <code>.gnmi.GetRequest.DataType type = 3;</code>
     * @return The type.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest.DataType getType();

    /**
     * <pre>
     * Encoding to be used.
     * </pre>
     *
     * <code>.gnmi.Encoding encoding = 5;</code>
     * @return The enum numeric value on the wire for encoding.
     */
    int getEncodingValue();
    /**
     * <pre>
     * Encoding to be used.
     * </pre>
     *
     * <code>.gnmi.Encoding encoding = 5;</code>
     * @return The encoding.
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding getEncoding();

    /**
     * <pre>
     * The schema models to be used.
     * </pre>
     *
     * <code>repeated .gnmi.ModelData use_models = 6;</code>
     */
    java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData> 
        getUseModelsList();
    /**
     * <pre>
     * The schema models to be used.
     * </pre>
     *
     * <code>repeated .gnmi.ModelData use_models = 6;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData getUseModels(int index);
    /**
     * <pre>
     * The schema models to be used.
     * </pre>
     *
     * <code>repeated .gnmi.ModelData use_models = 6;</code>
     */
    int getUseModelsCount();
    /**
     * <pre>
     * The schema models to be used.
     * </pre>
     *
     * <code>repeated .gnmi.ModelData use_models = 6;</code>
     */
    java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelDataOrBuilder> 
        getUseModelsOrBuilderList();
    /**
     * <pre>
     * The schema models to be used.
     * </pre>
     *
     * <code>repeated .gnmi.ModelData use_models = 6;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelDataOrBuilder getUseModelsOrBuilder(
        int index);

    /**
     * <pre>
     * Extension messages associated with the GetRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 7;</code>
     */
    java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> 
        getExtensionList();
    /**
     * <pre>
     * Extension messages associated with the GetRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 7;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension getExtension(int index);
    /**
     * <pre>
     * Extension messages associated with the GetRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 7;</code>
     */
    int getExtensionCount();
    /**
     * <pre>
     * Extension messages associated with the GetRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 7;</code>
     */
    java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> 
        getExtensionOrBuilderList();
    /**
     * <pre>
     * Extension messages associated with the GetRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 7;</code>
     */
    org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder getExtensionOrBuilder(
        int index);
  }
  /**
   * <pre>
   * GetRequest is sent when a client initiates a Get RPC. It is used to specify
   * the set of data elements for which the target should return a snapshot of
   * data. The use_models field specifies the set of schema modules that are to
   * be used by the target - where use_models is not specified then the target
   * must use all schema models that it has.
   * Reference: gNMI Specification Section 3.3.1
   * </pre>
   *
   * Protobuf type {@code gnmi.GetRequest}
   */
  public static final class GetRequest extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:gnmi.GetRequest)
      GetRequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use GetRequest.newBuilder() to construct.
    private GetRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private GetRequest() {
      path_ = java.util.Collections.emptyList();
      type_ = 0;
      encoding_ = 0;
      useModels_ = java.util.Collections.emptyList();
      extension_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new GetRequest();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_GetRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.openconfig.proto.gnmi.Gnmi.internal_static_gnmi_GetRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest.class, org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest.Builder.class);
    }

    /**
     * <pre>
     * Type of elements within the data tree.
     * </pre>
     *
     * Protobuf enum {@code gnmi.GetRequest.DataType}
     */
    public enum DataType
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <pre>
       * All data elements.
       * </pre>
       *
       * <code>ALL = 0;</code>
       */
      ALL(0),
      /**
       * <pre>
       * Config (rw) only elements.
       * </pre>
       *
       * <code>CONFIG = 1;</code>
       */
      CONFIG(1),
      /**
       * <pre>
       * State (ro) only elements.
       * </pre>
       *
       * <code>STATE = 2;</code>
       */
      STATE(2),
      /**
       * <pre>
       * Data elements marked in the schema as operational. This refers to data
       * elements whose value relates to the state of processes or interactions
       * running on the device.
       * </pre>
       *
       * <code>OPERATIONAL = 3;</code>
       */
      OPERATIONAL(3),
      UNRECOGNIZED(-1),
      ;

      /**
       * <pre>
       * All data elements.
       * </pre>
       *
       * <code>ALL = 0;</code>
       */
      public static final int ALL_VALUE = 0;
      /**
       * <pre>
       * Config (rw) only elements.
       * </pre>
       *
       * <code>CONFIG = 1;</code>
       */
      public static final int CONFIG_VALUE = 1;
      /**
       * <pre>
       * State (ro) only elements.
       * </pre>
       *
       * <code>STATE = 2;</code>
       */
      public static final int STATE_VALUE = 2;
      /**
       * <pre>
       * Data elements marked in the schema as operational. This refers to data
       * elements whose value relates to the state of processes or interactions
       * running on the device.
       * </pre>
       *
       * <code>OPERATIONAL = 3;</code>
       */
      public static final int OPERATIONAL_VALUE = 3;


      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DataType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static DataType forNumber(int value) {
        switch (value) {
          case 0: return ALL;
          case 1: return CONFIG;
          case 2: return STATE;
          case 3: return OPERATIONAL;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<DataType>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          DataType> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<DataType>() {
              public DataType findValueByNumber(int number) {
                return DataType.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest.getDescriptor().getEnumTypes().get(0);
      }

      private static final DataType[] VALUES = values();

      public static DataType valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private DataType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:gnmi.GetRequest.DataType)
    }

    private int bitField0_;
    public static final int PREFIX_FIELD_NUMBER = 1;
    private org.opennms.features.openconfig.proto.gnmi.Gnmi.Path prefix_;
    /**
     * <pre>
     * Prefix used for paths.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     * @return Whether the prefix field is set.
     */
    @java.lang.Override
    public boolean hasPrefix() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Prefix used for paths.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     * @return The prefix.
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPrefix() {
      return prefix_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : prefix_;
    }
    /**
     * <pre>
     * Prefix used for paths.
     * </pre>
     *
     * <code>.gnmi.Path prefix = 1;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPrefixOrBuilder() {
      return prefix_ == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Path.getDefaultInstance() : prefix_;
    }

    public static final int PATH_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Path> path_;
    /**
     * <pre>
     * Paths requested by the client.
     * </pre>
     *
     * <code>repeated .gnmi.Path path = 2;</code>
     */
    @java.lang.Override
    public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.Path> getPathList() {
      return path_;
    }
    /**
     * <pre>
     * Paths requested by the client.
     * </pre>
     *
     * <code>repeated .gnmi.Path path = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder> 
        getPathOrBuilderList() {
      return path_;
    }
    /**
     * <pre>
     * Paths requested by the client.
     * </pre>
     *
     * <code>repeated .gnmi.Path path = 2;</code>
     */
    @java.lang.Override
    public int getPathCount() {
      return path_.size();
    }
    /**
     * <pre>
     * Paths requested by the client.
     * </pre>
     *
     * <code>repeated .gnmi.Path path = 2;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.Path getPath(int index) {
      return path_.get(index);
    }
    /**
     * <pre>
     * Paths requested by the client.
     * </pre>
     *
     * <code>repeated .gnmi.Path path = 2;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.PathOrBuilder getPathOrBuilder(
        int index) {
      return path_.get(index);
    }

    public static final int TYPE_FIELD_NUMBER = 3;
    private int type_ = 0;
    /**
     * <pre>
     * The type of data being requested.
     * </pre>
     *
     * <code>.gnmi.GetRequest.DataType type = 3;</code>
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * The type of data being requested.
     * </pre>
     *
     * <code>.gnmi.GetRequest.DataType type = 3;</code>
     * @return The type.
     */
    @java.lang.Override public org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest.DataType getType() {
      org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest.DataType result = org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest.DataType.forNumber(type_);
      return result == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest.DataType.UNRECOGNIZED : result;
    }

    public static final int ENCODING_FIELD_NUMBER = 5;
    private int encoding_ = 0;
    /**
     * <pre>
     * Encoding to be used.
     * </pre>
     *
     * <code>.gnmi.Encoding encoding = 5;</code>
     * @return The enum numeric value on the wire for encoding.
     */
    @java.lang.Override public int getEncodingValue() {
      return encoding_;
    }
    /**
     * <pre>
     * Encoding to be used.
     * </pre>
     *
     * <code>.gnmi.Encoding encoding = 5;</code>
     * @return The encoding.
     */
    @java.lang.Override public org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding getEncoding() {
      org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding result = org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding.forNumber(encoding_);
      return result == null ? org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding.UNRECOGNIZED : result;
    }

    public static final int USE_MODELS_FIELD_NUMBER = 6;
    @SuppressWarnings("serial")
    private java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData> useModels_;
    /**
     * <pre>
     * The schema models to be used.
     * </pre>
     *
     * <code>repeated .gnmi.ModelData use_models = 6;</code>
     */
    @java.lang.Override
    public java.util.List<org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData> getUseModelsList() {
      return useModels_;
    }
    /**
     * <pre>
     * The schema models to be used.
     * </pre>
     *
     * <code>repeated .gnmi.ModelData use_models = 6;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelDataOrBuilder> 
        getUseModelsOrBuilderList() {
      return useModels_;
    }
    /**
     * <pre>
     * The schema models to be used.
     * </pre>
     *
     * <code>repeated .gnmi.ModelData use_models = 6;</code>
     */
    @java.lang.Override
    public int getUseModelsCount() {
      return useModels_.size();
    }
    /**
     * <pre>
     * The schema models to be used.
     * </pre>
     *
     * <code>repeated .gnmi.ModelData use_models = 6;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelData getUseModels(int index) {
      return useModels_.get(index);
    }
    /**
     * <pre>
     * The schema models to be used.
     * </pre>
     *
     * <code>repeated .gnmi.ModelData use_models = 6;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.Gnmi.ModelDataOrBuilder getUseModelsOrBuilder(
        int index) {
      return useModels_.get(index);
    }

    public static final int EXTENSION_FIELD_NUMBER = 7;
    @SuppressWarnings("serial")
    private java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> extension_;
    /**
     * <pre>
     * Extension messages associated with the GetRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 7;</code>
     */
    @java.lang.Override
    public java.util.List<org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension> getExtensionList() {
      return extension_;
    }
    /**
     * <pre>
     * Extension messages associated with the GetRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 7;</code>
     */
    @java.lang.Override
    public java.util.List<? extends org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder> 
        getExtensionOrBuilderList() {
      return extension_;
    }
    /**
     * <pre>
     * Extension messages associated with the GetRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 7;</code>
     */
    @java.lang.Override
    public int getExtensionCount() {
      return extension_.size();
    }
    /**
     * <pre>
     * Extension messages associated with the GetRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 7;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.GnmiExt.Extension getExtension(int index) {
      return extension_.get(index);
    }
    /**
     * <pre>
     * Extension messages associated with the GetRequest. See the
     * gNMI extension specification for further definition.
     * </pre>
     *
     * <code>repeated .gnmi_ext.Extension extension = 7;</code>
     */
    @java.lang.Override
    public org.opennms.features.openconfig.proto.gnmi.GnmiExt.ExtensionOrBuilder getExtensionOrBuilder(
        int index) {
      return extension_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getPrefix());
      }
      for (int i = 0; i < path_.size(); i++) {
        output.writeMessage(2, path_.get(i));
      }
      if (type_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest.DataType.ALL.getNumber()) {
        output.writeEnum(3, type_);
      }
      if (encoding_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding.JSON.getNumber()) {
        output.writeEnum(5, encoding_);
      }
      for (int i = 0; i < useModels_.size(); i++) {
        output.writeMessage(6, useModels_.get(i));
      }
      for (int i = 0; i < extension_.size(); i++) {
        output.writeMessage(7, extension_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getPrefix());
      }
      for (int i = 0; i < path_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, path_.get(i));
      }
      if (type_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest.DataType.ALL.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, type_);
      }
      if (encoding_ != org.opennms.features.openconfig.proto.gnmi.Gnmi.Encoding.JSON.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(5, encoding_);
      }
      for (int i = 0; i < useModels_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, useModels_.get(i));
      }
      for (int i = 0; i < extension_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, extension_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest)) {
        return super.equals(obj);
      }
      org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest other = (org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest) obj;

      if (hasPrefix() != other.hasPrefix()) return false;
      if (hasPrefix()) {
        if (!getPrefix()
            .equals(other.getPrefix())) return false;
      }
      if (!getPathList()
          .equals(other.getPathList())) return false;
      if (type_ != other.type_) return false;
      if (encoding_ != other.encoding_) return false;
      if (!getUseModelsList()
          .equals(other.getUseModelsList())) return false;
      if (!getExtensionList()
          .equals(other.getExtensionList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPrefix()) {
        hash = (37 * hash) + PREFIX_FIELD_NUMBER;
        hash = (53 * hash) + getPrefix().hashCode();
      }
      if (getPathCount() > 0) {
        hash = (37 * hash) + PATH_FIELD_NUMBER;
        hash = (53 * hash) + getPathList().hashCode();
      }
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (37 * hash) + ENCODING_FIELD_NUMBER;
      hash = (53 * hash) + encoding_;
      if (getUseModelsCount() > 0) {
        hash = (37 * hash) + USE_MODELS_FIELD_NUMBER;
        hash = (53 * hash) + getUseModelsList().hashCode();
      }
      if (getExtensionCount() > 0) {
        hash = (37 * hash) + EXTENSION_FIELD_NUMBER;
        hash = (53 * hash) + getExtensionList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.openconfig.proto.gnmi.Gnmi.GetRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParen