/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.SearchContext;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.AcknowledgmentDao;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.AlarmAddRemoveRequest;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsEventParameter;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.SituationPayload;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.web.rest.support.Aliases;
import org.opennms.web.rest.support.CriteriaBehavior;
import org.opennms.web.rest.support.CriteriaBehaviors;
import org.opennms.web.rest.support.SecurityHelper;
import org.opennms.web.rest.v2.AlarmRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="situations")
@Produces(value={"application/json", "application/xml"})
@Tag(name="Situation", description="Alarms API")
public class SituationsRestService
extends AlarmRestService {
    private static final Logger LOG = LoggerFactory.getLogger(SituationsRestService.class);
    static final String SITUATION_LOG_MSG = "situationLogMsg";
    static final String DESCR = "situationDescr";
    static final String STATUS = "situationStatus";
    static final String ID = "situationId";
    static final String RELATED_PREFIX = "related-reductionKey";
    static final String CREATED = "USER_CREATED";
    static final String REMOVED_ALARM = "REMOVED_ALARM";
    static final String ADDED_ALARM = "ADDED_ALARM";
    static final String ACCEPTED = "ACCEPTED";
    static final String REJECTED = "REJECTED";
    static final String SOURCE = "Api";
    private final String IS_SITUATION = "isSituation";
    @Autowired
    private EventForwarder eventForwarder;
    @Autowired
    private AcknowledgmentDao m_ackDao;

    @Override
    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response get(@Context UriInfo uriInfo, @Context SearchContext searchContext) {
        return super.get(uriInfo, searchContext);
    }

    @POST
    @Path(value="create")
    @Transactional
    public Response create(@Context UriInfo uriInfo, SituationPayload payload) throws InterruptedException {
        String situationId = UUID.randomUUID().toString();
        return this.handleAssociation(payload.getAlarmIdList(), payload.getDiagnosticText(), payload.getDescription(), uriInfo, situationId);
    }

    @POST
    @Path(value="associateAlarm")
    @Transactional
    public Response associateAlarm(@Context UriInfo uriInfo, AlarmAddRemoveRequest request) throws InterruptedException {
        OnmsAlarm situationAlarm = (OnmsAlarm)this.getDao().get((Serializable)request.getSituationId());
        if (situationAlarm == null || !situationAlarm.isSituation()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Invalid situation ID: " + request.getSituationId())).build();
        }
        Set<OnmsAlarm> toAdd = this.loadValidAlarms(request.getAlarmIdList(), uriInfo);
        LinkedHashSet<OnmsAlarm> mergedAlarms = new LinkedHashSet<OnmsAlarm>(situationAlarm.getRelatedAlarms());
        mergedAlarms.addAll(toAdd);
        if (mergedAlarms.equals(situationAlarm.getRelatedAlarms())) {
            return Response.noContent().build();
        }
        String sid = this.getSituationParamFromAlarm(situationAlarm, ID).orElseGet(() -> {
            LOG.warn("Could not find situationId on alarm: {}. Using reductionKey.", (Object)situationAlarm.getId());
            return String.valueOf(situationAlarm.getId());
        });
        this.buildAndSendEvent(mergedAlarms, situationAlarm, sid, ADDED_ALARM, null, null);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="removeAlarm")
    @Transactional
    public Response removeAlarm(@Context UriInfo uriInfo, AlarmAddRemoveRequest request) {
        OnmsAlarm situationAlarm = (OnmsAlarm)this.getDao().get((Serializable)request.getSituationId());
        if (situationAlarm == null || !situationAlarm.isSituation()) {
            return Response.noContent().build();
        }
        return this.removeAlarmsFromSituation(situationAlarm, request.getAlarmIdList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="clear")
    @Transactional
    public Response doAction(AlarmAddRemoveRequest req, @Context SecurityContext secCtx) {
        Integer alarmId = req.getSituationId();
        try {
            this.writeLock();
            if (alarmId == null) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Unable to determine alarm ID to update based on query path.").type("text/plain").build();
                return response;
            }
            OnmsAlarm alarm = (OnmsAlarm)this.getDao().get((Serializable)alarmId);
            if (alarm == null) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Unable to locate alarm with ID '" + alarmId + "'")).type("text/plain").build();
                return response;
            }
            String ackUser = secCtx.getUserPrincipal().getName();
            if (StringUtils.isNotBlank((String)ackUser)) {
                SecurityHelper.assertUserEditCredentials(secCtx, ackUser);
            }
            this.clearAlarm(alarm, ackUser);
        }
        finally {
            this.writeUnlock();
        }
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="alarms/clear")
    @Produces(value={"application/json", "application/xml"})
    @Transactional
    public Response removeAndClear(AlarmAddRemoveRequest req, @Context SecurityContext secCtx, @Context UriInfo uriInfo) throws InterruptedException {
        try {
            this.writeLock();
            OnmsAlarm situationAlarm = (OnmsAlarm)this.getDao().get((Serializable)req.getSituationId());
            if (situationAlarm == null || !situationAlarm.isSituation()) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Invalid situation ID: " + req.getSituationId())).type("text/plain").build();
                return response;
            }
            Response initialResponse = this.removeAlarmsFromSituation(situationAlarm, req.getAlarmIdList());
            if (initialResponse.getStatus() != 200) {
                Response response = initialResponse;
                return response;
            }
            String user = secCtx.getUserPrincipal().getName();
            if (StringUtils.isNotBlank((String)user)) {
                SecurityHelper.assertUserEditCredentials(secCtx, user);
            }
            this.clearAlarms(req.getAlarmIdList(), user);
            Response response = Response.ok().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @POST
    @Path(value="accepted/{id}")
    public Response acceptSituation(@PathParam(value="id") Integer id) {
        if (id == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Situation ID is required").build();
        }
        OnmsAlarm situation = (OnmsAlarm)this.getDao().get((Serializable)id);
        if (situation == null || !situation.isSituation()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Situation not found: " + id)).build();
        }
        String currentStatus = this.getSituationParamFromAlarm(situation, STATUS).orElse("");
        if (ACCEPTED.equals(currentStatus)) {
            LOG.debug("Situation {} already accepted", (Object)id);
            return Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)("Situation " + id + " already accepted")).build();
        }
        String sid = this.getSituationParamFromAlarm(situation, ID).orElseGet(() -> {
            LOG.warn("Could not find situationId on alarm: {}. Using reductionKey.", (Object)situation.getId());
            return String.valueOf(situation.getId());
        });
        this.buildAndSendEvent(situation.getRelatedAlarms(), situation, sid, ACCEPTED, null, null);
        return Response.ok().build();
    }

    private void clearAlarm(OnmsAlarm alarm, String user) {
        OnmsAcknowledgment ack = new OnmsAcknowledgment((Acknowledgeable)alarm, user);
        this.performAction(ack, Action.CLEAR, Boolean.TRUE);
    }

    private void clearAlarms(List<Integer> alarmIds, String user) {
        for (Integer alarmId : alarmIds) {
            OnmsAlarm alarm = (OnmsAlarm)this.getDao().get((Serializable)alarmId);
            if (alarm == null) continue;
            this.clearAlarm(alarm, user);
        }
    }

    private Response removeAlarmsFromSituation(OnmsAlarm situationAlarm, List<Integer> alarmIdsToRemove) {
        Set<OnmsAlarm> remaining = situationAlarm.getRelatedAlarms().stream().filter(a -> !alarmIdsToRemove.contains(a.getId())).collect(Collectors.toUnmodifiableSet());
        if (situationAlarm.getRelatedAlarms().equals(remaining)) {
            return Response.noContent().build();
        }
        String situationId = this.getSituationParamFromAlarm(situationAlarm, ID).orElseGet(() -> {
            LOG.warn("Could not find situationId on alarm {}. Using ID as fallback.", (Object)situationAlarm.getId());
            return Integer.toString(situationAlarm.getId());
        });
        this.buildAndSendEvent(remaining, situationAlarm, situationId, REMOVED_ALARM, null, null);
        return Response.ok().build();
    }

    public void performAction(OnmsAcknowledgment ack, Action action, Boolean value) {
        boolean alarmUpdated = false;
        switch (action) {
            case ACK: {
                ack.setAckAction(value != false ? AckAction.ACKNOWLEDGE : AckAction.UNACKNOWLEDGE);
                alarmUpdated = true;
                break;
            }
            case ESCALATE: {
                if (!Boolean.TRUE.equals(value)) break;
                ack.setAckAction(AckAction.ESCALATE);
                alarmUpdated = true;
                break;
            }
            case CLEAR: {
                if (!Boolean.TRUE.equals(value)) break;
                ack.setAckAction(AckAction.CLEAR);
                alarmUpdated = true;
                break;
            }
        }
        if (alarmUpdated) {
            this.m_ackDao.processAck(ack);
            this.m_ackDao.flush();
        }
    }

    @Override
    protected CriteriaBuilder getCriteriaBuilder(UriInfo uriInfo) {
        CriteriaBuilder builder = super.getCriteriaBuilder(uriInfo);
        CriteriaBehavior<?> isSituationBehavior = this.getCriteriaBehaviors().get(Aliases.alarm.prop("isSituation"));
        isSituationBehavior.beforeVisit(builder, "true", ConditionType.EQUALS, false);
        return builder;
    }

    @Override
    protected Map<String, CriteriaBehavior<?>> getCriteriaBehaviors() {
        Map<String, CriteriaBehavior<?>> base = CriteriaBehaviors.ALARM_BEHAVIORS;
        Map<String, CriteriaBehavior<?>> prefixed = CriteriaBehaviors.withAliasPrefix(Aliases.alarm, base);
        CriteriaBehavior<?> b = prefixed.get(Aliases.alarm.prop("isSituation"));
        return Collections.singletonMap(Aliases.alarm.prop("isSituation"), b);
    }

    private Response handleAssociation(List<Integer> alarmIds, String diagText, String desctiption, UriInfo uriInfo, String sid) throws InterruptedException {
        Set<OnmsAlarm> alarms = this.loadValidAlarms(alarmIds, uriInfo);
        if (alarms.size() < 2) {
            return Response.noContent().build();
        }
        this.buildAndSendEvent(alarms, null, sid, CREATED, diagText, desctiption);
        return Response.ok().build();
    }

    private Set<OnmsAlarm> loadValidAlarms(List<Integer> ids, UriInfo uriInfo) throws InterruptedException {
        HashSet<OnmsAlarm> alarms = new HashSet<OnmsAlarm>();
        for (Integer id : ids) {
            OnmsAlarm alarm = (OnmsAlarm)this.getDao().load((Serializable)id);
            if (alarm == null || !this.alarmIsNotInAnotherSituation(alarm.getReductionKey(), uriInfo)) continue;
            alarms.add(alarm);
        }
        return alarms;
    }

    private boolean alarmIsNotInAnotherSituation(String reductionKey, UriInfo uriInfo) throws InterruptedException {
        for (OnmsAlarm sit : this.fetchAllSituationAlarms(uriInfo)) {
            for (OnmsAlarm a : sit.getRelatedAlarms()) {
                if (!reductionKey.equals(a.getReductionKey())) continue;
                LOG.debug("Alarm {} already in another situation", (Object)reductionKey);
                return false;
            }
        }
        return true;
    }

    protected List<OnmsAlarm> fetchAllSituationAlarms(UriInfo uriInfo) {
        CriteriaBuilder builder = this.getCriteriaBuilder(uriInfo);
        return this.getDao().findMatching(builder.toCriteria());
    }

    public static OnmsAlarm getAlarmForDescription(Collection<OnmsAlarm> alarms) {
        Objects.requireNonNull(alarms, "alarms can not be null");
        if (alarms.isEmpty()) {
            throw new IllegalArgumentException("alarms can not be empty");
        }
        return alarms.stream().sorted(Comparator.comparing(OnmsAlarm::getSeverity).thenComparing(x -> x.getLastEventTime().getTime())).findFirst().orElseThrow(() -> new IllegalArgumentException("alarms can not be empty"));
    }

    private void buildAndSendEvent(Collection<OnmsAlarm> alarms, OnmsAlarm situation, String sid, String status, String diagText, String desctiption) {
        Object descr;
        String logMsg;
        EventBuilder eb = new EventBuilder().setUei("uei.opennms.org/alarms/situation").setSource(SOURCE).setSeverity(this.maxSeverityLabel(alarms)).setTime(new Date()).addParam(ID, sid);
        OnmsAlarm desc = null;
        if (!REJECTED.equals(status)) {
            desc = CREATED.equals(status) ? SituationsRestService.getAlarmForDescription(alarms) : SituationsRestService.getAlarmForDescription(situation.getRelatedAlarms());
        }
        switch (status) {
            case "USER_CREATED": {
                logMsg = String.format("Created situation with %d alarms", alarms.size());
                descr = Objects.toString(desctiption, "");
                if (diagText == null) break;
                descr = (String)descr + "<p>Diagnostic: " + diagText + "</p>";
                break;
            }
            case "ADDED_ALARM": {
                logMsg = String.format("Added alarms to situation %s", sid);
                descr = Objects.toString(situation != null ? situation.getDescription() : null, "");
                break;
            }
            case "REMOVED_ALARM": {
                logMsg = String.format("Removed alarms from situation %s", sid);
                descr = Objects.toString(situation != null ? situation.getDescription() : null, "");
                break;
            }
            case "ACCEPTED": {
                logMsg = "Situation accepted";
                descr = Objects.toString(situation != null ? situation.getDescription() : null, "");
                break;
            }
            case "REJECTED": {
                logMsg = "Situation rejected";
                descr = Objects.toString(situation != null ? situation.getDescription() : null, "");
                break;
            }
            default: {
                logMsg = situation.getLogMsg();
                descr = desctiption;
            }
        }
        if (!logMsg.isBlank()) {
            eb.addParam(SITUATION_LOG_MSG, logMsg);
        }
        if (!((String)descr).isBlank()) {
            eb.addParam(DESCR, (String)descr);
        }
        if (desc != null && desc.getNodeId() != null) {
            eb.setNodeid(desc.getNodeId().longValue());
        }
        AtomicInteger idx = new AtomicInteger(0);
        for (String key : alarms.stream().map(OnmsAlarm::getReductionKey).toList()) {
            eb.addParam(RELATED_PREFIX + idx.incrementAndGet(), key);
        }
        eb.addParam(STATUS, status);
        this.eventForwarder.sendNow(eb.getEvent());
    }

    public String maxSeverityLabel(Collection<OnmsAlarm> alarmSet) {
        OnmsSeverity maxSeverity = OnmsSeverity.get((int)alarmSet.stream().mapToInt(a -> a.getSeverity() != null ? a.getSeverity().getId() : OnmsSeverity.INDETERMINATE.getId()).max().orElseGet(() -> ((OnmsSeverity)OnmsSeverity.INDETERMINATE).getId()));
        return maxSeverity.getLabel();
    }

    private Optional<String> getSituationParamFromAlarm(OnmsAlarm alarm, String name) {
        OnmsEvent databaseEvent = alarm.getLastEvent();
        if (databaseEvent == null) {
            return Optional.empty();
        }
        List<OnmsEventParameter> parms = databaseEvent.getEventParameters().stream().filter(x -> x.getName().equals(name)).toList();
        if (parms == null) {
            return Optional.empty();
        }
        return parms.stream().map(OnmsEventParameter::getValue).findFirst();
    }

    public static enum Action {
        ACK,
        UNACK,
        ESCALATE,
        CLEAR,
        ACCEPT;

    }
}

