/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.opennms.netmgt.dao.api.MonitoringSystemDao;
import org.opennms.netmgt.model.OnmsMonitoringSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="monitoringSystems")
@Transactional
@Tag(name="MonitoringSystems", description="Monitoring Systems API")
public class MonitoringSystemsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(MonitoringSystemsRestService.class);
    @Autowired
    private MonitoringSystemDao dao;

    @GET
    @Path(value="/main")
    @Produces(value={"application/json"})
    @Operation(summary="Get main monitoring system", description="Get main monitoring system", operationId="MonitoringSystemsRestServiceGetMainMonitoringSystem")
    public Response getMainMonitoringSystem(@Context HttpServletRequest request) {
        try {
            OnmsMonitoringSystem system = this.dao.getMainMonitoringSystem();
            if (system != null) {
                MonitoringSystemResponseDTO dto = new MonitoringSystemResponseDTO();
                dto.id = system.getId();
                dto.label = system.getLabel();
                dto.location = system.getLocation();
                dto.type = system.getType();
                return Response.ok((Object)dto).build();
            }
            return Response.noContent().build();
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)"Error getting monitoring system.").build());
        }
    }

    public static class MonitoringSystemResponseDTO {
        public String id;
        public String label;
        public String location;
        public String type;
    }
}

