/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.dns;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.provision.persist.RequisitionRequest;
import org.opennms.netmgt.provision.service.dns.ForeignIdHashSource;

@XmlRootElement(name="dns-requisition-request")
@XmlAccessorType(value=XmlAccessType.NONE)
public class DnsRequisitionRequest
implements RequisitionRequest {
    private static final int DEFAULT_PORT = 53;
    private static final long DEFAULT_SERIAL = 0L;
    private static final boolean DEFAULT_FALLBACK = false;
    public static final ForeignIdHashSource DEFAULT_FOREIGN_ID_HASH_SOURCE = ForeignIdHashSource.NODE_LABEL;
    private static final List<String> DEFAULT_SERVICES = Arrays.asList("ICMP", "SNMP");
    @XmlAttribute(name="host")
    private String host;
    @XmlAttribute(name="port")
    private Integer port;
    @XmlAttribute(name="zone")
    private String zone;
    @XmlAttribute(name="foreign-source")
    private String foreignSource;
    @XmlAttribute(name="serial")
    private Long serial;
    @XmlAttribute(name="fallback")
    private Boolean fallback;
    @XmlAttribute(name="expression")
    private String expression;
    @XmlAttribute(name="location")
    private String location;
    @XmlAttribute(name="foreign-id-hash-source")
    private ForeignIdHashSource foreignIdHashSource;
    @XmlElement(name="service")
    private List<String> services;

    public DnsRequisitionRequest() {
    }

    public DnsRequisitionRequest(Map<String, String> parameters) {
        String servicesStr;
        String fallbackStr;
        this.host = parameters.get("host");
        if (this.host == null || this.host.isEmpty()) {
            throw new IllegalArgumentException("host is required.");
        }
        String portStr = parameters.get("port");
        if (portStr != null) {
            this.port = Integer.valueOf(portStr);
        }
        this.zone = parameters.get("zone");
        if (this.zone == null || this.zone.isEmpty()) {
            throw new IllegalArgumentException("zone is required.");
        }
        this.foreignSource = parameters.get("foreignSource");
        if (this.foreignSource == null || this.foreignSource.isEmpty()) {
            throw new IllegalArgumentException("foreignSource is required.");
        }
        String serialStr = parameters.get("serial");
        if (serialStr != null) {
            this.serial = Long.valueOf(serialStr);
        }
        if ((fallbackStr = parameters.get("fallback")) != null) {
            this.fallback = Boolean.valueOf(fallbackStr);
        }
        this.expression = parameters.get("expression");
        this.location = parameters.get("location");
        String foreignIdHashSourceStr = parameters.get("foreignIdHashSource");
        if (foreignIdHashSourceStr != null) {
            this.foreignIdHashSource = ForeignIdHashSource.valueOf(foreignIdHashSourceStr);
        }
        if ((servicesStr = parameters.get("services")) != null) {
            this.services = Arrays.asList(servicesStr.split(","));
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port != null ? this.port : 53;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getForeignSource() {
        return this.foreignSource;
    }

    public void setForeignSource(String foreignSource) {
        this.foreignSource = foreignSource;
    }

    public Long getSerial() {
        return this.serial != null ? this.serial : 0L;
    }

    public void setSerial(Long serial) {
        this.serial = serial;
    }

    public Boolean getFallback() {
        return this.fallback != null ? this.fallback : false;
    }

    public void setFallback(Boolean fallback) {
        this.fallback = fallback;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getLocation() {
        return this.location;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public ForeignIdHashSource getForeignIdHashSource() {
        return this.foreignIdHashSource != null ? this.foreignIdHashSource : DEFAULT_FOREIGN_ID_HASH_SOURCE;
    }

    public void setForeignIdHashSource(ForeignIdHashSource foreignIdHashSource) {
        this.foreignIdHashSource = foreignIdHashSource;
    }

    public List<String> getServices() {
        return this.services != null ? this.services : DEFAULT_SERVICES;
    }

    public void setServices(List<String> services) {
        this.services = services;
    }

    public boolean equals(Object other) {
        if (!(other instanceof DnsRequisitionRequest)) {
            return false;
        }
        DnsRequisitionRequest castOther = (DnsRequisitionRequest)other;
        return Objects.equals(this.host, castOther.host) && Objects.equals(this.port, castOther.port) && Objects.equals(this.zone, castOther.zone) && Objects.equals(this.foreignSource, castOther.foreignSource) && Objects.equals(this.serial, castOther.serial) && Objects.equals(this.fallback, castOther.fallback) && Objects.equals(this.expression, castOther.expression) && Objects.equals(this.location, castOther.location) && Objects.equals((Object)this.foreignIdHashSource, (Object)castOther.foreignIdHashSource) && Objects.equals(this.services, castOther.services);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.host, this.port, this.zone, this.foreignSource, this.serial, this.fallback, this.expression, this.location, this.foreignIdHashSource, this.services});
    }
}

