/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.buffer;

import io.pkts.buffer.BaseBuffer;
import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.buffer.WriteNotSupportedException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public abstract class AbstractBuffer
extends BaseBuffer {
    private static final String FOR_INPUT_STRING = "For input string: \"";
    private static final String EMPTY_BUFFER_CANT_WRITE = "This is an empty buffer. Cant write to it";
    protected int readerIndex;
    protected int writerIndex;
    protected int markedReaderIndex;
    protected int lowerBoundary;
    protected int upperBoundary;

    protected AbstractBuffer(int readerIndex, int lowerBoundary, int upperBoundary, int writerIndex) {
        assert (lowerBoundary <= upperBoundary);
        this.readerIndex = readerIndex;
        this.markedReaderIndex = readerIndex;
        this.lowerBoundary = lowerBoundary;
        this.upperBoundary = upperBoundary;
        this.writerIndex = writerIndex;
    }

    @Override
    public abstract Buffer clone();

    @Override
    public int getLowerBoundary() {
        return this.lowerBoundary;
    }

    @Override
    public int getUpperBoundary() {
        return this.upperBoundary;
    }

    @Override
    public int getReaderIndex() {
        return this.readerIndex;
    }

    @Override
    public int getWriterIndex() {
        return this.writerIndex;
    }

    @Override
    public void setWriterIndex(int index) {
        this.writerIndex = index;
    }

    @Override
    public void setReaderIndex(int index) {
        this.readerIndex = index;
    }

    @Override
    public int capacity() {
        return this.upperBoundary - this.lowerBoundary;
    }

    @Override
    public int getWritableBytes() {
        return this.upperBoundary - this.writerIndex;
    }

    @Override
    public void markReaderIndex() {
        this.markedReaderIndex = this.readerIndex;
    }

    @Override
    public Buffer slice(int stop) {
        return this.slice(this.getReaderIndex(), stop);
    }

    @Override
    public Buffer slice() {
        if (!this.hasReadableBytes()) {
            return Buffers.EMPTY_BUFFER;
        }
        return this.slice(this.getReaderIndex(), this.getWriterIndex() - this.lowerBoundary);
    }

    @Override
    public int getReadableBytes() {
        return this.writerIndex - this.readerIndex - this.lowerBoundary;
    }

    @Override
    public void resetReaderIndex() {
        this.readerIndex = this.markedReaderIndex;
    }

    protected void checkIndex(int index) throws IndexOutOfBoundsException {
        if (index >= this.lowerBoundary + this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected void checkWriterIndex(int index) throws IndexOutOfBoundsException {
        if (index < this.writerIndex || index >= this.upperBoundary) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public final short readUnsignedByte() throws IndexOutOfBoundsException, IOException {
        return (short)(this.readByte() & 0xFF);
    }

    @Override
    public boolean hasWriteSupport() {
        return false;
    }

    @Override
    public void write(byte b) throws IndexOutOfBoundsException {
        throw new WriteNotSupportedException(EMPTY_BUFFER_CANT_WRITE);
    }

    @Override
    public void write(String s) throws IndexOutOfBoundsException, WriteNotSupportedException, UnsupportedEncodingException {
        throw new WriteNotSupportedException(EMPTY_BUFFER_CANT_WRITE);
    }

    @Override
    public void write(String s, String charset) throws IndexOutOfBoundsException, WriteNotSupportedException, UnsupportedEncodingException {
        throw new WriteNotSupportedException(EMPTY_BUFFER_CANT_WRITE);
    }

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public abstract int hashCode();
}

