/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.HistoryManager;
import org.opennms.features.topology.api.HistoryOperation;
import org.opennms.features.topology.api.support.SavedHistory;
import org.opennms.features.topology.api.support.ServiceLocator;
import org.osgi.framework.BundleContext;
import org.slf4j.LoggerFactory;

public class BundleContextHistoryManager
implements HistoryManager {
    public static final String DATA_FILE_NAME = BundleContextHistoryManager.class.getName() + ".properties";
    private final BundleContext m_bundleContext;
    private final ServiceLocator m_serviceLocator;
    private final List<HistoryOperation> m_operations = new CopyOnWriteArrayList<HistoryOperation>();

    public BundleContextHistoryManager(BundleContext bundleContext, ServiceLocator serviceLocator) {
        this.m_bundleContext = bundleContext;
        this.m_serviceLocator = serviceLocator;
    }

    public synchronized void onBind(HistoryOperation operation) {
        try {
            this.m_operations.add(operation);
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(this.getClass()).warn("Exception during onBind()", e);
        }
    }

    public synchronized void onUnbind(HistoryOperation operation) {
        try {
            this.m_operations.remove(operation);
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(this.getClass()).warn("Exception during onUnbind()", e);
        }
    }

    public void applyHistory(String fragment, GraphContainer container) {
        SavedHistory hist = this.getHistoryByFragment(fragment);
        if (hist != null) {
            hist.apply(container, this.m_operations, this.m_serviceLocator);
        }
    }

    public String saveOrUpdateHistory(String userId, GraphContainer graphContainer) {
        SavedHistory history = new SavedHistory(graphContainer, this.m_operations);
        this.saveHistory(userId, history);
        return history.getFragment();
    }

    protected synchronized void saveHistory(String userId, SavedHistory hist) {
        Properties props = BundleContextHistoryManager.loadProperties(this.m_bundleContext);
        String historyXml = this.toXML(hist);
        props.put(hist.getFragment(), historyXml);
        props.put(userId, hist.getFragment());
        BundleContextHistoryManager.storeProperties(this.m_bundleContext, props);
    }

    public synchronized SavedHistory getHistoryByFragment(String fragment) {
        if (fragment != null) {
            Properties props = BundleContextHistoryManager.loadProperties(this.m_bundleContext);
            String xml = props.getProperty(fragment);
            if (xml == null || "".equals(xml)) {
                return null;
            }
            return (SavedHistory)JaxbUtils.unmarshal(SavedHistory.class, (Reader)new StringReader(xml));
        }
        return null;
    }

    public synchronized SavedHistory getHistoryByUserId(String userId) {
        String fragment = this.getHistoryFragment(userId);
        if (fragment != null) {
            return this.getHistoryByFragment(fragment);
        }
        return null;
    }

    public synchronized String getHistoryFragment(String userId) {
        return BundleContextHistoryManager.loadProperties(this.m_bundleContext).getProperty(userId);
    }

    public synchronized void deleteHistory() {
        this.m_bundleContext.getDataFile(DATA_FILE_NAME).delete();
    }

    private void cleanUp(String userId, Properties properties) {
        if (properties.containsKey(userId)) {
            String historyHash = properties.getProperty(userId);
            int usageCount = 0;
            for (Object eachKey : properties.keySet()) {
                String eachValue = properties.getProperty((String)eachKey);
                if (eachValue == null || !eachValue.equals(historyHash)) continue;
                ++usageCount;
            }
            if (usageCount == 1) {
                properties.remove(historyHash);
            }
        }
    }

    private String toXML(SavedHistory hist) {
        return JaxbUtils.marshal((Object)hist);
    }

    private static Properties loadProperties(BundleContext context) {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(context.getDataFile(DATA_FILE_NAME)));
        }
        catch (FileNotFoundException e) {
            LoggerFactory.getLogger(BundleContextHistoryManager.class).warn("BundleContextHistoryManager data file does not exist yet");
        }
        catch (IOException e) {
            LoggerFactory.getLogger(BundleContextHistoryManager.class).warn("IOException when reading BundleContextHistoryManager data file", (Throwable)e);
        }
        return props;
    }

    private static void storeProperties(BundleContext context, Properties props) {
        try {
            props.store(new FileOutputStream(context.getDataFile(DATA_FILE_NAME)), BundleContextHistoryManager.class.getName() + " History Data");
        }
        catch (FileNotFoundException e) {
            LoggerFactory.getLogger(BundleContextHistoryManager.class).warn("BundleContextHistoryManager data file does not exist");
        }
        catch (IOException e) {
            LoggerFactory.getLogger(BundleContextHistoryManager.class).warn("IOException when writing to BundleContextHistoryManager data file", (Throwable)e);
        }
    }
}

