/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.implementations;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.netmgt.events.api.EventParameterUtils;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.upgrade.api.AbstractOnmsUpgrade;
import org.opennms.upgrade.api.OnmsUpgradeException;

public class EventParameterMigratorOffline
extends AbstractOnmsUpgrade {
    private static final int BATCH_SIZE = 2000;

    @Override
    public int getOrder() {
        return 8;
    }

    @Override
    public String getDescription() {
        return "Moves event parameters from the 'eventparms' column to the 'event_parameters' table.";
    }

    @Override
    public boolean requiresOnmsRunning() {
        return false;
    }

    @Override
    public void preExecute() throws OnmsUpgradeException {
        try (Connection connection = DataSourceFactory.getInstance().getConnection();){
            Statement preExecutionStatement = connection.createStatement();
            try (ResultSet preExecutionResultSet = preExecutionStatement.executeQuery("SELECT EXISTS (SELECT 1 FROM pg_attribute WHERE attrelid = (SELECT oid FROM pg_class WHERE relname = 'events') AND attname = 'eventparms')");){
                preExecutionResultSet.next();
                if (!preExecutionResultSet.getBoolean(1)) {
                    throw new OnmsUpgradeException("The 'eventParms' column no longer exists");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new OnmsUpgradeException("Error checking for column 'eventParms'", e);
            }
        }
        catch (SQLException e) {
            throw new OnmsUpgradeException("Error opening database connection", e);
        }
    }

    @Override
    public void postExecute() throws OnmsUpgradeException {
    }

    @Override
    public void rollback() throws OnmsUpgradeException {
    }

    @Override
    public void execute() throws OnmsUpgradeException {
        long eventCount = 0L;
        long parameterCount = 0L;
        try (Connection connection = DataSourceFactory.getInstance().getConnection();){
            connection.setAutoCommit(false);
            while (true) {
                Statement selectStatement = connection.createStatement();
                try {
                    ResultSet resultSet = selectStatement.executeQuery("SELECT eventid, eventparms FROM events WHERE eventparms IS NOT NULL LIMIT 2000");
                    try {
                        if (!resultSet.next()) break;
                        try {
                            PreparedStatement insertStatement = connection.prepareStatement("INSERT INTO event_parameters (eventid, name, value, type, position) VALUES  (?,?,?,?,?)");
                            try {
                                PreparedStatement nullifyStatement = connection.prepareStatement("UPDATE events SET eventparms=NULL WHERE eventid=?");
                                try {
                                    do {
                                        Integer eventId = resultSet.getInt("eventid");
                                        String eventParms = resultSet.getString("eventparms");
                                        List parmList = EventParameterUtils.decode((String)eventParms);
                                        if (parmList != null) {
                                            List normalizedParms = EventParameterUtils.normalizePreserveOrder((List)parmList);
                                            for (int i = 0; i < normalizedParms.size(); ++i) {
                                                Parm parm = (Parm)normalizedParms.get(i);
                                                insertStatement.setInt(1, eventId);
                                                insertStatement.setString(2, parm.getParmName());
                                                insertStatement.setString(3, parm.getValue().getContent());
                                                insertStatement.setString(4, parm.getValue().getType());
                                                insertStatement.setInt(5, i);
                                                insertStatement.execute();
                                                ++parameterCount;
                                            }
                                        }
                                        nullifyStatement.setInt(1, eventId);
                                        nullifyStatement.execute();
                                        ++eventCount;
                                    } while (resultSet.next());
                                    this.log("Processed %d eventparms entries, %d event parameters inserted...\n", eventCount, parameterCount);
                                    connection.commit();
                                    continue;
                                }
                                finally {
                                    if (nullifyStatement == null) continue;
                                    nullifyStatement.close();
                                    continue;
                                }
                            }
                            finally {
                                if (insertStatement == null) continue;
                                insertStatement.close();
                                continue;
                            }
                        }
                        catch (SQLException e) {
                            connection.rollback();
                            connection.setAutoCommit(true);
                            throw e;
                        }
                    }
                    finally {
                        if (resultSet == null) continue;
                        resultSet.close();
                        continue;
                    }
                }
                finally {
                    if (selectStatement == null) continue;
                    selectStatement.close();
                    continue;
                }
                break;
            }
            connection.setAutoCommit(true);
            this.log("Rows migrated. Dropping column 'eventparms'...\n", new Object[0]);
            Statement postMigrationStatement = connection.createStatement();
            postMigrationStatement.execute("ALTER TABLE events DROP COLUMN eventparms");
        }
        catch (Throwable e) {
            throw new OnmsUpgradeException("Can't move event parameters to table: " + e.getMessage(), e);
        }
    }
}

