/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.implementations;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.upgrade.api.AbstractOnmsUpgrade;
import org.opennms.upgrade.api.OnmsUpgradeException;

public class DataCollectionConfigMigratorOffline
extends AbstractOnmsUpgrade {
    final File dataCollectionConfigDir;
    final File dataCollectionConfigDirBackupZip;
    final Map<String, String> substitutionMap = new HashMap<String, String>();

    public DataCollectionConfigMigratorOffline() throws OnmsUpgradeException {
        this.substitutionMap.put("org.opennms.netmgt.collectd.PersistAllSelectorStrategy", "org.opennms.netmgt.collection.support.PersistAllSelectorStrategy");
        this.substitutionMap.put("org.opennms.netmgt.dao.support.IndexStorageStrategy", "org.opennms.netmgt.collection.support.IndexStorageStrategy");
        this.dataCollectionConfigDir = Paths.get(ConfigFileConstants.getHome(), "etc", "datacollection").toFile();
        if (!this.dataCollectionConfigDir.isDirectory()) {
            throw new OnmsUpgradeException(String.format("Failed to determine the data collection configuration directory. %s is not a directory", this.dataCollectionConfigDir.getAbsolutePath()));
        }
        this.dataCollectionConfigDirBackupZip = new File(this.dataCollectionConfigDir.getAbsolutePath() + ".zip");
    }

    @Override
    public String getDescription() {
        return "Modifies the packages names used in etc/datacollection/*.xml. See NMS-7612.";
    }

    @Override
    public boolean requiresOnmsRunning() {
        return false;
    }

    @Override
    public int getOrder() {
        return 7;
    }

    @Override
    public void preExecute() throws OnmsUpgradeException {
        this.log("Backing up %s\n", this.dataCollectionConfigDir);
        this.zipDir(this.dataCollectionConfigDirBackupZip, this.dataCollectionConfigDir);
    }

    @Override
    public void execute() throws OnmsUpgradeException {
        this.log("Patching files...\n", new Object[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.dataCollectionConfigDir.toPath(), "*.xml");){
            for (Path entry : stream) {
                this.migrateDataCollectionConfig(entry.toFile());
            }
        }
        catch (IOException e) {
            throw new OnmsUpgradeException("Failed to list files in folder.", e);
        }
    }

    private void migrateDataCollectionConfig(File cfgFile) throws OnmsUpgradeException {
        try {
            this.log("  %s\n", cfgFile.getAbsolutePath());
            String cfgFileContents = FileUtils.readFileToString((File)cfgFile);
            for (Map.Entry<String, String> substitution : this.substitutionMap.entrySet()) {
                cfgFileContents = cfgFileContents.replace(substitution.getKey(), substitution.getValue());
            }
            FileUtils.write((File)cfgFile, (CharSequence)cfgFileContents);
        }
        catch (IOException e) {
            throw new OnmsUpgradeException(String.format("Failed to update %s", cfgFile), e);
        }
    }

    @Override
    public void postExecute() {
        if (this.dataCollectionConfigDirBackupZip.exists()) {
            this.log("Removing backup %s\n", this.dataCollectionConfigDirBackupZip);
            FileUtils.deleteQuietly((File)this.dataCollectionConfigDirBackupZip);
        }
    }

    @Override
    public void rollback() throws OnmsUpgradeException {
        if (!this.dataCollectionConfigDirBackupZip.exists()) {
            throw new OnmsUpgradeException(String.format("Backup %s not found. Can't rollback.", this.dataCollectionConfigDirBackupZip));
        }
        this.log("Unziping backup %s to %s\n", this.dataCollectionConfigDirBackupZip, this.dataCollectionConfigDir);
        this.unzipFile(this.dataCollectionConfigDirBackupZip, this.dataCollectionConfigDir);
        this.log("Rollback succesful. The backup file %s will be kept.\n", this.dataCollectionConfigDirBackupZip);
    }
}

